/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import java.io.Serializable;
import java.util.Comparator;

public class WwnVendor
implements Comparator,
Comparable,
Serializable {
    public static final String Vendor_Cisco = "Cisco";
    public static final String Vendor_Brocade = "Brocade";
    public static final int HBA = 1;
    public static final int DISK = 2;
    public static final int TAPE = 4;
    public static final int SWITCH = 8;
    public static final int GATEWAY = 16;
    public static final int MDS = 32;
    public static final int[] VALUES = new int[]{1, 2, 4, 8, 16, 32};
    public static final char[] TYPES = new char[]{'h', 'd', 't', 's', 'g', 'm'};
    private int _oui;
    private String _vendor;
    private int _type;

    public WwnVendor(int mac, String vendor, int type) {
        this._oui = mac;
        this._vendor = vendor;
        this._type = type;
    }

    public boolean isStorage() {
        return (this._type & 2) == 2 || (this._type & 4) == 4;
    }

    public boolean isHost() {
        return (this._type & 1) == 1;
    }

    public boolean isSwitch() {
        return (this._type & 8) == 8 || (this._type & 0x20) == 32;
    }

    public boolean isMds() {
        return this.isCisco() && (this._type & 0x20) == 32;
    }

    public boolean isCisco() {
        return this._vendor != null && this._vendor.equalsIgnoreCase(Vendor_Cisco);
    }

    public boolean isBrocade() {
        return this._vendor != null && this._vendor.equalsIgnoreCase(Vendor_Brocade);
    }

    public boolean isTypeAmbiguous() {
        if (this.isStorage() && this.isHost()) {
            return true;
        }
        return !this.isStorage() && !this.isHost();
    }

    public String getVendor() {
        return this._vendor;
    }

    public int getOUI() {
        return this._oui;
    }

    public int getType() {
        return this._type;
    }

    public int hashCode() {
        return this._oui;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof WwnVendor)) {
            return false;
        }
        WwnVendor that = (WwnVendor)o;
        return this._oui == that._oui;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        WwnVendor w1 = (WwnVendor)o1;
        WwnVendor w2 = (WwnVendor)o2;
        return w1._oui - w2._oui;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public String getTypeName() {
        int lastToken;
        StringBuilder sb = new StringBuilder();
        if ((this._type & 1) == 1) {
            sb.append("HBA|");
        }
        if ((this._type & 2) == 2) {
            sb.append("DISK|");
        }
        if ((this._type & 4) == 4) {
            sb.append("TAPE|");
        }
        if ((this._type & 8) == 8) {
            sb.append("SWITCH|");
        }
        if ((this._type & 0x10) == 16) {
            sb.append("GATEWAY|");
        }
        if ((this._type & 0x20) == 32) {
            sb.append("MDS|");
        }
        if ((lastToken = sb.lastIndexOf("|")) > 0) {
            sb.deleteCharAt(lastToken);
        }
        return sb.toString();
    }

    public String getTypeString() {
        String types = "";
        for (int i = 0; i < VALUES.length; ++i) {
            if ((this._type & VALUES[i]) != VALUES[i]) continue;
            types = types + (TYPES[i] + 124);
        }
        return types;
    }

    public String getOUIHexString() {
        StringBuilder sb = new StringBuilder(Integer.toHexString(this._oui).toUpperCase());
        if (sb.length() < 6) {
            int len = sb.length();
            for (int i = 0; i < 6 - len; ++i) {
                sb.insert(0, '0');
            }
        }
        sb.insert(0, "0x");
        return sb.toString();
    }

    public String toString() {
        return this.getOUIHexString() + '(' + this._vendor + ',' + this.getTypeName() + ')';
    }

    public static String format(WwnVendor v) {
        if (v == null) {
            return "";
        }
        return v.getOUIHexString() + ' ' + v.getVendor() + ' ' + v.getTypeString();
    }

    public static WwnVendor parse(String vendorStr) {
        if (vendorStr == null || !vendorStr.startsWith("0x")) {
            return null;
        }
        String[] parts = vendorStr.split(" ");
        if (parts == null || parts.length < 3) {
            return null;
        }
        try {
            int oui = Integer.parseInt(parts[0].substring(2), 16);
            String tstr = parts[2].toLowerCase();
            int type = 0;
            for (int i = 0; i < TYPES.length; ++i) {
                if (tstr.indexOf(TYPES[i]) == -1) continue;
                type |= VALUES[i];
            }
            WwnVendor v = new WwnVendor(oui, parts[1], type);
            return v;
        }
        catch (Exception ex) {
            System.err.println("Cannot get WwnVendor from string:" + vendorStr + " with error:" + ex);
            return null;
        }
    }
}

