/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.mds.flash.FileSystemModel;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import java.io.IOException;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class CliCommandHandler {
    static Logger _Logger = Logger.getLogger((String)"CLI");
    protected Vsh _vsh;
    protected SnmpPeer _peer;
    protected JFrame _frame;

    public CliCommandHandler(JFrame frame, SnmpPeer peer, boolean useSsh) throws IOException, SnmpException {
        this._frame = frame;
        this._peer = peer;
        this.setVshCon(useSsh);
    }

    protected CliCommandHandler() {
    }

    public void setTimeOut(int timeout) {
        if (this._vsh != null) {
            Vsh.setTimeout(timeout);
        }
    }

    public void setTcpTimeOut(int tcpTimeout) {
        if (this._vsh != null) {
            this._vsh.setTcpTimeout(tcpTimeout);
        }
    }

    protected void setVshCon(boolean useSsh) throws IOException, SnmpException {
        this._vsh = this._peer.isV3() ? Vsh.get(this._frame, this._peer.getAddress().getHostAddress(), this._peer.getUserName(), this._peer.getAuthPassword().trim(), useSsh, null) : Vsh.get(this._frame, this._peer.getAddress().getHostAddress(), null, null, useSsh, null);
        if (this._vsh == null) {
            throw new SnmpException("Unable to connect switch " + this._peer + ".");
        }
        Vsh.put(this._vsh);
        this.setTcpTimeOut(0);
        this.setTimeOut(0);
    }

    public void reconnect(boolean useSsh) throws IOException, SnmpException {
        try {
            this._vsh.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setVshCon(useSsh);
    }

    public String executeCLICommand(String command, String newPrompt, boolean needConfirm) throws SnmpException {
        String[] stringArray;
        if (newPrompt != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = newPrompt;
        } else {
            stringArray = null;
        }
        return this.executeCLICommand(command, stringArray, needConfirm);
    }

    public String executeCLICommand(String command, String[] newPrompts, boolean needConfirm) throws SnmpException {
        return this.executeCLICommand(command, newPrompts, needConfirm, true);
    }

    public String executeCLICommand(String command, String[] newPrompts, boolean needConfirm, boolean isPromptChange) throws SnmpException {
        return this.executeCLICommand(command, newPrompts, needConfirm, isPromptChange, false);
    }

    public String executeCLICommand(String command, String[] newPrompts, boolean needConfirm, boolean isPromptChange, boolean hideCommand) throws SnmpException {
        try {
            _Logger.debug((Object)(this._peer + " Prompt:" + this._vsh.getPrompt() + (hideCommand ? "" : ": CLI Cmd:" + command)));
            _Logger.getAllAppenders();
            this._vsh.send(command + "\n");
            if (needConfirm) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this._vsh.send("y\n");
            }
            if (newPrompts != null && newPrompts.length > 0) {
                StringBuffer bufOut = new StringBuffer();
                this._vsh.expect(newPrompts, bufOut);
                if (isPromptChange) {
                    this._vsh.learn();
                    _Logger.debug((Object)(this._peer + " Prompt After Learning:" + this._vsh.getPrompt()));
                }
                return this.extractOutput(bufOut.toString(), command);
            }
            String output = this.extractOutput(this._vsh.readPromptCheckingPromptText(), command);
            _Logger.debug((Object)(this._peer + ": CLI Output:" + output));
            return output;
        }
        catch (IOException ex) {
            throw new SnmpException(ex.getMessage());
        }
    }

    public String executeCLICommandCheckEOLStatus(String command, String[] prompts, boolean needConfirm, boolean isPromptChange) throws SnmpException {
        String returnValue = this.executeCLICommand(command, prompts, needConfirm, isPromptChange);
        try {
            if (returnValue != null && this.findProblem()) {
                throw new SnmpException(returnValue.trim());
            }
        }
        catch (IOException e) {
            throw new SnmpException(e.getMessage());
        }
        return returnValue;
    }

    public String executeCLICommandPromptError(String command, String[] prompts, boolean needConfirm, boolean isPromptChange) throws SnmpException {
        String returnValue = this.executeCLICommand(command, prompts, needConfirm, isPromptChange);
        if (returnValue != null && returnValue.length() > 0 && (returnValue.toUpperCase().indexOf("ERROR") != -1 || returnValue.toLowerCase().indexOf("invalid") != -1)) {
            throw new SnmpException(returnValue.trim());
        }
        return returnValue;
    }

    public String executeCLICommandCheckEOLStatus(String command, String newPrompt, boolean needConfirm) throws SnmpException {
        String returnValue = this.executeCLICommand(command, newPrompt, needConfirm);
        try {
            if (returnValue != null && this.findProblem()) {
                throw new SnmpException(returnValue.trim());
            }
        }
        catch (IOException e) {
            throw new SnmpException(e.getMessage());
        }
        return returnValue;
    }

    public String executeCLICommandPromptError(String command, String newPrompt, boolean needConfirm, boolean isPromptChange) throws SnmpException {
        String[] stringArray;
        if (newPrompt != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = newPrompt;
        } else {
            stringArray = null;
        }
        return this.executeCLICommandPromptError(command, stringArray, needConfirm, isPromptChange);
    }

    public String executeCLICommandPromptError(String command, String[] prompts, boolean needConfirm) throws SnmpException {
        String returnValue = this.executeCLICommand(command, prompts, needConfirm);
        if (returnValue != null && returnValue.length() > 0 && (returnValue.toUpperCase().indexOf("ERROR") != -1 || returnValue.toLowerCase().indexOf("invalid") != -1)) {
            throw new SnmpException(returnValue.trim());
        }
        return returnValue;
    }

    public String executeCLICommandPromptError(String command, String newPrompt, boolean needConfirm) throws SnmpException {
        String[] stringArray;
        if (newPrompt != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = newPrompt;
        } else {
            stringArray = null;
        }
        return this.executeCLICommandPromptError(command, stringArray, needConfirm);
    }

    private boolean findProblem() throws IOException {
        this._vsh.send("show eol status \n");
        this._vsh.readPrompt();
        String swResult = this._vsh.getReply();
        String actualResult = FileSystemModel.stripFooter(swResult);
        actualResult = FileSystemModel.stripHeader(actualResult);
        return Integer.parseInt(actualResult.trim()) != 0;
    }

    private String extractOutput(String buf, String command) {
        int cmdIndex = buf.trim().indexOf(command.trim());
        int promptIndex = buf.lastIndexOf(this._vsh.getPrompt());
        return promptIndex != -1 ? buf.substring(cmdIndex != -1 ? command.length() + 1 : 0, promptIndex).trim() : buf.substring(cmdIndex != -1 ? command.length() + 1 : 0).trim();
    }

    public boolean isInConfigMode() {
        return this._vsh.getPrompt().indexOf("config") != -1;
    }

    public void cleanup() {
        this._vsh = null;
    }

    public void closeVsh() {
        if (this._vsh != null) {
            this._vsh.closeVsh();
        }
    }

    public String getCurrentPrompt() {
        return this._vsh.getPrompt();
    }

    public String getStartPrompt() {
        int index = this._vsh.getPrompt().indexOf("(");
        if (index != -1) {
            return this._vsh.getPrompt().substring(0, index) + "#";
        }
        return this._vsh.getPrompt();
    }

    public static String getPromptLessDelimitor(String prompt, String delimitor) {
        int ii;
        if (delimitor != null && (ii = prompt.indexOf(delimitor)) != -1) {
            return prompt.substring(0, ii);
        }
        return prompt;
    }
}

