/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpString;

class CommonRoleFeatureRule {
    String _name;
    int[] _ruleIndex;
    int[] _operations;
    int[] _operationSelected;
    int[] _permits;
    MibEnum[] _roleOperEnum = MibNode.get((String)"commonRoleFeatureOperation").getEnums();

    public CommonRoleFeatureRule(String name, int[] ruleIndex, SnmpString operations, SnmpString operSelected, int[] permits) {
        this._name = name;
        byte[] operB = operations.getValue();
        byte[] selectedB = operSelected.getValue();
        this._operations = new int[this._roleOperEnum.length + 1];
        this._operationSelected = new int[this._roleOperEnum.length + 1];
        this._permits = permits;
        this._ruleIndex = ruleIndex;
        for (int i = 1; i <= this._roleOperEnum.length; ++i) {
            this._operations[i] = SnmpString.getBit((byte[])operB, (int)i) ? 1 : 0;
            this._operationSelected[i] = SnmpString.getBit((byte[])selectedB, (int)i) ? 1 : 0;
        }
    }

    public String getName() {
        return this._name;
    }

    public int[] getRuleIndex() {
        return this._ruleIndex;
    }

    public int[] getOperations() {
        return this._operations;
    }

    public int[] getOperationSelected() {
        return this._operationSelected;
    }

    public int[] getPermits() {
        return this._permits;
    }

    void setRuleIndex(int oper, int index) {
        this._ruleIndex[oper] = index;
    }

    void setOperation(int oper) {
        this._operations[oper] = 1;
    }

    void setOperationSelected(int selected) {
        this._operationSelected[selected] = 1;
    }

    void setPermit(int oper, int permit) {
        this._permits[oper] = permit;
    }
}

