/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.mds.Panel;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class VsanIdMenuButton
extends MenuButton {
    public static final int VSAN_TYPE = 1;
    public static final int VSAN_IP_TYPE = 2;
    public static final int N5K_VSAN_IP_TYPE = 3;
    SnmpPeer _peer;
    Panel _parent;
    int _type;
    IfIndexIf _switch;

    public VsanIdMenuButton(JMenu menu, SnmpPeer peer, IfIndexIf sw) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._type = 1;
        this._switch = sw;
    }

    public VsanIdMenuButton(JMenu menu, SnmpPeer peer, int type, IfIndexIf sw) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._type = type;
        this._switch = sw;
    }

    public void setParent(Panel parent) {
        this._parent = parent;
    }

    public void setPeer(SnmpPeer peer, IfIndexIf sw) {
        this._peer = peer;
        this._switch = sw;
        this._menu = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this._menu = new JMenu();
        try {
            Object[] names;
            Object[] objectArray = names = this._type == 1 ? this.getVsanId(this._peer) : this.getVsanIPId(this._peer);
            if (names == null || names.length == 0) {
                this.setEnabled(false);
                return;
            }
            this.buildMenu(names);
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
        super.actionPerformed(e);
        if (e.getSource() instanceof JMenuItem && this._parent != null) {
            this._parent.setChanged((FieldPanel)this.getParent());
        }
    }

    protected String[] getVsanId(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] vsanName = MibNode.get((String)"vsanName").getOid();
        int oidLen = vsanName.length;
        vbl.add(new SnmpVarBind(new SnmpOID(vsanName)));
        vbl = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl, (int)0).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        Array vsanId = new Array();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            if (oid[oidLen] == 4094) continue;
            vsanId.addElement((Object)SnmpOID.toString((int[])oid, (int)oidLen, (int)oid.length));
        }
        if (vsanId.size() == 0) {
            return null;
        }
        String[] names = new String[vsanId.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)vsanId.elementAt(i);
        }
        return names;
    }

    protected String[] getVsanIPId(SnmpPeer peer) throws SnmpException {
        int[] interfaceList = new int[]{};
        int ipInterfaceType = this._type == 3 ? 5 : 4;
        try {
            interfaceList = PortChooser.fetchInterfaces(peer, ipInterfaceType, this._switch);
        }
        catch (SnmpException ex) {
            return new String[0];
        }
        if (interfaceList == null || interfaceList.length == 0) {
            return null;
        }
        String[] names = new String[interfaceList.length];
        for (int j = 0; j < interfaceList.length; ++j) {
            names[j] = this._switch.ifIndexToName(interfaceList[j]);
        }
        return names;
    }
}

