/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.FiconCacheIf;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;

public class VsanUtil {
    public static final int MAX_SLOTS = 16;
    public static final int MAX_PORTS_PER_SLOT = 64;
    public static final int MAX_BAYS = 2;
    public static final int MAX_PORTS = 1152;
    public static final int MAX_PORT_ARRAYSIZE = 144;
    public static final int MAX_ARRAYSIZE_PORT_END = 144;
    public static final int MAX_PORTCHANNELS = 256;
    public static final int MAX_PORTCHANNEL_ARRAYSIZE = 32;
    public static final int MAX_ARRAYSIZE_PORTCHANNEL_END = 176;
    public static final int MAX_PORTCHANNEL_STARTPOS = 1152;
    public static final int MAX_FCIPS = 528;
    public static final int MAX_FCIP_ARRAYSIZE = 66;
    public static final int MAX_ARRAYSIZE_FCIP_END = 242;
    public static final int MAX_FCIP_STARTPOS = 1408;
    public static final int MAX_ISCSIS = 256;
    public static final int MAX_ISCSI_ARRAYSIZE = 32;
    public static final int MAX_ARRAYSIZE_ISCSI_END = 274;
    public static final int MAX_ISCSI_STARTPOS = 1936;
    public static final int MAX_VFC_EXPLICIT = IfIndexUtil.EXPLICIT_VFC_ID_MASK + 1;
    public static final int MAX_VFC_EXPLICIT_ARRAYSIZE = MAX_VFC_EXPLICIT / 8;
    public static final int MAX_ARRAYSIZE_VFC_EXPLICIT_END = 274 + MAX_VFC_EXPLICIT_ARRAYSIZE;
    public static final int MAX_VFC_EXPLICIT_STARTPOS = 2192;
    public static final int MAX_VFC_SLOTPORTS = 4096;
    public static final int MAX_VFC_SLOTPORT_ARRAYSIZE = 512;
    public static final int MAX_ARRAYSIZE_VFC_SLOTPORT_END = MAX_ARRAYSIZE_VFC_EXPLICIT_END + 512;
    public static final int MAX_VFC_SLOTPORT_STARTPOS = MAX_ARRAYSIZE_VFC_EXPLICIT_END * 8;
    public static final int MAX_VFC_PORTCHANNELS = 4097;
    public static final int MAX_VFC_PORTCHANNEL_ARRAYSIZE = 512;
    public static final int MAX_ARRAYSIZE_VFC_PORTCHANNEL_END = MAX_ARRAYSIZE_VFC_SLOTPORT_END + 512;
    public static final int MAX_VFC_PO_STARTPOS = MAX_ARRAYSIZE_VFC_SLOTPORT_END * 8;
    public static final int MAX_VFC_FEX_IMPLICIT = 12288;
    public static final int MAX_VFC_FEX_IMPLICIT_ARRAYSIZE = 1536;
    public static final int MAX_ARRAYSIZE_VFC_FEX_IMPLICIT_END = MAX_ARRAYSIZE_VFC_PORTCHANNEL_END + 1536;
    public static final int MAX_VFC_FEX_IMPLICIT_STARTPOS = MAX_ARRAYSIZE_VFC_PORTCHANNEL_END * 8;
    public static final int RESERVERED_VSAN = 4094;
    public static final int MAX_BAY_PORT_ARRAY_SIZE = 16;
    public static final int MAX_BAY_PORT_STARTPOS = 1024;

    public static String getVSanLabel(byte[] b) {
        int i;
        if (b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8;
        for (i = 0; i < max && !VsanUtil.getBit(b, i); ++i) {
        }
        while (i < max) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(VsanUtil.portToName(i));
            while (i < max) {
                int j;
                for (j = i + 1; j < max && VsanUtil.getBit(b, j); ++j) {
                }
                if (j > i + 1) {
                    sb.append('-');
                    sb.append(VsanUtil.portToName(j - 1));
                }
                for (i = j; i < max && !VsanUtil.getBit(b, i); ++i) {
                }
                if (i >= max) continue;
                sb.append(',');
                sb.append(VsanUtil.portToName(i));
            }
        }
        return sb.toString();
    }

    public static String getVSanLabel(byte[] b, IfIndexIf ifIndexIf) {
        return VsanUtil.getVSanLabel(b, ifIndexIf, 0);
    }

    public static String getVSanLabel(byte[] b, IfIndexIf ifIndexIf, int startBitPos) {
        if (startBitPos != 0 && startBitPos != 1152 && startBitPos != 1408 && startBitPos != 1936 && startBitPos != 2192 && startBitPos != MAX_VFC_SLOTPORT_STARTPOS && startBitPos != MAX_VFC_PO_STARTPOS && startBitPos != MAX_VFC_FEX_IMPLICIT_STARTPOS) {
            throw new IllegalArgumentException("Invalid value for 'startBitPos' argument passed in :" + startBitPos);
        }
        if (b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8;
        int i = 0;
        while (i < max) {
            int j;
            while (i < max && !VsanUtil.getBit(b, i)) {
                ++i;
            }
            if (i >= max) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(VsanUtil.portToName(i + startBitPos, ifIndexIf));
            for (j = i + 1; j < max && VsanUtil.getBit(b, j) && ifIndexIf.isPortRangeSupport(); ++j) {
            }
            if (j > i + 1) {
                sb.append('-');
                sb.append(VsanUtil.portToName(j - 1 + startBitPos, ifIndexIf));
            }
            i = j;
        }
        return sb.toString();
    }

    static String getPortTypeName(String port) {
        int p = 0;
        while (!Character.isDigit(port.charAt(p))) {
            ++p;
        }
        return port.substring(0, p);
    }

    public static String getVSanLabel(byte[] b, boolean isFiconEnabled, SnmpPeer peer) {
        int i;
        if (!isFiconEnabled || peer == null) {
            return VsanUtil.getVSanLabel(b);
        }
        if (b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8;
        for (i = 0; !(i >= max || VsanUtil.getBit(b, i) && VsanUtil.portToFiconPort(i, peer) != -1); ++i) {
        }
        while (i < max) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(SnmpFiconPort.toString(VsanUtil.portToFiconPort(i, peer)));
            while (i < max) {
                int j;
                for (j = i + 1; j < max && VsanUtil.getBit(b, j) && VsanUtil.portToFiconPort(j, peer) != -1; ++j) {
                }
                if (j > i + 1) {
                    sb.append('-');
                    sb.append(SnmpFiconPort.toString(VsanUtil.portToFiconPort(j - 1, peer)));
                }
                for (i = j; !(i >= max || VsanUtil.getBit(b, i) && VsanUtil.portToFiconPort(i, peer) != -1); ++i) {
                }
                if (i >= max) continue;
                sb.append(',');
                sb.append(SnmpFiconPort.toString(VsanUtil.portToFiconPort(i, peer)));
            }
        }
        return sb.toString();
    }

    public static String getVSanLabel(byte[] b, boolean isFiconEnabled, IfIndexIf ifIndexIf, FiconCacheIf ficonCacheIf) {
        int i;
        if (!isFiconEnabled || ficonCacheIf == null) {
            return VsanUtil.getVSanLabel(b, ifIndexIf);
        }
        if (b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8;
        for (i = 0; !(i >= max || VsanUtil.getBit(b, i) && VsanUtil.portToFiconPort(i, ifIndexIf, ficonCacheIf) != -1); ++i) {
        }
        while (i < max) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(SnmpFiconPort.toString(VsanUtil.portToFiconPort(i, ifIndexIf, ficonCacheIf)));
            while (i < max) {
                int j;
                for (j = i + 1; j < max && VsanUtil.getBit(b, j) && VsanUtil.portToFiconPort(j, ifIndexIf, ficonCacheIf) != -1; ++j) {
                }
                if (j > i + 1) {
                    sb.append('-');
                    sb.append(SnmpFiconPort.toString(VsanUtil.portToFiconPort(j - 1, ifIndexIf, ficonCacheIf)));
                }
                for (i = j; !(i >= max || VsanUtil.getBit(b, i) && VsanUtil.portToFiconPort(i, ifIndexIf, ficonCacheIf) != -1); ++i) {
                }
                if (i >= max) continue;
                sb.append(',');
                sb.append(SnmpFiconPort.toString(VsanUtil.portToFiconPort(i, ifIndexIf, ficonCacheIf)));
            }
        }
        return sb.toString();
    }

    static int portToIfIndex(int i) {
        if (i >= 2192) {
            int vsifId = (i -= 2192) + 1;
            return IfIndexUtil.vfcIndexToIfIndex(vsifId, 30);
        }
        if (i >= 1936) {
            int port = (i -= 1936) % 16 + 1;
            int card = (i >> 4) + 1;
            return IfIndexUtil.nameToIfIndex(card, port, 11);
        }
        if (i >= 1408) {
            int fcip = i - 1408 + 1;
            return 0xA000000 + fcip - 1;
        }
        if (i >= 1152) {
            int portChannel = i - 1152 + 1;
            return 0x4000000 + portChannel - 1;
        }
        int port = i % 64 + 1;
        int card = (i >> 6) + 1;
        return IfIndexUtil.nameToIfIndex(card, port, 1);
    }

    static int portToIfIndex(int i, IfIndexIf ifIndexIf) {
        boolean isPortBase0;
        boolean bl = isPortBase0 = !ifIndexIf.isPortRangeSupport();
        if (i >= MAX_VFC_FEX_IMPLICIT_STARTPOS) {
            int port = (i -= MAX_VFC_FEX_IMPLICIT_STARTPOS) % 64 + 1;
            int fexChassis = (i >> 6) + 1 + 100;
            int vfcIfIndex = IfIndexUtil.getVfcIfIndex(4, -1, fexChassis - 1, port - 1, 0);
            return vfcIfIndex;
        }
        if (i >= MAX_VFC_PO_STARTPOS) {
            int vfcpo = i -= MAX_VFC_PO_STARTPOS;
            int vfcIfIndex = IfIndexUtil.getVfcIfIndex(1, 0, 0, 0, vfcpo);
            return vfcIfIndex;
        }
        if (i >= MAX_VFC_SLOTPORT_STARTPOS) {
            int port = (i -= MAX_VFC_SLOTPORT_STARTPOS) % 64 + 1;
            int card = (i >> 6) + 1;
            int vfcIfIndex = IfIndexUtil.getVfcIfIndex(2, 0, card, port, 0);
            return vfcIfIndex;
        }
        if (i >= 2192) {
            int vsifId = i -= 2192;
            int vfcIfIndex = IfIndexUtil.getVfcIfIndex(0, vsifId, 0, 0, 0);
            return vfcIfIndex;
        }
        if (i >= 1936) {
            int port = (i -= 1936) % 16 + (isPortBase0 ? 0 : 1);
            int card = (i >> 4) + 1;
            return ifIndexIf.nameToIfIndex(card, port, 11);
        }
        if (i >= 1408) {
            int fcip = i - 1408 + 1;
            return 0xA000000 + fcip - 1;
        }
        if (i >= 1152) {
            int portChannel = i - 1152 + 1;
            return 0x4000000 + portChannel - 1;
        }
        int port = i % 64 + (isPortBase0 ? 0 : 1);
        int card = (i >> 6) + 1;
        if (i >= 1024) {
            return ifIndexIf.nameToIfIndex(card, port, 153);
        }
        return ifIndexIf.nameToIfIndex(card, port, 1);
    }

    static String portToName(int i) {
        StringBuffer sb = new StringBuffer();
        if (i >= 2192) {
            int vigId = (i -= 2192) + 1;
            int vsifId = 1;
            sb.append(vigId).append("/").append(vsifId);
        } else if (i >= 1936) {
            int port = (i -= 1936) % 16 + 1;
            int card = (i >> 4) + 1;
            sb.append(card);
            sb.append('/');
            sb.append(port);
        } else if (i >= 1408) {
            int fcip = i - 1408 + 1;
            sb.append(fcip);
        } else if (i >= 1152) {
            int portChannel = i - 1152 + 1;
            sb.append(portChannel);
        } else {
            int port = i % 64 + 1;
            int card = (i >> 6) + 1;
            sb.append(card);
            sb.append('/');
            sb.append(port);
        }
        return sb.toString();
    }

    static String portToName(int i, IfIndexIf ifIndexIf) {
        StringBuffer sb = new StringBuffer();
        if (i >= MAX_VFC_FEX_IMPLICIT_STARTPOS) {
            int port = (i -= MAX_VFC_FEX_IMPLICIT_STARTPOS) % 64 + 1;
            int fexChassis = (i >> 6) + 1 + 100;
            sb.append(fexChassis);
            sb.append("/1/");
            sb.append(port);
        } else if (i >= MAX_VFC_PO_STARTPOS) {
            int vfcpo = (i -= MAX_VFC_PO_STARTPOS) + 1;
            sb.append(vfcpo);
        } else if (i >= MAX_VFC_SLOTPORT_STARTPOS) {
            int port = (i -= MAX_VFC_SLOTPORT_STARTPOS) % 64 + 1;
            int card = (i >> 6) + 1;
            sb.append(card);
            sb.append('/');
            sb.append(port);
        } else if (i >= 2192) {
            int vfcId = i -= 2192;
            sb.append(vfcId);
        } else if (i >= 1936) {
            int port = (i -= 1936) % 16 + 1;
            int card = (i >> 4) + 1;
            if (ifIndexIf.isPortRangeSupport()) {
                sb.append(card);
                sb.append('/');
                sb.append(port);
            } else {
                sb.append(ifIndexIf.ifIndexToName(ifIndexIf.nameToIfIndex(card, port - 1, 0)));
            }
        } else if (i >= 1408) {
            int fcip = i - 1408 + 1;
            sb.append(fcip);
        } else if (i >= 1152) {
            int portChannel = i - 1152 + 1;
            sb.append(portChannel);
        } else {
            int port = i % 64 + 1;
            int card = (i >> 6) + 1;
            if (ifIndexIf.isPortRangeSupport()) {
                sb.append(card);
                sb.append('/');
                sb.append(port);
            } else if (i >= 1024) {
                sb.append(ifIndexIf.ifIndexToName(ifIndexIf.nameToIfIndex(card, port - 1, 153)));
            } else {
                sb.append(ifIndexIf.ifIndexToName(ifIndexIf.nameToIfIndex(card, port - 1, 0)));
            }
        }
        return sb.toString();
    }

    static int portToFiconPort(int i, SnmpPeer peer) {
        int ifIndex;
        if (i >= 1936) {
            int port = i % 16 + 1;
            int card = (i >> 4) + 1;
            ifIndex = IfIndexUtil.nameToIfIndex(card, port, 11);
        } else if (i >= 1408) {
            int fcip = i - 1408;
            ifIndex = 0xA000000 + fcip;
        } else if (i >= 1152) {
            int portChannel = i - 1152;
            ifIndex = 0x4000000 + portChannel;
        } else {
            int port = i % 64 + 1;
            int card = (i >> 6) + 1;
            ifIndex = IfIndexUtil.nameToIfIndex(card, port, 1);
        }
        return FiconPortByIfIndexCache.getInstance(peer).getFiconPort(ifIndex);
    }

    static int portToFiconPort(int i, IfIndexIf ifIndexIf, FiconCacheIf ficonCacheIf) {
        int ifIndex;
        boolean isPortBase0;
        boolean bl = isPortBase0 = !ifIndexIf.isPortRangeSupport();
        if (i >= 1936) {
            int port = i % 16 + (isPortBase0 ? 0 : 1);
            int card = (i >> 4) + 1;
            ifIndex = ifIndexIf.nameToIfIndex(card, port, 11);
        } else if (i >= 1408) {
            int fcip = i - 1408;
            ifIndex = 0xA000000 + fcip;
        } else if (i >= 1152) {
            int portChannel = i - 1152;
            ifIndex = 0x4000000 + portChannel;
        } else {
            int port = i % 64 + (isPortBase0 ? 0 : 1);
            int card = (i >> 6) + 1;
            ifIndex = ifIndexIf.nameToIfIndex(card, port, 1);
        }
        return ficonCacheIf.getFiconAddress(ifIndex);
    }

    public static int[] getVSanMemberList(byte[] b) {
        int i;
        Array memberList = new Array();
        if (b.length == 0) {
            return new int[0];
        }
        int max = b.length * 8;
        for (i = 0; i < max; ++i) {
            if (!VsanUtil.getBit(b, i)) continue;
            memberList.addElement((Object)new Integer(VsanUtil.portToIfIndex(i)));
        }
        int[] vsanMemberList = new int[memberList.size()];
        for (i = 0; i < memberList.size(); ++i) {
            vsanMemberList[i] = (Integer)memberList.elementAt(i);
        }
        return vsanMemberList;
    }

    public static int[] getVSanMemberList(byte[] b, IfIndexIf ifIndexIf) {
        return VsanUtil.getVSanMemberList(b, ifIndexIf, 0);
    }

    public static int[] getVSanMemberList(byte[] b, IfIndexIf ifIndexIf, int startBitPos) {
        int i;
        Array memberList = new Array();
        if (b.length == 0) {
            return new int[0];
        }
        int max = b.length * 8;
        for (i = 0; i < max; ++i) {
            if (!VsanUtil.getBit(b, i)) continue;
            memberList.addElement((Object)new Integer(VsanUtil.portToIfIndex(i + startBitPos, ifIndexIf)));
        }
        int[] vsanMemberList = new int[memberList.size()];
        for (i = 0; i < memberList.size(); ++i) {
            vsanMemberList[i] = (Integer)memberList.elementAt(i);
        }
        return vsanMemberList;
    }

    public static boolean getBit(byte[] b, int pos) {
        int shift = pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        return (b[pos / 8] >> shift & 1) != 0;
    }

    public static void setBit(byte[] b, int card, int port) {
        int pos = (card << 6) + port;
        VsanUtil.setBit(b, pos);
    }

    public static void setBit(int offset, byte[] b, int card, int port) {
        int shift = offset == 1936 ? 4 : 6;
        int pos = offset + (card << shift) + port;
        VsanUtil.setBit(b, pos);
    }

    public static void setBitVsif(byte[] b, int vigOrVsifId) {
        int pos = vigOrVsifId - 1;
        VsanUtil.setBit(b, pos);
    }

    public static void setBit(byte[] b, int pos) {
        int shift = pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        int n = pos / 8;
        b[n] = (byte)(b[n] | 1 << shift);
    }

    public static void clearBit(byte[] b, int pos) {
        int shift = pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        int n = pos / 8;
        b[n] = (byte)(b[n] & ~(1 << shift));
    }

    public static byte[] testBit(byte[] b, int index) {
        if (b == null) {
            b = new byte[32];
        }
        if (index > b.length * 8) {
            byte[] newB = new byte[index / 8 + 1];
            System.arraycopy(b, 0, newB, 0, b.length);
            b = newB;
        }
        return b;
    }

    public static String getDefaultVsanName(int id) {
        int nZeros = 0;
        if (id < 10) {
            nZeros = 3;
        } else if (id < 100) {
            nZeros = 2;
        } else if (id < 1000) {
            nZeros = 1;
        }
        StringBuffer sb = new StringBuffer("VSAN");
        for (int i = 0; i < nZeros; ++i) {
            sb.append('0');
        }
        sb.append(id);
        return sb.toString();
    }

    public static boolean anyBitOn(byte[] b) {
        int pos;
        if (b == null || b.length == 0) {
            return false;
        }
        for (pos = 0; pos < b.length && !VsanUtil.getBit(b, pos); ++pos) {
        }
        return pos < b.length;
    }
}

