/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.flash;

import com.cisco.dcbu.lib.jnm.IfVshStatus;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.flash.FileSystemModel;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.MergeSort;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FlashFile {
    private static MergeSort fileMS = new MergeSort(){

        @Override
        public int compareElementsAt(int a, int b) {
            return ((MDSFile)this.toSort[a]).getName().compareTo(((MDSFile)this.toSort[b]).getName());
        }
    };
    MDSFile _file;
    protected boolean _isBuiltChildList = false;
    String _volume;
    Object[] children;
    FileSystemModel _model;
    Vsh _vsh = null;
    SnmpPeer _peer;
    JFrame _frame;

    public FlashFile(String volume, String baseDir, JFrame frame, String hostname, boolean useSSH) {
        this._volume = volume;
        this._frame = frame;
        this._file = new MDSFile(volume, baseDir);
    }

    public FlashFile(String volume, String baseDir, JFrame frame, SnmpPeer peer, boolean useSSH) {
        this._volume = volume;
        this._frame = frame;
        this._file = new MDSFile(volume, baseDir);
    }

    public FlashFile(String baseDir) {
        this._file = new MDSFile(this._volume, baseDir);
    }

    public FlashFile(MDSFile file) {
        this._file = file;
    }

    public void setModel(FileSystemModel model) {
        this._model = model;
    }

    public String toString() {
        return this._file.getDisplayName();
    }

    public MDSFile getFile() {
        return this._file;
    }

    public String getFullPath() {
        if (this.getFile().getPath() != null) {
            return (this.getFile().getPath().endsWith("/") ? this.getFile().getPath() : this.getFile().getPath() + "/") + this.getFile().getName();
        }
        return this.getFile().getName() + "//" + this.getFile().getVolume();
    }

    public static String getFullPath(Object[] pathArray) {
        StringBuffer fullPath = new StringBuffer();
        for (int j = 0; j < pathArray.length; ++j) {
            FlashFile thisNode = (FlashFile)pathArray[j];
            if (fullPath.length() > 0) {
                fullPath.append(thisNode + (j < pathArray.length - 1 ? "/" : ""));
                continue;
            }
            fullPath.append(pathArray[j] + "://" + thisNode.getFile().getVolume() + "/");
        }
        return fullPath.toString();
    }

    protected Object[] getChildren(Logger log) {
        block6: {
            if (this.children != null || this._isBuiltChildList) {
                return this.children;
            }
            try {
                Object[] files = this.list(this._file, log);
                if (files != null && files.length > 0) {
                    fileMS.sort(files);
                    this.children = new FlashFile[files.length];
                    String path = this._file._path != null ? (this._file.getPath().endsWith("/") ? this._file.getPath() : this._file.getPath() + "/") : this._file.getName() + "//" + this._file.getVolume() + "/";
                    for (int i = 0; i < files.length; ++i) {
                        this.children[i] = new FlashFile(path.trim() + ((MDSFile)files[i]).getName());
                        ((FlashFile)this.children[i])._file = files[i];
                        ((FlashFile)this.children[i])._volume = this._volume;
                        ((FlashFile)this.children[i]).setModel(this._model);
                    }
                }
                this._isBuiltChildList = true;
            }
            catch (SecurityException se) {
            }
            catch (Exception e) {
                Util.errorMessage((Component)this._frame, e);
                if (!SnmpSession.isTrace()) break block6;
                DefaultLogger._ExLogger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.children;
    }

    private MDSFile[] list(MDSFile file, Logger log) throws Exception {
        FileStruct retStruct = this.listSingle(file, log);
        MDSFile[] ret = this.listSingle((MDSFile)file, (Logger)log).files;
        if (ret.length == 0) {
            VshStatusImpl vshImpl = new VshStatusImpl();
            this._vsh = this._model._peer != null ? Vsh.get(this._model._frame, this._model._peer, this._model._useSSH, (IfVshStatus)vshImpl) : Vsh.get(this._model._frame, this._model._hostName, this._model._useSSH, (IfVshStatus)vshImpl);
            if (this._vsh != null) {
                this._vsh.closeVsh();
            }
            retStruct = this.listSingle(file, log);
            ret = this.listSingle((MDSFile)file, (Logger)log).files;
        }
        if (!retStruct.msg.equals("")) {
            Util.errorMessage((Component)this._frame, "CLI error: " + retStruct.msg);
        }
        return ret;
    }

    private FileStruct listSingle(MDSFile file, Logger log) throws Exception {
        FileStruct fileStruct = new FileStruct(new MDSFile[0], "");
        String dirContents = null;
        try {
            if (!file.isFile()) {
                VshStatusImpl vshImpl = new VshStatusImpl();
                this._vsh = this._model._peer != null ? Vsh.get(this._model._frame, this._model._peer, this._model._useSSH, (IfVshStatus)vshImpl) : Vsh.get(this._model._frame, this._model._hostName, this._model._useSSH, (IfVshStatus)vshImpl);
                if (this._vsh == null) {
                    throw new IOException("CLI connection cancelled");
                }
                String targetDir = file.getPath() == null ? file.getName() + "//" + file.getVolume() : (file.getPath().endsWith("/") ? file.getPath() : file.getPath() + "/") + file.getName();
                this._vsh.send("dir " + targetDir + "\n");
                this._vsh.readPrompt();
                dirContents = this._vsh.getReply();
                Vsh.put(this._vsh);
                this._vsh = null;
                if (dirContents.length() > 0) {
                    fileStruct = this.parseResults(dirContents, file, log);
                }
                if (SnmpSession.isTrace()) {
                    System.out.println(dirContents);
                }
                if (log != null) {
                    log.log((Priority)Level.INFO, (Object)dirContents);
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            log.log((Priority)Level.INFO, (Object)("FlashFile::listSingle: Exception caught dirContents = " + dirContents));
            throw e;
        }
        finally {
            if (this._vsh != null) {
                Vsh.put(this._vsh);
            }
        }
        return fileStruct;
    }

    FileStruct parseResults(String dirContents, MDSFile baseFile, Logger log) {
        StringTokenizer tokenizer = new StringTokenizer(dirContents, "\r\n\f");
        Vector<String> vecFiles = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                String fileInfo = "\\s{0,}\\d{1,}\\s{1,}[a-zA-Z]{3}\\s{1,}\\d{1,2}\\s{1,}\\d{2}:\\d{2}:\\d{2}\\s{1,}\\d{4}.*";
                String memUsed = "\\s{0,}\\d{1,}\\s{1,}bytes used\\s{0,}";
                String memFree = "\\s{0,}\\d{1,}\\s{1,}bytes free\\s{0,}";
                String memTotal = "\\s{0,}\\d{1,}\\s{1,}bytes total\\s{0,}";
                if (token.matches(fileInfo)) {
                    vecFiles.addElement(token);
                    continue;
                }
                if (token.matches(memUsed)) {
                    this._model._used = Long.parseLong(token.trim().split(" ")[0]);
                    continue;
                }
                if (token.matches(memFree)) {
                    this._model._free = Long.parseLong(token.trim().split(" ")[0]);
                    continue;
                }
                if (!token.matches(memTotal)) {
                    if (token.trim().startsWith("Permission denied")) {
                        return new FileStruct(new MDSFile[0], token.trim());
                    }
                    if (token.trim().startsWith("error")) {
                        return new FileStruct(new MDSFile[0], token.trim());
                    }
                    if (!token.trim().contains("failed")) continue;
                    return new FileStruct(new MDSFile[0], token.trim());
                }
                this._model._total = Long.parseLong(token.trim().split(" ")[0]);
                break;
            }
            catch (Exception e) {
                log.log((Priority)Level.INFO, (Object)("FlashFile::parseResults: Exception caught dirContents = " + dirContents));
            }
        }
        if (vecFiles.size() == 0) {
            return new FileStruct(new MDSFile[0], "");
        }
        ArrayList<MDSFile> fileList = new ArrayList<MDSFile>();
        String strFile = "";
        int column = 1;
        MDSFile file = null;
        int date = 0;
        int month = 0;
        int hr = 0;
        int min = 0;
        int second = 0;
        int year = 0;
        for (int index = 0; index < vecFiles.size(); ++index) {
            strFile = (String)vecFiles.elementAt(index);
            tokenizer = new StringTokenizer(strFile, " \t:");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                switch (column) {
                    case 1: {
                        file = new MDSFile();
                        try {
                            file._size = Integer.parseInt(token);
                        }
                        catch (NumberFormatException nfe) {
                            return new FileStruct(new MDSFile[0], "CLI error. Please close windows and try again");
                        }
                        ++column;
                        break;
                    }
                    case 2: {
                        if (token.equalsIgnoreCase("Apr")) {
                            month = 3;
                        } else if (token.equalsIgnoreCase("Feb")) {
                            month = 1;
                        } else if (token.equalsIgnoreCase("Jan")) {
                            month = 0;
                        } else if (token.equalsIgnoreCase("Mar")) {
                            month = 2;
                        } else if (token.equalsIgnoreCase("May")) {
                            month = 4;
                        } else if (token.equalsIgnoreCase("Jun")) {
                            month = 5;
                        } else if (token.equalsIgnoreCase("Jul")) {
                            month = 6;
                        } else if (token.equalsIgnoreCase("Aug")) {
                            month = 7;
                        } else if (token.equalsIgnoreCase("Sep")) {
                            month = 8;
                        } else if (token.equalsIgnoreCase("Oct")) {
                            month = 9;
                        } else if (token.equalsIgnoreCase("Nov")) {
                            month = 10;
                        } else if (token.equalsIgnoreCase("Dec")) {
                            month = 11;
                        }
                        ++column;
                        break;
                    }
                    case 3: {
                        date = Integer.parseInt(token);
                        ++column;
                        break;
                    }
                    case 4: {
                        hr = Integer.parseInt(token);
                        ++column;
                        break;
                    }
                    case 5: {
                        min = Integer.parseInt(token);
                        ++column;
                        break;
                    }
                    case 6: {
                        second = Integer.parseInt(token);
                        ++column;
                        break;
                    }
                    case 7: {
                        year = Integer.parseInt(token);
                        Calendar cal = Calendar.getInstance();
                        cal.set(year, month, date, hr, min, second);
                        file._lastModified = cal.getTime();
                        month = 0;
                        second = 0;
                        min = 0;
                        hr = 0;
                        date = 0;
                        ++column;
                        break;
                    }
                    case 8: {
                        String[] fileTokens = strFile.split("\\d{2}:\\d{2}:\\d{2}\\s{1,}\\d{4}");
                        file._fileName = fileTokens[1].trim();
                        file._path = baseFile.getPath() == null ? baseFile.getName() + "//" + baseFile.getVolume() : (baseFile.getPath().trim().endsWith("/") ? baseFile.getPath() : baseFile.getPath() + "/") + baseFile.getName();
                        fileList.add(file);
                        file = new MDSFile();
                        ++column;
                    }
                }
            }
            column = 1;
        }
        return new FileStruct(fileList.toArray(new MDSFile[fileList.size()]), "");
    }

    class Result {
        String resultString;
        boolean hasWarning;

        Result() {
        }
    }

    public class MDSFile {
        String _volumeName = null;
        String _fileName = null;
        Date _lastModified = null;
        String _path = null;
        int _size = 0;

        public MDSFile() {
        }

        public MDSFile(String volumeName, String fileName) {
            this._volumeName = volumeName;
            this._fileName = fileName;
        }

        public String getPath() {
            return this._path;
        }

        public boolean isFile() {
            return !this._fileName.trim().endsWith("/") && !this._fileName.trim().endsWith(":");
        }

        public String getName() {
            return this._fileName;
        }

        public String getVolume() {
            return this._volumeName;
        }

        public String getDisplayName() {
            return this._fileName.trim().endsWith("/") || this._fileName.trim().endsWith(":") ? this._fileName.substring(0, this._fileName.length() - 1) : this._fileName;
        }

        public Date lastModified() {
            return this._lastModified;
        }

        public int length() {
            return this._size;
        }
    }

    class FileStruct {
        MDSFile[] files = new MDSFile[0];
        String msg = "";

        public FileStruct(MDSFile[] files, String msg) {
            this.files = files;
            this.msg = msg;
        }
    }

    class VshStatusImpl
    implements IfVshStatus {
        VshStatusImpl() {
        }

        @Override
        public void setStatus(String status) {
            if (SnmpSession.isTrace()) {
                System.out.println(status);
            }
        }
    }
}

