/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.renderers;

import com.cisco.dcbu.lib.ui.table.ChangedBooleanCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CheckBoxHeaderRenderer
implements TableCellRenderer {
    private final TableCellRenderer mDelegate = new JTableHeader().getDefaultRenderer();
    private final CheckBoxIcon mCheckBoxIcon = new CheckBoxIcon();
    private KTable mTable;
    private boolean[] mHeaderValues;

    public CheckBoxHeaderRenderer(final KTable table) {
        this.mTable = table;
        JTableHeader header = table.getTableHeader();
        this.mHeaderValues = new boolean[table.getColumnModel().getColumnCount()];
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int viewColumnIndex = table.columnAtPoint(e.getPoint());
                int modelColumnIndex = table.convertColumnIndexToModel(viewColumnIndex);
                TableCellRenderer columnHeaderRen = table.getColumnModel().getColumn(viewColumnIndex).getHeaderRenderer();
                if (columnHeaderRen == CheckBoxHeaderRenderer.this && table.getModel().isCellEditable(-1, modelColumnIndex)) {
                    ((CheckBoxHeaderRenderer)CheckBoxHeaderRenderer.this).mHeaderValues[viewColumnIndex] = !CheckBoxHeaderRenderer.this.mHeaderValues[viewColumnIndex];
                    table.getTableHeader().resizeAndRepaint();
                    CheckBoxHeaderRenderer.this.setAllCellsInCol(table, viewColumnIndex, CheckBoxHeaderRenderer.this.mHeaderValues[viewColumnIndex]);
                }
            }
        });
    }

    public void resetHeaderValues() {
        this.mHeaderValues = new boolean[this.mTable.getColumnModel().getColumnCount()];
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.mDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ((JLabel)comp).setIcon(this.mCheckBoxIcon);
        JCheckBox checkBox = this.mCheckBoxIcon.getComponent();
        checkBox.setEnabled(table.getModel().isCellEditable(row, table.convertColumnIndexToModel(column)));
        if (checkBox.isEnabled()) {
            checkBox.setSelected(this.mHeaderValues[column]);
        } else {
            checkBox.setSelected(false);
        }
        return comp;
    }

    public void autoRenderBooleanColumns() {
        Enumeration<TableColumn> enumeration = this.mTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn column = enumeration.nextElement();
            int colModelIndex = column.getModelIndex();
            if (this.mTable.getModel().getColumnClass(colModelIndex) != Boolean.class) continue;
            column.setHeaderRenderer(this);
        }
    }

    public void setAllCellsInCol(KTable table, int viewColIndex, boolean flag) {
        if (table.isEditing()) {
            table.editingStopped(null);
        }
        int rows = table.getRowCount();
        for (int row = 0; row < rows; ++row) {
            if (!table.isCellEditable(row, viewColIndex)) continue;
            table.setValueAt(flag, row, viewColIndex);
        }
        table.repaint();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new WindowsLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame("Test");
        KTableModel model = new KTableModel();
        model.setHeaders(new String[]{"Col 1", "Col 2", "Col 3", "Col 4"});
        Array a = new Array();
        a.addElement((Object)new Object[]{"1", true, false, true, null});
        a.addElement((Object)new Object[]{"2", false, false, true, null});
        model.setData(a);
        model.setEditable(new boolean[]{false, true, false, true});
        KTable table = new KTable(model);
        table.setAutoResizeMode(3);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        table.setCellSelectionEnabled(true);
        JScrollPane tablePane = new JScrollPane(table);
        int[] colWidth = new int[]{90, 120, 130, 300};
        for (int i = 0; i < colWidth.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidth[i]);
        }
        tablePane.setPreferredSize(new Dimension(560, 200));
        ChangedBooleanCellRenderer booleanRenderer = new ChangedBooleanCellRenderer();
        table.setDefaultRenderer(Boolean.class, booleanRenderer);
        booleanRenderer.setHorizontalAlignment(0);
        CheckBoxHeaderRenderer headerR = new CheckBoxHeaderRenderer(table);
        headerR.autoRenderBooleanColumns();
        f.getContentPane().add("Center", tablePane);
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    private class CheckBoxIcon
    implements Icon {
        private final JCheckBox mComponent = new JCheckBox();
        private final Icon mLookAndFeelIcon = UIManager.getIcon("CheckBox.icon");

        CheckBoxIcon() {
        }

        public JCheckBox getComponent() {
            return this.mComponent;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.mLookAndFeelIcon.paintIcon(this.mComponent, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.mLookAndFeelIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.mLookAndFeelIcon.getIconHeight();
        }
    }
}

