/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.renderers;

import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;

public class IpRouteV6IndexRenderer
extends IndexCellRenderer {
    @Override
    public String getLabel(int[] index) {
        StringBuffer sb = new StringBuffer(50);
        int pos = 1;
        boolean isIpV6 = index[pos++] == 2;
        int len = isIpV6 ? 16 : 4;
        boolean isDefault = true;
        pos += len;
        for (int i = 0; i < len; ++i) {
            if (index[i + 2] == 0) continue;
            isDefault = false;
            break;
        }
        if (isDefault) {
            sb.append("default");
        } else {
            sb.append(isIpV6 ? SnmpIpAddress.toHexString((int[])index, (int)2, (int)(len + 2)) : SnmpOID.toString((int[])index, (int)2, (int)(len + 2)));
        }
        sb.append(", ");
        sb.append(index[pos++]);
        int type = index[pos++];
        if (type == 0) {
            return sb.toString();
        }
        if (type == 16) {
            sb.append(", ");
            sb.append(SnmpString.toString((int[])index, (int)pos, (int)index.length));
        } else {
            sb.append(", ");
            sb.append(type == 2 ? SnmpIpAddress.toHexString((int[])index, (int)pos, (int)index.length) : SnmpOID.toString((int[])index, (int)pos, (int)index.length));
        }
        return sb.toString();
    }
}

