/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

public abstract class AbstractZone
implements Comparator,
Comparable,
Serializable {
    public static final int ZONE = 1;
    public static final int ALIAS = 2;
    public static final int ZONE_MEMBER = 3;
    public static final int ZONESET = 4;
    private static final int MAX_MEMBER_LENGTH = 256;
    protected int type;
    protected int zoneIndex;
    protected String zoneName;
    protected long zoneLastModtime;
    public static int compareMode = 2;
    protected int zoneVsanId = -1;

    protected AbstractZone() {
    }

    public boolean isZone() {
        return this.type == 1;
    }

    public boolean isAlias() {
        return this.type == 2;
    }

    public boolean isZoneMember() {
        return this.type == 3;
    }

    public boolean isZoneset() {
        return this.type == 4;
    }

    public int getZoneIndex() {
        return this.zoneIndex;
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String name) {
        this.zoneName = name;
    }

    public int getZoneVsanId() {
        return this.zoneVsanId;
    }

    public String getZoneLastModtime() {
        return SnmpTimeticks.formatTimeAsDate((long)this.zoneLastModtime);
    }

    public long getLastModifiedAsLong() {
        return this.zoneLastModtime;
    }

    public void setZoneLastModtime(long modTime) {
        this.zoneLastModtime = modTime;
    }

    public void addMembers(CommandHandler handler, AbstractZone[] az) throws SnmpException {
    }

    public void buildLinkRemovePDU(VarBindList list, Array memberList, ZoneCapability cap) {
    }

    public void removeLink(AbstractZone member) {
    }

    public int[] getSnmpIndex() {
        return null;
    }

    public int[] getNameOID() {
        return null;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        AbstractZone z1 = (AbstractZone)o1;
        AbstractZone z2 = (AbstractZone)o2;
        return z1.toString().compareToIgnoreCase(z2.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AbstractZone z = (AbstractZone)obj;
        return this.toString().equals(obj.toString());
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public abstract int[] getRowStatusOid(boolean var1);

    public abstract void buildTimeStampVarBind(VarBindList var1);

    public AbstractZone clone(CommandHandler handler, int index, String cloneName, long sysupTime) throws SnmpException {
        return handler.clone(this, index, cloneName, sysupTime);
    }

    public boolean isIvr() {
        return this.zoneVsanId == -1;
    }

    public static void delete(CommandHandler handler, AbstractZone[] parent, AbstractZone[] az) throws SnmpException {
        handler.delete(parent, az);
    }

    public static byte[] testBit(byte[] b, int index, boolean isZeroBased) {
        int modIndex;
        int n = modIndex = isZeroBased ? index + 1 : index;
        if (b == null) {
            b = new byte[2];
        }
        if (modIndex > (b.length - 1) * 8) {
            int byteLen = modIndex / 8 + (modIndex % 8 > 0 ? 1 : 0);
            byte[] newB = new byte[byteLen + 1 > 256 ? byteLen : byteLen + 1];
            System.arraycopy(b, 0, newB, 0, b.length);
            b = newB;
        }
        return b;
    }

    public static void modifyAbstractZoneName(CommandHandler handler, ArrayList list, long sysUpTime) throws SnmpException {
        handler.modifyAbstractZoneName(list, sysUpTime);
    }

    public static int getCompareMode() {
        return compareMode;
    }

    public static void setCompareMode(int compareMode) {
        AbstractZone.compareMode = compareMode;
    }
}

