/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.SaveConfigAction;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.net.InetAddress;
import java.util.ArrayList;

public class EnhancedSaveConfigAction
extends SaveConfigAction {
    private SnmpPeer[] _cfsSwitchPeers;
    private ArrayList _peersToPoll;
    private ArrayList _failedSwitches = new ArrayList();
    StringBuffer _failedCause = new StringBuffer();

    private EnhancedSaveConfigAction(CommandHandler cmdHandler, int vsanToCopy, SnmpPeer[] cfsSwitchPeers, PollerCallbackIf pollerCallBack) {
        super(cmdHandler, vsanToCopy, null, pollerCallBack);
        this._cfsSwitchPeers = cfsSwitchPeers;
    }

    @Override
    public VarBindList getActionVarBind() throws SnmpException {
        VarBindList vb = super.getActionVarBind();
        this._failedSwitches.clear();
        this._failedCause.setLength(0);
        this._peersToPoll = new ArrayList();
        for (int i = 0; i < this._cfsSwitchPeers.length; ++i) {
            try {
                this._cfsSwitchPeers[i].set(new SnmpPDU(-93, vb));
                this._peersToPoll.add(this._cfsSwitchPeers[i]);
                continue;
            }
            catch (SnmpException ex) {
                this._failedSwitches.add(this._cfsSwitchPeers[i]);
                this._failedCause.append(this._cfsSwitchPeers[i] + ":" + ex.getMessage() + "\n");
            }
        }
        if (this._peersToPoll.size() == 0) {
            throw new SnmpException(this._failedCause.toString());
        }
        return null;
    }

    @Override
    public VarBindList getCleanUpVarBind() {
        VarBindList vb = super.getCleanUpVarBind();
        if (vb != null && vb.size() > 0) {
            try {
                new SnmpAggregrate().set(this._cfsSwitchPeers, vb);
            }
            catch (SnmpException snmpException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
        SnmpPeer[] peers = this._peersToPoll.toArray(new SnmpPeer[0]);
        VarBindList pollVb = super.getPollVarBind();
        for (int k = 0; k < peers.length; ++k) {
            try {
                SnmpPDU pdu = peers[k].send(new SnmpPDU(-96, pollVb));
                this.processPollPDU(manager, pdu);
                continue;
            }
            catch (SnmpException ex) {
                this._peersToPoll.remove(peers[k]);
                if (this._failedSwitches.contains(peers[k])) continue;
                this._failedSwitches.add(peers[k]);
                this._failedCause.append(peers[k] + ":" + ex.getMessage() + "\n");
            }
        }
        if (this._peersToPoll.size() == 0) {
            return this._failedSwitches.size() > 0 ? 2 : 1;
        }
        return 0;
    }

    private void processPollPDU(PollerManager manager, SnmpPDU pdu) throws SnmpException {
        SnmpPeer peer = this.findPeer(pdu.getAddress());
        StringBuffer peerStatus = new StringBuffer();
        int result = pdu.getVariables().intValue(0);
        if (result == 1 || result == 2) {
            peerStatus.setLength(0);
            this._pollerCallBack.pollStatus(manager, null, peerStatus.append(this.toString() + " on Enhanced " + peer));
            return;
        }
        if (result == 4) {
            this._failedSwitches.add(peer);
            this._failedCause.append(peer + ":" + MibEnum.getLabel((MibEnum[])COPY_FAIL_CAUSE_ENUM, (int)pdu.getVariables().intValue(1)) + "\n");
        }
        this._peersToPoll.remove(peer);
    }

    @Override
    public void failed(PollerManager manager, SnmpException ex) {
        super.failed(manager, new SnmpException(this._failedCause.toString()));
    }

    public static AbstractMdsAction createAction(CommandHandler cmdHandler, int vsanToCopy, SnmpPeer[] enhancedSws, PollerManager manager, PollerCallbackIf callback) throws SnmpException {
        EnhancedSaveConfigAction act = new EnhancedSaveConfigAction(cmdHandler, vsanToCopy, enhancedSws, callback);
        manager.addTask(act);
        return act;
    }

    private SnmpPeer findPeer(InetAddress add) throws SnmpException {
        for (int i = 0; i < this._cfsSwitchPeers.length; ++i) {
            if (!this._cfsSwitchPeers[i].getAddress().equals(add)) continue;
            return this._cfsSwitchPeers[i];
        }
        return null;
    }
}

