/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.MdsCommandHandler;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.ZoneActivationAction;
import com.cisco.dcbu.lib.mds.zm.ZoneCommitAction;
import com.cisco.dcbu.lib.mds.zm.ZoneMode;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class IvrCfsZoneActivationAction
extends ZoneActivationAction {
    private boolean _isCommitted;

    private IvrCfsZoneActivationAction(CommandHandler cmdHandler, ZoneSet zs, boolean activate, PollerCallbackIf pollerCallBack, VersionPeer[] cfsSws) {
        super(cmdHandler, zs, activate, pollerCallBack, cfsSws);
    }

    @Override
    public VarBindList getPollVarBind() {
        VarBindList vb = super.getPollVarBind();
        if (this._zs.isIvr()) {
            vb.add(ZoneCommitAction.IVR_ZONESET_COMMIT_RESULT, MdsCommandHandler.IVR_CFS_INDEX);
            vb.add(ZoneCommitAction.IVR_ZONESET_COMMIT_REASON, MdsCommandHandler.IVR_CFS_INDEX);
        }
        return vb;
    }

    @Override
    public VarBindList getActionVarBind() throws SnmpException {
        VarBindList vb = super.getActionVarBind();
        this._isCommitted = false;
        if (this._zs.isIvr()) {
            try {
                SnmpPDU setPDU = new SnmpPDU(-93, vb);
                SnmpFetch.set((SnmpPeer)this._cmdHandler.getSnmpPeer(), (SnmpPDU)new SnmpPDU(-93, vb));
            }
            catch (SnmpException ex) {
                if (ex.getMessage().toLowerCase().indexOf("timeout") != -1 || ex.getMessage().toLowerCase().indexOf("n/a") != -1) {
                    System.out.println("Ignoring TIMEOUT and checking for locked session.");
                    ZoneMode zmMode = this._cmdHandler.getZoneMode();
                    if (!zmMode.isEnhanced() || !zmMode.isCommitPending()) {
                        throw ex;
                    }
                }
                throw ex;
            }
            vb = new VarBindList();
            vb.add(ZoneCommitAction.IVR_ZONESET_COMMIT, MdsCommandHandler.IVR_CFS_INDEX, (SnmpVar)new SnmpInt(4));
        }
        return vb;
    }

    @Override
    public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
        int resultactivation = super.pollStatus(manager, response, status);
        if (!this._isCommitted) {
            int result = ZoneCommitAction.handlePollStatus(manager, response, status, this._zs.getZoneVsanId(), this._pollerCallBack, 1);
            if (result == 1) {
                this._isCommitted = true;
                status.setLength(0);
                status.append(manager.getSwitchPeer() + ":Commit Successful");
                result = 0;
            }
            this._pollerCallBack.pollStatus(manager, response, status);
            return result;
        }
        return resultactivation;
    }

    public boolean isCommitSuccessful() {
        return this._isCommitted;
    }

    public static AbstractMdsAction createAction(CommandHandler cmdHandler, ZoneSet zs, boolean activate, PollerManager manager, PollerCallbackIf callback, boolean createActive, VersionPeer[] cfsSws) throws SnmpException {
        IvrCfsZoneActivationAction act = new IvrCfsZoneActivationAction(cmdHandler, zs, activate, callback, cfsSws);
        act._createActiveZoneset = createActive;
        manager.addTask(act);
        manager.setignoreTimeout(true);
        return act;
    }
}

