/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;

public class PollerManager
implements Runnable {
    public static final int IN_PROGRESS = 0;
    public static final int SUCCESS = 1;
    public static final int FAIL = 2;
    public static final String TIME_OUT_STRING = "timeout";
    private ArrayList _tasks = new ArrayList();
    private ArrayList _taskInitiators = new ArrayList();
    private PollerCallbackIf _initiator;
    private SnmpPeer _switchPeer;
    private ArrayList _finishedTasks = new ArrayList();
    private boolean _stopped;
    private boolean _ignoreTimeout = false;

    public PollerManager(PollerCallbackIf initiator, SnmpPeer peer) {
        this._initiator = initiator;
        this._switchPeer = peer;
    }

    public void setignoreTimeout(boolean ignoreTimeout) {
        this._ignoreTimeout = ignoreTimeout;
    }

    public boolean getignoreTimeout() {
        return this._ignoreTimeout;
    }

    public SnmpPeer getSwitchPeer() {
        return this._switchPeer;
    }

    public void addTask(AbstractMdsAction action) throws SnmpException {
        KPoller poller = new KPoller(action, this);
        this._tasks.add(poller);
        this._taskInitiators.add(action);
    }

    public boolean tasksFinished() {
        return this._tasks.size() == 0;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public int getRemainingTasks() {
        return this._tasks.size();
    }

    public ArrayList getRemTasks() {
        return this._tasks;
    }

    public ArrayList getFinishedTasks() {
        return this._finishedTasks;
    }

    private synchronized void startRun() {
        try {
            this._stopped = false;
            while (this._tasks.size() > 0) {
                KPoller poller = (KPoller)this._tasks.get(0);
                this._initiator.pollStatus(this, null, new StringBuffer(poller.getAction().toString()));
                poller.start();
                if (!poller.getAction().isPollableAction()) continue;
                this.wait();
            }
        }
        catch (InterruptedException ex) {
        }
        catch (SnmpException ex) {
            this.failed(ex);
        }
        this._initiator.success(this, new StringBuffer(this._stopped ? "Stopped" : "Finished"));
    }

    public AbstractMdsAction getTaskAction(int index) {
        if (index < 0 || index >= this._tasks.size()) {
            return null;
        }
        return ((KPoller)this._tasks.get(index)).getAction();
    }

    @Override
    public void run() {
        this.startRun();
    }

    public boolean isStopped() {
        return this._stopped;
    }

    public int pollStatus(VarBindList response, StringBuffer status) {
        return ((PollerCallbackIf)this._taskInitiators.get(0)).pollStatus(this, response, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void success(StringBuffer status) {
        PollerManager pollerManager = this;
        synchronized (pollerManager) {
            if (this._taskInitiators.size() > 0) {
                this._finishedTasks.add(this._taskInitiators.get(0));
                ((PollerCallbackIf)this._taskInitiators.get(0)).success(this, status);
                this._taskInitiators.remove(0);
            }
            if (this._tasks.size() > 0) {
                this._tasks.remove(0);
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failed(SnmpException ex) {
        PollerManager pollerManager = this;
        synchronized (pollerManager) {
            if (ex != null && this._taskInitiators.size() > 0) {
                ((PollerCallbackIf)this._taskInitiators.get(0)).failed(this, ex);
            }
            this._tasks.clear();
            this._taskInitiators.clear();
            this.notify();
        }
    }

    public synchronized void stop() {
        for (int i = 0; i < this._tasks.size(); ++i) {
            ((KPoller)this._tasks.get(i)).stop();
        }
        this._tasks.clear();
        this._taskInitiators.clear();
        this._stopped = true;
        this.notify();
    }

    class KPoller
    implements ActionListener {
        static final int POLL_INTERVAL = 3000;
        private SnmpPeer _peer;
        private int _elapsedSecs;
        private boolean _isStopped;
        private Timer _statusTimer;
        private PollerManager _initiator;
        private AbstractMdsAction _action;

        public KPoller(AbstractMdsAction action, PollerManager initiator) throws SnmpException {
            this._peer = PollerManager.this.getSwitchPeer();
            this._action = action;
            this._initiator = initiator;
        }

        public AbstractMdsAction getAction() {
            return this._action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == this._statusTimer && !this._isStopped) {
                    this.timerAction();
                }
            }
            catch (SnmpException ex) {
                PollerManager.this.failed(ex);
            }
        }

        public void stop() {
            if (null != this._statusTimer) {
                this._statusTimer.stop();
                this._statusTimer = null;
            }
            this._isStopped = true;
        }

        public void start() throws SnmpException {
            if (!this._action.isPollableAction()) {
                this._action.startAction();
                this._initiator.success(new StringBuffer("Success:" + this._action));
            } else {
                this.init();
                this._statusTimer = new Timer(3000, this);
                this._elapsedSecs = 0;
                this._statusTimer.start();
            }
        }

        private void timerAction() throws SnmpException {
            int status;
            StringBuffer buf = new StringBuffer("checking status, elapsed time:" + this._elapsedSecs / 1000 + " sec");
            VarBindList vblPoll = this._action.getPollVarBind();
            VarBindList resp = null;
            if (vblPoll != null) {
                SnmpPDU pdu = new SnmpPDU(-96, vblPoll);
                if (this._action.getPollPDUTimeOut() > 0) {
                    pdu.setTimeout(this._action.getPollPDUTimeOut());
                }
                try {
                    resp = this._peer.set(pdu).getVariables();
                }
                catch (SnmpException ex) {
                    if (ex.getMessage().toLowerCase().indexOf(PollerManager.TIME_OUT_STRING) != -1) {
                        System.out.println("Got TIMEOUT EXCEPTION, Ignored for Large Zone Database:" + PollerManager.this.getignoreTimeout());
                    }
                    if (!PollerManager.this.getignoreTimeout() && ex.getMessage().indexOf(PollerManager.TIME_OUT_STRING) == -1) {
                        throw ex;
                    }
                    System.out.println("TIMEOUT TRACE Ignore TIME OUT for Large Zone Database ");
                    this._elapsedSecs += 3000;
                    return;
                }
            }
            if ((status = this._initiator.pollStatus(resp, buf)) == 0) {
                this._elapsedSecs += 3000;
            } else {
                this._statusTimer.stop();
                this._statusTimer = null;
                this.cleanUp();
                if (status != 1) {
                    this._initiator.failed(new SnmpException(buf.toString()));
                } else {
                    this._initiator.success(buf);
                }
            }
        }

        private void cleanUp() throws SnmpException {
            VarBindList cleanUpVarBind = this._action.getCleanUpVarBind();
            if (cleanUpVarBind != null && cleanUpVarBind.size() > 0) {
                this._peer.set(new SnmpPDU(-93, cleanUpVarBind));
            }
        }

        private void init() throws SnmpException {
            VarBindList actionVarBind = this._action.getActionVarBind();
            if (actionVarBind != null) {
                SnmpFetch.set((SnmpPeer)this._peer, (SnmpPDU)new SnmpPDU(-93, actionVarBind));
            }
        }
    }
}

