/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.ArrayList;
import java.util.Comparator;

public class VsanOb
implements Comparator,
Comparable {
    ArrayList vsanList;
    int vsanId;
    String vsanName;

    public VsanOb(int vsan, String name) {
        this.vsanId = vsan;
        this.vsanName = name;
    }

    public static ArrayList discoverVsans(SnmpPeer peer) throws SnmpException {
        ArrayList<VsanOb> vsans = new ArrayList<VsanOb>();
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get((String)"vsanName").getOid());
        VarBindList resp = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)vbl).getVariables();
        for (int k = 0; k < resp.size(); ++k) {
            int[] oid = resp.getVb(k).getOid().getValue();
            vsans.add(new VsanOb(oid[oid.length - 1], resp.stringValue(k)));
        }
        return vsans;
    }

    public static VsanOb findVsanOb(int vsanId, ArrayList vsanList) {
        for (int k = 0; k < vsanList.size(); ++k) {
            VsanOb obb = (VsanOb)vsanList.get(k);
            if (obb.vsanId != vsanId) continue;
            return obb;
        }
        return null;
    }

    public String toString() {
        return this.vsanName + (this.vsanId > 0 ? "(" + this.vsanId + ")" : "");
    }

    public int getVsanId() {
        return this.vsanId;
    }

    public ArrayList getVsanList() {
        return this.vsanList;
    }

    public String getVsanName() {
        return this.vsanName;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        VsanOb vo1 = (VsanOb)o1;
        VsanOb vo2 = (VsanOb)o2;
        return vo1.vsanId - vo2.vsanId;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }
}

