/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.mds.zm.CopyFullZoneAction;
import com.cisco.dcbu.lib.mds.zm.EnhancedSaveConfigAction;
import com.cisco.dcbu.lib.mds.zm.IvrCfsZoneActivationAction;
import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.SaveConfigAction;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.Zone;
import com.cisco.dcbu.lib.mds.zm.ZoneActivationAction;
import com.cisco.dcbu.lib.mds.zm.ZoneAlias;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.mds.zm.ZoneCommitAction;
import com.cisco.dcbu.lib.mds.zm.ZoneData;
import com.cisco.dcbu.lib.mds.zm.ZoneDistributeAction;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.mds.zm.ZoneUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ZoneAction
implements PollerCallbackIf {
    static final String SELECT_NODE = "Please select a single node.";
    public static final String INVALID_TFTP = "Invalid TFTP server address";
    static final String COLON = ":";
    protected ZoneData _zoneData;
    protected VersionPeer swVesionrPeer;
    protected int _vsanId;
    protected PollerManager[] _manager;
    protected StatusIf _dialog;
    protected boolean _failed;
    private ZoneSet _ivrZoneSet;
    protected boolean _activate;
    private ArrayList _fullZoneDatabase;
    protected OutputStream _out;
    protected ArrayList _failedList = new ArrayList();
    protected boolean _createActiveZoneset;
    protected boolean _findZoneSetIndex;
    protected VersionPeer[] _cfsSwitchPeers;
    protected ZoneCapability _zoneCapability;
    protected ArrayList _ivrZoneSwitchInfo;
    protected int _ivrRegionID;
    protected ArrayList _vsanVersionPeers;

    public ZoneAction(StatusIf dialog, ArrayList ivrSwLst, int regionId) {
        this._dialog = dialog;
        this._ivrZoneSwitchInfo = ivrSwLst;
        this.createZoneData();
        this._ivrRegionID = regionId;
    }

    protected void createZoneData() {
        this._zoneData = new ZoneData();
    }

    public ArrayList getAllIvrSwitchesInfo() {
        return this._ivrZoneSwitchInfo;
    }

    public ArrayList getIvrSwitchesInfo(int regionId) {
        ArrayList<IvrZoneSwitch> regionSw = new ArrayList<IvrZoneSwitch>();
        if (this._ivrZoneSwitchInfo != null) {
            for (int i = 0; i < this._ivrZoneSwitchInfo.size(); ++i) {
                IvrZoneSwitch zsw = (IvrZoneSwitch)this._ivrZoneSwitchInfo.get(i);
                if (regionId <= 0) {
                    if (zsw._ivrRegionId > 0) continue;
                    regionSw.add(zsw);
                    continue;
                }
                if (zsw._ivrRegionId != regionId) continue;
                regionSw.add(zsw);
            }
        }
        return regionSw;
    }

    public void setVsanSwitch(VersionPeer sw, int vsan, ArrayList vsanVerPeers) throws SnmpException {
        this.swVesionrPeer = sw;
        this._vsanId = vsan;
        this.setVsanSwitch();
        this._zoneCapability = this._zoneData.getZoneCapability();
        this._vsanVersionPeers = vsanVerPeers;
    }

    protected void setVsanSwitch() throws SnmpException {
        this._zoneData.setVsanSwitch(this.swVesionrPeer, this._vsanId, this._dialog);
    }

    public CommandHandler getCmdHandler() {
        return this._zoneData.getCmdHandler();
    }

    public Object[] refresh() throws SnmpException {
        ArrayList<Object[]> zoneSetCollection;
        this.getCmdHandler().resetDiscovery();
        this._zoneData.refreshZoningMode();
        this._zoneData.populateData();
        this._dialog.setStatus("Zone Discovery Finished");
        Object[] fullzoneData = new Object[3];
        Object[] zonesets = this._zoneData.getZonesets().toArray();
        Arrays.sort(zonesets);
        Object[] ob = this._zoneData.getZones().toArray();
        Arrays.sort(ob);
        fullzoneData[1] = ob;
        Object[] obAlias = this._zoneData.getAliases().toArray();
        Arrays.sort(obAlias);
        fullzoneData[2] = obAlias;
        fullzoneData[0] = zoneSetCollection = new ArrayList<Object[]>();
        for (int i = 0; i < zonesets.length; ++i) {
            Object[] zoneSetDetails = new Object[]{zonesets[i], this._zoneData.getZoneSetMembers((ZoneSet)zonesets[i])};
            zoneSetCollection.add(zoneSetDetails);
        }
        return fullzoneData;
    }

    public Object[] refresh(boolean enforced) throws SnmpException {
        this._zoneData.refreshZoningMode();
        this._zoneData.populateZoneZoneSetData(enforced);
        if (this._vsanId == -1) {
            this._zoneData.populateZoneMemberData(enforced);
        }
        return null;
    }

    public void stopPolling() {
        if (this._manager != null) {
            for (int i = 0; i < this._manager.length; ++i) {
                if (this._manager[i] == null) continue;
                this._manager[i].stop();
            }
            this._manager = null;
        }
        this._dialog.setStatus("Stopped Polling");
    }

    public void close() {
        this.stopPolling();
        this._dialog.dispose();
    }

    public ArrayList getZoneMembers(Zone az) {
        return this._zoneData.getZoneMembers(az);
    }

    public ArrayList getDetailedAliases() {
        return this._zoneData.getDetailedAliases();
    }

    public void refreshZoningMode() throws SnmpException {
        this._zoneData.refreshZoningMode();
    }

    protected void updateCommitForAction(AbstractMdsAction act) {
    }

    @Override
    public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
        if (this._vsanId == -1) {
            AbstractMdsAction act = manager.getTaskAction(0);
            if (act != null && act instanceof ZoneActivationAction) {
                this.showStatus(manager.getSwitchPeer() + COLON + status.toString());
                this.updateCommitForAction(act);
            } else {
                this._dialog.setStatus(manager.getSwitchPeer() + COLON + status.toString());
            }
        } else {
            this._dialog.setStatus(manager.getSwitchPeer() + COLON + status.toString());
        }
        return 0;
    }

    @Override
    public void failed(PollerManager manager, SnmpException ex) {
        if (this._manager != null) {
            AbstractMdsAction task = manager.getTaskAction(0);
            if (manager.getSwitchPeer().compareTo(this.swVesionrPeer.getSwitchPeer()) == 0 && task != null && task instanceof ZoneActivationAction && ex.toString().indexOf("already active") != -1 && this._zoneData.getActiveZoneSet() != null && this._zoneData.getLocalActiveZoneSet() != null && this._zoneData.getActiveZoneSet().getLastModifiedAsLong() < this._zoneData.getLocalActiveZoneSet().getLastModifiedAsLong()) {
                this._zoneData.getActiveZoneSet().setZoneLastModtime(this._zoneData.getLocalActiveZoneSet().getLastModifiedAsLong());
            }
            this._failedList.add(new SnmpException(manager.getSwitchPeer().toString() + COLON + ex.getMessage()));
            this._failed = true;
            this.showStatus(manager.getSwitchPeer() + COLON + ex.getMessage());
        }
    }

    private void showFailedMessage() {
        Exception[] exp = new Exception[this._failedList.size()];
        for (int e = 0; e < exp.length; ++e) {
            exp[e] = (Exception)this._failedList.get(e);
        }
        this._dialog.handleError(exp);
    }

    protected void refreshDevice() {
    }

    public void runRefreshOnSeparateThread() {
    }

    @Override
    public void success(PollerManager manager, StringBuffer status) {
        if (manager != null) {
            this.showStatus(manager.getSwitchPeer() + COLON + status.toString());
            if (manager.getSwitchPeer().compareTo(this.swVesionrPeer.getSwitchPeer()) == 0 && manager.getTaskAction(0) != null) {
                if (manager.getTaskAction(0) instanceof ZoneActivationAction || this.isEnhanced() && manager.getTaskAction(0) instanceof ZoneCommitAction) {
                    if (this._activate) {
                        this._zoneData.fetchActiveZoneSet();
                    } else if (!this.isEnhanced() || !(manager.getTaskAction(0) instanceof ZoneCommitAction)) {
                        this._zoneData.resetActiveZoneset();
                    }
                    try {
                        this._zoneData.cacheActiveLocalZoneset(true);
                    }
                    catch (SnmpException ex) {
                        this._dialog.setStatus("Failed to get zone time stamp " + ex.getMessage());
                    }
                    try {
                        this.refreshDevice();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (manager.getTaskAction(0) instanceof ZoneCommitAction) {
                    this.updateCommit();
                    if (((ZoneCommitAction)manager.getTaskAction(0)).isDiscardCommand()) {
                        this.runRefreshOnSeparateThread();
                    }
                }
            }
        }
        if (this.areAllPollersfinished()) {
            this._dialog.setStatus(this._failed ? "Failed" : "Success");
            if (this._failed && (manager == null || !manager.isStopped())) {
                this.showFailedMessage();
            }
            this._dialog.actionFinished();
        }
    }

    protected void updateCommit() {
        try {
            this._zoneData.updateCommit(false);
        }
        catch (SnmpException ex) {
            this._dialog.setStatus("Failed to update read from object " + ex.getMessage());
        }
    }

    private boolean areAllPollersfinished() {
        if (this._manager != null) {
            for (int i = 0; i < this._manager.length; ++i) {
                if (this._manager[i] == null || this._manager[i].tasksFinished()) continue;
                return false;
            }
        }
        return true;
    }

    public String getNewZoneName() {
        return (this._vsanId == -1 ? "IvrZone" : "Zone") + this._zoneData.getNextZoneId();
    }

    public ArrayList getAvailableZoneSets() {
        return this._zoneData.getZonesets();
    }

    public ArrayList getAvailableZones() {
        return this._zoneData.getZones();
    }

    public ZoneSet createZoneSet(String zonesetName, String zoneName, boolean readOnly, Array members, boolean qos, int qospriority, boolean broadcast, HashMap vsanAfid, long sysUpTime) throws SnmpException {
        return this._zoneData.createZoneSet(zonesetName, zoneName, this._zoneData.getNextZoneId(), readOnly, members, qos, qospriority, broadcast, vsanAfid, sysUpTime);
    }

    ZoneSet getLocalActiveZoneSet() {
        return this._zoneData.getLocalActiveZoneSet();
    }

    public boolean activateAction(ZoneSet zs, boolean b, boolean saveConfig, String fileName, boolean createActiveZoneset) throws SnmpException {
        this.clearFailStatus();
        this._activate = b;
        this._createActiveZoneset = createActiveZoneset;
        if (this._vsanId == -1) {
            return this.initiateIvrZoneActivation(zs, b, saveConfig, fileName);
        }
        if (zs == null) {
            throw new SnmpException("Please select a Zoneset");
        }
        this._manager = new PollerManager[]{new PollerManager(this, this.swVesionrPeer.getSwitchPeer())};
        this.buildActivationActions(this.swVesionrPeer, zs, b, this._manager[0], saveConfig, fileName, this.isEnhanced());
        this._manager[0].start();
        return true;
    }

    public boolean distributeAction(int v) throws SnmpException {
        this.clearFailStatus();
        this._manager = new PollerManager[]{new PollerManager(this, this.swVesionrPeer.getSwitchPeer())};
        ZoneDistributeAction.createAction(v, this._manager[0], this);
        this._manager[0].start();
        return true;
    }

    public boolean commitAction(int v) throws SnmpException {
        return this.commitAction(v, v == -1 ? 4 : 1);
    }

    public boolean commitAction(int v, int command) throws SnmpException {
        this.clearFailStatus();
        this._manager = new PollerManager[]{new PollerManager(this, this.swVesionrPeer.getSwitchPeer())};
        ZoneCommitAction.createAction(this.swVesionrPeer, v, this._manager[0], this, command);
        this._manager[0].start();
        return true;
    }

    protected void clearFailStatus() {
        this._failed = false;
        this._failedList.clear();
        this._cfsSwitchPeers = null;
    }

    protected void buildActivationActions(VersionPeer sw, ZoneSet zs, boolean b, PollerManager manager, boolean saveConfig, String fileName, boolean isEnhanced) throws SnmpException {
        CommandHandler cmdH;
        if (zs.getZoneVsanId() == -1 && !b) {
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get((String)"civrZoneEnforcedZoneSetName").getOid(), 0);
            String ivrActZnst = SnmpFetch.get((SnmpPeer)sw.getSwitchPeer(), (VarBindList)vbl).getVariables().stringValue(0);
            if (ivrActZnst == null || ivrActZnst.length() == 0) {
                return;
            }
        }
        if (!(cmdH = this.getCmdHandler()).getVerPeer().getSwitchPeer().equals((Object)sw.getSwitchPeer())) {
            cmdH = ZoneUtil.getCommandHandler(sw.getIvrCapability(), zs.getZoneVsanId(), sw, cmdH._statusIf);
        }
        if (zs.getZoneVsanId() == -1 && isEnhanced) {
            IvrCfsZoneActivationAction.createAction(cmdH, zs, b, manager, this, this._createActiveZoneset, this._cfsSwitchPeers);
        } else {
            if (isEnhanced) {
                ArrayList enhancedModeSws = new ArrayList();
                ArrayList nonEnhancedModeSws = new ArrayList();
                if (this._vsanVersionPeers != null) {
                    ZoneUtil.getIVRCfsLockSw(this._vsanVersionPeers, enhancedModeSws, nonEnhancedModeSws, this._vsanId);
                }
                this._cfsSwitchPeers = enhancedModeSws.toArray(new VersionPeer[enhancedModeSws.size()]);
            }
            this.buildActivationAction(cmdH, zs, b, manager);
            if (isEnhanced) {
                ZoneCommitAction.createAction(sw, this._vsanId, manager, this);
            }
        }
        this.buildSaveConfigActions(sw, zs, b, manager, saveConfig, fileName, isEnhanced);
    }

    protected void buildActivationAction(CommandHandler cmdH, ZoneSet zs, boolean activate, PollerManager manager) throws SnmpException {
        ZoneActivationAction.createAction(cmdH, zs, activate, manager, this, this._createActiveZoneset, null);
    }

    protected void buildSaveConfigActions(VersionPeer sw, ZoneSet zs, boolean b, PollerManager manager, boolean saveConfig, String fileName, boolean isEnhanced) throws SnmpException {
        AbstractMdsAction act = null;
        CommandHandler cmdH = this.getCmdHandler();
        if (!cmdH.getVerPeer().getSwitchPeer().equals((Object)sw.getSwitchPeer())) {
            cmdH = ZoneUtil.getCommandHandler(sw.getIvrCapability(), zs.getZoneVsanId(), sw, cmdH._statusIf);
        }
        if (saveConfig) {
            act = isEnhanced ? EnhancedSaveConfigAction.createAction(cmdH, SaveConfigAction.getVsanIdForSaveConfig(this._vsanId, true), VersionPeer.getSnmpPeersFromVerPeers(this._cfsSwitchPeers), manager, this) : SaveConfigAction.createAction(cmdH, SaveConfigAction.getVsanIdForSaveConfig(this._vsanId, true), null, manager, this, null);
            act.setOutputStream(this._out);
        }
        if (fileName != null && fileName.length() > 0 && sw.equals(this.swVesionrPeer)) {
            String tftpServerAddress = null;
            try {
                tftpServerAddress = NetUtil.detectSourceAddress((InetAddress)sw.getSwitchPeer().getAddress()).getHostAddress();
                this._dialog.setStatus("Using TFTP Address:" + tftpServerAddress);
            }
            catch (Exception ex) {
                throw new SnmpException("Invalid TFTP server address: " + ex.getMessage());
            }
            act = SaveConfigAction.createAction(cmdH, SaveConfigAction.getVsanIdForSaveConfig(this._vsanId, true), fileName, manager, this, tftpServerAddress);
            act.setOutputStream(this._out);
        }
    }

    private boolean initiateIvrZoneActivation(ZoneSet zs, boolean activate, boolean saveConfig, String fileName) throws SnmpException {
        int i;
        if (zs == null) {
            throw new SnmpException("Please select a Zoneset");
        }
        this._ivrZoneSet = zs;
        ArrayList swList = this.buildIvrEnabledSwitches();
        ArrayList enhancedModeSws = new ArrayList();
        ArrayList nonEnhancedModeSws = new ArrayList();
        ZoneUtil.getIVRCfsLockSw(swList, enhancedModeSws, nonEnhancedModeSws, -1);
        if (swList.size() > 1 && activate && nonEnhancedModeSws.size() > 0) {
            System.out.println("Setting up full Zoning Database for non Enhanced mode switches:" + nonEnhancedModeSws);
            this._fullZoneDatabase = this.getCmdHandler().buildFullZoneCmdArray(this._zoneData.getZonesets(), this._zoneData.getZones(), this._zoneData.getZoneMembers(), null, -1);
        } else {
            this._fullZoneDatabase = null;
        }
        this._manager = new PollerManager[nonEnhancedModeSws.size() + (enhancedModeSws.size() > 0 ? 1 : 0)];
        for (i = 0; i < nonEnhancedModeSws.size(); ++i) {
            this._manager[i] = new PollerManager(this, ((VersionPeer)nonEnhancedModeSws.get(i)).getSwitchPeer());
            this.buildAction((VersionPeer)nonEnhancedModeSws.get(i), zs, activate, this._manager[i], saveConfig, this.swVesionrPeer.equals(nonEnhancedModeSws.get(i)) ? fileName : null, false);
        }
        if (enhancedModeSws.size() > 0) {
            this._cfsSwitchPeers = enhancedModeSws.toArray(new VersionPeer[enhancedModeSws.size()]);
            VersionPeer enhSw = enhancedModeSws.contains(this.swVesionrPeer) ? this.swVesionrPeer : (VersionPeer)enhancedModeSws.get(0);
            this._manager[this._manager.length - 1] = new PollerManager(this, enhSw.getSwitchPeer());
            this.buildAction(enhSw, zs, activate, this._manager[this._manager.length - 1], saveConfig, enhSw.equals(this.swVesionrPeer) ? fileName : null, true);
        }
        for (i = 0; i < this._manager.length; ++i) {
            this._manager[i].start();
        }
        return true;
    }

    public ArrayList buildIvrEnabledSwitches() {
        return IvrZoneSwitch.getIvrSwitches(this.getIvrSwitchesInfo(this._ivrRegionID), true);
    }

    protected void buildAction(VersionPeer sw, ZoneSet zs, boolean activate, PollerManager manager, boolean saveConfig, String fileName, boolean isEnhanced) throws SnmpException {
        if (this._fullZoneDatabase != null && activate && sw != this.swVesionrPeer) {
            System.out.println("Setting up full Zoning Database to be copied to switch:" + sw);
            CopyFullZoneAction action = new CopyFullZoneAction((PollerCallbackIf)this, this._dialog, this._fullZoneDatabase, sw, -1, -1);
            action.setOutputStream(this._out);
            manager.addTask(action);
        }
        ZoneSet zsToActivate = zs;
        this.buildActivationActions(sw, zsToActivate, activate, manager, saveConfig, sw.equals(this.swVesionrPeer) ? fileName : null, isEnhanced);
    }

    public boolean isActiveLocalZonesetModified() {
        return ZoneSet.isModifiedActive(this._zoneData.getActiveZoneSet(), this._zoneData.getLocalActiveZoneSet());
    }

    public ZoneSet getActiveZoneSet() {
        return this._zoneData.getActiveZoneSet();
    }

    public String toString() {
        return this._vsanId == -1 ? "Start Ivr Zone " + this._ivrZoneSet + " Activation" : "Start Zone Activation";
    }

    private void showStatus(String str) {
        AbstractMdsAction.writeOut(this._out, str);
        this._dialog.setStatus(str);
    }

    public ArrayList getDetailedZones(ArrayList zoneList, ZoneSet zs) {
        return this._zoneData.getDetailedZones(this._zoneData.getZoneSetMembers(zs));
    }

    public ZoneSet getActiveLocalZoneSet() {
        return this._zoneData.getLocalActiveZoneSet();
    }

    public void setOutStream(OutputStream out) {
        this._out = out;
    }

    public static void validateVsansForIVR(ArrayList zonemembers, ZoneSet zs) throws SnmpException {
        ZoneAction.validateVsansForIVR(zonemembers);
    }

    public static void validateVsansForIVR(ArrayList vsanList) throws SnmpException {
    }

    public static HashMap validateDomainsForIVR(ArrayList vsanList) throws SnmpException {
        return null;
    }

    public boolean isZoneMemberOfZnst(String zoneName, String zonesetName) {
        Zone zn = this._zoneData.findZone(zoneName);
        if (zn == null) {
            return false;
        }
        ZoneSet zs = this._zoneData.findZoneSet(zonesetName);
        if (zs == null) {
            return false;
        }
        ArrayList<Zone> znLst = new ArrayList<Zone>();
        znLst.add(zn);
        ArrayList znMems = ZoneData.getZoneSetMembers(zs, znLst);
        return znMems != null && znMems.size() == 1;
    }

    public void insertMembers(AbstractZone az, Object[] members, boolean clone) throws SnmpException {
        if (members != null && members.length != 0) {
            if (az.isZoneset()) {
                Zone[] zmem = new Zone[members.length];
                System.arraycopy(members, 0, zmem, 0, members.length);
                int mismatchedIndex = ((ZoneSet)az).findMatchMember(zmem);
                if (mismatchedIndex != -1) {
                    throw new SnmpException(members[mismatchedIndex] + " already a member of " + az);
                }
            }
            this._zoneData.addMembers(members, az, clone, null);
            this.doAdditionalAction();
        }
    }

    protected void doAdditionalAction() {
    }

    public ArrayList getZoneSetMembers(ZoneSet zs) {
        return this._zoneData.getZoneSetMembers(zs);
    }

    public void setFindZonesetIndex(boolean findZoneSetIndex) {
        this._findZoneSetIndex = findZoneSetIndex;
    }

    public Zone findZone(String name) {
        return this._zoneData.findZone(name);
    }

    public ZoneAlias findZoneAlias(String name) {
        return this._zoneData.findZoneAlias(name);
    }

    public ZoneSet findZoneSet(String name) {
        return this._zoneData.findZoneSet(name);
    }

    public boolean isEnhanced() {
        return this._zoneData.isEnhanced();
    }

    public boolean isCommitRequired() {
        return this._zoneData.isCommitRequired();
    }

    public String getLockOwner() {
        return this._zoneData.getLockOwner();
    }

    public int getLockOwnerType() {
        return this._zoneData.getLockOwnerType();
    }

    public ZoneCapability getZoneCapability() {
        return this._zoneCapability;
    }

    public void setStatusIf(StatusIf stIfg) {
        this._dialog = stIfg;
    }

    public int getIvrRegionID() {
        return this._ivrRegionID;
    }

    public void setIvrRegionID(int regionID) {
        this._ivrRegionID = regionID;
    }
}

