/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class ZoneDistributeAction
extends AbstractMdsAction {
    public static final int[] ZONESET_DISTRIBUTE_RESULT = MibNode.get((String)"zoneZoneSetDistributeResult").getOid();
    public static final int[] ZONESET_FAIL_CAUSE = MibNode.get((String)"zoneZoneSetDistributeFailReason").getOid();
    public static final int[] ZONESET_DISTRIBUTE = MibNode.get((String)"zoneZoneSetDistributeVsan").getOid();
    public static final MibEnum[] causeEnums = MibNode.oidToNode((int[])MibNode.get((String)"zoneZoneSetDistributeFailReason").getOid()).getEnums();
    public static final int DISTRIBUTESUCCESS = 1;
    public static final int IN_PROGRESS = 3;
    protected int _vsan;

    protected ZoneDistributeAction(int v, PollerCallbackIf pollerCallBack) {
        super(pollerCallBack);
        this._vsan = v;
    }

    @Override
    public VarBindList getPollVarBind() {
        VarBindList vb = new VarBindList();
        vb.add(ZONESET_DISTRIBUTE_RESULT, 0);
        vb.add(ZONESET_FAIL_CAUSE, 0);
        return vb;
    }

    @Override
    public VarBindList getActionVarBind() throws SnmpException {
        VarBindList vb = new VarBindList();
        vb.add(ZONESET_DISTRIBUTE, 0, (SnmpVar)new SnmpInt(this._vsan));
        return vb;
    }

    @Override
    public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
        status.append(" Distributing full zone configuration ");
        int activateResult = response.intValue(0);
        if (activateResult == 3) {
            this._pollerCallBack.pollStatus(manager, response, status);
            return 0;
        }
        if (activateResult == 1) {
            this._pollerCallBack.pollStatus(manager, response, status);
            return 1;
        }
        status.append(" Distribution failed ");
        int causeVal = response.intValue(1);
        status.append(MibEnum.getLabel((MibEnum[])causeEnums, (int)causeVal));
        return 2;
    }

    @Override
    public void success(PollerManager manager, StringBuffer status) {
        try {
            this.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
        status.setLength(0);
        super.success(manager, status.append(" Distribution success"));
    }

    protected void refresh() throws Exception {
    }

    @Override
    public String toString() {
        return "Distributing full zone configuration " + this._vsan + ".";
    }

    public static AbstractMdsAction createAction(int v, PollerManager manager, PollerCallbackIf callback) throws SnmpException {
        ZoneDistributeAction act = new ZoneDistributeAction(v, callback);
        manager.addTask(act);
        return act;
    }
}

