/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;

public class ZoneMemberFormat {
    public static final int WWN_FORMAT = 1;
    public static final int DID_FORMAT = 2;
    public static final int FCID_FORMAT = 3;
    public static final int FPORT_FORMAT = 4;
    public static final int ISCSI_FORMAT = 5;
    public static final int IF_FORMAT = 6;
    public static final int DID_IF_FORMAT = 7;
    public static final int PORT_IP_FORMAT = 8;
    public static final int PORT_IP_V6_FORMAT = 9;
    public static final int DEVICE_ALIAS_FORMAT = 10;
    public static final int WWN_LUN_FORMAT = 11;
    public static final int FCID_LUN_FORMAT = 12;
    public static final String[] TYPES = new String[]{"WWN", "DID", "FCID", "FWWN", "iSCSI", "I/F", "DID+I/F", "IP Subnet(v4)", "IP Subnet(v6)", "Device Alias", "WWN+LUN", "FCID+LUN"};
    public static final String[] CLI_TYPES = new String[]{"pwwn", "domain-id", "fcid", "fwwn", "symbolic-nodename", "interface", "DID+I/F", "ip-address", "ip-address", "device-alias", "WWN+LUN", "FCID+LUN"};

    private ZoneMemberFormat() {
    }

    public static String getTypeName(int type) {
        if (type >= 1 && type <= 12) {
            return TYPES[type - 1];
        }
        return null;
    }

    public static String getCLITypeName(int type) {
        if (type >= 1 && type <= 12) {
            return CLI_TYPES[type - 1];
        }
        return null;
    }

    public static Object[] getSwitchPort(int format, byte[] id) {
        int[] ifIndex = new int[1];
        byte[] swWwn = null;
        if (format == 4) {
            ifIndex[0] = IfIndexUtil.fmFwwn2IfIndex(id);
            swWwn = IfIndexUtil.ifWwn2SwWwn(id);
        } else if (format == 7) {
            swWwn = new byte[]{id[0]};
            ifIndex[0] = ZoneMemberFormat.getIfFormatIfIndex(id, 1);
        } else if (format == 6) {
            swWwn = ZoneMemberFormat.getIfFormatSwitchWwn(id);
            ifIndex[0] = ZoneMemberFormat.getIfFormatIfIndex(id, 0);
        } else if (format == 2) {
            swWwn = new byte[]{id[0]};
            ifIndex[0] = 0xFF & id[1];
        } else if (format == 10) {
            // empty if block
        }
        if (swWwn != null) {
            return new Object[]{ifIndex, swWwn};
        }
        return null;
    }

    public static int getIfFormatIfIndex(byte[] id, int startpos) {
        byte[] ifIn = new byte[4];
        System.arraycopy(id, startpos, ifIn, 0, ifIn.length);
        return SnmpIntList.valueOf(ifIn)[0];
    }

    public static byte[] getIfFormatSwitchWwn(byte[] id) {
        byte[] swWwn = null;
        if (id.length == 12 || id.length == 10) {
            swWwn = new byte[8];
            System.arraycopy(id, id.length - swWwn.length, swWwn, 0, swWwn.length);
        }
        return swWwn;
    }

    public static byte[] buildSwitchInterfacememberId(int format, int ifIndex, byte[] swWwnOrDID) {
        byte[] memId = null;
        byte[] ifBytes = null;
        ifBytes = SnmpIntList.valueOf(new int[]{ifIndex});
        if (format == 6) {
            memId = new byte[12];
            System.arraycopy(ifBytes, 0, memId, 0, ifBytes.length);
            System.arraycopy(swWwnOrDID, 0, memId, 4, swWwnOrDID.length);
        } else if (format == 7) {
            memId = new byte[5];
            System.arraycopy(ifBytes, 0, memId, 1, ifBytes.length);
            memId[0] = swWwnOrDID[0];
        }
        return memId;
    }

    public static byte[][] getIpAddressMask(byte[] id) {
        byte[] address = new byte[id.length == 4 || id.length == 8 ? 4 : 16];
        System.arraycopy(id, 0, address, 0, address.length);
        byte[] mask = null;
        if (id.length == 8 || id.length > 16) {
            mask = new byte[id.length - address.length];
            System.arraycopy(id, address.length, mask, 0, mask.length);
        }
        return new byte[][]{address, mask};
    }

    public static byte[] getSubnet(byte[][] ipAddressMask) {
        byte[] ipAddress = ipAddressMask[0];
        byte[] mask = ipAddressMask[1];
        byte[] subnet = new byte[ipAddress.length];
        System.arraycopy(ipAddress, 0, subnet, 0, ipAddress.length);
        if (mask != null && mask.length > 0) {
            if (ipAddress.length == 16) {
                int prefix = SnmpIntList.bytesToInt(mask, 0);
                if (prefix <= 128) {
                    mask = SnmpIpAddress.getMaskFromPrefix((int)prefix, (boolean)true);
                }
                ipAddressMask[1] = mask;
            }
            for (int i = 0; i < mask.length; ++i) {
                subnet[i] = (byte)(subnet[i] & mask[i] & 0xFF);
            }
        }
        return subnet;
    }

    public static int translateToSnmpFormat(int format, int vsanId) {
        if (format == 11) {
            return 1;
        }
        if (format == 12) {
            return 3;
        }
        return format;
    }
}

