/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.SwingUtilities;

public final class CommandDispatcher
implements ActionListener,
ItemListener {
    Object _dispatcher;

    public CommandDispatcher(Object dispatcher) {
        this._dispatcher = dispatcher;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String mName = e.getActionCommand();
        if (mName == null) {
            return;
        }
        int offset = mName.indexOf(" ");
        int eventOffset = mName.indexOf("ActionEvent");
        if (eventOffset != -1) {
            Class[] types = new Class[]{ActionEvent.class};
            Object[] args = new ActionEvent[]{e};
            this.invoke(mName.substring(0, offset), types, args, e.getSource());
        } else if (offset == -1) {
            this.invoke(mName, null, null, e.getSource());
        } else {
            Class[] types = new Class[]{String.class};
            Object[] args = new String[]{mName.substring(offset + 1)};
            this.invoke(mName.substring(0, offset), types, args, e.getSource());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem mi = (JCheckBoxMenuItem)e.getItem();
            String mName = mi.getActionCommand();
            int offset = mName.indexOf(" ");
            int nArgs = offset == -1 ? 1 : 2;
            Class[] types = new Class[nArgs];
            types[0] = Boolean.TYPE;
            Object[] args = new Object[nArgs];
            Object object = args[0] = e.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
            if (nArgs == 1) {
                this.invoke(mName, types, args, e.getSource());
            } else if (nArgs == 2) {
                types[1] = String.class;
                args[1] = mName.substring(offset + 1);
                this.invoke(mName.substring(0, offset), types, args, e.getSource());
            }
        }
    }

    void invoke(String mName, Class[] types, Object[] args, Object source) {
        block5: {
            Component c = (Component)source;
            try {
                Class<?> dispatcherClass = this._dispatcher.getClass();
                dispatcherClass.getMethod(mName, types).invoke(this._dispatcher, args);
            }
            catch (InvocationTargetException ex) {
                Throwable realEx = ex.getTargetException();
                if (realEx == null) {
                    realEx = ex;
                }
                Util.errorMessage(c, realEx.getMessage());
                DefaultLogger._ExLogger.warn((Object)realEx.getMessage(), realEx);
                Window w = SwingUtilities.windowForComponent(c);
                if (w != null) {
                    SwingUtilities.windowForComponent(c).setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception ex) {
                Util.errorMessage(c, ex);
                Window w = SwingUtilities.windowForComponent(c);
                if (w == null) break block5;
                SwingUtilities.windowForComponent(c).setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

