/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.comps;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.comps.Editor;
import com.cisco.dcbu.lib.ui.comps.JFilePanel;
import com.cisco.dcbu.lib.ui.comps.ToggleControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ScriptPanel
extends JPanel {
    private Editor _editor = new Editor();
    private JFilePanel _save = new JFilePanel(1);
    private JPanel _savePanel = new JPanel();
    private JCheckBox _cbSave = new JCheckBox();
    private String _workingDir = null;
    private String _prefix = null;

    public ScriptPanel(String workingDir, String prefix) {
        this._workingDir = workingDir;
        this._prefix = prefix;
        this.setLayout(new BorderLayout());
        this._savePanel.add(this._cbSave);
        this._savePanel.add(this._save);
        new ToggleControl(this._cbSave, this._save);
        this.add((Component)this._savePanel, "North");
        this.add((Component)this._editor, "Center");
        String someFileName = this._workingDir + File.separator + this._prefix + new Date().getTime() + ".txt";
        this._save.setFile(someFileName);
    }

    public String getFileName() {
        return this._save.getFile();
    }

    public void setScript(String script) {
        this._editor.setScript(script);
    }

    public String getScript() {
        return this._editor.getScript();
    }

    public Editor getEditor() {
        return this._editor;
    }

    public void saveFile() {
        String file = this._save.getFile();
        if (this._cbSave.isSelected() && file != null && !file.trim().equals("")) {
            this.saveFile(new File(file));
        }
    }

    private void saveFile(File fileToLoad) {
        try {
            if (this._editor.getScript().trim().equals("")) {
                System.out.println("Nothing to save in : " + fileToLoad.getAbsolutePath());
                return;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileToLoad));
            writer.write(this._editor.getScript());
            writer.flush();
            writer.close();
            System.out.println("File saved to : " + fileToLoad.getAbsolutePath());
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public JFilePanel getFilePanel() {
        return this._save;
    }

    public void setSelection(boolean b) {
        this._cbSave.setSelected(b);
    }

    public boolean isSelected() {
        return this._cbSave.isSelected();
    }
}

