/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.table.ColumnGroup;
import com.cisco.dcbu.lib.ui.table.GroupableTableHeader;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class GroupableTableHeaderUI
extends BasicTableHeaderUI {
    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle clipBounds = g.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        int column = 0;
        Dimension size = this.header.getSize();
        Rectangle cellRect = new Rectangle(0, 0, size.width, size.height);
        HashMap<ColumnGroup, Rectangle> h = new HashMap<ColumnGroup, Rectangle>();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            cellRect.height = size.height;
            cellRect.y = 0;
            TableColumn aColumn = enumeration.nextElement();
            Array cGroups = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
            if (cGroups != null) {
                int groupHeight = 0;
                for (int i = 0; i < cGroups.size(); ++i) {
                    ColumnGroup cGroup = (ColumnGroup)cGroups.elementAt(i);
                    Rectangle groupRect = (Rectangle)h.get(cGroup);
                    if (groupRect == null) {
                        groupRect = new Rectangle(cellRect);
                        Dimension d = cGroup.getSize(this.header.getTable());
                        groupRect.width = d.width;
                        groupRect.height = d.height;
                        h.put(cGroup, groupRect);
                    }
                    this.paintCell(g, groupRect, cGroup);
                    cellRect.height = size.height - (groupHeight += groupRect.height);
                    cellRect.y = groupHeight;
                }
            }
            cellRect.width = aColumn.getWidth();
            if (cellRect.intersects(clipBounds)) {
                this.paintCell(g, cellRect, column);
            }
            cellRect.x += cellRect.width;
            ++column;
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = this.getHeaderRenderer(aColumn);
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private TableCellRenderer getHeaderRenderer(TableColumn aColumn) {
        TableCellRenderer r = aColumn.getHeaderRenderer();
        if (r == null) {
            r = this.header.getDefaultRenderer();
        }
        return r;
    }

    private void paintCell(Graphics g, Rectangle cellRect, ColumnGroup cGroup) {
        TableCellRenderer renderer = cGroup.getHeaderRenderer();
        Component component = renderer.getTableCellRendererComponent(this.header.getTable(), cGroup.getHeaderValue(), false, false, -1, -1);
        this.rendererPane.removeAll();
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(g, component, this.header, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
    }

    private int getHeaderHeight() {
        int height = 0;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            TableColumn aColumn = columnModel.getColumn(column);
            TableCellRenderer renderer = this.getHeaderRenderer(aColumn);
            Component comp = renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, column);
            int cHeight = comp.getPreferredSize().height;
            Array enums = ((GroupableTableHeader)this.header).getColumnGroups(aColumn);
            if (enums != null) {
                for (int i = 0; i < enums.size(); ++i) {
                    ColumnGroup cGroup = (ColumnGroup)enums.elementAt(i);
                    cHeight += cGroup.getSize((JTable)this.header.getTable()).height;
                }
            }
            height = Math.max(height, cHeight);
        }
        return height;
    }

    private Dimension createHeaderSize(long width) {
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeight());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSize(width);
    }
}

