/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.PrintUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.ui.table.ChangedBooleanCellRenderer;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.ComboRenderer;
import com.cisco.dcbu.lib.ui.table.KTableColumnModel;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.table.MultiLineTableCellRenderer;
import com.cisco.dcbu.lib.ui.table.PasswordCellRenderer;
import com.cisco.dcbu.lib.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class KTable
extends JTable
implements ActionListener {
    public static final Color _BgColor = (Color)UIManager.getDefaults().get("Label.background");
    static final int PAGE_MARGIN = 20;
    public static final int HEADER_COL_HEIGHT = 18;
    static final String[] _MenuItems = new String[]{"Export to File...", "Print Table..."};
    static double _MaxScreenRatioHeight = 0.6;
    static ComboRenderer _ComboRenderer;
    protected static int _HeaderColMargin;
    public static boolean _ExportAsXML;
    protected JPopupMenu _popup;
    protected boolean _isSortable;
    private int[] _colPages;
    private int _colPageCount;
    private boolean _preserveSelection;
    private boolean _multiRow;

    public KTable(TableModel dataModel) {
        super(dataModel);
        this.setBackground(_BgColor);
        this.setGridColor(Color.gray);
        TableCellRenderer headerRenderer = this.getTableHeader().getDefaultRenderer();
        ((JLabel)((Object)headerRenderer)).setHorizontalAlignment(2);
        ((JLabel)((Object)headerRenderer)).setVerticalAlignment(3);
        if (_HeaderColMargin == -1) {
            Component comp = headerRenderer.getTableCellRendererComponent(this, "", false, false, 0, 0);
            _HeaderColMargin = (int)comp.getPreferredSize().getWidth();
        }
        this.setDefaultRenderer(Boolean.class, new ChangedBooleanCellRenderer());
        this.registerKeys();
        this.setRowHeight(this.calcRowHeight());
    }

    private int calcRowHeight() {
        int h;
        int rowHeight = this.getRowHeight();
        if (rowHeight < (h = this.getFontMetrics(this.getFont()).getHeight() + 2)) {
            return h;
        }
        return rowHeight;
    }

    public KTable(TableModel dataModel, boolean multiRow) {
        this(dataModel);
        this._multiRow = multiRow;
        if (multiRow) {
            this.setDefaultRenderer(ArrayList.class, new MultiLineTableCellRenderer());
        }
    }

    public void registerKeys() {
        this.registerKeyboardAction(this, "C", KeyStroke.getKeyStroke(67, 2), 0);
        this.registerKeyboardAction(this, "V", KeyStroke.getKeyStroke(86, 2), 0);
        this.registerKeyboardAction(this, "Z", KeyStroke.getKeyStroke(90, 2), 0);
    }

    public void addPopupMenu() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                KTable.this.checkPopup(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                KTable.this.checkPopup(me);
            }
        });
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        Component editorComponent;
        if (condition == 1 && this.isFocusOwner() && !Boolean.FALSE.equals((Boolean)this.getClientProperty("JTable.autoStartsEdit")) && (editorComponent = this.getEditorComponent()) == null) {
            if (e == null || e.getID() != 401) {
                return false;
            }
            int code = e.getKeyCode();
            if (code == 127 || code == 8) {
                ListSelectionModel s = this.getSelectionModel();
                int[] rows = this.getSelectedRows();
                int[] columns = this.getSelectedColumns();
                if (rows != null && rows.length > 0 && columns != null && columns.length > 0) {
                    for (int i = 0; i < rows.length; ++i) {
                        for (int j = 0; j < columns.length; ++j) {
                            if (!this.isCellEditable(rows[i], columns[j])) continue;
                            try {
                                Class<?> c = this.getColumnClass(columns[j]);
                                int modelcol = this.convertColumnIndexToModel(columns[j]);
                                if (c.equals("".getClass())) {
                                    this.getModel().setValueAt("", rows[i], modelcol);
                                } else {
                                    this.getModel().setValueAt(null, rows[i], modelcol);
                                }
                                ((KTableModel)this.getModel()).fireTableCellUpdated(rows[i], columns[j]);
                                continue;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                }
                return false;
            }
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    protected void checkPopup(MouseEvent me) {
        try {
            if (me.isPopupTrigger()) {
                if (this._popup == null) {
                    this.buildPopupMenu();
                }
                this.setPopupContext();
                this._popup.show(this, me.getX(), me.getY());
                me.consume();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void buildPopupMenu() {
        this._popup = new JPopupMenu();
        for (int i = 0; i < _MenuItems.length; ++i) {
            this._popup.add(Util.createMenuItem(_MenuItems[i], _MenuItems[i], this));
        }
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new KTableColumnModel();
    }

    protected void setPopupContext() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand().charAt(0)) {
            case 'C': {
                this.copy();
                break;
            }
            case 'V': {
                this.paste();
                break;
            }
            case 'Z': {
                ((KTableModel)this.getModel()).undo();
                break;
            }
            case 'P': {
                try {
                    this.print("job");
                }
                catch (PrinterException ex) {
                    Util.errorMessage((Component)this, ex);
                }
                break;
            }
            case 'E': {
                String fName = Util.getFileName(Util.getFrameAncestor(this), "*.txt", 1);
                if (fName == null) break;
                this.export(fName);
            }
        }
    }

    protected String getCellString(TableModel model, int row, int col) {
        Object o = model.getValueAt(row, col);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String fName) {
        File file = new File(fName);
        try (PrintWriter os = null;){
            int r;
            os = new PrintWriter(new FileOutputStream(file));
            TableModel model = this.getModel();
            String[] cols = null;
            String title = null;
            if (_ExportAsXML) {
                os.println("<?xml version=\"1.0\"?>");
                title = file.getName();
                os.println("<" + title + ">");
                cols = new String[this.getColumnCount()];
                for (int i = 0; i < cols.length; ++i) {
                    char[] c = model.getColumnName(this.convertColumnIndexToModel(i)).toCharArray();
                    for (int j = 0; j < c.length; ++j) {
                        if (Character.isLetterOrDigit(c[j])) continue;
                        c[j] = 95;
                    }
                    cols[i] = new String(c);
                }
            } else {
                if (model instanceof KTableModel) {
                    KTableModel ktModel = (KTableModel)model;
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        os.print(ktModel.getColumnNameWithoutHtml(this.convertColumnIndexToModel(i)) + "\t");
                    }
                } else {
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        os.print(model.getColumnName(this.convertColumnIndexToModel(i)) + "\t");
                    }
                }
                os.println();
            }
            if (_ExportAsXML) {
                for (r = 0; r < model.getRowCount(); ++r) {
                    os.println(" <row>");
                    for (int c = 0; c < this.getColumnCount(); ++c) {
                        String cellText = this.getCellString(model, r, this.convertColumnIndexToModel(c));
                        os.println("  <" + cols[c] + ">" + cellText + "</" + cols[c] + ">");
                    }
                    os.println(" </row>");
                }
                os.println("</" + title + ">");
            } else {
                for (r = 0; r < model.getRowCount(); ++r) {
                    for (int c = 0; c < this.getColumnCount(); ++c) {
                        String cellText = this.getCellString(model, r, this.convertColumnIndexToModel(c));
                        if (cellText == null || cellText.length() == 0) {
                            cellText = " ";
                        }
                        os.print(cellText + "\t");
                    }
                    os.println();
                }
            }
        }
    }

    public void copy() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int[] rows = this.getSelectedRows();
            int[] cols = this.getSelectedColumns();
            StringBuffer sb = new StringBuffer(80);
            TableModel model = this.getModel();
            int c1 = 0;
            int r1 = 0;
            int r = 0;
            while (r < rows.length) {
                int c = 0;
                while (c < cols.length) {
                    r1 = rows[r];
                    c1 = this.convertColumnIndexToModel(cols[c]);
                    TableCellRenderer renderer = this.getCellRenderer(r1, cols[c]);
                    if (this.getCellRenderer(r1, cols[c]) instanceof PasswordCellRenderer) {
                        sb.append("");
                    } else if (renderer instanceof DefaultTableCellRenderer) {
                        Component comp = ((DefaultTableCellRenderer)renderer).getTableCellRendererComponent(this, model.getValueAt(r1, c1), true, true, r1, cols[c]);
                        if (comp != null && comp instanceof JLabel) {
                            sb.append(((JLabel)comp).getText());
                        } else {
                            sb.append(this.getCellString(model, r1, c1));
                        }
                    } else {
                        sb.append(this.getCellString(model, r1, c1));
                    }
                    if (++c >= cols.length) continue;
                    sb.append('\t');
                }
                if (++r >= rows.length) continue;
                sb.append('\n');
            }
            StringSelection selection = new StringSelection(sb.toString());
            clipboard.setContents(selection, null);
        }
        catch (Exception ex) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void paste() {
        Component c;
        if (this.isEditing() && (c = this.getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)c).paste();
            return;
        }
        Transferable selection = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        KTableModel model = (KTableModel)this.getModel();
        try {
            String text = (String)selection.getTransferData(DataFlavor.stringFlavor);
            String[] rows = this.getCopiedStrings(text, "\n");
            int[] srows = this.getSelectedRows();
            int[] scols = this.getSelectedColumns();
            if (srows != null && scols != null && srows.length + scols.length > 2) {
                this.replicate(model, rows, srows, scols);
                model.fireTableRowsUpdated(srows[0], srows[srows.length - 1]);
            } else {
                Cell cell = this.getCurrentCell();
                for (int r = 0; r < rows.length; ++r) {
                    int viewRow = r + cell._row;
                    String[] cols = StringUtil.tokenize(rows[r], "\t");
                    for (int c2 = 0; c2 < cols.length; ++c2) {
                        int viewCol = this.convertColumnIndexToModel(c2 + cell._col);
                        if (!model.isCellEditable(viewRow, viewCol)) continue;
                        model.setValueAt(cols[c2], viewRow, viewCol);
                    }
                }
                model.fireTableRowsUpdated(cell._row, cell._row + rows.length - 1);
            }
        }
        catch (Exception ex) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    String[] getCopiedStrings(String token, String delim) {
        StringTokenizer st = new StringTokenizer(token, delim, true);
        ArrayList<String> arr = new ArrayList<String>();
        if (token.startsWith(delim)) {
            arr.add("");
        }
        block0: while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if (str.equals(delim)) {
                if (!st.hasMoreElements()) {
                    arr.add("");
                }
                while (st.hasMoreElements()) {
                    String next = st.nextToken();
                    if (next.equals(delim)) {
                        arr.add("");
                        if (st.hasMoreElements()) continue;
                        arr.add("");
                        continue;
                    }
                    arr.add(next);
                    continue block0;
                }
                continue;
            }
            arr.add(str);
        }
        return arr.toArray(new String[arr.size()]);
    }

    void replicate(KTableModel model, String[] text, int[] rowIndexes, int[] colsIndexes) {
        String[] cols = this.getColsText(text[0], "\t");
        if (cols.length != colsIndexes.length) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        for (int pasteRow : rowIndexes) {
            for (int r = 0; r < text.length; ++r) {
                cols = this.getColsText(text[r], "\t");
                int cTextIndex = 0;
                for (int columnIndex : colsIndexes) {
                    int pasteCol = this.convertColumnIndexToModel(columnIndex);
                    if (model.isCellEditable(pasteRow, pasteCol)) {
                        model.setValueAt(cols[cTextIndex++], pasteRow, pasteCol);
                        continue;
                    }
                    ++cTextIndex;
                }
            }
        }
    }

    String[] getColsText(String text, String delimiter) {
        if (text.equals("")) {
            return new String[]{""};
        }
        return StringUtil.tokenize(text, "\t");
    }

    public void see(int row, int col) {
        Rectangle cellRect = this.getCellRect(row, col, false);
        if (cellRect != null) {
            this.scrollRectToVisible(cellRect);
        }
    }

    public Cell getCurrentCell() {
        int[] rows = this.getSelectedRows();
        int[] cols = this.getSelectedColumns();
        return new Cell(rows == null ? 0 : rows[0], cols == null ? 0 : cols[0]);
    }

    public int getHeaderColumnWidth(FontMetrics fm, int column) {
        String colName = this.getModel().getColumnName(column);
        if (colName != null && colName.length() > 0) {
            if (colName.charAt(0) == '<' && colName.startsWith("<html>")) {
                String str2;
                int width2;
                int offset = colName.indexOf("<br>", 6);
                String str1 = colName.substring(6, offset);
                int width = fm.stringWidth(str1);
                if (offset != -1 && (width2 = fm.stringWidth(str2 = colName.substring(offset + 4))) > width) {
                    width = width2;
                }
                return width + _HeaderColMargin;
            }
            return fm.stringWidth(colName) + _HeaderColMargin;
        }
        return 0;
    }

    public int colWidthToWidest(int viewColumn) {
        KTableModel model = (KTableModel)this.getModel();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int column = this.convertColumnIndexToModel(viewColumn);
        int widest = this.getHeaderColumnWidth(fm, column);
        if (model.getRowCount() > 0 && model.isCellEditable(0, viewColumn)) {
            fm = this.getFontMetrics(ChangedCellRenderer._ChangedFont);
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            String os = this.getCellStringForWidth(model, i, column);
            TableCellRenderer r = this.getCellRenderer(i, viewColumn);
            int width = 0;
            int w = 0;
            if (r instanceof Component) {
                w = (int)((Component)((Object)r)).getPreferredSize().getWidth();
            }
            if (os != null && os.length() > 0) {
                if (this._multiRow) {
                    width = fm.stringWidth(os);
                    if (width > widest) {
                        widest = width;
                    }
                } else {
                    int ts = fm.stringWidth(os);
                    width = w > 5 && ts > w ? w : ts;
                }
            } else {
                width = w;
            }
            if (width <= widest) continue;
            widest = width;
        }
        this.columnModel.getColumn(viewColumn).setPreferredWidth(widest += 4);
        return widest;
    }

    private String getCellStringForWidth(TableModel model, int row, int col) {
        Object o = model.getValueAt(row, col);
        if (this._multiRow && o != null && o instanceof ArrayList) {
            String val = "";
            ArrayList list = (ArrayList)o;
            for (int i = 0; i < list.size(); ++i) {
                String valNew = list.get(i).toString();
                if (valNew.length() <= val.length()) continue;
                val = valNew;
            }
            return val;
        }
        return this.getCellString(model, row, col);
    }

    public int colWidthToWidest() {
        TableModel model = this.getModel();
        if (model instanceof KTableModel) {
            int headerLines = ((KTableModel)model)._headerLines;
            JComponent comp = (JComponent)this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this, "", false, false, 0, 0);
            comp.setPreferredSize(new Dimension(50, headerLines * (this.calcRowHeight() + 2) + 2));
        }
        int width = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            width += this.colWidthToWidest(i);
        }
        return width += this.getColumnCount();
    }

    public Dimension calcPreferredSize() {
        int width = this.colWidthToWidest();
        int height = this.getPreferredHeight();
        int maxHeight = KTable.getMaxHeight();
        int maxWidth = KTable.getMaxWidth();
        if (width > maxWidth) {
            width = maxWidth;
            height += 16;
        }
        if (height > maxHeight) {
            height = maxHeight;
            width += 16;
        }
        return new Dimension(width, height);
    }

    public int getPreferredHeight() {
        int height = this.getTableHeader().getPreferredSize().height;
        int numRows = 0;
        KTableModel model = (KTableModel)this.getModel();
        if (model != null && model._data != null) {
            numRows = model._data.size();
        }
        height = !this._multiRow ? (height += numRows * this.getRowHeight()) : (height += this.calcMultiRowHeight() + (numRows - ((KTableModel)this.getModel())._data.size()) * this.getRowHeight());
        return height;
    }

    public static int getMaxHeight() {
        return (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * _MaxScreenRatioHeight);
    }

    public static final int getMaxWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize().width - 8;
    }

    public void print(String jobName) throws PrinterException {
        if (PrintUtil.printDialog()) {
            PrintUtil.setPrintable(this.getPrintable(JTable.PrintMode.NORMAL, null, null));
            PrintUtil.print();
        }
    }

    public void find(boolean next, String candidate, boolean ignoreCase, boolean exactMatch, boolean byRow) {
        String[] candidates = new String[]{candidate};
        int row = this.getSelectedRow();
        int col = this.convertColumnIndexToModel(this.getSelectedColumn());
        TableModel model = this.getModel();
        if (byRow) {
            if (row == -1) {
                row = 0;
            }
            col += next ? 1 : -1;
        } else {
            row += next ? 1 : -1;
            if (col == -1) {
                col = 0;
            }
        }
        if (next) {
            if (byRow) {
                while (row < model.getRowCount()) {
                    while (col < model.getColumnCount()) {
                        if (this.match(candidates, ignoreCase, exactMatch, row, col, false)) {
                            return;
                        }
                        ++col;
                    }
                    ++row;
                    col = 0;
                }
            } else {
                while (col < model.getColumnCount()) {
                    while (row < model.getRowCount()) {
                        if (this.match(candidates, ignoreCase, exactMatch, row, col, false)) {
                            return;
                        }
                        ++row;
                    }
                    ++col;
                    row = 0;
                }
            }
        } else if (byRow) {
            while (row >= 0) {
                while (col >= 0) {
                    if (this.match(candidates, ignoreCase, exactMatch, row, col, false)) {
                        return;
                    }
                    --col;
                }
                --row;
                col = model.getColumnCount() - 1;
            }
        } else {
            while (col >= 0) {
                while (row >= 0) {
                    if (this.match(candidates, ignoreCase, exactMatch, row, col, false)) {
                        return;
                    }
                    --row;
                }
                --col;
                row = model.getRowCount() - 1;
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    public void findFirstOccurance(String[] candidates, int columnIndex, boolean ignoreCase, boolean exactMatch, boolean byRow) {
        int row = 0;
        int col = 0;
        TableModel model = this.getModel();
        boolean next = true;
        int numMatches = 0;
        int columnCount = model.getColumnCount();
        try {
            if (columnIndex != -1) {
                col = columnIndex;
                columnCount = col + 1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (next) {
            if (byRow) {
                while (row < model.getRowCount()) {
                    while (col < columnCount) {
                        if (this.match(candidates, ignoreCase, exactMatch, row, col, true) && ++numMatches == candidates.length) {
                            return;
                        }
                        ++col;
                    }
                    ++row;
                    col = 0;
                }
            } else {
                while (col < columnCount) {
                    while (row < model.getRowCount()) {
                        if (this.match(candidates, ignoreCase, exactMatch, row, col, true) && ++numMatches == candidates.length) {
                            return;
                        }
                        ++row;
                    }
                    ++col;
                    row = 0;
                }
            }
        } else if (byRow) {
            while (row >= 0) {
                while (col >= 0) {
                    if (this.match(candidates, ignoreCase, exactMatch, row, col, true) && ++numMatches == candidates.length) {
                        return;
                    }
                    --col;
                }
                --row;
                col = columnCount - 1;
            }
        } else {
            while (col >= 0) {
                while (row >= 0) {
                    if (this.match(candidates, ignoreCase, exactMatch, row, col, true) && ++numMatches == candidates.length) {
                        return;
                    }
                    --row;
                }
                --col;
                row = model.getRowCount() - 1;
            }
        }
        Toolkit.getDefaultToolkit().beep();
    }

    private boolean matchEquals(String match, String[] candidates) {
        if (match != null && candidates != null) {
            for (int i = 0; i < candidates.length; ++i) {
                if (!match.equals(candidates[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchIndexOf(String match, String[] candidates) {
        if (match != null && candidates != null) {
            for (int i = 0; i < candidates.length; ++i) {
                if (match.indexOf(candidates[i]) == -1) continue;
                return true;
            }
        }
        return false;
    }

    boolean match(String[] candidates, boolean ignoreCase, boolean exactMatch, int row, int col, boolean addSelection) {
        String match = this.getCellString(this.getModel(), row, col);
        if (match == null) {
            return false;
        }
        if (ignoreCase) {
            match = match.toLowerCase();
        }
        if (exactMatch && this.matchEquals(match, candidates) || !exactMatch && this.matchIndexOf(match, candidates)) {
            int viewCol = this.convertColumnIndexToView(col);
            if (viewCol == -1) {
                return false;
            }
            if (addSelection) {
                this.addRowSelectionInterval(row, row);
                this.addColumnSelectionInterval(viewCol, viewCol);
            } else {
                this.setRowSelectionInterval(row, row);
                this.setColumnSelectionInterval(viewCol, viewCol);
            }
            this.see(row, viewCol);
            return true;
        }
        return false;
    }

    public void setRenderer(JComboBox combo) {
        if (_ComboRenderer == null) {
            _ComboRenderer = new ComboRenderer();
        }
        combo.setRenderer(_ComboRenderer);
    }

    public final void setSortable(boolean isSortable) {
        this._isSortable = isSortable;
    }

    public final void setPreserveSelection(boolean selected) {
        this._preserveSelection = selected;
    }

    @Override
    public void clearSelection() {
        if (!this._preserveSelection) {
            super.clearSelection();
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        TableCellEditor editor = this.getCellEditor(row, column);
        if (editor != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(row, column, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    @Override
    public void editingStopped(ChangeEvent event) {
        super.editingStopped(event);
        this.repaint();
    }

    public boolean isMultiRow() {
        return this._multiRow;
    }

    public int calcMultiRowHeight() {
        KTableModel model = (KTableModel)this.getModel();
        int totalRowHt = 0;
        if (!this._multiRow) {
            return ((KTableModel)this.getModel())._data.size() * this.getRowHeight();
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            int rowHt = this.getRowHeight();
            for (int j = 0; j < model.getColumnCount(); ++j) {
                int rowHeight;
                Object obCol = model.getValueAt(i, j);
                if (obCol == null || !(obCol instanceof ArrayList) || (rowHeight = this.getRowHeight() * ((ArrayList)obCol).size()) <= rowHt) continue;
                rowHt = rowHeight;
            }
            this.setRowHeight(i, rowHt);
            totalRowHt += rowHt;
        }
        return totalRowHt;
    }

    static {
        _HeaderColMargin = -1;
    }
}

