/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.tree;

import com.cisco.dcbu.lib.ui.UITransferHandler;
import com.cisco.dcbu.lib.ui.tree.DndTreeNode;
import com.cisco.dcbu.lib.ui.tree.Tree;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DndTree
extends Tree
implements DropTargetListener,
DragGestureListener,
DragSourceListener {
    private UITransferHandler _dndTransferData;

    public DndTree(DefaultTreeModel root, UITransferHandler dndTransferData) {
        super(root);
        this.init(dndTransferData);
    }

    public DndTree(TreeNode tn, UITransferHandler dndTransferData) {
        super(tn);
        this.init(dndTransferData);
    }

    private void init(UITransferHandler dndTransferData) {
        this._dndTransferData = dndTransferData;
        new DropTarget(this, 3, this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public Object[] getDataTransferObject() {
        return this._dndTransferData.getTransferObject();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (null != this.getSelectionPath()) {
            DndTreeNode drag = (DndTreeNode)this.getSelectionPath().getLastPathComponent();
            this._dndTransferData.setTransferObject(new Object[]{drag.getUserObject()}, this);
            if (drag.isDragSupported()) {
                e.startDrag(DragSource.DefaultCopyDrop, new StringSelection(this.getSelectionPath().toString()), this);
            }
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        int row;
        Point p = e.getLocation();
        Rectangle rec = this.getVisibleRect();
        Point plow = new Point(rec.x, rec.y);
        SwingUtilities.convertPointToScreen(plow, this);
        if (p.y <= plow.y + 1) {
            int row2 = this.getClosestRowForLocation(rec.x, rec.y);
            if (row2 > 0) {
                this.scrollRowToVisible(row2 - 1);
            }
        } else if (p.y >= plow.y + rec.height - 2 && (row = this.getClosestRowForLocation(rec.x, rec.y + rec.height)) > 0 && row < this.getRowCount()) {
            if (row == this.getRowCount() - 1) {
                this.scrollRowToVisible(row);
            } else {
                this.scrollRowToVisible(row + 1);
            }
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        Point p = e.getLocation();
        TreePath path = this.getPathForLocation(p.x, p.y);
        if (null == path) {
            this.setSelectionPath(this.getSelectionPath());
            return;
        }
        DndTreeNode ndDrop = (DndTreeNode)path.getLastPathComponent();
        if (this.okToDrop(this.getDataTransferObject(), ndDrop)) {
            TreePath[] newPaths = this._dndTransferData.getSource() == this ? new TreePath[]{this.getSelectionPath(), path} : new TreePath[]{path};
            this.setSelectionPaths(newPaths);
        }
    }

    public void handleSpecialDrag(DndTreeNode ndDrop, TreePath path) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.dropAction(e);
    }

    protected boolean okToDrop(Object[] transferObject, DndTreeNode dropNd) {
        return transferObject != null && transferObject.length > 0 && dropNd.isDropSupported();
    }

    public void dropAction(DropTargetDropEvent e) {
    }
}

