/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.wizard;

import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WizardNavigator
extends JPanel
implements ActionListener {
    static final String[] _ButtonLabels = new String[]{"Back", "Next", "Cancel", "Help"};
    static final String[] _ButtonIcons = new String[]{"icons/WestArrow.gif", "icons/EastArrow.gif"};
    JButton[] _buttons;
    JWizard _wizard;
    static final int BTN_BACK = 0;
    static final int BTN_NEXT_FINISH = 1;
    static final int BTN_CANCEL = 2;
    static final int BTN_HELP = 3;

    public void dispose() {
        this._wizard._nav = null;
        this._wizard = null;
    }

    public WizardNavigator(JWizard wizard) {
        int i;
        this._wizard = wizard;
        this.setLayout(new BoxLayout(this, 1));
        this.add(new DialogSeparator(false));
        JPanel nav = new JPanel();
        nav.setLayout(new FlowLayout(2, 6, 3));
        this._buttons = new JButton[_ButtonLabels.length];
        for (i = 0; i < this._buttons.length; ++i) {
            this._buttons[i] = new JButton(_ButtonLabels[i]);
            this._buttons[i].addActionListener(this);
            nav.add(this._buttons[i]);
        }
        for (i = 0; i < _ButtonIcons.length; ++i) {
            this._buttons[i].setIcon(Util.loadIcon(_ButtonIcons[i]));
        }
        this._buttons[1].setHorizontalTextPosition(2);
        this.getHelp().setVisible(false);
        this.add(nav);
    }

    public void setButtonAttr(boolean notFirst, boolean isLast) {
        this._buttons[0].setVisible(notFirst);
        char ch = this._buttons[1].getText().charAt(0);
        if (isLast && ch != 'F') {
            this.setFinishButton("Finish");
        } else if (!isLast && ch != 'N') {
            this.setNextButton("Next");
        }
    }

    public void setFinishButton(String text) {
        this._buttons[1].setText(text);
        this._buttons[1].setActionCommand("Finish");
        this._buttons[1].setMnemonic('F');
        this._buttons[1].setIcon(null);
    }

    public void setNextButton(String text) {
        this._buttons[1].setText(text);
        this._buttons[1].setActionCommand("Next");
        this._buttons[1].setMnemonic('N');
        this._buttons[1].setIcon(Util.loadIcon(_ButtonIcons[1]));
    }

    public void setCancelButton(String text) {
        this._buttons[2].setText(text);
        this._buttons[2].setActionCommand("Cancel");
        this._buttons[2].setMnemonic('C');
    }

    public JButton getNextBtn() {
        return this._buttons[1];
    }

    public JButton getBackBtn() {
        return this._buttons[0];
    }

    public JButton getCancel() {
        return this._buttons[2];
    }

    public JButton getHelp() {
        return this._buttons[3];
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ((AbstractButton)ev.getSource()).getActionCommand();
        switch (((AbstractButton)ev.getSource()).getActionCommand().charAt(0)) {
            case 'B': {
                this._wizard.getCurrent().doPrevious();
                break;
            }
            case 'N': {
                this._wizard.getCurrent().doNext();
                break;
            }
            case 'F': {
                this._wizard.getCurrent().doFinish();
                break;
            }
            case 'H': {
                this._wizard.getCurrent().doHelp();
                break;
            }
            case 'C': {
                if (this._wizard.getCurrent() == null) {
                    this._wizard.dispose();
                    this.dispose();
                    break;
                }
                this._wizard.getCurrent().doCancel();
            }
        }
    }
}

