/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.install.PortConfigurator;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.lib.util.ThreadInfo;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class GenUtil {
    static Properties _JVM_properties;

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static boolean equals(Object[] o1, Object[] o2, Comparator c) {
        return Arrays.equals(GenUtil.sort(o1, c), GenUtil.sort(o2, c));
    }

    public static boolean startsWith(byte[] barray1, byte[] barray2) {
        if (barray1 == null || barray2 == null || barray2.length > barray1.length) {
            return false;
        }
        for (int i = 0; i < barray2.length; ++i) {
            if (barray1[i] == barray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isValueFilled(byte[] ba, byte value) {
        if (ba == null || ba.length == 0) {
            return false;
        }
        for (int i = 0; i < ba.length; ++i) {
            if (ba[i] == value) continue;
            return false;
        }
        return true;
    }

    public static boolean validateUsername(String userName) {
        char[] chars;
        if (userName == null || userName.length() == 0) {
            return false;
        }
        for (char aChar : chars = userName.toCharArray()) {
            if ('-' == aChar || '_' == aChar || '.' == aChar || '+' == aChar || Character.isLetterOrDigit(aChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean validatePassword(String password) {
        if (password == null || password.length() < 8) {
            return false;
        }
        char[] chars = password.toCharArray();
        boolean hasLetter = false;
        boolean hasDigit = false;
        for (char aChar : chars) {
            if ('-' == aChar || '_' == aChar || '.' == aChar || '+' == aChar) continue;
            if (Character.isLetter(aChar)) {
                hasLetter = true;
                continue;
            }
            if (Character.isDigit(aChar)) {
                hasDigit = true;
                continue;
            }
            return false;
        }
        return hasLetter && hasDigit;
    }

    public static Object[] sort(Object[] o, Comparator c) {
        Object[] a = null;
        if (o != null) {
            if (o.length == 1 || c == null && !(o[0] instanceof Comparable)) {
                a = o;
            } else {
                a = (Object[])o.clone();
                if (c != null) {
                    Arrays.sort(a, c);
                } else {
                    Arrays.sort(a);
                }
            }
        }
        return a;
    }

    public static int linearSearch(int[] a, int key, int toIndex) {
        int max;
        int n = max = toIndex == -1 ? a.length : toIndex;
        for (int i = 0; i < max; ++i) {
            if (a[i] != key) continue;
            return i;
        }
        return -1;
    }

    public static int linearSearch(int[] a, int key) {
        return GenUtil.linearSearch(a, key, -1);
    }

    public static int linearSearch(Object[] a, Object key, int toIndex) {
        int max;
        int n = max = toIndex == -1 ? a.length : toIndex;
        for (int i = 0; i < max; ++i) {
            if (!GenUtil.equals(a[i], key)) continue;
            return i;
        }
        return -1;
    }

    public static int linearSearch(Object[] a, Object key) {
        return GenUtil.linearSearch(a, key, -1);
    }

    public static int binarySearch(short[] a, short key, int toIndex) {
        int low = 0;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            short midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static int searchUniqueMatch(String[] values, String key) {
        int low = 0;
        int high = values.length - 1;
        key = key.toLowerCase();
        while (low <= high) {
            int cmp;
            int mid = low + high >> 1;
            String value = values[mid];
            int n = cmp = value.startsWith(key) ? 0 : value.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            if (key.length() != value.length() && (mid > 0 && values[mid - 1].startsWith(key) || mid < values.length - 1 && values[mid + 1].startsWith(key))) {
                return -1;
            }
            return mid;
        }
        return -1;
    }

    public static void arraycopy(byte[] src, int srcPos, int[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = src[srcPos + i] & 0xFF;
        }
    }

    public static void arraycopy(int[] src, int srcPos, byte[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = (byte)(src[srcPos + i] & 0xFF);
        }
    }

    public static int[] shortArrayToIntArray(short[] sa) {
        int[] ia = null;
        if (sa != null) {
            ia = new int[sa.length];
            for (int i = 0; i < sa.length; ++i) {
                ia[i] = sa[i];
            }
        }
        return ia;
    }

    public static int[] shortListToIntArray(Collection<Short> scol) {
        if (scol == null) {
            return new int[0];
        }
        int[] ia = new int[scol.size()];
        int i = 0;
        for (short svalue : scol) {
            ia[i++] = svalue;
        }
        return ia;
    }

    private static synchronized void readJVMProperties() {
        if (_JVM_properties == null) {
            _JVM_properties = new Properties();
            Enumeration<Object> iter = System.getProperties().keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                if (key.startsWith("java") || key.startsWith("sun.")) continue;
                _JVM_properties.put(key, System.getProperty(key));
            }
        }
    }

    public static String loadServerLog4j() {
        System.setProperty("log.dir", ClientCache.getInstallLocation() + File.separator + "logs");
        String logConfFile = System.getProperty("org.apache.log4j.file");
        if (logConfFile == null || logConfFile.length() == 0) {
            logConfFile = ClientCache.getConfDir() + "log4j_fms.xml";
        }
        DOMConfigurator.configure((String)logConfFile);
        return logConfFile;
    }

    public static void loadServerProperties(Logger log) throws IOException {
        String key;
        GenUtil.readJVMProperties();
        String configFile = System.getProperty("server.properties.file");
        if (configFile == null || configFile.length() == 0) {
            configFile = ClientCache.getConfDir() + "server.properties";
        }
        Properties properties = new Properties();
        GenUtil.loadConfiguration(configFile, properties);
        if (log == null) {
            System.out.println("Server configuration file loaded: " + configFile);
        } else {
            log.info((Object)("Server configuration file loaded: " + configFile));
        }
        System.getProperties().putAll((Map<?, ?>)properties);
        ArrayList propList = ServerPropertyUtil.readServerProperties();
        for (PropertyWrapper prop : propList) {
            key = prop.getKey();
            System.setProperty(key, prop.getValue());
        }
        for (Object obj : _JVM_properties.keySet()) {
            key = (String)obj;
            String value = _JVM_properties.getProperty(key);
            if (value == null || value.length() == 0) continue;
            System.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfiguration(String configFile, Properties properties) throws IOException {
        FileInputStream fis = null;
        try {
            File file = new File(configFile);
            if (!file.exists()) {
                throw new IOException("file not found: " + configFile);
            }
            if (!file.canRead()) {
                throw new IOException("cannot read file: " + configFile);
            }
            fis = new FileInputStream(file);
            if (fis == null) {
                throw new IOException("file not found: " + configFile);
            }
            properties.load(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String dump(Object o) {
        return GenUtil.dump(o, null);
    }

    public static String dump(Object o, String lnInd) {
        StringBuilder sb = new StringBuilder();
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (Modifier.isStatic(methods[i].getModifiers())) continue;
            String name = methods[i].getName();
            if (name.startsWith("get")) {
                name = name.substring(3);
            } else if (!name.startsWith("is")) continue;
            Class<?>[] paramCls = methods[i].getParameterTypes();
            if (paramCls.length != 0) continue;
            sb.append("\n");
            if (lnInd != null) {
                sb.append(lnInd);
            }
            sb.append(name).append(": ");
            try {
                sb.append(methods[i].invoke(o, null));
                continue;
            }
            catch (Exception ex) {
                sb.append(ex.getMessage());
            }
        }
        return sb.toString();
    }

    public static String dump(ByteBuffer buf, int offset, int len) {
        StringBuilder sb = new StringBuilder(buf.limit() * 3);
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                sb.append("\n");
            } else if (i % 8 == 0) {
                sb.append(" ");
            }
            String s = Integer.toHexString(buf.get(offset + i) & 0xFF);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s).append(" ");
        }
        return sb.toString();
    }

    public static String dump(byte[] buf, int offset, int len) {
        StringBuilder sb = new StringBuilder(len * 3);
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                sb.append("\n");
            } else if (i % 8 == 0) {
                sb.append(" ");
            }
            String s = Integer.toHexString(buf[offset + i] & 0xFF);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s).append(" ");
        }
        return sb.toString();
    }

    public static void getAllThreadInfos(List<ThreadInfo> threads) {
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        GenUtil.getThreadInfos(topThreadGroup, threads);
    }

    public static void getThreadInfos(ThreadGroup threadGroup, List<ThreadInfo> sb) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread t = threads[i];
            String name = t.getName();
            long cpuTime = threadBean.getThreadCpuTime(t.getId());
            sb.add(new ThreadInfo(name, cpuTime));
        }
        ThreadGroup[] subGroups = new ThreadGroup[threadGroup.activeGroupCount()];
        int numGroups = threadGroup.enumerate(subGroups, false);
        for (int i = 0; i < numGroups; ++i) {
            GenUtil.getThreadInfos(subGroups[i], sb);
        }
    }

    public static String dumpAllThreads(boolean stackTrace) {
        StringBuilder sb = new StringBuilder();
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        sb.append("Active threads: ").append(topThreadGroup.activeCount());
        GenUtil.dumpThreads(topThreadGroup, stackTrace, sb, "");
        return sb.toString();
    }

    public static void dumpThreads(ThreadGroup threadGroup, boolean stackTrace, StringBuilder sb, String indent) {
        String LINESEP = System.getProperty("line.separator");
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads, false);
        sb.append(LINESEP).append(indent).append("Group ").append(threadGroup.getName()).append(" (").append(numThreads).append(")");
        indent = indent + "\t";
        for (int i = 0; i < numThreads; ++i) {
            Thread t = threads[i];
            sb.append(LINESEP).append(indent).append(i + 1).append(": ").append(t.getName()).append(",\t").append((Object)t.getState()).append(",\tpriority: ").append(t.getPriority()).append(",\t").append(t.isDaemon() ? "daemon" : "nondaemon");
            if (!stackTrace) continue;
            StackTraceElement[] stes = t.getStackTrace();
            for (int j = 0; j < stes.length; ++j) {
                sb.append(LINESEP).append(indent).append("\t").append(stes[j].toString());
            }
        }
        sb.append(LINESEP);
        ThreadGroup[] subGroups = new ThreadGroup[threadGroup.activeGroupCount()];
        int numGroups = threadGroup.enumerate(subGroups, false);
        for (int i = 0; i < numGroups; ++i) {
            GenUtil.dumpThreads(subGroups[i], stackTrace, sb, indent);
        }
    }

    public static String dumpEnvs() {
        StringBuilder sb = new StringBuilder("system environment variables:");
        Object[] keys = System.getenv().keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            sb.append("\n\t" + keys[i] + " = " + System.getenv((String)keys[i]));
        }
        sb.append("\nJRE properties:");
        Properties props = System.getProperties();
        keys = props.keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            sb.append("\n\t" + keys[i].toString() + " = " + props.get(keys[i]).toString());
        }
        return sb.toString();
    }

    public static List toRegexPatterns(String regex) {
        String[] ss = regex.split(",", -1);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            try {
                patterns.add(Pattern.compile(ss[i]));
                continue;
            }
            catch (PatternSyntaxException ex) {
                System.err.println(ss[i] + " regex pattern syntax error: " + ex);
            }
        }
        return patterns;
    }

    public static String regexMatch(ArrayList patterns, String input) {
        return GenUtil.regexMatch(patterns, input, true);
    }

    public static String regexMatch(ArrayList patterns, String input, boolean convertToUpper) {
        if (patterns != null) {
            if (convertToUpper) {
                input = input.toUpperCase();
            }
            for (int i = 0; i < patterns.size(); ++i) {
                Matcher m = ((Pattern)patterns.get(i)).matcher(input);
                if (!m.matches()) continue;
                if (m.groupCount() >= 1) {
                    input = m.group(1);
                }
                return input;
            }
        }
        return input;
    }

    public static String getWebServerPath() {
        PortConfigurator pc = new PortConfigurator(ClientCache.getDcmDir(), "fm");
        String path = null;
        try {
            pc.load(ClientCache.getDcmDir() + File.separator + pc.WEB);
            pc.getWebPortsFromTomcat();
            System.out.println("Server.xml is loaded: scheme -- " + pc.isHTTPS() + " ::" + "port -- " + pc.getWebPort());
            String localIp = InetAddress.getLocalHost().getHostAddress();
            path = (pc.isHTTPS() ? "https" : "http") + "://" + localIp + ":" + pc.getWebPort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public static boolean isCiscoSerialNumber(String serialNum) {
        int i;
        if (serialNum == null) {
            return false;
        }
        String sn = serialNum.trim().toUpperCase();
        if (sn.length() != 10 && sn.length() != 11) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (Character.isLetter(sn.charAt(i))) continue;
            return false;
        }
        for (i = 3; i < 7; ++i) {
            if (Character.isDigit(sn.charAt(i))) continue;
            return false;
        }
        for (i = 7; i < 10; ++i) {
            if (Character.isLetterOrDigit(sn.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getCiscoSerialNumber(String deviceId) {
        if (deviceId == null || deviceId.length() < 11) {
            return null;
        }
        String str1 = null;
        String str2 = null;
        int lidx = deviceId.indexOf(40);
        if (lidx > 0) {
            str1 = deviceId.substring(0, lidx);
            int ridx = deviceId.indexOf(41, lidx);
            str2 = ridx > 0 ? deviceId.substring(lidx + 1, ridx) : deviceId.substring(lidx + 1);
        } else {
            str1 = deviceId;
        }
        if (GenUtil.isCiscoSerialNumber(str1)) {
            return str1.toUpperCase();
        }
        if (str2 != null && GenUtil.isCiscoSerialNumber(str2)) {
            return str2.toUpperCase();
        }
        return null;
    }

    public static String getSysName(String deviceId) {
        if (deviceId == null || !deviceId.startsWith("c6k") && deviceId.length() < 11) {
            return null;
        }
        String str1 = null;
        String str2 = null;
        int lidx = deviceId.indexOf(40);
        if (lidx > 0) {
            str1 = deviceId.substring(0, lidx);
            int ridx = deviceId.indexOf(41, lidx);
            str2 = ridx > 0 ? deviceId.substring(lidx + 1, ridx) : deviceId.substring(lidx + 1);
        } else {
            str1 = deviceId;
        }
        if (!GenUtil.isCiscoSerialNumber(str1)) {
            return str1;
        }
        if (str2 != null && !GenUtil.isCiscoSerialNumber(str2)) {
            return str2;
        }
        return null;
    }

    public static String trimDomain(String sysName) {
        String[] splits;
        if (sysName == null) {
            return null;
        }
        String trimed = sysName;
        int lp = trimed.indexOf(40);
        int rp = trimed.indexOf(41);
        if (lp > 0 && rp > lp) {
            trimed = trimed.substring(0, lp);
        }
        if ((splits = trimed.split("\\.")) == null || splits.length == 0) {
            return trimed;
        }
        if (splits.length >= 4) {
            boolean hasIP = true;
            block0: for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < splits[i].length(); ++j) {
                    char c = splits[i].charAt(j);
                    if (c == '.' || Character.isDigit(c)) continue;
                    hasIP = false;
                    continue block0;
                }
            }
            if (hasIP) {
                return trimed.substring(0, splits[0].length() + splits[1].length() + splits[2].length() + splits[3].length() + 3);
            }
        }
        return splits[0];
    }

    public static String trimCisco(String modelName) {
        if (modelName == null) {
            return null;
        }
        String trimed = modelName.toUpperCase();
        if (trimed.length() > 5) {
            trimed = trimed.replaceFirst("CISCO", "");
        }
        return trimed.trim();
    }

    public static String replaceStringForXML(String orig) {
        if (orig == null) {
            return null;
        }
        String ret = orig.replaceAll("\"", "&#34;");
        return ret;
    }

    public static void main(String[] args) {
        int i;
        Pattern pat = Pattern.compile("(.*)[_-]HBA.*");
        Matcher m = pat.matcher("test-HBA.123");
        if (m.matches()) {
            System.out.println("match test-HBA.123");
            for (i = 0; i < m.groupCount(); ++i) {
                System.out.println("i:" + m.group(i));
            }
        }
        if ((m = (pat = Pattern.compile("(.*)[_-].*")).matcher("test-HBA.123")).matches()) {
            System.out.println("match test-HBA.123");
            for (i = 0; i < m.groupCount(); ++i) {
                System.out.println("i:" + m.group(i));
            }
        }
    }
}

