/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.ReportFilterDO;
import com.cisco.dcbu.jaxws.san.wo.ReportTemplateBaseDO;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.ui.ReportConstants;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.model.FabricHolder;
import com.cisco.dcbu.sm.common.model.FileWrapper;
import com.cisco.dcbu.sm.common.model.FilterTreeWrapper;
import com.cisco.dcbu.sm.common.model.NameValuePair;
import com.cisco.dcbu.sm.common.model.ReportAttribute;
import com.cisco.dcbu.sm.common.model.ReportTemplateBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.config.BackUpConfiguration;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.facade.IscImpl;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.scheduler.SchedulerManagerImpl;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.UserManager;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.WebConst;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.quartz.JobDataMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportUtil {
    public static final String REPORT_DIR = "reports";
    public static final String ANALYSIS_DIR = "analysis";
    public static String REPORT_EXT;
    public static String CSV_EXT;
    public static String XLS_EXT;
    public static final String DUPLICATE_NAME_ERROR = "Duplicate job name defined! please use another name.";
    public static final int ERROR_STATUS = -1;
    public static String _FullReportDir;
    public static final String _FilterSQL = "SELECT DISTINCT FABRIC.ID, FABRIC.NAME, VSAN.ID, VSAN.NAME, VSAN.IS_DISJOINT, VSAN.IS_UP, SWITCH.SYS_NAME, VSAN.VSAN_ID, FABRIC.FID, VSAN.PRINCIPAL_SWWN, FABRIC.LICENSE_ID FROM FABRIC JOIN VSAN ON (VSAN.FABRIC_ID = FABRIC.ID) JOIN SWITCH ON (VSAN.PRINCIPAL_SW_ID = SWITCH.ID) ORDER BY FABRIC.NAME ASC, VSAN.VSAN_ID ASC";
    public static final String _GroupSQL = "SELECT GROUPS.ID, GROUPS.NAME, GROUPS.TYPE,GROUPS.FABRIC_ID FROM GROUPS ORDER BY GROUPS.NAME ASC";
    private static ReportUtil _ReportUtil;
    private static final String BLANK = "";
    Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _ParentMap = null;
    private Map<String, String> _Filter2DisplayMap = null;
    public static final String[] INTERVAL_OPTIONS;
    static final String[] SummaryDetailList;
    static final String[] PerfUtilList;
    public static final String[] REPORT_NAME;
    static final String[] REPORT_TEMPLATE_NAME;
    String[] _FilterDisplay = new String[]{"Timeout", "Show Top", "Embed Charts in Reports", "Use Fixed Value Range for charts", "MinYAxis", "MaxYAxis", "MaxUnit", "MinUnit"};
    String[] _FilterKey = new String[]{"fcPingTimeout", "numRecords", "embedCharts", "useFixedRange", "lowBar", "highBar", "highUnit", "lowUnit"};
    private static final ReportTemplateBaseDO[] SanHealthReports_Array;
    private static final ReportTemplateBaseDO[] CommonReports_Array;
    public static final List<ReportTemplateBaseDO> SanHealthReports;
    private static final ReportTemplateBaseDO[] HealthAnalysisTemplates_Array;
    public static final List<ReportTemplateBaseDO> HealthAnalysisTemplates;
    public static final List<String> SanHealthReports_TemplateNames;
    public static final List<String> CommonReports_TemplateNames;
    public static final List<String> HealthAnalysis_TemplateNames;

    public static ReportUtil getInstance() {
        if (_ReportUtil == null) {
            _ReportUtil = new ReportUtil();
        }
        return _ReportUtil;
    }

    public static String getIntervalText(int interval) {
        if (interval >= 0 && interval <= 5) {
            return INTERVAL_OPTIONS[interval];
        }
        return BLANK;
    }

    private ReportUtil() {
        this.initParentMap();
        this.initFilterMap();
    }

    private void initParentMap() {
        this._ParentMap = new HashMap<String, String>();
        for (String child : REPORT_NAME) {
            this._ParentMap.put(child, "Analysis");
        }
    }

    private void initFilterMap() {
        this._Filter2DisplayMap = new HashMap<String, String>();
        for (int i = 0; i < this._FilterKey.length; ++i) {
            this._Filter2DisplayMap.put(this._FilterKey[i], this._FilterDisplay[i]);
        }
    }

    public static String getUserNameInPath(File file) {
        if (file == null) {
            return null;
        }
        String[] files = file.getAbsolutePath().split(Pattern.quote(File.separator));
        for (int i = 0; i < files.length; ++i) {
            String s = files[i];
            if (s == null || !s.equals(REPORT_DIR) || i >= files.length - 1) continue;
            return files[i + 1];
        }
        return null;
    }

    public static String formatUserName(String name) {
        return name == null || name.length() <= 8 ? name : name.substring(0, 8);
    }

    public static String formatTemplateName(String templateName) {
        return templateName.substring(0, templateName.lastIndexOf(".xml"));
    }

    public static void getLocalTemplates(File reportDir, ArrayList<NameValuePair> templateList) {
        if (reportDir == null) {
            return;
        }
        File[] files = reportDir.listFiles();
        String localIP = null;
        try {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (localIP == null) {
            return;
        }
        for (File file : files) {
            String name;
            if (file.isFile() && file.getName().endsWith("xml")) {
                String templateName = file.getName();
                templateName = templateName.substring(0, templateName.lastIndexOf(".xml"));
                String userName = ReportUtil.getUserNameInPath(file);
                templateList.add(new NameValuePair(userName + "." + templateName, ReportUtil.formatUserName(userName) + "." + templateName, localIP));
                continue;
            }
            if (!file.isDirectory() || "fcpolicy".equalsIgnoreCase(name = file.getName()) || ANALYSIS_DIR.equalsIgnoreCase(name)) continue;
            ReportUtil.getLocalTemplates(file, templateList);
        }
    }

    public static String savePolicyFile(String modFileName, String fileContent) throws Exception {
        if (modFileName.trim().length() == 0) {
            throw new Exception("Invalid file Name");
        }
        File backedFile = null;
        try (BufferedWriter bwr = null;){
            backedFile = new File(modFileName);
            FileOutputStream fo = new FileOutputStream(backedFile);
            OutputStreamWriter wr = new OutputStreamWriter(fo);
            bwr = new BufferedWriter(wr);
            bwr.write(fileContent);
            bwr.flush();
            bwr.close();
            String string = modFileName;
            return string;
        }
    }

    public static ArrayList<FileWrapper> getLocalReports(File reportDir, String base, Map dataMap, String serverIpAdd, boolean allAdmin) {
        ArrayList<FileWrapper> list = new ArrayList<FileWrapper>();
        File[] all = reportDir.listFiles();
        if (all == null) {
            return list;
        }
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].isDirectory()) {
                ReportUtil.populateReportList(base, list, dataMap, all[i], serverIpAdd, allAdmin);
                continue;
            }
            if (!all[i].isDirectory() || all[i].getName().equalsIgnoreCase(ANALYSIS_DIR)) continue;
            ReportUtil.getReportsInDir(all[i], base, list, dataMap, serverIpAdd, allAdmin);
        }
        File analysisReportDir = new File(reportDir + File.separator + ANALYSIS_DIR);
        if (!analysisReportDir.exists()) {
            analysisReportDir.mkdir();
        }
        ReportUtil.getReportsInDir(analysisReportDir, base, list, dataMap, serverIpAdd, allAdmin);
        return list;
    }

    public static ArrayList<FileWrapper> getLocalReports(File reportDir, String base, Map dataMap, String serverIpAdd) {
        return ReportUtil.getLocalReports(reportDir, base, dataMap, serverIpAdd, false);
    }

    private static void getReportsInDir(File dir, String base, ArrayList<FileWrapper> list, Map dataMap, String serverIpAdd, boolean allAdmin) {
        File[] all = dir.listFiles();
        for (int i = 0; i < all.length; ++i) {
            String name;
            if (all[i].isFile()) {
                ReportUtil.populateReportList(base, list, dataMap, all[i], serverIpAdd, allAdmin);
                continue;
            }
            if (!all[i].isDirectory() || "fcpolicy".equalsIgnoreCase(name = all[i].getName())) continue;
            ReportUtil.getReportsInDir(all[i], base, list, dataMap, serverIpAdd, allAdmin);
        }
    }

    private static void populateReportList(String base, ArrayList<FileWrapper> list, Map dataMap, File report, String serverIpAdd, boolean allAdmin) {
        String userName = (String)dataMap.get("userName");
        boolean isAdmin = (Boolean)dataMap.get("isAdmin");
        String sanHealthFilter = (String)dataMap.get("sanHealthFilter");
        if (sanHealthFilter != null && !report.getParent().endsWith(sanHealthFilter)) {
            return;
        }
        try {
            Logger.getLogger((String)"fms").debug((Object)("REport:" + report.getAbsolutePath() + " canWrite:" + report.canWrite()));
        }
        catch (Exception exx) {
            // empty catch block
        }
        if ((report.getName().endsWith(REPORT_EXT) || report.getName().endsWith(CSV_EXT) || report.getName().endsWith(XLS_EXT)) && (allAdmin || ReportUtil.isReportReadOnly(serverIpAdd, report) || ReportUtil.allowed(report, userName, isAdmin))) {
            list.add(ReportUtil.getWrapper(report, base, serverIpAdd));
        }
    }

    private static boolean isReportReadOnly(String serverIp, File report) {
        Boolean isWrite = PersistentHelper.getHelper().getReportsFileWriteFlag(serverIp, report.getAbsolutePath());
        if (isWrite == null) {
            return !report.canWrite();
        }
        return isWrite == false;
    }

    public static void cleanOldReports(String serverIp, long elapse, File rptDir) {
        File[] fileList;
        try {
            fileList = rptDir.listFiles();
        }
        catch (Exception ex) {
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            String fname = fileList[i].getName();
            if (fileList[i].isFile()) {
                if (!fname.endsWith(".html") && !fname.endsWith(".csv")) continue;
                try {
                    if (System.currentTimeMillis() - fileList[i].lastModified() <= elapse) continue;
                    fileList[i].delete();
                    PersistentHelper.getHelper().deleteReportFileWriteFlag(serverIp, fname);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            if (!fileList[i].isDirectory() || "fcpolicy".equalsIgnoreCase(fname)) continue;
            ReportUtil.cleanOldReports(serverIp, elapse, fileList[i]);
        }
    }

    private static FileWrapper getWrapper(File f, String base, String serverIpAdd) {
        FileWrapper w = new FileWrapper();
        w.setParent(f.getParentFile().getName());
        w.setName(f.getName());
        String url = null;
        url = base + f.getAbsolutePath() + "&svr=" + serverIpAdd + "&currentScreenID=" + base.substring(1, base.lastIndexOf(".do"));
        w.setAbsoluteName("<a href=\"" + url + "\" target=\"_blank\">" + f.getName() + "</a>");
        w.setLink(url);
        w.setLastModified(new Date(f.lastModified()));
        w.setFile(f);
        w.setId(Math.abs(f.getAbsolutePath().hashCode()) + BLANK);
        w.setReadOnly(!f.canWrite());
        String[] pathArr = f.getAbsolutePath().split(Pattern.quote(File.separator));
        for (int i = 0; i < pathArr.length; ++i) {
            String s = pathArr[i];
            if (!REPORT_DIR.equals(s)) continue;
            w.setCreator(pathArr[i + 1]);
            w.setTemplate(pathArr[i + 3]);
            break;
        }
        w.setContext(ReportUtil.getContext(f));
        return w;
    }

    private static boolean allowed(File file, String userName, boolean isAdmin) {
        if (isAdmin) {
            return true;
        }
        return file.getAbsolutePath().indexOf(userName) >= 0 && userName.equalsIgnoreCase(ReportUtil.getUserNameInPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContext(File report) {
        String temp = null;
        if (report.getName().endsWith(CSV_EXT)) {
            BufferedReader reader = null;
            try {
                String line;
                int endIndex;
                reader = new LineNumberReader(new FileReader(report));
                while ((endIndex = (line = ((LineNumberReader)reader).readLine()).indexOf(" as of")) == -1) {
                }
                temp = line.substring(0, endIndex);
            }
            catch (Exception e) {
                String endIndex = BLANK;
                return endIndex;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        if (report.getName().endsWith(XLS_EXT)) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(report);
                HSSFWorkbook workBook = new HSSFWorkbook((InputStream)inputStream);
                HSSFSheet sheet = workBook.getSheetAt(0);
                Iterator rowIter = sheet.rowIterator();
                while (rowIter.hasNext()) {
                    HSSFRow nextRow = (HSSFRow)rowIter.next();
                    Iterator cellIter = nextRow.cellIterator();
                    while (cellIter.hasNext()) {
                        HSSFCell nextCell = (HSSFCell)cellIter.next();
                        String cellText = nextCell.toString();
                        int endIndex = cellText.indexOf(" as of");
                        if (endIndex == -1) continue;
                        temp = cellText.substring(0, endIndex);
                        break;
                    }
                    if (temp == null) continue;
                }
            }
            catch (Exception e) {
                String sheet = BLANK;
                return sheet;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception ex) {}
                }
            }
        } else {
            BufferedReader reader = null;
            try {
                int startIndex;
                String line;
                int index;
                reader = new LineNumberReader(new FileReader(report));
                int addToStartIndex = 13;
                do {
                    if ((index = (line = ((LineNumberReader)reader).readLine()).indexOf("BannerTitle\">")) != -1 || (index = line.indexOf("BannerTitle\"/>")) == -1) continue;
                    addToStartIndex = 14;
                } while (index < 0);
                int endIndex = line.indexOf("</span");
                temp = line.substring(index + addToStartIndex, endIndex);
                if ((endIndex = temp.indexOf(" as of")) != -1) {
                    temp = temp.substring(0, endIndex);
                }
                if ((startIndex = temp.indexOf(">")) != -1) {
                    temp = temp.substring(startIndex + 1);
                }
            }
            catch (Exception e) {
                String string = BLANK;
                return string;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
        if (temp != null) {
            if (temp.indexOf("SAN") == 0) {
                return "SAN";
            }
            temp = temp.replaceAll(" &gt; ", BLANK);
            temp = temp.replaceAll(" > ", BLANK);
        } else {
            temp = BLANK;
        }
        return temp;
    }

    public static void deleteFiles(File report, String serverIp, boolean usePattern) {
        File[] fileArray;
        if (report == null || !report.exists()) {
            return;
        }
        File parent = report.getParentFile();
        String reportName = report.getName().substring(0, report.getName().lastIndexOf("."));
        if (usePattern) {
            fileArray = parent.listFiles(new MyFileFilter(reportName));
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = report;
        }
        File[] files = fileArray;
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                file.delete();
                PersistentHelper.getHelper().deleteReportFileWriteFlag(serverIp, file.getName());
            }
            return;
        }
    }

    public ArrayList<ReportTemplateBase> getCustomReportTemplates(boolean isAdmin, String userName) {
        ArrayList<ReportTemplateBase> all = new ArrayList();
        all = this.getTemplatesFromDb(isAdmin, userName);
        Collections.sort(all);
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ReportTemplateBase> getTemplatesFromDb(boolean isAdmin, String uName) {
        ArrayList<ReportTemplateBase> tempList;
        block8: {
            tempList = new ArrayList<ReportTemplateBase>();
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String suffix = BLANK;
            String queryTemplatesSql = "select document_name, user_name from xmlDocs";
            if (!isAdmin) {
                suffix = " where user_name = ?";
            }
            try {
                conn = ConnectionManager.getConnection();
                ps = conn.prepareStatement(queryTemplatesSql + suffix);
                if (!isAdmin) {
                    ps.setString(1, uName);
                }
                rs = ps.executeQuery();
                String userName = null;
                String docName = null;
                while (rs.next()) {
                    docName = ReportUtil.formatTemplateName(rs.getString(1));
                    userName = rs.getString(2);
                    tempList.add(new ReportTemplateBase(docName, userName));
                }
                DbUtil.close((ResultSet)rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block8;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(ps);
                DbUtil.close((Connection)conn);
            }
            DbUtil.close((Statement)ps);
            DbUtil.close((Connection)conn);
        }
        return tempList;
    }

    public ArrayList<ReportAttribute> openReportTemplate(String reportTemplateName, String userName) {
        ArrayList<ReportAttribute> reportAttributeList = new ArrayList<ReportAttribute>();
        try {
            File file2Read = new File(_FullReportDir + File.separator + userName + File.separator + "custom" + File.separator + reportTemplateName);
            PersistentHelper.getHelper().retrieveFile(reportTemplateName, file2Read, userName);
            if (!file2Read.exists()) {
                this._Log.warn((Object)("Failed to read the file: " + file2Read));
                return reportAttributeList;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(file2Read);
            Element template = doc.getDocumentElement();
            this.handlePreV5Scope(template, reportAttributeList);
            NodeList groups = template.getElementsByTagName("group");
            for (int i = 0; i < groups.getLength(); ++i) {
                Element group = (Element)groups.item(i);
                String groupName = group.getAttribute("name");
                if (groupName.equalsIgnoreCase("Scope")) {
                    this.handleAfterV5Scope(reportAttributeList, group);
                } else {
                    reportAttributeList.add(new ReportAttribute(groupName, groupName, true, groupName, groupName, new String[0], null, null, null, group.getAttribute("state")));
                }
                NodeList reports = group.getElementsByTagName("report");
                for (int j = 0; j < reports.getLength(); ++j) {
                    String selection;
                    String parentName;
                    String reportName;
                    Element report = (Element)reports.item(j);
                    boolean isPreV5 = this.preV5ReportHandler(report, groupName, reportName = report.getAttribute("name"), parentName = this.getParent(report.getAttribute("parent"), reportName, groupName), selection = this.getSelection(report.getAttribute("selection"), reportName, parentName, groupName), reportAttributeList);
                    if (isPreV5) continue;
                    NodeList filters = report.getElementsByTagName("filter");
                    String[] optionDataArray = new String[filters.getLength()];
                    for (int k = 0; k < filters.getLength(); ++k) {
                        Element e = (Element)filters.item(k);
                        String key = e.getAttribute("name");
                        String displayVlu = this._Filter2DisplayMap.get(key);
                        String vlu = e.getAttribute("value");
                        optionDataArray[k] = (displayVlu == null ? key : displayVlu) + ":" + (vlu == null || vlu.length() == 0 ? "on" : vlu);
                    }
                    ReportAttribute rptAttr = new ReportAttribute(reportName, groupName, true, parentName, selection, optionDataArray);
                    rptAttr.setState(report.getAttribute("state"));
                    reportAttributeList.add(rptAttr);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return reportAttributeList;
    }

    private void handleAfterV5Scope(ArrayList<ReportAttribute> reportAttributeList, Element group) {
        NodeList roots = group.getElementsByTagName("root");
        Element root = (Element)roots.item(0);
        NodeList networks = root.getElementsByTagName("network");
        Element network = (Element)networks.item(0);
        String nwName = network.getAttribute("name");
        reportAttributeList.add(new ReportAttribute(nwName, "Scope", true, root.getAttribute("name"), nwName, new String[0], network.getAttribute("dbId"), network.getAttribute("id"), network.getAttribute("vsanIndexSwitchWWN"), network.getAttribute("state")));
        NodeList fabrics = network.getElementsByTagName("fabric");
        for (int i = 0; i < fabrics.getLength(); ++i) {
            Element fabric = (Element)fabrics.item(i);
            String fabricName = fabric.getAttribute("name");
            NodeList vsans = fabric.getElementsByTagName("vsan");
            reportAttributeList.add(new ReportAttribute(fabricName, "Scope", true, nwName, fabricName, new String[0], fabric.getAttribute("dbId"), fabric.getAttribute("id"), fabric.getAttribute("vsanIndexSwitchWWN"), fabric.getAttribute("state")));
            for (int j = 0; j < vsans.getLength(); ++j) {
                Element vsan = (Element)vsans.item(j);
                String vsanName = vsan.getAttribute("name");
                String type = vsan.getAttribute("type");
                if (type.equalsIgnoreCase("group")) {
                    reportAttributeList.add(new ReportAttribute(vsanName, "Scope", true, fabricName, vsanName, new String[0], vsan.getAttribute("gdbId"), vsan.getAttribute("gtype"), vsan.getAttribute("vsanIndexSwitchWWN"), vsan.getAttribute("state"), type));
                    continue;
                }
                reportAttributeList.add(new ReportAttribute(vsanName, "Scope", true, fabricName, vsanName, new String[0], vsan.getAttribute("dbId"), vsan.getAttribute("id"), vsan.getAttribute("vsanIndexSwitchWWN"), vsan.getAttribute("state")));
            }
        }
    }

    private boolean preV5ReportHandler(Element report, String groupName, String reportName, String parentName, String selection, ArrayList<ReportAttribute> attrList) {
        int appendLen = 0;
        if (reportName.equalsIgnoreCase("Fabric Events")) {
            String[] optionDataArray = this.formOptionArray(report, appendLen);
            ReportAttribute rptAttr = new ReportAttribute(reportName, groupName, true, parentName, selection, optionDataArray);
            rptAttr.setState(report.getAttribute("state"));
            attrList.add(rptAttr);
            return true;
        }
        if (reportName.equalsIgnoreCase("Switches+Details")) {
            reportName = "Switches";
            String[] optionDataArray = this.formOptionArray(report, ++appendLen);
            optionDataArray[optionDataArray.length - 1] = "Include Switch Details:on";
            ReportAttribute rptAttr = new ReportAttribute(reportName, groupName, true, parentName, selection, optionDataArray);
            rptAttr.setState(report.getAttribute("state"));
            attrList.add(rptAttr);
            return true;
        }
        if (reportName.startsWith("SummaryDetail")) {
            String[] optionDataArray = new String[]{"Include Summary Details:on"};
            ReportAttribute attr = attrList.get(attrList.size() - 1);
            attr.setOptionDataArray(optionDataArray);
            attr.setState(report.getAttribute("state"));
            return true;
        }
        return reportName.indexOf("Utilization Summary") > 0;
    }

    private String[] formOptionArray(Element report, int appendLen) {
        NodeList filters = report.getElementsByTagName("filter");
        String[] optionDataArray = filters.getLength() == 0 ? new String[]{} : new String[filters.getLength() + appendLen];
        for (int k = 0; k < filters.getLength() && optionDataArray.length > k; ++k) {
            Element e = (Element)filters.item(k);
            String key = e.getAttribute("name");
            String displayVlu = this._Filter2DisplayMap.get(key);
            optionDataArray[k] = (displayVlu == null ? key : displayVlu) + ":" + e.getAttribute("value");
        }
        return optionDataArray;
    }

    private String getSelection(String selection, String attrName, String pName, String gName) {
        if (selection == null || selection.length() == 0) {
            if (attrName.equals(gName)) {
                return attrName;
            }
            if (pName.equals(gName)) {
                return "\t" + attrName;
            }
            return "\t\t" + attrName;
        }
        return selection;
    }

    private String getParent(String parent, String attName, String groupName) {
        String pName = null;
        if (parent == null || parent.length() == 0) {
            pName = this._ParentMap.get(attName);
        }
        if (pName == null || pName.equals(parent)) {
            pName = groupName;
        }
        return pName;
    }

    private void handlePreV5Scope(Element template, ArrayList<ReportAttribute> reportAttributeList) {
        if (template.getAttribute("fabricId").length() == 0) {
            return;
        }
        int fabricId = Integer.parseInt(template.getAttribute("fabricId"));
        int vsanId = Integer.parseInt(template.getAttribute("vsanId"));
        String fabricName = template.getAttribute("fabric");
        String vsanName = template.getAttribute("vsan");
        if (fabricId == -2) {
            return;
        }
        if (vsanId != -1) {
            reportAttributeList.add(new ReportAttribute(vsanName, "Scope", true, fabricName));
            return;
        }
        if (fabricId != -1) {
            reportAttributeList.add(new ReportAttribute(fabricName, "Scope", true, "SAN"));
            return;
        }
        reportAttributeList.add(new ReportAttribute("SAN", "Scope", true, "Data Center"));
    }

    public static boolean isHealthAnalysis(String templateName) {
        for (ReportTemplateBaseDO tmpl : HealthAnalysisTemplates) {
            if (!templateName.equals(tmpl.templateName)) continue;
            return true;
        }
        return false;
    }

    public String getTemplatesInXml(String isAdminStr, String userName) {
        ArrayList<FabricHolder> scopeView = this.getFilterTree();
        StringBuffer scopeInXml = new StringBuffer();
        scopeInXml.append("<templates label=\"Templates\">\n");
        scopeInXml.append("<category label=\"" + ReportTemplateBaseDO.CATEGORY_COMMON + "\">\n");
        for (ReportTemplateBaseDO tmpl : CommonReports_Array) {
            scopeInXml.append("<template label=\"" + tmpl.description + "\" name=\"" + tmpl.templateName + "\" limitingScope=\"" + tmpl.limitingScope + "\" category=\"" + ReportTemplateBaseDO.CATEGORY_COMMON + "\" />\n");
        }
        scopeInXml.append("</category>\n");
        scopeInXml.append("<category label=\"" + ReportTemplateBaseDO.CATEGORY_SAN_HEALTH + "\">\n");
        for (ReportTemplateBaseDO tmpl : SanHealthReports) {
            scopeInXml.append("<template label=\"" + tmpl.description + "\" name=\"" + tmpl.templateName + "\" limitingScope=\"" + tmpl.limitingScope + "\" category=\"" + ReportTemplateBaseDO.CATEGORY_SAN_HEALTH + "\" />\n");
        }
        scopeInXml.append("</category>\n");
        scopeInXml.append("<category label=\"" + ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED + "\">\n");
        for (ReportTemplateBaseDO tmpl : HealthAnalysisTemplates) {
            scopeInXml.append("<template label=\"" + tmpl.description + "\" name=\"" + tmpl.templateName + "\" limitingScope=\"" + tmpl.limitingScope + "\" category=\"" + ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED + "\" />\n");
        }
        scopeInXml.append("</category>\n");
        ArrayList<ReportTemplateBase> totalTemplateList = ReportUtil.getInstance().getCustomReportTemplates(Boolean.getBoolean(isAdminStr), userName);
        if (totalTemplateList != null && totalTemplateList.size() > 0) {
            scopeInXml.append("<category label=\"" + ReportTemplateBaseDO.CATEGORY_SAN_USER + "  (Based predefined scope)" + "\">\n");
            for (ReportTemplateBase tmpl : totalTemplateList) {
                scopeInXml.append("<template label=\"" + tmpl.getTemplateName() + "\" name=\"" + tmpl.getTemplateName() + "\" limitingScope=\"" + ReportTemplateBaseDO.SCOPE_LIMIT_NONE + "\" category=\"" + ReportTemplateBaseDO.CATEGORY_SAN_USER + "\"  />\n");
            }
            scopeInXml.append("</category>\n");
        }
        scopeInXml.append("</templates>");
        return scopeInXml.toString();
    }

    private String getServerForFabric(int fId) {
        String serverIp = BLANK;
        try {
            serverIp = ClusterProcessor.getInstance().getServerIpByPK(new FabricPK(fId));
        }
        catch (Exception ex) {
            this._Log.error((Object)("Unable to find server for Fabric " + fId));
        }
        return serverIp;
    }

    public String getScopeInXml() {
        ArrayList<FabricHolder> scopeView = this.getFilterTree();
        StringBuffer scopeInXml = new StringBuffer();
        boolean isFederatedMode = ClusterProcessor.getInstance().getFMServers().size() > 1;
        Map<Long, List<FilterTreeWrapper>> fabric2GrpMap = this.buildGroups();
        scopeInXml.append("<folders label=\"Scope\">\n");
        scopeInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"Data Center\" \tparent=\"Scope\" group=\"Scope\" selection=\"Data Center\">\n");
        scopeInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"SAN\" \tparent=\"Data Center\" group=\"Scope\" selection=\"\tSAN\">\n");
        for (FabricHolder fh : scopeView) {
            String fabricName = fh.getName();
            String serverIp = isFederatedMode ? this.getServerForFabric(fh.getFid()) : BLANK;
            fh.setServerIP(serverIp);
            scopeInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"" + fabricName + "\"  \tparent=\"SAN\" dbId=\"" + fh.getId() + "\" attrId=\"" + fh.getFid() + "\" group=\"Scope\" selection=\"\t\t" + fabricName + "\" serverIp=\"" + fh.getServerIP() + "\">\n");
            for (FilterTreeWrapper wrapper : fh.getVsans()) {
                String vsanName = wrapper.getVsanName();
                scopeInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + vsanName + "\"  \tparent=\"" + fabricName + "\" dbId=\"" + wrapper.getVsanId() + "\" attrId=\"" + wrapper.getVid() + "\" vsanIndexSwitchWWN=\"" + wrapper.getVsanIndexSwitchWWN() + "\" group=\"Scope\" icon=\"vsanIcon\" selection=\"\t\t\t-- " + vsanName + "\"/>\n");
            }
            List<FilterTreeWrapper> groupList = fabric2GrpMap.get(fh.getId());
            if (groupList != null) {
                for (FilterTreeWrapper grpWpr : groupList) {
                    String grpName = grpWpr.getGroupName();
                    scopeInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + grpName + "\"  fdbid=\"" + fh.getId() + "\" parent=\"" + fabricName + "\" dbId=\"" + grpWpr.getGroupId() + "\" fabricId=\"" + fh.getFid() + "\" attrId=\"" + grpWpr.getGroupType() + "\"  group=\"Scope\" icon=\"groupIcon\" selection=\"\t\t\t-- " + grpName + "\" type=\"group\"/>\n");
                }
            }
            scopeInXml.append("</folder>\n");
        }
        scopeInXml.append("</folder>\n");
        scopeInXml.append("</folder>\n");
        scopeInXml.append("</folders>");
        return scopeInXml.toString();
    }

    public String getScopeInXmlSimple() {
        ArrayList<FabricHolder> scopeView = this.getFilterTree();
        StringBuffer scopeInXml = new StringBuffer();
        boolean isFederatedMode = ClusterProcessor.getInstance().getFMServers().size() > 1;
        scopeInXml.append("<folders label=\"Scope\">\n");
        for (FabricHolder fh : scopeView) {
            String fabricName = fh.getName();
            String serverIp = isFederatedMode ? this.getServerForFabric(fh.getFid()) : BLANK;
            fh.setServerIP(serverIp);
            scopeInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"" + fabricName + "\"  \tparent=\"Scope\" dbId=\"" + fh.getId() + "\" attrId=\"" + fh.getFid() + "\" group=\"Scope\" selection=\"\t\t" + fabricName + "\" serverIp=\"" + fh.getServerIP() + "\">\n");
            scopeInXml.append("</folder>\n");
        }
        scopeInXml.append("</folders>");
        return scopeInXml.toString();
    }

    public String getNavigationInXml() {
        return this.getVsanNavigationInXml(true);
    }

    public String getVsanNavigationInXml(boolean showVsans) {
        ArrayList<FabricHolder> scopeView = this.getFilterTree();
        Map<Long, List<FilterTreeWrapper>> fabric2GrpMap = this.buildGroups();
        StringBuffer scopeInXml = new StringBuffer();
        scopeInXml.append("<folders label=\"Scope\" type=\"root\">\n");
        scopeInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"Data Center\" network=\"Data Center\" parent=\"Scope\" group=\"Scope\" icon=\"baseIcon\" selection=\"Data Center\" type=\"datacenter\">\n");
        scopeInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"SAN\" \t \tnetwork=\"SAN\" parent=\"Data Center\" group=\"Scope\" icon=\"sanIcon\" selection=\"\tSAN\" type=\"san\">\n");
        boolean isFederatedMode = ClusterProcessor.getInstance().getFMServers().size() > 1;
        for (FabricHolder fh : scopeView) {
            String serverIp = isFederatedMode ? this.getServerForFabric(fh.getFid()) : BLANK;
            fh.setServerIP(serverIp);
            String fabricName = fh.getName();
            scopeInXml.append("<folder state=\"unchecked\" isBranch=\"" + (showVsans ? "true" : "false") + "\" label=\"" + fabricName + "\"  fdbid=\"" + fh.getId() + "\"\tparent=\"" + "SAN" + "\" fabricId=\"" + fh.getFid() + "\" group=\"Scope\" icon=\"fabricIcon\" selection=\"\t\t" + fabricName + "\" serverIp=\"" + fh.getServerIP() + "\" type=\"fabric\">\n");
            if (showVsans) {
                for (FilterTreeWrapper wrapper : fh.getVsans()) {
                    String vsanName = wrapper.getVsanName();
                    scopeInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + vsanName + "\"  fdbid=\"" + fh.getId() + "\" parent=\"" + fabricName + "\" vdbId=\"" + wrapper.getVsanId() + "\" fabricId=\"" + fh.getFid() + "\" vsanId=\"" + wrapper.getVid() + "\" icon=\"vsanIcon\" vsanIndexSwitchWWN=\"" + wrapper.getVsanIndexSwitchWWN() + "\" group=\"Scope\" selection=\"\t\t\t-- " + vsanName + "\" type=\"vsan\"/>\n");
                }
                List<FilterTreeWrapper> groupList = fabric2GrpMap.get(fh.getId());
                if (groupList != null) {
                    for (FilterTreeWrapper grpWpr : groupList) {
                        String grpName = grpWpr.getGroupName();
                        scopeInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + grpName + "\"  fdbid=\"" + fh.getId() + "\" parent=\"" + fabricName + "\" gdbId=\"" + grpWpr.getGroupId() + "\" fabricId=\"" + fh.getFid() + "\" grpType=\"" + grpWpr.getGroupType() + "\"  group=\"Scope\" icon=\"groupIcon\" selection=\"\t\t\t-- " + grpName + "\" type=\"group\"/>\n");
                    }
                }
            }
            scopeInXml.append("</folder>\n");
        }
        scopeInXml.append("</folder>\n");
        scopeInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"LAN\" network=\"LAN\" parent=\"Data Center\" group=\"Scope\" icon=\"sanIcon\" selection=\"\tLAN\" type=\"lan\">\n");
        scopeInXml.append("</folder>\n");
        scopeInXml.append("</folder>\n");
        scopeInXml.append("</folders>");
        return scopeInXml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, List<FilterTreeWrapper>> buildGroups() {
        PreparedStatement stmt;
        Connection con;
        HashMap<Long, List<FilterTreeWrapper>> fabric2GrpMap;
        block13: {
            fabric2GrpMap = new HashMap<Long, List<FilterTreeWrapper>>();
            con = null;
            stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                String sql = _GroupSQL;
                stmt = con.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long grpId = rs.getLong(1);
                    String grpName = rs.getString(2);
                    int grpType = rs.getInt(3);
                    long fdbId = rs.getLong(4);
                    FilterTreeWrapper wrapper = new FilterTreeWrapper();
                    wrapper.setGroupId(grpId);
                    wrapper.setGroupName(grpName);
                    wrapper.setGroupType(grpType);
                    ArrayList<FilterTreeWrapper> groupList = (ArrayList<FilterTreeWrapper>)fabric2GrpMap.get(fdbId);
                    if (groupList == null) {
                        groupList = new ArrayList<FilterTreeWrapper>();
                        fabric2GrpMap.put(fdbId, groupList);
                    }
                    groupList.add(wrapper);
                }
                if (rs == null) break block13;
            }
            catch (Exception ex) {
                block14: {
                    try {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close((Statement)stmt);
                        }
                        if (con != null) {
                            DbUtil.close((Connection)con);
                        }
                        throw throwable;
                    }
                    DbUtil.close((ResultSet)rs);
                }
                if (stmt != null) {
                    DbUtil.close((Statement)stmt);
                }
                if (con != null) {
                    DbUtil.close((Connection)con);
                }
            }
            DbUtil.close((ResultSet)rs);
        }
        if (stmt != null) {
            DbUtil.close((Statement)stmt);
        }
        if (con != null) {
            DbUtil.close((Connection)con);
        }
        return fabric2GrpMap;
    }

    public String getRptViewNavigation() {
        String internalName;
        StringBuffer rptViewNavInXml = new StringBuffer();
        rptViewNavInXml.append("<folders label=\"Reports\">\n");
        rptViewNavInXml.append("<folders state=\"unchecked\" isBranch=\"true\" label=\"By Template\" \tparent=\"Reports\" group=\"Templates\">\n");
        rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"Common\" \tparent=\"By Template\" group=\"Predefined\">\n");
        for (ReportTemplateBaseDO t : CommonReports_Array) {
            String sanName = t.description;
            String internalName2 = t.templateName;
            rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + sanName + "\" parent=\"Common\"  group=\"Predefined\" selection=\"" + internalName2 + "\"/>\n");
        }
        rptViewNavInXml.append("</folder>");
        rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"SAN Health\" \tparent=\"By Template\" group=\"Predefined\">\n");
        for (ReportTemplateBaseDO t : SanHealthReports) {
            String sanName = t.description;
            internalName = t.templateName;
            rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + sanName + "\" parent=\"SAN Health\"  group=\"Predefined\" selection=\"" + internalName + "\"/>\n");
        }
        rptViewNavInXml.append("</folder>");
        rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"Other Predefined\" \tparent=\"By Template\" group=\"Other Predefined\">\n");
        for (ReportTemplateBaseDO t : HealthAnalysisTemplates) {
            String sanName = t.description;
            internalName = t.templateName;
            rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + sanName + "\" parent=\"Other SAN Analysis\"  group=\"Other Predefined\" selection=\"" + internalName + "\"/>\n");
        }
        rptViewNavInXml.append("</folder>");
        rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"User Defined\" \tparent=\"By Template\" group=\"User Defined\">\n");
        try {
            ArrayList rstPairList = DisplayUtil.getTemplatesFromDb();
            for (NameValuePair rstPair : rstPairList) {
                String customTplName = rstPair.getDescription();
                rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + customTplName + "\" parent=\"SAN User Defined\"  group=\"User Defined\" selection=\"" + customTplName + "\"/>\n");
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        rptViewNavInXml.append("</folder>");
        rptViewNavInXml.append("</folders>");
        rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"true\" label=\"By User\" \tparent=\"Reports\" group=\"Users\">\n");
        ArrayList allUsers = DCNMUserImpl.getAllUsers();
        for (FMUserBase usrBase : allUsers) {
            rptViewNavInXml.append("<folder state=\"unchecked\" isBranch=\"false\" label=\"" + usrBase.getUsername() + "\" parent=\"By User\"  group=\"Users\" selection=\"" + usrBase.getUsername() + "\"/>\n");
        }
        rptViewNavInXml.append("</folder>");
        rptViewNavInXml.append("</folders>\n");
        return rptViewNavInXml.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<FabricHolder> getFilterTree() {
        PreparedStatement stmt;
        Connection con;
        ArrayList<FabricHolder> all;
        block15: {
            all = new ArrayList<FabricHolder>();
            con = null;
            stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                String sql = _FilterSQL;
                stmt = con.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String tooltip;
                    boolean licensed;
                    long fabricId = rs.getLong(1);
                    String fabricName = rs.getString(2);
                    long vsanId = rs.getLong(3);
                    String vsanName = rs.getString(4);
                    boolean isDisjoint = rs.getBoolean(5);
                    boolean isUp = rs.getBoolean(6);
                    String segmentedAt = rs.getString(7);
                    int id = rs.getInt(8);
                    int fid = rs.getInt(9);
                    byte[] principalSwWWN = rs.getBytes(10);
                    boolean bl = licensed = rs.getInt(11) > 1;
                    if (vsanName == null) {
                        vsanName = "VSAN" + id;
                    }
                    FilterTreeWrapper wrapper = new FilterTreeWrapper();
                    wrapper.setFabricId(fabricId);
                    wrapper.setFabricName(fabricName);
                    wrapper.setVsanId(vsanId);
                    wrapper.setFid(fid);
                    wrapper.setVsanIndexSwitchWWN(id + "-" + SnmpWWN.toHexString((byte[])principalSwWWN));
                    wrapper.setLicensed(licensed);
                    wrapper.setVid((long)id);
                    String prefix = null;
                    prefix = !vsanName.endsWith(id + BLANK) ? id + "," : BLANK;
                    String str = BLANK;
                    String string = !isUp ? (isDisjoint ? " (" + prefix + "Down,Segmented)" : " (" + prefix + "Down)") : (str = isDisjoint ? " (" + prefix + "Segmented)" : BLANK);
                    String string2 = !isUp ? (isDisjoint ? " (Down,Segmented @ " + segmentedAt + ")" : "(Down)") : (tooltip = isDisjoint ? " (Segmented @ " + segmentedAt + ")" : BLANK);
                    if (isUp && !isDisjoint && !prefix.equals(BLANK)) {
                        str = "(" + id + ")";
                    }
                    wrapper.setVsanName(vsanName + str);
                    wrapper.setTooltip(vsanName + str);
                    if (segmentedAt != null) {
                        wrapper.setTooltip(vsanName + tooltip);
                    }
                    this.getFabricHolder(wrapper, all);
                }
                if (rs == null) break block15;
            }
            catch (Exception ex) {
                block16: {
                    try {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                        if (rs == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close((Statement)stmt);
                        }
                        if (con != null) {
                            DbUtil.close((Connection)con);
                        }
                        throw throwable;
                    }
                    DbUtil.close((ResultSet)rs);
                }
                if (stmt != null) {
                    DbUtil.close((Statement)stmt);
                }
                if (con != null) {
                    DbUtil.close((Connection)con);
                }
            }
            DbUtil.close((ResultSet)rs);
        }
        if (stmt != null) {
            DbUtil.close((Statement)stmt);
        }
        if (con != null) {
            DbUtil.close((Connection)con);
        }
        return all;
    }

    private FabricHolder getFabricHolder(FilterTreeWrapper row, ArrayList<FabricHolder> all) {
        boolean newFabric = false;
        boolean newVsan = false;
        FabricHolder fholder = null;
        FilterTreeWrapper wrapper = null;
        for (int i = 0; i < all.size(); ++i) {
            FabricHolder holder = all.get(i);
            if (holder.getId() != row.getFabricId()) continue;
            fholder = holder;
            break;
        }
        if (fholder == null) {
            newFabric = true;
            fholder = new FabricHolder();
            fholder.setId(row.getFabricId());
            fholder.setName(row.getFabricName());
            fholder.setFid(row.getFid());
            fholder.setLicensed(row.isLicensed());
            fholder.setWrapper(row);
        }
        ArrayList v = fholder.getVsans();
        for (int i = 0; i < v.size(); ++i) {
            FilterTreeWrapper holder = (FilterTreeWrapper)v.get(i);
            if (holder.getVsanId() != row.getVsanId()) continue;
            wrapper = holder;
            break;
        }
        if (wrapper == null) {
            newVsan = true;
            wrapper = new FilterTreeWrapper();
            wrapper.setVsanId(row.getVsanId());
            wrapper.setVsanName(row.getVsanName());
            wrapper.setTooltip(row.getTooltip());
            wrapper.setFabricName(row.getFabricName());
            wrapper.setVsanIndexSwitchWWN(row.getVsanIndexSwitchWWN());
            wrapper.setFid(row.getFid());
            wrapper.setVid(row.getVid());
            wrapper.setNavGroupId(row.getNavGroupId());
            wrapper.setNavGroupType(row.getNavGroupType());
            wrapper.setNavGroupName(row.getNavGroupName());
        }
        if (newFabric) {
            all.add(fholder);
        }
        if (newVsan) {
            fholder.getVsans().add(wrapper);
        }
        return fholder;
    }

    public static void main(String[] args) {
        new ReportUtil();
        ReportUtil.getInstance().getScopeInXml();
    }

    public int saveReportTemplate(String reportTemplateName, String userName, ReportAttribute[] updatedAttrs, String pmInterval) {
        File templateDir = new File(_FullReportDir + File.separator + userName + File.separator + "custom");
        if (!templateDir.exists() || !templateDir.isDirectory()) {
            templateDir.mkdir();
        }
        File f = new File(templateDir + File.separator + reportTemplateName + ".xml");
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element template = doc.createElement("template");
            template.setAttribute("name", reportTemplateName);
            template.setAttribute("interval", pmInterval);
            template.setAttribute("author", userName);
            template.setAttribute("creation-time", String.valueOf(new Date().getTime()));
            template.setAttribute("personal", "true");
            doc.appendChild(template);
            ReportAttribute rptAttr = null;
            Object groupName = null;
            Element group = null;
            Element report = null;
            Element filter = null;
            Element root = null;
            Element network = null;
            Element fabric = null;
            Element vsan = null;
            for (int idx = 0; idx < updatedAttrs.length; ++idx) {
                rptAttr = updatedAttrs[idx];
                while (rptAttr.getGroupName().equals("Scope")) {
                    if (rptAttr.getGroupName().equals(rptAttr.getAttriName()) || group == null) {
                        group = doc.createElement("group");
                        group.setAttribute("name", "Scope");
                        template.appendChild(group);
                    }
                    if (rptAttr.getGroupName().equals(rptAttr.getParent())) {
                        root = doc.createElement("root");
                        root.setAttribute("name", rptAttr.getAttriName());
                        group.appendChild(root);
                    } else if (rptAttr.getParent().equals("Data Center")) {
                        network = doc.createElement("network");
                        network.setAttribute("name", rptAttr.getAttriName());
                        network.setAttribute("state", rptAttr.getState());
                        if (root != null) {
                            root.appendChild(network);
                        }
                    } else if (rptAttr.getParent().equals("SAN")) {
                        if (network != null) {
                            fabric = doc.createElement("fabric");
                            fabric.setAttribute("name", rptAttr.getAttriName());
                            fabric.setAttribute("dbId", rptAttr.getAttrDbId());
                            fabric.setAttribute("id", rptAttr.getAttrId());
                            fabric.setAttribute("vsanIndexSwitchWWN", rptAttr.getVsanIndexSwitchWWN());
                            fabric.setAttribute("state", rptAttr.getState());
                            network.appendChild(fabric);
                        }
                    } else if (fabric != null) {
                        vsan = doc.createElement("vsan");
                        if (rptAttr.getType().equalsIgnoreCase("group")) {
                            vsan.setAttribute("gdbId", rptAttr.getAttrDbId());
                            vsan.setAttribute("gtype", rptAttr.getAttrId());
                            vsan.setAttribute("type", rptAttr.getType());
                        } else {
                            vsan.setAttribute("dbId", rptAttr.getAttrDbId());
                            vsan.setAttribute("id", rptAttr.getAttrId());
                        }
                        vsan.setAttribute("name", rptAttr.getAttriName());
                        vsan.setAttribute("vsanIndexSwitchWWN", rptAttr.getVsanIndexSwitchWWN());
                        vsan.setAttribute("state", rptAttr.getState());
                        fabric.appendChild(vsan);
                    }
                    rptAttr = updatedAttrs[++idx];
                }
                if (rptAttr.getAttriName().equals(rptAttr.getGroupName())) {
                    group = doc.createElement("group");
                    group.setAttribute("name", rptAttr.getAttriName());
                    group.setAttribute("state", rptAttr.getState());
                    template.appendChild(group);
                    continue;
                }
                if (rptAttr.getGroupName().equals(rptAttr.getParent()) || rptAttr.getParent().equals("Analysis")) {
                    String[] options;
                    report = doc.createElement("report");
                    report.setAttribute("name", rptAttr.getAttriName());
                    report.setAttribute("state", rptAttr.getState());
                    if (group != null) {
                        group.appendChild(report);
                    }
                    if ((options = rptAttr.getOptionDataArray()) == null) continue;
                    for (String option : options) {
                        if (option == null) continue;
                        String[] opSet = option.split(":");
                        filter = doc.createElement("filter");
                        filter.setAttribute("name", opSet[0]);
                        filter.setAttribute("value", opSet[1]);
                        report.appendChild(filter);
                    }
                    this.preV5Handler(report, group, doc, options);
                    continue;
                }
                filter = doc.createElement("filter");
                filter.setAttribute("name", rptAttr.getAttriName());
                filter.setAttribute("state", rptAttr.getState());
                if (report == null) continue;
                report.appendChild(filter);
            }
            this.writeToFile(f, doc);
            if (!reportTemplateName.startsWith("SAN_Health")) {
                DbUtil.deleteFileFromDb((String)f.getName(), (String)userName);
                PersistentHelper.getHelper().storeFile(f, userName);
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            return -1;
        }
        return 1;
    }

    private void preV5Handler(Element report, Element group, Document doc, String[] options) {
        block6: {
            String name;
            block5: {
                name = report.getAttribute("name");
                if (!name.equals("Summary")) break block5;
                NodeList filters = report.getElementsByTagName("filter");
                if (filters.getLength() == 0) {
                    return;
                }
                for (int i = 0; i < filters.getLength(); ++i) {
                    Element e = (Element)filters.item(i);
                    String n = e.getAttribute("name");
                    if (!n.trim().equals("Include Summary Details")) continue;
                    for (String detailName : SummaryDetailList) {
                        report = doc.createElement("report");
                        report.setAttribute("name", detailName);
                        group.appendChild(report);
                    }
                }
                break block6;
            }
            if (!name.equals("Utilization Summary")) break block6;
            for (String detailName : PerfUtilList) {
                report = doc.createElement("report");
                report.setAttribute("name", detailName);
                Element filter = null;
                for (String option : options) {
                    if (option == null) continue;
                    String[] opSet = option.split(":");
                    filter = doc.createElement("filter");
                    filter.setAttribute("name", opSet[0]);
                    filter.setAttribute("value", opSet[1]);
                    report.appendChild(filter);
                }
                group.appendChild(report);
            }
        }
    }

    public CallResultDO runScheduledReport(ReportFilterDO rptFilter) {
        CallResultDO rstDo = new CallResultDO();
        try {
            int scheduleResultCode;
            String auth_mode;
            if (rptFilter.isEmailRpt()) {
                SchedulerManagerImpl.validateEmailSettings();
            }
            JobDataMap jobStatesMap = new JobDataMap();
            jobStatesMap.put("ReportUrl", rptFilter.getRptUrl());
            jobStatesMap.put("UserName", rptFilter.getUserName());
            jobStatesMap.put((Object)"GenerationTime", (Object)new Date());
            jobStatesMap.put("Template", rptFilter.getTplName());
            String fullAddr = rptFilter.getFullAddr();
            String[] addrArr = fullAddr.split(":");
            jobStatesMap.put("ServerScheme", addrArr[0]);
            jobStatesMap.put((Object)"ServerPort", addrArr.length < 3 ? Integer.valueOf(80) : addrArr[2]);
            jobStatesMap.put("ServerAddr", addrArr[1].substring(2));
            jobStatesMap.put("Interval", rptFilter.getInterval());
            jobStatesMap.put("IntervalText", rptFilter.getIntervalText());
            jobStatesMap.put("JobType", WebConst.JOB_TYPES[rptFilter.getJobType()]);
            jobStatesMap.put("exp2Csv", rptFilter.getExp2Csv());
            jobStatesMap.put("fileName", rptFilter.getRptName());
            jobStatesMap.put("startTimeInMillSec", rptFilter.getStartTime());
            jobStatesMap.put("endTimeInMillSec", rptFilter.getEndTime());
            jobStatesMap.put("isLan", rptFilter.isLan());
            jobStatesMap.put("Lan_Group_Id", rptFilter.getSelectedLanGroupId());
            jobStatesMap.put("Lan_Group_Name", rptFilter.getSelectedLanGroupName());
            jobStatesMap.put("Scope_XML", rptFilter.getSelectedScopeXML());
            jobStatesMap.put("FabricPK", rptFilter.getSelectedFabric());
            jobStatesMap.put("selectedFabricDBID", rptFilter.getSelectedFabricDBID());
            jobStatesMap.put("UserComment", rptFilter.getUserComment());
            jobStatesMap.put("Group_Id", rptFilter.getSelectedGroupId());
            jobStatesMap.put("Group_Name", rptFilter.getSelectedGroupName());
            String fName = null;
            try {
                fName = rptFilter.isLan() ? NavigationUtil.getInstance().getGroupName(rptFilter.getSelectedLanGroupId()) : GlobalFabricManager.getInstance().getFabricNameFromDBID(rptFilter.getSelectedFabricDBID());
            }
            catch (SQLException sqex) {
                this._Log.error((Object)("Could not find Fabric for FabricID:" + rptFilter.getSelectedFabric()));
            }
            GregorianCalendar strtDate = new GregorianCalendar();
            Date startDate = new Date(rptFilter.getStartTime());
            strtDate.setTime(startDate);
            GregorianCalendar endDate = new GregorianCalendar();
            Date finishDate = new Date(rptFilter.getEndTime());
            endDate.setTime(finishDate);
            int serverType = BackUpConfiguration.getServerTypeVal();
            if (rptFilter.getJobType() == 7) {
                if (serverType == 3 && !BackUpConfiguration.isBackUpServerConfigured()) {
                    throw new RemoteException("Please configure Backup Server from Admin/SFTP Credentials");
                }
                if (rptFilter.isLan() && NavigationUtil.getInstance().isEmptyLanGroup(rptFilter.getSelectedLanGroupId())) {
                    throw new RemoteException("The selected LAN group is empty.\nPlease add switches to selected group and create backup job.");
                }
                jobStatesMap.put("ServerType", serverType);
                jobStatesMap.put("ConfigType", rptFilter.getConfigType());
            }
            jobStatesMap.put("IsLan", rptFilter.isLan());
            jobStatesMap.put("Group", fName != null ? fName : (!rptFilter.isLan() ? "FABRIC ID:" + rptFilter.getSelectedFabric() : "LAN ID:" + rptFilter.getSelectedLanGroupId()));
            String details = rptFilter.getIntervalText() + " at " + String.format("%1$tH:%1$tM", strtDate) + (rptFilter.getInterval() > 1 ? "  from:" : " ") + String.format("%1$ta %1$tm/%1$td/%1$tY", strtDate) + (rptFilter.getInterval() > 1 ? "   to:" + String.format("%1$ta %1$tm/%1$td/%1$tY", endDate) : BLANK) + (rptFilter.getServertype() == 3 ? " (via SFTP)" : " (via TFTP)");
            jobStatesMap.put("moreInfo", details);
            boolean emailReport = rptFilter.isEmailRpt();
            if (emailReport) {
                IscImpl.getInstance().validateEmailSettings();
                jobStatesMap.put("Email", "on");
                jobStatesMap.put("Recipient", rptFilter.getEmailTo());
                jobStatesMap.put("Subject", rptFilter.getEmailSub());
                jobStatesMap.put("DisplayLink", rptFilter.isEmailLink() ? "on" : null);
            }
            if ((auth_mode = System.getProperty("authentication.mode")) != null && !auth_mode.equalsIgnoreCase("local")) {
                this.persistRemoteUser(rptFilter.getUserName() + "@" + auth_mode);
            }
            if ((scheduleResultCode = SchedulerManagerImpl.getInstance().scheduleJob(rptFilter.getInterval(), rptFilter.getJobType(), rptFilter.getJobName(), jobStatesMap, startDate, finishDate, true)) == -1) {
                rstDo.setResultMessage(DUPLICATE_NAME_ERROR);
                rstDo.setResultStatus(scheduleResultCode);
            }
        }
        catch (Exception ex) {
            rstDo.setResultMessage(ex.getMessage());
            rstDo.setResultStatus(-1);
        }
        return rstDo;
    }

    private void persistRemoteUser(String userName) throws Exception {
        try {
            UserManager umgr = UserManager.getInstance();
            FMUser fmUser = umgr.findUser(userName);
            if (fmUser == null) {
                if (UserManager.findUserFromDB((String)userName) != null) {
                    return;
                }
                throw new Exception("Can not find user:" + userName + " from the server");
            }
            if (UserManager.findUserFromDB((String)userName) != null) {
                umgr.updateUser(userName, fmUser.getHashedPwd());
                UserManager.updateRoleForUser((String)fmUser.getRoleName(), (String)userName);
            } else {
                UserManager.createUserInDB((String)userName, (String)fmUser.getHashedPwd(), (String)fmUser.getRoleName());
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    private void writeToFile(File f, Document doc) throws Exception {
        String XALAN_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty(XALAN_INDENT_AMOUNT, "3");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        String xmlString = sw.toString();
        try (BufferedWriter bw = null;){
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
            bw.write(xmlString);
            bw.flush();
            bw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileCheckSum(File file, char ignoreLineChar) throws IOException {
        long checksum = 0L;
        FileInputStream fis = null;
        FilterInputStream cis = null;
        InputStreamReader rd = null;
        BufferedReader brd = null;
        ByteArrayInputStream bStr = null;
        try {
            Adler32 crc = null;
            long sizeOfFile = 0L;
            fis = new FileInputStream(file);
            rd = new InputStreamReader(fis);
            brd = new BufferedReader(rd);
            String line = null;
            StringBuffer buf = new StringBuffer();
            while ((line = brd.readLine()) != null) {
                String prepend = BLANK;
                boolean p = false;
                if (ignoreLineChar != '0' && line.trim().indexOf(ignoreLineChar) != -1) continue;
                buf.append(line.trim());
            }
            bStr = new ByteArrayInputStream(buf.toString().getBytes());
            crc = new Adler32();
            cis = new CheckedInputStream(bStr, crc);
            byte[] buffer = new byte[100];
            while (cis.read(buffer) >= 0) {
            }
            checksum = ((CheckedInputStream)cis).getChecksum().getValue();
        }
        catch (IOException e) {
            System.out.println("the exception has been thrown" + e);
            System.exit(1);
        }
        finally {
            if (cis != null) {
                cis.close();
            }
            if (bStr != null) {
                bStr.close();
            }
            if (brd != null) {
                brd.close();
            }
            if (rd != null) {
                rd.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGroupName(long groupId) {
        String groupName;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block4: {
            con = null;
            stmt = null;
            String sql = null;
            rs = null;
            groupName = BLANK;
            try {
                con = ConnectionManager.getConnection();
                sql = "SELECT NAME FROM GROUPS WHERE (ID=?)";
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, groupId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                groupName = rs.getString(1);
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close((Connection)con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close((Statement)stmt);
                DbUtil.close((Connection)con);
            }
        }
        DbUtil.close((ResultSet)rs);
        DbUtil.close((Statement)stmt);
        DbUtil.close((Connection)con);
        return groupName;
    }

    static {
        int i;
        REPORT_EXT = ".html";
        CSV_EXT = ".csv";
        XLS_EXT = ".xls";
        _FullReportDir = ClientCache.getDcmDir() + File.separator + "fm" + File.separator + REPORT_DIR;
        _ReportUtil = null;
        INTERVAL_OPTIONS = new String[]{"never", "Once", "Daily", "Weekly", "5 MINUTE", "Monthly"};
        SummaryDetailList = new String[]{"SummaryDetail -- Permament License Summary Details", "SummaryDetail -- Trial License Summary Details", "SummaryDetail -- Device Count", "SummaryDetail -- Port Usage", "SummaryDetail -- Health Status and Monitoring"};
        PerfUtilList = new String[]{"Device Utilization Summary", "ISL Utilization Summary"};
        REPORT_NAME = new String[]{ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[13][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[5][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[6][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[7][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[8][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[9][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[10][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[11][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[12][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[14][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[4][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[16][1], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[18][1]};
        REPORT_TEMPLATE_NAME = new String[]{ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[13][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[5][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[6][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[7][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[8][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[9][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[10][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[11][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[12][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[14][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[4][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[16][0], ReportConstants.SAN_HEALTH_REPORTS_USER_NAME[18][0]};
        SanHealthReports_Array = new ReportTemplateBaseDO[]{new ReportTemplateBaseDO("SAN_Health_Summary", "Summary", ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_SAN_HEALTH), new ReportTemplateBaseDO("SAN_Health_Fabric", "Fabric", ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_SAN_HEALTH)};
        CommonReports_Array = new ReportTemplateBaseDO[]{new ReportTemplateBaseDO("Common_Switch", "Switch", ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_COMMON), new ReportTemplateBaseDO("Common_Performance", "Performance", ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_COMMON), new ReportTemplateBaseDO("Common_Diagnostic", "Diagnostic", ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_COMMON)};
        SanHealthReports = Collections.unmodifiableList(Arrays.asList(SanHealthReports_Array));
        HealthAnalysisTemplates_Array = new ReportTemplateBaseDO[]{new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[0], REPORT_NAME[0], ReportTemplateBaseDO.SCOPE_LIMIT_FABRIC, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[1], REPORT_NAME[1], ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[2], REPORT_NAME[2], ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[3], REPORT_NAME[3], ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[5], REPORT_NAME[5], ReportTemplateBaseDO.SCOPE_LIMIT_FABRIC, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[7], REPORT_NAME[7], ReportTemplateBaseDO.SCOPE_LIMIT_FABRIC, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[8], REPORT_NAME[8], ReportTemplateBaseDO.SCOPE_LIMIT_NONE, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[11], REPORT_NAME[11], ReportTemplateBaseDO.SCOPE_LIMIT_LAN, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED), new ReportTemplateBaseDO(REPORT_TEMPLATE_NAME[12], REPORT_NAME[12], ReportTemplateBaseDO.SCOPE_LIMIT_FABRIC, ReportTemplateBaseDO.CATEGORY_SAN_OTHER_PREDEFINED)};
        HealthAnalysisTemplates = Collections.unmodifiableList(Arrays.asList(HealthAnalysisTemplates_Array));
        String[] arr = new String[SanHealthReports_Array.length];
        for (i = 0; i < SanHealthReports_Array.length; ++i) {
            arr[i] = ReportUtil.SanHealthReports_Array[i].templateName;
        }
        SanHealthReports_TemplateNames = Arrays.asList(arr);
        arr = new String[CommonReports_Array.length];
        for (i = 0; i < CommonReports_Array.length; ++i) {
            arr[i] = ReportUtil.CommonReports_Array[i].templateName;
        }
        CommonReports_TemplateNames = Arrays.asList(arr);
        arr = new String[HealthAnalysisTemplates_Array.length];
        for (i = 0; i < HealthAnalysisTemplates_Array.length; ++i) {
            arr[i] = ReportUtil.HealthAnalysisTemplates_Array[i].templateName;
        }
        HealthAnalysis_TemplateNames = Arrays.asList(arr);
    }

    static class MyFileFilter
    implements FileFilter {
        private String _pattern;

        MyFileFilter(String pattern) {
            this._pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            if (this._pattern == null) {
                return true;
            }
            if (file == null || !file.exists()) {
                return false;
            }
            return file.getAbsolutePath().indexOf(this._pattern) >= 0;
        }
    }
}

