/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.TFTPEventListenerIf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class TFTP {
    public static final int DEFAULT_TFTP_PORT = 69;
    public static final int DEFAULT_MAX_CONNS = 10;
    public static final int DEFAULT_MAX_TIMEOUTS = 20;
    public static final int DEFAULT_TIMEOUT = 500;
    static final int START_PORT = 29000;
    static final int END_PORT = 65000;
    static final int HEADER_SIZE = 4;
    static final int BLOCK_SIZE = 512;
    static final int PKT_SIZE = 516;
    public static final byte RRQ_OPCODE = 1;
    public static final byte WRQ_OPCODE = 2;
    public static final byte DATA_OPCODE = 3;
    public static final byte ACK_OPCODE = 4;
    public static final byte ERROR_OPCODE = 5;
    static final byte NOTDEF_ERR = 0;
    static final byte FILE_NOT_FOUND_ERR = 1;
    static final byte ACCESS_VIOLATION_ERR = 2;
    static final byte DISK_FULL_ERR = 3;
    static final byte ILLEGAL_OP_ERR = 4;
    static final byte UNKNOWN_TRANS_ID_ERR = 5;
    static final byte FILE_EXISTS_ERR = 6;
    static final byte ACCESSVIOLATION_ERR = 7;
    static final String _READ = ".read";
    static final String _WRITE = ".write";
    static final String _OWRITE = ".owrite";
    InetAddress _lAddr;
    int _lPort;
    int _maxTimeouts = 20;
    int _maxConns = 10;
    int _conns = 0;
    String _root = ClientCache.getLocation() + "tftp";
    static TFTP _tftp;
    Listener _listener;
    HashSet _workers = new HashSet();
    int _tid = 29000;
    int _servers;
    HashMap _acl = new HashMap();
    HashMap _fileMap = new HashMap();
    static TFTPEventListenerIf _Trace;
    static boolean _Tracing;
    static Array _listeners;

    private TFTP() throws IOException {
        DatagramSocket sock = new DatagramSocket(69);
        sock.close();
        this._lPort = 69;
        this._lAddr = TFTP.getLocalAddress();
    }

    public static TFTP getInstance() throws IOException {
        if (_tftp == null) {
            _tftp = new TFTP();
        }
        return _tftp;
    }

    public static void addListener(TFTPEventListenerIf l) {
        _listeners.addElement((Object)l);
    }

    public static void removeListener(TFTPEventListenerIf l) {
        _listeners.removeElement((Object)l);
    }

    static void notifyEventIn(byte type, InetAddress addr, int port, String msg) {
        for (int i = 0; i < _listeners.size(); ++i) {
            ((TFTPEventListenerIf)_listeners.elementAt(i)).tftpEvent(true, type, addr, port, msg);
        }
    }

    static void notifyEventOut(byte type, InetAddress addr, int port, String msg) {
        for (int i = 0; i < _listeners.size(); ++i) {
            ((TFTPEventListenerIf)_listeners.elementAt(i)).tftpEvent(false, type, addr, port, msg);
        }
    }

    public InetAddress getServerAddress() {
        return this._lAddr;
    }

    public int getServerPort() {
        return this._lPort;
    }

    public int getMaxTimeouts() {
        return this._maxTimeouts;
    }

    public void setMaxTimeouts(int maxTimeouts) {
        this._maxTimeouts = maxTimeouts;
    }

    public int getMaxConns() {
        return this._maxConns;
    }

    public void setMaxConns(int maxConns) {
        this._maxConns = maxConns;
    }

    public int getConns() {
        return this._conns;
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String root) {
        this._root = root;
    }

    final synchronized int getTid() {
        this._tid = this._tid == 65000 ? 29000 : ++this._tid;
        return this._tid;
    }

    public static boolean canStartServer() {
        if (_tftp != null) {
            return true;
        }
        try {
            DatagramSocket sock = new DatagramSocket(69);
            sock.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean canStartServerOnAllNics() throws IOException {
        TFTP tftpSr = TFTP.getInstance();
        if (tftpSr._servers > 0) {
            return true;
        }
        InetAddress[] iAdd = NetUtil.getLocalAddresses();
        if (iAdd != null) {
            for (int a = 0; a < iAdd.length; ++a) {
                if (TFTP.isAddressAvailable(iAdd[a])) continue;
                return false;
            }
        }
        try {
            if (!TFTP.isAddressAvailable(InetAddress.getByName("0.0.0.0"))) {
                return false;
            }
        }
        catch (UnknownHostException ex) {
            return false;
        }
        return true;
    }

    private static boolean isAddressAvailable(InetAddress iAdd) {
        try {
            DatagramSocket sock = new DatagramSocket(69, iAdd);
            sock.close();
        }
        catch (Exception exx) {
            DefaultLogger._LibLogger.info((Object)("Failed to Bind to address:" + iAdd));
            return false;
        }
        return true;
    }

    public static String canStartServerAsString() {
        if (_tftp != null) {
            return null;
        }
        try {
            DatagramSocket sock = new DatagramSocket(69);
            sock.close();
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
        return null;
    }

    public synchronized void startServer() throws SocketException {
        if (this._listener == null) {
            this._conns = 0;
            File dir = new File(this._root);
            if (!dir.exists()) {
                dir.mkdir();
            }
            this._listener = new Listener(null, this._lPort);
            this._listener.start();
        }
        ++this._servers;
    }

    public synchronized void startServer(boolean trace) throws SocketException {
        if (trace && !_Tracing) {
            TFTP.addListener(_Trace);
            _Tracing = true;
        } else {
            TFTP.removeListener(_Trace);
            _Tracing = false;
        }
        this.startServer();
    }

    public synchronized void stopServer() {
        if (this._servers > 0) {
            --this._servers;
        }
        if (this._listener != null && this._servers == 0) {
            this._listener._keepAlive = false;
            for (Worker worker : this._workers) {
                worker._keepAlive = false;
            }
            this._workers.clear();
            this._listener = null;
        }
    }

    public void get(String src, String dest, InetAddress host, int port) throws IOException {
        byte[] ib = new byte[516];
        byte[] ob = new byte[516];
        DatagramPacket ip = new DatagramPacket(ib, ib.length);
        DatagramPacket op = new DatagramPacket(ob, ob.length);
        DatagramSocket sock = new DatagramSocket(this.getTid());
        sock.setSoTimeout(500);
        Thunk t = new Thunk(){

            @Override
            public boolean ok() {
                return true;
            }
        };
        File f = new File(dest);
        try {
            this.receiveFile(host, port, f, src, sock, ip, op, ib, ob, true, t);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            sock.close();
        }
    }

    public void put(String src, InetAddress host, int port) throws IOException {
        byte[] ib = new byte[516];
        byte[] ob = new byte[516];
        DatagramPacket ip = new DatagramPacket(ib, ib.length);
        DatagramPacket op = new DatagramPacket(ob, ob.length);
        DatagramSocket sock = new DatagramSocket(this.getTid());
        sock.setSoTimeout(500);
        Thunk t = new Thunk(){

            @Override
            public boolean ok() {
                return true;
            }
        };
        File f = new File(src);
        try {
            this.sendFile(host, port, f, src, sock, ip, op, ib, ob, true, t);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            sock.close();
        }
    }

    final void receiveFile(InetAddress host, int port, File file, String name, DatagramSocket sock, DatagramPacket ip, DatagramPacket op, byte[] ib, byte[] ob, boolean isClient, Thunk thunk) throws IOException {
        int dataLength = 512;
        InetAddress rAddr = host;
        int rPort = port;
        FilterOutputStream out = null;
        FileOutputStream fout = null;
        try {
            if (isClient) {
                TFTP.sendReq((byte)1, sock, rAddr, rPort, name, op, ob);
            } else {
                TFTP.sendAck(sock, rAddr, rPort, 0, op, ob);
            }
            int block = 1;
            int timeouts = 0;
            block13: while (dataLength > 0 && dataLength <= 512 && thunk.ok()) {
                try {
                    sock.receive(ip);
                }
                catch (SocketTimeoutException ex) {
                    if (timeouts >= this._maxTimeouts) {
                        throw new IOException("Connection timed out");
                    }
                    ++timeouts;
                    continue;
                }
                timeouts = 0;
                if (isClient && block == 1) {
                    rPort = ip.getPort();
                }
                if (rAddr.equals(ip.getAddress()) && rPort == ip.getPort()) {
                    switch (TFTP.getOpcode(ip)) {
                        case 5: {
                            TFTP.notifyEventIn((byte)5, rAddr, rPort, TFTP.getError(ip));
                            throw new IOException(TFTP.getError(ip));
                        }
                        case 3: {
                            if (out == null) {
                                fout = new FileOutputStream(file);
                                out = new BufferedOutputStream(fout);
                            }
                            TFTP.notifyEventIn((byte)3, rAddr, rPort, TFTP.getBlock(ip) + "/" + TFTP.getDataLength(ip));
                            if (block == TFTP.getBlock(ip)) {
                                dataLength = TFTP.getDataLength(ip);
                                try {
                                    ((BufferedOutputStream)out).write(ip.getData(), 4, dataLength);
                                    ((BufferedOutputStream)out).flush();
                                }
                                catch (IOException ex) {
                                    TFTP.sendErr(sock, rAddr, rPort, (byte)3, op, ob);
                                    throw ex;
                                }
                                TFTP.sendAck(sock, rAddr, rPort, block, op, ob);
                                ++block;
                                continue block13;
                            }
                            if (TFTP.getBlock(ip) != block - 1) continue block13;
                            sock.send(op);
                            TFTP.notifyEventOut((byte)3, rAddr, rPort, Integer.toString(block));
                            continue block13;
                        }
                    }
                    throw new IOException("Received bad packet.");
                }
                TFTP.sendErr(sock, ip.getAddress(), ip.getPort(), (byte)5, op, ob);
            }
        }
        catch (IOException ex) {
            DefaultLogger._LibLogger.debug((Object)("TFTP IO warning" + ex.getMessage()));
            throw ex;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    final void sendFile(InetAddress host, int port, File file, String name, DatagramSocket sock, DatagramPacket ip, DatagramPacket op, byte[] ib, byte[] ob, boolean isClient, Thunk thunk) throws IOException {
        InetAddress rAddr = host;
        int rPort = port;
        int dataLength = 512;
        int block = 1;
        BufferedInputStream in = null;
        try {
            if (isClient) {
                TFTP.sendReq((byte)2, sock, rAddr, rPort, name, op, ob);
                block = 0;
            }
            while (dataLength == 512 && thunk.ok()) {
                if (!isClient || block != 0) {
                    try {
                        if (in == null) {
                            FileInputStream fin = new FileInputStream(file);
                            in = new BufferedInputStream(fin);
                        }
                        if ((dataLength = in.read(ob, 4, 512)) <= 0) {
                            dataLength = 0;
                        }
                        TFTP.sendData(sock, rAddr, rPort, block, dataLength, op, ob);
                    }
                    catch (IOException ex) {
                        DefaultLogger._ExLogger.debug((Object)ex.getMessage(), (Throwable)ex);
                        TFTP.sendErr(sock, rAddr, rPort, (byte)0, op, ob);
                        throw ex;
                    }
                }
                int timeouts = 0;
                boolean gotack = false;
                block11: while (!gotack && thunk.ok()) {
                    try {
                        sock.receive(ip);
                    }
                    catch (SocketTimeoutException ex) {
                        if (timeouts >= this._maxTimeouts) {
                            throw new IOException("Connection timed out");
                        }
                        ++timeouts;
                        continue;
                    }
                    if (isClient && block == 0) {
                        rPort = ip.getPort();
                    }
                    if (rAddr.equals(ip.getAddress()) && rPort == ip.getPort()) {
                        switch (TFTP.getOpcode(ip)) {
                            case 5: {
                                TFTP.notifyEventIn((byte)5, rAddr, rPort, TFTP.getError(ip));
                                throw new IOException(TFTP.getError(ip));
                            }
                            case 4: {
                                int inBlock = TFTP.getBlock(ip);
                                TFTP.notifyEventIn((byte)4, rAddr, rPort, Integer.toString(inBlock));
                                if (block == inBlock) {
                                    gotack = true;
                                    if (++block != 65536) continue block11;
                                    block = 0;
                                    continue block11;
                                }
                                if (inBlock != block - 1) continue block11;
                                sock.send(op);
                                continue block11;
                            }
                        }
                        throw new IOException("Received bad packet");
                    }
                    TFTP.sendErr(sock, ip.getAddress(), ip.getPort(), (byte)5, op, ob);
                }
            }
        }
        catch (IOException ex) {
            if (in != null) {
                in.close();
            }
            throw ex;
        }
    }

    public static final byte getOpcode(DatagramPacket pkt) {
        byte[] data = pkt.getData();
        return data[1];
    }

    public static final String getFilename(DatagramPacket pkt) {
        byte[] data = pkt.getData();
        String name = "";
        if (data.length >= 10) {
            for (int i = 2; i < data.length; ++i) {
                if (data[i] != 0) continue;
                name = new String(data, 2, i - 2);
                break;
            }
        }
        return name;
    }

    public static final String getError(DatagramPacket pkt) {
        byte[] data = pkt.getData();
        return data[3] + ":" + new String(data, 4, pkt.getLength() - 5);
    }

    public static final int getBlock(DatagramPacket pkt) {
        byte[] data = pkt.getData();
        return (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }

    public static final int getDataLength(DatagramPacket pkt) {
        return pkt.getLength() - 4;
    }

    public static final String getOpcodeName(DatagramPacket pkt) {
        return TFTP.getOpcodeName(TFTP.getOpcode(pkt));
    }

    public static final String getOpcodeName(byte opcode) {
        switch (opcode) {
            case 1: {
                return "RRQ";
            }
            case 2: {
                return "WRQ";
            }
            case 4: {
                return "ACK";
            }
            case 3: {
                return "DATA";
            }
            case 5: {
                return "ERR";
            }
        }
        return "UNKNOWN";
    }

    static final void sendReq(byte opcode, DatagramSocket sock, InetAddress addr, int port, String name, DatagramPacket pkt, byte[] buff) throws IOException {
        byte[] bmode = new byte[]{111, 99, 116, 101, 116};
        buff[0] = 0;
        buff[1] = opcode;
        System.arraycopy(name.getBytes(), 0, buff, 2, name.length());
        buff[name.length() + 2] = 0;
        System.arraycopy(bmode, 0, buff, name.length() + 3, bmode.length);
        buff[name.length() + bmode.length + 3] = 0;
        pkt.setData(buff);
        pkt.setLength(name.length() + bmode.length + 4);
        pkt.setAddress(addr);
        pkt.setPort(port);
        sock.send(pkt);
        TFTP.notifyEventOut(opcode, addr, port, name);
    }

    static final void sendAck(DatagramSocket sock, InetAddress addr, int port, int block, DatagramPacket pkt, byte[] buff) throws IOException {
        buff[0] = 0;
        buff[1] = 4;
        buff[2] = (byte)((block & 0xFFFF) >> 8);
        buff[3] = (byte)(block & 0xFF);
        pkt.setData(buff);
        pkt.setLength(4);
        pkt.setAddress(addr);
        pkt.setPort(port);
        sock.send(pkt);
        TFTP.notifyEventOut((byte)4, addr, port, Integer.toString(block));
    }

    static final void sendErr(DatagramSocket sock, InetAddress addr, int port, byte err, DatagramPacket pkt, byte[] buff) throws IOException {
        buff[0] = 0;
        buff[1] = 5;
        buff[2] = 0;
        buff[3] = err;
        buff[4] = 0;
        pkt.setData(buff);
        pkt.setLength(4);
        pkt.setAddress(addr);
        pkt.setPort(port);
        sock.send(pkt);
        TFTP.notifyEventOut((byte)5, addr, port, Integer.toString(err));
    }

    static final void sendData(DatagramSocket sock, InetAddress addr, int port, int block, int length, DatagramPacket pkt, byte[] buff) throws IOException {
        buff[0] = 0;
        buff[1] = 3;
        buff[2] = (byte)((block & 0xFFFF) >> 8);
        buff[3] = (byte)(block & 0xFF);
        pkt.setData(buff);
        pkt.setLength(4 + length);
        pkt.setAddress(addr);
        pkt.setPort(port);
        sock.send(pkt);
        TFTP.notifyEventOut((byte)3, addr, port, block + "/" + length);
    }

    public void addIpAccess(String addr, String rd, String wr, String owr) {
        this._acl.put(addr + _READ, rd);
        this._acl.put(addr + _WRITE, wr);
        this._acl.put(addr + _OWRITE, owr);
    }

    public void delIpAccess(String addr) {
        this._acl.remove(addr + _READ);
        this._acl.remove(addr + _WRITE);
        this._acl.remove(addr + _OWRITE);
    }

    public void addFileMapping(String inFile, String outFile) {
        this._fileMap.put(inFile, outFile);
    }

    public void delFileMapping(String inFile, String outFile) {
        this._fileMap.remove(inFile);
    }

    public final boolean canRead(InetAddress addr) {
        boolean val = false;
        if (this._acl.containsKey(addr.getHostAddress() + _READ)) {
            String rd = (String)this._acl.get(addr.getHostAddress() + _READ);
            val = rd.equalsIgnoreCase("true");
        }
        return val;
    }

    public final boolean canWrite(InetAddress addr) {
        boolean val = false;
        if (this._acl.containsKey(addr.getHostAddress() + _WRITE)) {
            String wr = (String)this._acl.get(addr.getHostAddress() + _WRITE);
            val = wr.equalsIgnoreCase("true");
        }
        return val;
    }

    public final boolean canOverWrite(InetAddress addr) {
        boolean val = false;
        if (this._acl.containsKey(addr.getHostAddress() + _OWRITE)) {
            String owr = (String)this._acl.get(addr.getHostAddress() + _OWRITE);
            val = owr.equalsIgnoreCase("true");
        }
        return val;
    }

    public final String translate(String name) {
        if (this._fileMap.containsKey(name)) {
            return (String)this._fileMap.get(name);
        }
        return this._root + File.separator + name;
    }

    public static void main(String[] args) {
        String USAGE = "Usage: {-server <props>| -get <host> <src> <dest> | -put <host> <src> <dest>}";
        int port = 69;
        try {
            TFTP t = TFTP.getInstance();
            if (args.length == 0) {
                System.err.println("Usage: {-server <props>| -get <host> <src> <dest> | -put <host> <src> <dest>}");
                System.exit(1);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-trace")) {
                    TFTP.addListener(new TFTPEventListenerIf(){

                        @Override
                        public void tftpEvent(boolean inComing, byte opcode, InetAddress addr, int port, String msg) {
                            String dirn = inComing ? "Received " : "Sent ";
                            String opName = TFTP.getOpcodeName(opcode);
                            System.err.println(dirn + opName + " " + addr + "/" + port + " " + msg);
                        }
                    });
                    continue;
                }
                if (args[i].equals("-server")) {
                    String cmd;
                    FileInputStream in = new FileInputStream(args[i + 1]);
                    Properties props = new Properties();
                    props.load(in);
                    if (props.size() > 0) {
                        t.startServer();
                    }
                    Enumeration<?> e = props.propertyNames();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String val = props.getProperty(key);
                        if (val == null) continue;
                        if (key.startsWith("tftp.maxConns")) {
                            t.setMaxConns(Integer.parseInt(val));
                            continue;
                        }
                        if (key.startsWith("tftp.root")) {
                            t.setRoot(val);
                            continue;
                        }
                        if (key.startsWith("tftp.maxTimeouts")) {
                            t.setMaxTimeouts(Integer.parseInt(val));
                            continue;
                        }
                        if (!key.startsWith("tftp.ip")) continue;
                        StringTokenizer tok = new StringTokenizer(val, ",");
                        String ip = tok.nextToken();
                        String rd = tok.nextToken();
                        String wr = tok.nextToken();
                        String owr = tok.nextToken();
                        t.addIpAccess(ip, rd, wr, owr);
                    }
                    InputStreamReader rdr = new InputStreamReader(System.in);
                    BufferedReader brdr = new BufferedReader(rdr);
                    System.out.print("> ");
                    while ((cmd = brdr.readLine()) != null) {
                        if (cmd.equalsIgnoreCase("maxconns")) {
                            System.out.println(t.getMaxConns());
                        } else if (cmd.equalsIgnoreCase("maxtimeouts")) {
                            System.out.println(t.getMaxTimeouts());
                        } else if (cmd.equalsIgnoreCase("root")) {
                            System.out.println(t.getRoot());
                        } else if (cmd.equalsIgnoreCase("addr")) {
                            System.out.println(t.getServerAddress());
                        } else if (cmd.equalsIgnoreCase("conns")) {
                            System.out.println(t.getConns());
                        } else if (cmd.equalsIgnoreCase("stop")) {
                            System.out.println("terminating");
                            t.stopServer();
                            System.exit(0);
                        }
                        System.out.print("> ");
                    }
                    continue;
                }
                if (args[i].equals("-get")) {
                    t = TFTP.getInstance();
                    InetAddress addr = InetAddress.getByName(args[i + 1]);
                    t.get(args[i + 2], args[i + 3], addr, port);
                    break;
                }
                if (args[i].equals("-put")) {
                    t = TFTP.getInstance();
                    InetAddress addr = InetAddress.getByName(args[i + 1]);
                    t.put(args[i + 2], addr, port);
                    break;
                }
                System.err.println("Usage: {-server <props>| -get <host> <src> <dest> | -put <host> <src> <dest>}");
                System.exit(1);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            DefaultLogger._ExLogger.debug((Object)ex.getMessage(), (Throwable)ex);
            System.exit(1);
        }
        System.exit(0);
    }

    public static final InetAddress getLocalAddress() throws SocketException, UnknownHostException {
        return NetUtil.getLocalAddr((InetAddress)InetAddress.getByName("0.0.0.0"));
    }

    static {
        _Trace = new TFTPEventListenerIf(){

            @Override
            public void tftpEvent(boolean inComing, byte opcode, InetAddress addr, int port, String msg) {
                String dirn = inComing ? "Received " : "Sent ";
                System.out.println(dirn + TFTP.getOpcodeName(opcode) + " " + addr + "/" + port + " " + msg);
            }
        };
        _listeners = new Array();
    }

    class Worker
    extends Thread {
        DatagramPacket _pkt;
        boolean _keepAlive = true;

        Worker(DatagramPacket pkt, int id) throws SocketException {
            this.setName("TFTP Worker " + id + ":");
            this._pkt = pkt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block17: {
                rAddr = this._pkt.getAddress();
                rPort = this._pkt.getPort();
                lPort = TFTP.this.getTid();
                name = TFTP.getFilename(this._pkt);
                opcode = TFTP.getOpcode(this._pkt);
                ib = new byte[516];
                ob = new byte[516];
                ip = new DatagramPacket(ib, ib.length);
                op = new DatagramPacket(ob, ob.length);
                sock = null;
                try {
                    sock = new DatagramSocket(lPort, null);
                    sock.setSoTimeout(500);
                    thunk = new Thunk(){

                        @Override
                        public boolean ok() {
                            return Worker.this._keepAlive;
                        }
                    };
                    if (name.indexOf("..") != -1) {
                        TFTP.sendErr(sock, rAddr, rPort, (byte)2, op, ob);
                        sock.close();
                        break block17;
                    }
                    f = new File(TFTP.this.translate(name));
                    switch (opcode) {
                        case 1: {
                            TFTP.notifyEventIn((byte)1, rAddr, rPort, name);
                            if (!f.canRead()) {
                                TFTP.sendErr(sock, rAddr, rPort, (byte)1, op, ob);
                                ** break;
lbl26:
                                // 1 sources

                                break;
                            }
                            try {
                                TFTP.this.sendFile(rAddr, rPort, f, name, sock, ip, op, ib, ob, false, thunk);
                                ** break;
lbl30:
                                // 1 sources

                                break;
                            }
                            catch (IOException ex) {
                                DefaultLogger._LibLogger.debug((Object)("TFTP sending warning" + ex.getMessage()));
                                throw ex;
                            }
                        }
                        case 2: {
                            TFTP.notifyEventIn((byte)2, rAddr, rPort, name);
                            if (!(!f.exists() || f.canWrite() && TFTP.this.canOverWrite(rAddr))) {
                                TFTP.sendErr(sock, rAddr, rPort, (byte)6, op, ob);
                                ** break;
lbl39:
                                // 1 sources

                                break;
                            }
                            try {
                                TFTP.this.receiveFile(rAddr, rPort, f, name, sock, ip, op, ib, ob, false, thunk);
                                ** break;
lbl43:
                                // 1 sources

                                break;
                            }
                            catch (IOException ex) {
                                DefaultLogger._LibLogger.debug((Object)("TFTP receiving warning" + ex.getMessage()));
                                throw ex;
                            }
                        }
                        ** default:
lbl48:
                        // 1 sources

                        break;
                    }
                }
                catch (IOException ex) {
                    DefaultLogger._LibLogger.debug((Object)("TFTP running warning" + ex.getMessage()));
                }
                finally {
                    if (sock != null) {
                        sock.close();
                    }
                }
            }
            --TFTP.this._conns;
            TFTP.this._workers.remove(this);
        }
    }

    class Listener
    extends Thread {
        DatagramSocket _sock;
        boolean _keepAlive = true;

        Listener(InetAddress addr, int port) throws SocketException {
            this.setName("TFTP Incoming Listener:");
            this._sock = new DatagramSocket(port, addr);
            this._sock.setSoTimeout(500);
        }

        @Override
        public void run() {
            while (this._keepAlive) {
                try {
                    byte[] ib = new byte[516];
                    DatagramPacket ip = new DatagramPacket(ib, ib.length);
                    this._sock.receive(ip);
                    InetAddress addr = ip.getAddress();
                    byte opcode = TFTP.getOpcode(ip);
                    boolean kosher = opcode == 1 && TFTP.this.canRead(addr) || opcode == 2 && TFTP.this.canWrite(addr);
                    if (!kosher || TFTP.this._conns > TFTP.this._maxConns) continue;
                    Worker worker = new Worker(ip, ++TFTP.this._conns);
                    TFTP.this._workers.add(worker);
                    worker.start();
                }
                catch (SocketTimeoutException ex) {
                    DefaultLogger._LibLogger.debug((Object)("TFTP starting warning " + ex.getMessage()));
                }
                catch (IOException ex) {
                    DefaultLogger._LibLogger.warn((Object)("TFTP starting warning " + ex.getMessage()));
                }
            }
            this._sock.close();
        }
    }

    static interface Thunk {
        public boolean ok();
    }
}

