/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.channel;

import com.cisco.dcbu.lib.util.channel.ChannelImpl;

public class StoppableChannel<E>
extends ChannelImpl<E> {
    private boolean _process = false;
    private boolean _queueing;
    private Object _lock4Process = new Object();
    private Object _lock4Empty = new Object();
    private boolean _isEmpty;

    public StoppableChannel() {
        super("StoppableChannel", null);
    }

    public synchronized void activate() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " activate()"));
        }
        this.startQueueing();
        this.startProcessing();
    }

    public synchronized void deactivate() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " deactivate()"));
        }
        this.stopQueueing();
        this.stopProcessing();
    }

    public synchronized void startQueueing() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " startQueueing()"));
        }
        this._queueing = true;
    }

    public synchronized void stopQueueing() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " stopQueueing()"));
        }
        this._queueing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startProcessing() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " startProcessing()"));
        }
        this._process = true;
        Object object = this._lock4Process;
        synchronized (object) {
            this._lock4Process.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopProcessing() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " stopProcessing()"));
        }
        Object object = this._lock4Process;
        synchronized (object) {
            this._process = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForQueueToEmpty() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " waitForQueueToEmpty()"));
        }
        Object object = this._lock4Empty;
        synchronized (object) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)(this + " getSize() = " + this.getSize()));
            }
            this._isEmpty = this.getSize() <= 0;
            while (!this._isEmpty) {
                try {
                    this._lock4Empty.wait();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEmpty() {
        Object object;
        if (this._lock4Empty == null) {
            object = this;
            synchronized (object) {
                if (this._lock4Empty == null) {
                    this._lock4Empty = new Object();
                }
            }
        }
        object = this._lock4Empty;
        synchronized (object) {
            this._isEmpty = true;
            this._lock4Empty.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeDispatching() {
        while (!this._process) {
            Object object = this._lock4Process;
            synchronized (object) {
                try {
                    if (!this._process) {
                        this._lock4Process.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)(this + " waiting done"));
        }
    }

    @Override
    public void queue(E what) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)(this + " queue: " + what));
        }
        if (!this._queueing) {
            return;
        }
        try {
            super.queue(what);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isProcess() {
        return this._process;
    }

    public boolean isQueueing() {
        return this._queueing;
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }
}

