/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util.fcoe;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.fcoe.FCoEConfigCommandsIf;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FCoEConfigurationHelper {
    public static final String VFC_TRUNKING_MIN_VERSION = "5.2(0)";
    public static final String N5K_PC_MEMBER_FCOE_BINDING_SUPPORT_VERSION = "5.1(0)";
    public static final String MIN_VERSION_N5K_TRUNKING = "5.0(2)";
    public static final SwitchVersion MIN_VERSION_N5K_VE_FCOE_VERSION = new SwitchVersion("5.0(2)N2", false);
    public static final SwitchVersion MIN_VERSION_N5K_FCOE_NPV_VERSION = new SwitchVersion("5.0(3)N2", false);
    protected static final int SPEED_1G = 1000;
    static final int DISABLE_FEATURE = 3;
    static final int ENABLE_FEATURE = 2;
    static final int FEATURE_ENABLED = 2;
    protected static int[] _cfcFeatureCtrlOpStatusOid = MibNode.get((String)"cfcFeatureCtrlOpStatus").getOid();
    protected static int[] _cfcFeatureCtrlActionOid = MibNode.get((String)"cfcFeatureCtrlAction").getOid();
    protected static int[] _cfcFeatureCtrlLastActionResultOid = MibNode.get((String)"cfcFeatureCtrlLastActionResult").getOid();
    protected static int[] _cfcFeatureCtrlLastFailureReasonOid = MibNode.get((String)"cfcFeatureCtrlLastFailureReason").getOid();
    public static final int[] NPIV_INDEX = new int[]{16};
    protected static final int[] FCOE_INDEX = new int[]{66};
    protected static final int[] NPV_INDEX = new int[]{37};
    protected static final int[] FCOE_NPV_INDEX = new int[]{105};
    static final int MAX_FEATURE_SET_POLLING_ATTEMPTS = 8;
    static final int[] _cfcFeatureSetActionOid = MibNode.get((String)"cfcFeatureSetAction").getOid();
    static final int[] _cfcFeatureSetLastActionResultOid = MibNode.get((String)"cfcFeatureSetLastActionResult").getOid();
    static final int[] _cfcFeatureSetLastFailureReasonOid = MibNode.get((String)"cfcFeatureSetLastFailureReason").getOid();
    static final int[] _cfcFeatureSetOpStatusOid = MibNode.get((String)"cfcFeatureSetOpStatus").getOid();
    public static final int[] FCOE_SET_INDEX = new int[]{1};
    private static final SnmpInt INSERT_VALUE = new SnmpInt(4);
    private static int INTERFACE_STATUS_UP = 1;
    private static int INTERFACE_STATUS_DOWN = 2;
    private static final int[] VFC_ROW_STATUS_OID = MibNode.get((String)"cfcoeStaticVfcRowStatus").getOid();
    private static final int[] VIGLESS_VFC_BIND_TYPE_OID = MibNode.get((String)"cfcoeStaticVfcBindType").getOid();
    private static final int[] VIGLESS_VFC_BINDING_IF_OID = MibNode.get((String)"cfcoeStaticVfcBindIfIndex").getOid();
    private static final int[] _vsanIfVsanOid = MibNode.get((String)"vsanIfVsan").getOid();
    static final int[] _fcIfAllowedVsanList2kOid = MibNode.get((String)"fcIfAllowedVsanList2k").getOid();
    static final int[] _fcIfAllowedVsanList4kOid = MibNode.get((String)"fcIfAllowedVsanList4k").getOid();
    static final int[] _ifAdminStatus = MibNode.get((String)"ifAdminStatus").getOid();
    static final int[] _fcIfAdminMode = MibNode.get((String)"fcIfAdminMode").getOid();
    static Logger _logger = LogManager.getLogger((String)"fms.fcoe");

    public static int minimumPortSpeedForFcoe(SwitchAttrIf sw) {
        return 1000;
    }

    public static boolean isVeSupported(SwitchAttrIf sw) {
        if (sw != null) {
            if (sw.isNuovaFamily()) {
                SwitchVersion swVersion = new SwitchVersion(sw.getVersion(), false);
                if (!swVersion.lessThan(MIN_VERSION_N5K_VE_FCOE_VERSION)) {
                    return true;
                }
            } else {
                return sw.isVersionGreaterThanEqual(VFC_TRUNKING_MIN_VERSION);
            }
        }
        return false;
    }

    public static boolean isPCMemberFCoEBindingSupported(SwitchAttrIf sw) {
        if (sw != null) {
            if (sw.isNuovaFamily()) {
                return sw.isVersionGreaterThanEqual(N5K_PC_MEMBER_FCOE_BINDING_SUPPORT_VERSION);
            }
            return false;
        }
        return false;
    }

    public static boolean isVfcTrunkingSupported(SwitchAttrIf sw) {
        if (sw != null) {
            if (sw.isNuovaFamily() && sw.isVersionGreaterThanEqual(MIN_VERSION_N5K_TRUNKING)) {
                return true;
            }
            return sw.isVersionGreaterThanEqual(VFC_TRUNKING_MIN_VERSION);
        }
        return false;
    }

    public static boolean isVfcRestrictedToSinglePChannelMember(SwitchAttrIf sw) {
        return FCoEConfigurationHelper.isVfcTrunkingSupported(sw);
    }

    public static boolean isVfcImplicitBindingSupported(SwitchAttrIf sw) {
        return sw.isN7K() || sw.isMDS() && !sw.isNuovaFamily();
    }

    public static boolean isNPVorFCoENPVEnabled(SwitchAttrIf selectedSwitch, SnmpPeer peer) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : isNPVorEthNPVEnabled(), Checking NPV and FCoE NPV feature status on switch " + selectedSwitch.getName() + "."));
        }
        return FCoEConfigurationHelper.isNPVEnabled(selectedSwitch, peer) || FCoEConfigurationHelper.isFCoENPVEnabled(selectedSwitch, peer);
    }

    public static boolean isNPVEnabled(SwitchAttrIf sw, SnmpPeer peer) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : isFCoEEnabled(), Checking NPV feature status on switch " + sw.getName() + "."));
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, NPV_INDEX));
        pdu.addVar(vb);
        try {
            SnmpInt var;
            SnmpPDU resp = peer.send(pdu);
            if (resp.getVar(0) != null && (var = (SnmpInt)resp.getVar(0)).getValue() == 2) {
                return true;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationHelper : isNPVEnabled(), Failed to get the NPV feature status. Reason :", (Throwable)ex);
        }
        return false;
    }

    public static boolean isFCoENPVEnabled(SwitchAttrIf sw, SnmpPeer peer) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : isFCoEEnabled(), Checking FCoE NPV feature status on switch " + sw.getName() + "."));
        }
        SwitchVersion swVersion = new SwitchVersion(sw.getVersion(), false);
        if (!sw.isNuovaFamily() || swVersion.lessThan(MIN_VERSION_N5K_FCOE_NPV_VERSION)) {
            return false;
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, FCOE_NPV_INDEX));
        pdu.addVar(vb);
        try {
            SnmpInt var;
            SnmpPDU resp = peer.send(pdu);
            if (resp.getVar(0) != null && (var = (SnmpInt)resp.getVar(0)).getValue() == 2) {
                return true;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationHelper : isFCoENPVEnabled(), Failed to get the FCoE NPV feature status. Reason :", (Throwable)ex);
        }
        return false;
    }

    public static void enableFCoE(SwitchAttrIf sw, SnmpPeer peer) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : enableFCoE(), Enabling FCoE feature status on switch " + sw.getName() + "."));
        }
        if (sw.isNuovaFamily()) {
            FCoEConfigurationHelper.enableFCoEN5K(peer);
        } else if (sw.isN7K()) {
            FCoEConfigurationHelper.enableFCoEN7K(peer);
        } else if (sw.isMDS()) {
            FCoEConfigurationHelper.enableFCoEMDS(peer);
        }
    }

    public static boolean isNPIVEnabled(SwitchAttrIf sw, SnmpPeer peer) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : isNPIVEnabled(), Checking NPIV feature status on switch " + sw.getName() + "."));
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, NPIV_INDEX));
        pdu.addVar(vb);
        try {
            SnmpInt var;
            SnmpPDU resp = peer.send(pdu);
            if (resp.getVar(0) != null && (var = (SnmpInt)resp.getVar(0)).getValue() == 2) {
                return true;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationHelper : isNPIVEnabled(), Failed to get the NPIV feature status. Reason :", (Throwable)ex);
        }
        return false;
    }

    public static void enableNPIV(SwitchAttrIf sw, SnmpPeer peer) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : enableNPIV(), Enabling NPIV feature status on switch " + sw.getName() + "."));
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(_cfcFeatureCtrlActionOid, NPIV_INDEX), (SnmpVar)new SnmpInt(2));
        peer.set(pdu);
        boolean enabled = false;
        String lastFailureReason = null;
        int lastFeatureActionResult = -1;
        int lastFeatureStatus = -1;
        for (int i = 0; i < 8; ++i) {
            try {
                Thread.sleep(10000L);
                pdu = new SnmpPDU(-96, new VarBindList());
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, NPIV_INDEX)));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastActionResultOid, NPIV_INDEX)));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastFailureReasonOid, NPIV_INDEX)));
                SnmpPDU resp = peer.send(pdu);
                VarBindList vbl = resp.getVariables();
                if (resp.getVar(0) == null) continue;
                lastFeatureStatus = vbl.intValue(0);
                lastFeatureActionResult = vbl.intValue(1);
                lastFailureReason = vbl.stringValue(2);
                if (lastFeatureStatus != 2) continue;
                enabled = true;
                break;
            }
            catch (Exception ex) {
                _logger.error((Object)"FCoEConfigurationHelper : enableNPIV(), Failed to get the NPIV feature status. Reason :", (Throwable)ex);
            }
        }
        if (!enabled) {
            String msg = " Action Result: " + MibEnum.getLabel((MibEnum[])MibNode.get((String)"cfcFeatureCtrlLastActionResult").getEnums(), (int)lastFeatureActionResult);
            if (lastFailureReason != null) {
                msg = msg + "\nFailure Reason: " + lastFailureReason;
            }
            throw new Exception(msg);
        }
    }

    public static void enableFCoEN5K(SnmpPeer peer) throws Exception {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(_cfcFeatureCtrlActionOid, FCOE_INDEX), (SnmpVar)new SnmpInt(2));
        peer.set(pdu);
        boolean enabled = false;
        String lastFailureReason = null;
        int lastFeatureActionResult = -1;
        int lastFeatureStatus = -1;
        for (int i = 0; i < 8; ++i) {
            try {
                Thread.sleep(10000L);
                pdu = new SnmpPDU(-96, new VarBindList());
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, FCOE_INDEX)));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastActionResultOid, FCOE_INDEX)));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastFailureReasonOid, FCOE_INDEX)));
                SnmpPDU resp = peer.send(pdu);
                VarBindList vbl = resp.getVariables();
                if (resp.getVar(0) == null) continue;
                lastFeatureStatus = vbl.intValue(0);
                lastFeatureActionResult = vbl.intValue(1);
                lastFailureReason = vbl.stringValue(2);
                if (lastFeatureStatus != 2) continue;
                enabled = true;
                break;
            }
            catch (Exception ex) {
                _logger.error((Object)"FCoEConfigurationHelper : enableFCoEN5K(), Failed to get the FCoE feature status. Reason :", (Throwable)ex);
            }
        }
        if (!enabled) {
            String msg = " Action Result: " + MibEnum.getLabel((MibEnum[])MibNode.get((String)"cfcFeatureCtrlLastActionResult").getEnums(), (int)lastFeatureActionResult);
            if (lastFailureReason != null) {
                msg = msg + "\nFailure Reason: " + lastFailureReason;
            }
            throw new Exception(msg);
        }
    }

    public static void enableFCoEMDS(SnmpPeer peer) throws Exception {
        FCoEConfigurationHelper.enableFCoEN7K(peer);
    }

    public static void enableFCoEN7K(SnmpPeer peer) throws Exception {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(_cfcFeatureSetActionOid, FCOE_SET_INDEX), (SnmpVar)new SnmpInt(2));
        peer.set(pdu);
        boolean enabled = false;
        String lastFailureReason = null;
        int lastFeatureActionResult = -1;
        int lastFeatureStatus = 1;
        for (int i = 0; i < 8; ++i) {
            try {
                Thread.sleep(10000L);
                pdu = new SnmpPDU(-96, new VarBindList());
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureSetOpStatusOid, FCOE_SET_INDEX)));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureSetLastActionResultOid, FCOE_SET_INDEX)));
                pdu.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureSetLastFailureReasonOid, FCOE_SET_INDEX)));
                SnmpPDU resp = peer.send(pdu);
                VarBindList vbl = resp.getVariables();
                if (resp.getVar(0) == null) continue;
                lastFeatureStatus = vbl.intValue(0);
                lastFeatureActionResult = vbl.intValue(1);
                lastFailureReason = vbl.stringValue(2);
                if (lastFeatureStatus != 2) continue;
                enabled = true;
                break;
            }
            catch (Exception ex) {
                _logger.error((Object)"FCoEConfigurationHelper : enableFCoEN7K(), Failed to get the FCoE feature status. Reason :", (Throwable)ex);
            }
        }
        if (!enabled) {
            String msg = " Action Result: " + MibEnum.getLabel((MibEnum[])MibNode.get((String)"cfcFeatureSetLastActionResult").getEnums(), (int)lastFeatureActionResult);
            if (lastFailureReason != null) {
                msg = msg + "\nFailure Reason: " + lastFailureReason;
            }
            throw new Exception(msg);
        }
    }

    public static boolean isFCoEEnabled(SwitchAttrIf sw, SnmpPeer peer) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : isFCoEEnabled(), Checking FCoE feature status on switch " + sw.getName() + "."));
        }
        if (sw.isNuovaFamily()) {
            return FCoEConfigurationHelper.isFCoEEnabledN5K(peer) || FCoEConfigurationHelper.isFCoENPVEnabled(sw, peer);
        }
        if (sw.isN7K()) {
            return FCoEConfigurationHelper.isFCoEEnabledN7K(peer);
        }
        if (sw.isMDS()) {
            return FCoEConfigurationHelper.isFCoEEnabledMDS(peer);
        }
        return false;
    }

    public static boolean isFCoEEnabledN5K(SnmpPeer peer) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, FCOE_INDEX));
        pdu.addVar(vb);
        try {
            SnmpInt var;
            SnmpPDU resp = peer.send(pdu);
            if (resp.getVar(0) != null && (var = (SnmpInt)resp.getVar(0)).getValue() == 2) {
                return true;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationHelper : isFCoEEnabledN5K(), Failed to get the FCoE feature status. Reason :", (Throwable)ex);
        }
        return false;
    }

    public static boolean isFCoEEnabledMDS(SnmpPeer peer) {
        return FCoEConfigurationHelper.isFCoEEnabledN7K(peer);
    }

    public static boolean isFCoEEnabledN7K(SnmpPeer peer) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(_cfcFeatureSetOpStatusOid, FCOE_SET_INDEX));
        pdu.addVar(vb);
        try {
            SnmpInt var;
            SnmpPDU resp = peer.send(pdu);
            if (resp.getVar(0) != null && (var = (SnmpInt)resp.getVar(0)).getValue() == 2) {
                return true;
            }
        }
        catch (Exception ex) {
            _logger.error((Object)"FCoEConfigurationHelper : isFCoEEnabledN7K(), Failed to get the FCoE feature status. Reason :", (Throwable)ex);
        }
        return false;
    }

    public static void cretaeFCoE(SwitchAttrIf selectedSwitch, SnmpPeer peer, String interfaceName, List<String> vsans, String vfcName, int vsifIndex, boolean isImplicitBinding) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : cretaeFCoE(), Creating the vfc interface " + vfcName + ", for interface " + interfaceName));
        }
        int portIndex = selectedSwitch.nameToIfIndex(interfaceName);
        int[] index = IfIndexUtil.vfcIndexToVfcTableIndex(IfIndexUtil.ifindexToVfcIndex(vsifIndex));
        SnmpInt ethIfIndex = new SnmpInt(portIndex);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int[] rowStatusOid = VFC_ROW_STATUS_OID;
        pdu.addVar(new SnmpOID(rowStatusOid, index), (SnmpVar)INSERT_VALUE);
        pdu.addVar(new SnmpOID(VIGLESS_VFC_BIND_TYPE_OID, index), (SnmpVar)new SnmpInt(1));
        if (!isImplicitBinding) {
            SnmpInt bindIfIndex = ethIfIndex;
            pdu.addVar(new SnmpOID(VIGLESS_VFC_BINDING_IF_OID, index), (SnmpVar)bindIfIndex);
        }
        if (FCoEConfigurationHelper.isVfcTrunkingSupported(selectedSwitch)) {
            StringBuilder vsanListStr = null;
            for (String nextVsan : vsans) {
                if (vsanListStr == null) {
                    vsanListStr = new StringBuilder(nextVsan);
                    continue;
                }
                vsanListStr.append(",").append(nextVsan);
            }
            if (vsanListStr == null) {
                vsanListStr = new StringBuilder();
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("FCoEConfigurationHelper : cretaeFCoE(), Setting the vfc interface " + vfcName + " trunk allowed list to " + vsanListStr.toString()));
            }
            byte[] vsanBitmap = SnmpBitmap.parse(vsanListStr.toString(), false);
            SnmpString vsan2Kmap = new SnmpString(vsanBitmap);
            PortInterfaceUtil.getInstance(1);
            byte[] vsan4Kbitmap = PortInterfaceUtil.getVsan4k2(new SnmpOID(_fcIfAllowedVsanList2kOid), (SnmpVar)vsan2Kmap);
            if (vsan4Kbitmap == null) {
                vsan4Kbitmap = new byte[]{};
            }
            vsan4Kbitmap = SnmpBitmap.trimTrailingZero(vsan4Kbitmap);
            vsan2Kmap = new SnmpString(SnmpBitmap.trimTrailingZero(vsan2Kmap.getValue()));
            SnmpString vsan4Kmap = new SnmpString(vsan4Kbitmap);
            pdu.addVar(new SnmpOID(_fcIfAllowedVsanList2kOid, vsifIndex), (SnmpVar)vsan2Kmap);
            pdu.addVar(new SnmpOID(_fcIfAllowedVsanList4kOid, vsifIndex), (SnmpVar)vsan4Kmap);
        }
        peer.set(pdu);
    }

    public static void sendSetAdminStatePdu(SwitchAttrIf selectedSwitch, SnmpPeer peer, int vfcAdminMode, String vfcNameStr, int vsifIndex, String vsan) throws SnmpException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : sendSetAdminStatPdu(), Setting the vfc interface " + vfcNameStr + " admin status as UP ."));
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(_fcIfAdminMode, vsifIndex), (SnmpVar)new SnmpInt(vfcAdminMode));
        pdu.addVar(new SnmpOID(_ifAdminStatus, vsifIndex), (SnmpVar)new SnmpInt(INTERFACE_STATUS_UP));
        pdu.addVar(new SnmpOID(_vsanIfVsanOid, vsifIndex), (SnmpVar)new SnmpInt(vsan));
        peer.set(pdu);
    }

    public static void createVsan(SnmpPeer peer, Integer vsanId) throws SnmpException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : createVsan(), Creating VSAN " + vsanId + "."));
        }
        int[] _vsanRowStatusOid = MibNode.get((String)"vsanRowStatus").getOid();
        int[] _vsanLoadBalancingTypeOid = MibNode.get((String)"vsanLoadBalancingType").getOid();
        int[] _vsanInterOperValueOid = MibNode.get((String)"vsanInterOperValue").getOid();
        int[] _vsanAdminStateOid = MibNode.get((String)"vsanAdminState").getOid();
        int[] _vsanInorderDeliveryOid = MibNode.get((String)"vsanInorderDelivery").getOid();
        VarBindList varList = new VarBindList();
        varList.add(_vsanRowStatusOid, vsanId.intValue(), (SnmpVar)new SnmpInt(4));
        varList.add(_vsanLoadBalancingTypeOid, vsanId.intValue(), (SnmpVar)new SnmpInt(2));
        varList.add(_vsanInterOperValueOid, vsanId.intValue(), (SnmpVar)new SnmpInt(0));
        varList.add(_vsanAdminStateOid, vsanId.intValue(), (SnmpVar)new SnmpInt(1));
        varList.add(_vsanInorderDeliveryOid, vsanId.intValue(), (SnmpVar)new SnmpInt(2));
        SnmpPDU pdu = new SnmpPDU(-93, varList);
        pdu.setIgnoreSetCount(true);
        peer.set(pdu);
    }

    public static boolean checkDeviceConfiguration(SwitchAttrIf selectedSwitch, SnmpPeer peer, FCoEConfigCommandsIf fcoeCmdObj, String interfaceName, List<String> vlanNo, boolean isNPVEnabled) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("FCoEConfigurationHelper : checkDeviceConfiguration(), Checking the ethernet configuration on switch " + selectedSwitch.getName() + " port " + interfaceName + "."));
        }
        fcoeCmdObj.verifyInterfaceConfig(interfaceName, vlanNo, isNPVEnabled, FCoEConfigurationHelper.isVfcTrunkingSupported(selectedSwitch));
        MibNode adminStatusMib = MibNode.get((String)"ifAdminStatus");
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int portIndex = selectedSwitch.nameToIfIndex(interfaceName);
        pdu.addVar(new SnmpOID(adminStatusMib.getOid(), portIndex), (SnmpVar)new SnmpInt(INTERFACE_STATUS_DOWN));
        peer.set(pdu);
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(adminStatusMib.getOid(), portIndex), (SnmpVar)new SnmpInt(INTERFACE_STATUS_UP));
        peer.set(pdu);
        return true;
    }
}

