/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSchAuthCancelException;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.JSchPartialAuthException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserAuth;
import com.jcraft.jsch.UserInfo;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class UserAuthPublicKey
extends UserAuth {
    UserInfo userinfo;

    UserAuthPublicKey(UserInfo userinfo) {
        this.userinfo = userinfo;
    }

    @Override
    public boolean start(Session session) throws Exception {
        Vector identities = session.jsch.identities;
        Packet packet = session.packet;
        Buffer buf = packet.buffer;
        String passphrase = null;
        String username = session.username;
        byte[] _username = null;
        try {
            _username = username.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            _username = username.getBytes();
        }
        for (int i = 0; i < identities.size(); ++i) {
            Identity identity = (Identity)identities.elementAt(i);
            byte[] pubkeyblob = identity.getPublicKeyBlob();
            if (pubkeyblob != null) {
                packet.reset();
                buf.putByte((byte)50);
                buf.putString(_username);
                buf.putString("ssh-connection".getBytes());
                buf.putString("publickey".getBytes());
                buf.putByte((byte)0);
                buf.putString(identity.getAlgName().getBytes());
                buf.putString(pubkeyblob);
                session.write(packet);
                while (true) {
                    buf = session.read(buf);
                    if (buf.buffer[5] == 60 || buf.buffer[5] == 51 || buf.buffer[5] != 53) break;
                    buf.getInt();
                    buf.getByte();
                    buf.getByte();
                    byte[] _message = buf.getString();
                    byte[] lang = buf.getString();
                    String message = null;
                    try {
                        message = new String(_message, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        message = new String(_message);
                    }
                    if (this.userinfo == null) continue;
                    this.userinfo.showMessage(message);
                }
                if (buf.buffer[5] != 60) continue;
            }
            int count = 5;
            do {
                if (identity.isEncrypted() && passphrase == null) {
                    if (this.userinfo == null) {
                        throw new JSchException("USERAUTH fail");
                    }
                    if (identity.isEncrypted() && !this.userinfo.promptPassphrase("Passphrase for " + identity.getName())) {
                        throw new JSchAuthCancelException("publickey");
                    }
                    passphrase = this.userinfo.getPassphrase();
                }
                if ((!identity.isEncrypted() || passphrase != null) && identity.setPassphrase(passphrase)) break;
                passphrase = null;
            } while (--count != 0);
            if (identity.isEncrypted()) continue;
            if (pubkeyblob == null) {
                pubkeyblob = identity.getPublicKeyBlob();
            }
            if (pubkeyblob == null) continue;
            packet.reset();
            buf.putByte((byte)50);
            buf.putString(_username);
            buf.putString("ssh-connection".getBytes());
            buf.putString("publickey".getBytes());
            buf.putByte((byte)1);
            buf.putString(identity.getAlgName().getBytes());
            buf.putString(pubkeyblob);
            byte[] sid = session.getSessionId();
            int sidlen = sid.length;
            byte[] tmp = new byte[4 + sidlen + buf.index - 5];
            tmp[0] = (byte)(sidlen >>> 24);
            tmp[1] = (byte)(sidlen >>> 16);
            tmp[2] = (byte)(sidlen >>> 8);
            tmp[3] = (byte)sidlen;
            System.arraycopy(sid, 0, tmp, 4, sidlen);
            System.arraycopy(buf.buffer, 5, tmp, 4 + sidlen, buf.index - 5);
            byte[] signature = identity.getSignature(tmp);
            if (signature == null) break;
            buf.putString(signature);
            session.write(packet);
            while (true) {
                buf = session.read(buf);
                if (buf.buffer[5] == 52) {
                    return true;
                }
                if (buf.buffer[5] != 53) break;
                buf.getInt();
                buf.getByte();
                buf.getByte();
                byte[] _message = buf.getString();
                byte[] lang = buf.getString();
                String message = null;
                try {
                    message = new String(_message, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    message = new String(_message);
                }
                if (this.userinfo == null) continue;
                this.userinfo.showMessage(message);
            }
            if (buf.buffer[5] != 51) continue;
            buf.getInt();
            buf.getByte();
            buf.getByte();
            byte[] foo = buf.getString();
            int partial_success = buf.getByte();
            if (partial_success == 0) continue;
            throw new JSchPartialAuthException(new String(foo));
        }
        return false;
    }
}

