/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileCorruptedException;
import org.jrobin.core.Util;

public class DsDef {
    public static final String[] DS_TYPES = new String[]{"GAUGE", "COUNTER", "DERIVE", "ABSOLUTE"};
    private String dsName;
    private String dsType;
    private long heartbeat;
    private String comment;
    private double minValue;
    private double maxValue;

    public DsDef(String dsName, String dsType, long heartbeat, double minValue, double maxValue) throws RrdException {
        this.dsName = dsName;
        this.dsType = dsType;
        this.heartbeat = heartbeat;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.validate();
    }

    public String getDsName() {
        return this.dsName;
    }

    public String getDsType() {
        return this.dsType;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void validate() throws RrdException {
        if (this.dsName == null || this.dsName.length() == 0) {
            throw new RrdFileCorruptedException("Invalid datasource name specified");
        }
        if (!DsDef.isValidDsType(this.dsType)) {
            throw new RrdFileCorruptedException("Invalid datasource type specified: " + this.dsType);
        }
        if (this.heartbeat <= 0L) {
            throw new RrdFileCorruptedException("Invalid heartbeat, must be positive: " + this.heartbeat);
        }
        if (!Double.isNaN(this.minValue) && !Double.isNaN(this.maxValue) && this.minValue >= this.maxValue) {
            throw new RrdFileCorruptedException("Invalid min/max values specified: " + this.minValue + "/" + this.maxValue);
        }
    }

    public static boolean isValidDsType(String dsType) {
        for (int i = 0; i < DS_TYPES.length; ++i) {
            if (dsType.indexOf(DS_TYPES[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public String dump() {
        return "DS:" + this.dsName + ":" + this.dsType + ":" + this.heartbeat + ":" + Util.formatDouble(this.minValue, true) + ":" + Util.formatDouble(this.maxValue, true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DsDef) {
            DsDef dsObj = (DsDef)obj;
            return this.dsName.equals(dsObj.dsName);
        }
        return false;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

