/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdUpdater;

public class RrdDouble {
    private RrdFile file;
    private long pointer;
    private int count;
    private boolean cached = false;
    private double cachedValue;

    RrdDouble(RrdUpdater updater, int count) throws IOException {
        this.count = count;
        this.file = updater.getRrdFile();
        this.pointer = this.file.allocate(8, count);
    }

    RrdDouble(RrdUpdater updater) throws IOException {
        this(updater, 1);
    }

    RrdDouble(double initValue, RrdUpdater updater) throws IOException {
        this.count = 1;
        this.file = updater.getRrdFile();
        this.pointer = this.file.allocate(initValue);
        this.cached = true;
        this.cachedValue = initValue;
    }

    void set(int index, double value) throws IOException {
        long readPointer = this.pointer + (long)(index * 8);
        this.file.writeDouble(readPointer, value);
    }

    public void fixNaN() throws IOException {
        for (int i = 0; i < this.count; ++i) {
            double d = this.get(i);
            if (!Double.isNaN(d)) continue;
            this.set(i, 0.0);
        }
    }

    void set(double value) throws IOException {
        this.cached = true;
        this.cachedValue = value;
        this.set(0, value);
    }

    double get(int index) throws IOException {
        long readPointer = this.pointer + (long)(index * 8);
        return this.file.readDouble(readPointer);
    }

    double get() throws IOException {
        if (!this.cached) {
            this.cachedValue = this.get(0);
            this.cached = true;
        }
        return this.cachedValue;
    }
}

