/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrobin.core.RrdException;
import org.jrobin.graph.Comment;
import org.jrobin.graph.Source;
import org.jrobin.graph.ValueScaler;

class Gprint
extends Comment {
    private static final String SCALE_MARKER = "@s";
    private static final String UNIFORM_SCALE_MARKER = "@S";
    private static final String VALUE_MARKER = "@([0-9]{1})";
    private static final Pattern VALUE_PATTERN = Pattern.compile("@([0-9]{1})");
    private Source source;
    private int consolFun;

    Gprint(Source source, int consolFun, String comment) throws RrdException {
        super(comment);
        this.source = source;
        this.consolFun = consolFun;
    }

    @Override
    String getMessage() throws RrdException {
        String uniformPrefixStr;
        String prefixStr;
        String valueStr;
        double value = this.source.getAggregate(this.consolFun);
        Matcher m = VALUE_PATTERN.matcher(this.comment);
        if (m.find()) {
            valueStr = "" + value;
            prefixStr = "";
            uniformPrefixStr = "";
            if (!Double.isNaN(value)) {
                int numDec = Integer.parseInt(m.group(1));
                DecimalFormat df = this.getDecimalFormat(numDec);
                if (this.shouldScale() && !this.shouldUniformScale()) {
                    ValueScaler scaler = new ValueScaler(value);
                    valueStr = df.format(scaler.getScaledValue());
                    prefixStr = scaler.getPrefix();
                    this.scaleIndex = scaler.getScaleIndex();
                } else if (!this.shouldScale() && this.shouldUniformScale()) {
                    ValueScaler scaler = new ValueScaler(value, this.scaleIndex);
                    valueStr = df.format(scaler.getScaledValue());
                    uniformPrefixStr = scaler.getPrefix();
                    this.scaleIndex = scaler.getScaleIndex();
                } else if (!this.shouldScale() && !this.shouldUniformScale()) {
                    valueStr = df.format(value);
                } else if (this.shouldScale() && this.shouldUniformScale()) {
                    throw new RrdException("You cannot specify uniform and non-uniform value scaling at the same time");
                }
            }
        } else {
            throw new RrdException("Could not find where to place value. No @ placeholder found");
        }
        this.comment = this.comment.replaceFirst(VALUE_MARKER, valueStr);
        this.comment = this.comment.replaceFirst(SCALE_MARKER, prefixStr);
        this.comment = this.comment.replaceFirst(UNIFORM_SCALE_MARKER, uniformPrefixStr);
        return super.getMessage();
    }

    boolean shouldScale() {
        return this.comment.indexOf(SCALE_MARKER) >= 0;
    }

    boolean shouldUniformScale() {
        return this.comment.indexOf(UNIFORM_SCALE_MARKER) >= 0;
    }

    private DecimalFormat getDecimalFormat(int numDec) {
        String formatStr = "#,##0";
        for (int i = 0; i < numDec; ++i) {
            if (i == 0) {
                formatStr = formatStr + ".";
            }
            formatStr = formatStr + "0";
        }
        return new DecimalFormat(formatStr);
    }
}

