/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jrobin.core.RrdException;
import org.jrobin.graph.Grapher;
import org.jrobin.graph.RrdGraphDef;

public class RrdGraph {
    private JFreeChart chart;

    public RrdGraph(RrdGraphDef graphDef, RrdGraphDef errGraphDef, String label) throws IOException, RrdException {
        Grapher grapher = new Grapher(graphDef, errGraphDef, label);
        this.chart = grapher.createJFreeChart();
    }

    public BufferedImage getBufferedImage(int width, int height) {
        return this.chart.createBufferedImage(width, height);
    }

    public void saveAsPNG(String path, int width, int height) throws IOException {
        ChartUtilities.saveChartAsPNG((File)new File(path), (JFreeChart)this.chart, (int)width, (int)height);
    }

    public void saveAsJPEG(String path, int width, int height, float quality) throws IOException {
        ChartUtilities.saveChartAsJPEG((File)new File(path), (float)quality, (JFreeChart)this.chart, (int)width, (int)height);
    }

    public JPanel getChartPanel() {
        return new ChartPanel(this.chart);
    }

    public byte[] getPNGBytes(int width, int height) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ChartUtilities.writeBufferedImageAsPNG((OutputStream)outputStream, (BufferedImage)this.getBufferedImage(width, height));
        return outputStream.toByteArray();
    }

    public byte[] getJPEGBytes(int width, int height, float quality) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ChartUtilities.writeBufferedImageAsJPEG((OutputStream)outputStream, (float)quality, (BufferedImage)this.getBufferedImage(width, height));
        return outputStream.toByteArray();
    }

    public JFreeChart getChart() {
        return this.chart;
    }
}

