/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.data.Range;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Area;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Comment;
import org.jrobin.graph.Def;
import org.jrobin.graph.Gprint;
import org.jrobin.graph.Hrule;
import org.jrobin.graph.Line;
import org.jrobin.graph.OverlayGraph;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.Source;
import org.jrobin.graph.Stack;

public class RrdGraphDef {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    private ArrayList sources = new ArrayList();
    private ArrayList plotDefs = new ArrayList();
    private ArrayList graphs = new ArrayList();
    private ArrayList comments = new ArrayList();
    private int timeUnit;
    private int timeUnitCount;
    private SimpleDateFormat timeFormat;
    private long endTime = Util.getTime();
    private long startTime = this.endTime - 86400L;
    private String title = "<TITLE>";
    private String timeAxisLabel = "";
    private String valueAxisLabel = "";
    private Range valueRange;
    private boolean logarithmic = false;
    private double valueStep = 0.0;
    private Color backColor;

    public void setTimePeriod(long startTime, long endTime) throws RrdException {
        if (startTime < 0L || endTime <= startTime) {
            throw new RrdException("Invalid graph start/end time: " + startTime + "/" + endTime);
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public void setTimePeriod(Date start, Date end) throws RrdException {
        this.setTimePeriod(start.getTime() / 1000L, end.getTime() / 1000L);
    }

    public void setTimePeriod(GregorianCalendar start, GregorianCalendar end) throws RrdException {
        this.setTimePeriod(start.getTime(), end.getTime());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTimeAxisLabel(String timeAxisLabel) {
        this.timeAxisLabel = timeAxisLabel;
    }

    public void setValueAxisLabel(String valueAxisLabel) {
        this.valueAxisLabel = valueAxisLabel;
    }

    void addSource(Source def) {
        this.sources.add(def);
    }

    void addPlot(PlotDef plotDef) throws RrdException {
        this.plotDefs.add(plotDef);
        this.graphs.add(new OverlayGraph(plotDef));
    }

    void addPlot(Stack plotDef) throws RrdException {
        this.plotDefs.add(plotDef);
        OverlayGraph lastGraph = this.getLastGraph();
        if (lastGraph != null) {
            lastGraph.addPlotDef(plotDef);
            return;
        }
        this.graphs.add(new OverlayGraph(plotDef));
    }

    void addPlot(Hrule hruleDef) throws RrdException {
        this.plotDefs.add(hruleDef);
        this.graphs.add(new OverlayGraph(hruleDef));
        this.sources.add(hruleDef.getSource());
    }

    private OverlayGraph getLastGraph() {
        int count = this.graphs.size();
        if (count == 0) {
            return null;
        }
        return (OverlayGraph)this.graphs.get(count - 1);
    }

    void addComment(Comment comment) {
        this.comments.add(comment);
    }

    public Source[] getSources() {
        return this.sources.toArray(new Source[0]);
    }

    PlotDef[] getPlotDefs() {
        return this.plotDefs.toArray(new PlotDef[0]);
    }

    OverlayGraph[] getGraphs() {
        return this.graphs.toArray(new OverlayGraph[0]);
    }

    Comment[] getComments() {
        return this.comments.toArray(new Comment[0]);
    }

    long getEndTime() {
        return this.endTime;
    }

    long getStartTime() {
        return this.startTime;
    }

    String getTitle() {
        return this.title;
    }

    String getTimeAxisLabel() {
        return this.timeAxisLabel;
    }

    String getValueAxisLabel() {
        return this.valueAxisLabel;
    }

    private Source findSourceByName(String sourceName) throws RrdException {
        for (int i = 0; i < this.sources.size(); ++i) {
            Source source = (Source)this.sources.get(i);
            if (!source.getName().equals(sourceName)) continue;
            return source;
        }
        throw new RrdException("Datasource not found: " + sourceName);
    }

    public void area(String sourceName, Color color, String legend) throws RrdException {
        Source source = this.findSourceByName(sourceName);
        this.addPlot(new Area(source, color, legend));
    }

    public void line(String sourceName, Color color, String legend) throws RrdException {
        Source source = this.findSourceByName(sourceName);
        this.addPlot(new Line(source, color, legend));
    }

    public void line(String sourceName, Color color, String legend, float lineWidth) throws RrdException {
        Source source = this.findSourceByName(sourceName);
        this.addPlot(new Line(source, color, legend, lineWidth));
    }

    public void stack(String sourceName, Color color, String legend) throws RrdException {
        Source source = this.findSourceByName(sourceName);
        this.addPlot(new Stack(source, color, legend));
    }

    public void rule(double value, Color color, String legend) throws RrdException {
        this.addPlot(new Hrule(value, color, legend));
    }

    public void comment(String text) throws RrdException {
        this.addComment(new Comment(text));
    }

    public void gprint(String sourceName, int consolFun, String format) throws RrdException {
        Source source = this.findSourceByName(sourceName);
        this.addComment(new Gprint(source, consolFun, format));
    }

    public void datasource(String name, String file, String dsName, String consolFun) {
        this.addSource(new Def(name, file, dsName, consolFun));
    }

    public void datasource(String name, String rpn) {
        this.addSource(new Cdef(name, rpn));
    }

    public void setTimeUnit(int unit, int unitCount, SimpleDateFormat format) {
        this.timeUnit = unit;
        this.timeUnitCount = unitCount;
        this.timeFormat = format;
    }

    int getTimeUnit() {
        return this.timeUnit;
    }

    int getTimeUnitCount() {
        return this.timeUnitCount;
    }

    SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setValueRange(double lower, double upper) {
        this.valueRange = new Range(lower, upper);
    }

    Range getValueRange() {
        return this.valueRange;
    }

    boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    double getValueStep() {
        return this.valueStep;
    }

    public void setValueStep(double valueStep) {
        this.valueStep = valueStep;
    }

    Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
    }
}

