/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.RrdException;
import org.jrobin.graph.DataPoint;

class ValueExtractor {
    private DataPoint[] points;
    private int pos = 0;

    ValueExtractor(DataPoint[] points) throws RrdException {
        this.points = points;
        if (points.length < 2) {
            throw new RrdException("At least two datapoints are required");
        }
    }

    double getValue(long timestamp) throws RrdException {
        if (timestamp < this.points[this.pos].getTime()) {
            throw new RrdException("Backward reading not allowed");
        }
        while (this.pos < this.points.length - 1) {
            if (this.points[this.pos].getTime() <= timestamp && timestamp < this.points[this.pos + 1].getTime()) {
                return this.points[this.pos + 1].getValue();
            }
            ++this.pos;
        }
        return Double.NaN;
    }
}

