/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jrobin.core.ArcDef;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.Util;

class EditArchiveDialog
extends JDialog {
    private static final int FIELD_SIZE = 20;
    private static final String TITLE_NEW = "New archive";
    private static final String TITLE_EDIT = "Edit archive";
    private JLabel consolFunLabel = new JLabel("Consolidation function: ");
    private JLabel xffLabel = new JLabel("X-files factor: ");
    private JLabel stepsLabel = new JLabel("Steps: ");
    private JLabel rowsLabel = new JLabel("Rows: ");
    private JComboBox consolFunCombo = new JComboBox();
    private JTextField xffField = new JTextField(20);
    private JTextField stepsField = new JTextField(20);
    private JTextField rowsField = new JTextField(20);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private ArcDef arcDef;

    EditArchiveDialog(Frame parent, ArcDef arcDef) {
        super(parent, arcDef == null ? TITLE_NEW : TITLE_EDIT, true);
        this.constructUI(arcDef);
        this.pack();
        Util.centerOnScreen(this);
        this.setVisible(true);
    }

    private void constructUI(ArcDef arcDef) {
        String[] funs = ArcDef.CONSOL_FUNS;
        for (int i = 0; i < funs.length; ++i) {
            this.consolFunCombo.addItem(funs[i]);
        }
        this.consolFunCombo.setSelectedIndex(0);
        if (arcDef == null) {
            this.xffField.setText("0.5");
        } else {
            this.consolFunCombo.setSelectedItem(arcDef.getConsolFun());
            this.consolFunCombo.setEnabled(false);
            this.xffField.setText("" + arcDef.getXff());
            this.stepsField.setText("" + arcDef.getSteps());
            this.stepsField.setEnabled(false);
            this.rowsField.setText("" + arcDef.getRows());
        }
        JPanel content = (JPanel)this.getContentPane();
        GridBagLayout layout = new GridBagLayout();
        content.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        layout.setConstraints(this.consolFunLabel, gbc);
        content.add(this.consolFunLabel);
        gbc.gridy = 1;
        layout.setConstraints(this.xffLabel, gbc);
        content.add(this.xffLabel);
        gbc.gridy = 2;
        layout.setConstraints(this.stepsLabel, gbc);
        content.add(this.stepsLabel);
        gbc.gridy = 3;
        layout.setConstraints(this.rowsLabel, gbc);
        content.add(this.rowsLabel);
        gbc.gridy = 4;
        layout.setConstraints(this.okButton, gbc);
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        content.add(this.okButton);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        layout.setConstraints(this.consolFunCombo, gbc);
        content.add(this.consolFunCombo);
        gbc.gridy = 1;
        layout.setConstraints(this.xffField, gbc);
        content.add(this.xffField);
        gbc.gridy = 2;
        layout.setConstraints(this.stepsField, gbc);
        content.add(this.stepsField);
        gbc.gridy = 3;
        layout.setConstraints(this.rowsField, gbc);
        content.add(this.rowsField);
        gbc.gridy = 4;
        layout.setConstraints(this.cancelButton, gbc);
        content.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditArchiveDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditArchiveDialog.this.cancel();
            }
        });
        this.setDefaultCloseOperation(2);
    }

    private void ok() {
        this.arcDef = this.createArcDef();
        if (this.arcDef != null) {
            this.close();
        }
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void cancel() {
        this.close();
    }

    private ArcDef createArcDef() {
        int rows;
        int steps;
        double xff;
        String consolFun = (String)this.consolFunCombo.getSelectedItem();
        try {
            xff = Double.parseDouble(this.xffField.getText());
            if (xff < 0.0 || xff >= 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            Util.error(this, "X-files factor must be a number not less than 0.0 and less than 1.0");
            return null;
        }
        try {
            steps = Integer.parseInt(this.stepsField.getText());
            if (steps <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            Util.error(this, "Number of steps must be a positive integer");
            return null;
        }
        try {
            rows = Integer.parseInt(this.rowsField.getText());
            if (rows <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            Util.error(this, "Number of rows must be a positive integer");
            return null;
        }
        try {
            return new ArcDef(consolFun, xff, steps, rows);
        }
        catch (RrdException e) {
            e.printStackTrace();
            return null;
        }
    }

    ArcDef getArcDef() {
        return this.arcDef;
    }
}

