/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputEntityStream
extends FilterInputStream {
    private volatile long availableSize;

    public InputEntityStream(InputStream source, long size) {
        super(source);
        this.availableSize = size;
    }

    public int available() throws IOException {
        return Math.min((int)this.availableSize, super.available());
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        int result = -1;
        if (this.availableSize > 0L && (result = this.in.read()) != -1) {
            --this.availableSize;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this.availableSize > 0L && (result = this.in.read(b, off, Math.min(len, (int)this.availableSize))) > 0) {
            this.availableSize -= (long)result;
        }
        return result;
    }
}

