/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Controls;
import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.StringUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public final class DMSocket
extends Thread {
    DatagramSocket _sock;
    byte[] _responseBuf;
    Robot _robot;

    public DMSocket(int port) throws SocketException {
        this._sock = new DatagramSocket(port);
        this._responseBuf = new byte[255];
        this.start();
    }

    @Override
    public void run() {
        this.receiver();
    }

    private void receiver() {
        while (this._sock != null) {
            DatagramPacket packet = new DatagramPacket(this._responseBuf, this._responseBuf.length);
            try {
                this._sock.receive(packet);
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)("receiver: " + ex));
                continue;
            }
            try {
                DeviceManager.getInstance().toFront();
                String buf = new String(packet.getData(), 0, packet.getLength());
                if (buf.startsWith("open ")) {
                    this.openDevice(StringUtil.tokenize(buf.substring(5), " "));
                    continue;
                }
                if (buf.startsWith("robot ")) {
                    this.robot(buf.trim());
                    continue;
                }
                if (buf.startsWith("ecc ")) {
                    this.ecc(buf.trim());
                    continue;
                }
                if (buf.startsWith("select ")) {
                    this.select(buf.trim());
                    continue;
                }
                DefaultLogger._DefLogger.debug((Object)("Unknown socket cmd from " + packet.getAddress() + ":" + packet.getPort() + " - " + buf));
            }
            catch (Exception ex) {
                Util.errorMessage((Component)DeviceManager.getInstance(), ex);
            }
        }
    }

    void openDevice(final String[] arg) throws Exception {
        int i;
        if (arg.length == 1) {
            DeviceManager.getInstance().openAction(arg[0]);
            return;
        }
        if (arg.length < 2) {
            throw new Exception("bad args");
        }
        int shift = 1;
        if ("v3".equals(arg[0])) {
            DM._UseV3 = true;
            DM._AuthProtocol = Integer.parseInt(arg[1]);
            ++shift;
        } else if ("v2".equals(arg[0])) {
            DM._UseV3 = false;
        } else {
            DM._UseV3 = false;
            shift = 0;
        }
        InetSocketAddress add = null;
        Discover._UseProxy = false;
        for (i = shift; i < arg.length; ++i) {
            if (arg[i] == null || !arg[i].equals("proxy")) continue;
            String cmd = arg[i + 1];
            int index = cmd.indexOf(58);
            if (index == -1) {
                Util.errorMessage((Component)DeviceManager.getInstance(), "Invalid SNMP proxy format!\nExpected -x <proxy-address:port>");
            }
            try {
                DM._ProxyAddress = InetAddress.getByName(cmd.substring(0, index));
            }
            catch (Exception ex2) {
                Util.errorMessage((Component)DeviceManager.getInstance(), "Invalid SNMP proxy address : " + ex2.getMessage());
            }
            try {
                DM._ProxyPort = Integer.parseInt(cmd.substring(index + 1));
            }
            catch (Exception ex3) {
                Util.errorMessage((Component)DeviceManager.getInstance(), "Invalid SNMP proxy port : " + ex3.getMessage());
            }
            add = DM._ProxyAddress == null ? null : new InetSocketAddress(DM._ProxyAddress, DM._ProxyPort);
            System.out.println("DM._ProxyAddress=" + DM._ProxyAddress);
            if (add != null) {
                Discover._UseProxy = true;
            }
            System.out.println("Discover._UseProxy=" + Discover._UseProxy);
        }
        int n = i = Discover._UseProxy ? shift + 2 : shift;
        if (i + 2 > arg.length) {
            throw new Exception("bad args" + (i + 2) + " : arg " + arg.length);
        }
        final int shiftV = shift;
        final InetSocketAddress address = add;
        final int offsetV = i;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DMSocket.this.open(arg, shiftV, address, offsetV, DM._UseV3);
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                }
            }
        });
    }

    void open(String[] arg, int shift, InetSocketAddress add, int offset, boolean isV3) throws Exception {
        if (isV3 && arg.length > shift + 4) {
            DM._PrivProtocol = Integer.parseInt(arg[shift + 3]);
        }
        DeviceManager.getInstance().open(arg[shift + 0], arg[shift + 1], isV3 && arg.length > shift + 2 ? arg[shift + 2] : null, isV3 && arg.length > shift + 4 ? arg[shift + 4] : null, add);
    }

    void robot(String buf) throws AWTException {
        if (this._robot == null) {
            this._robot = new Robot();
        }
        DeviceManager.getInstance().requestFocus();
        for (int i = 6; i < buf.length(); ++i) {
            if (buf.charAt(i) == '^') {
                this._robot.keyPress(18);
                this._robot.keyPress(buf.charAt(++i));
                this._robot.keyRelease(18);
                continue;
            }
            if (buf.charAt(i) == ' ') {
                this._robot.waitForIdle();
                continue;
            }
            this._robot.keyPress(buf.charAt(i));
        }
    }

    void ecc(String buf) throws AWTException {
        if (this._robot == null) {
            this._robot = new Robot();
        }
        StringTokenizer token = new StringTokenizer(buf);
        String mName = token.nextToken();
        if (!token.hasMoreTokens()) {
            return;
        }
        mName = token.nextToken();
        DeviceManager.getInstance().requestFocus();
        if (mName.equals("port")) {
            this.eccPort(token);
        } else {
            this.eccDm(token, mName);
        }
    }

    private void eccDm(StringTokenizer token, String actionName) {
        try {
            DeviceManager.getInstance().deviceAction(actionName);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance().getView(), ex);
        }
        if (!token.hasMoreTokens()) {
            return;
        }
        String keyString = token.nextToken();
        if (keyString == null) {
            return;
        }
        String buf = keyString;
        this._robot.waitForIdle();
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) == '^') {
                this._robot.keyPress(18);
                this._robot.keyPress(buf.charAt(++i));
                this._robot.keyRelease(18);
                continue;
            }
            if (buf.charAt(i) == ' ') {
                this._robot.waitForIdle();
                continue;
            }
            this._robot.keyPress(buf.charAt(i));
        }
    }

    private void eccPort(StringTokenizer token) {
        String mName = token.nextToken();
        PhysicalElement[] selected = DeviceManager.getInstance().getView().getSelected();
        if (selected.length == 0) {
            return;
        }
        try {
            Class[] types = new Class[]{selected.getClass()};
            Method m = Class.forName("com.cisco.dcbu.dm.PhysicalElement").getMethod(mName, types);
            Object[] args = new Object[]{selected};
            m.invoke((Object)selected[0], args);
        }
        catch (InvocationTargetException ex) {
            Exception realEx = (Exception)ex.getTargetException();
            if (realEx == null) {
                realEx = ex;
            }
            Util.errorMessage((Component)DeviceManager.getInstance().getView(), mName + ": " + realEx.toString());
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance().getView(), ex);
        }
        if (!token.hasMoreTokens()) {
            return;
        }
        String keyString = token.nextToken();
        if (keyString == null) {
            return;
        }
        String buf = keyString;
        this._robot.waitForIdle();
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) == '^') {
                this._robot.keyPress(18);
                this._robot.keyPress(buf.charAt(++i));
                this._robot.keyRelease(18);
                continue;
            }
            if (buf.charAt(i) == ' ') {
                this._robot.waitForIdle();
                continue;
            }
            this._robot.keyPress(buf.charAt(i));
        }
    }

    void select(String buf) {
        Discover.getInstance();
        SwitchAttrIf ifIndexIf = Discover.getRoot();
        PhysicalView view = DeviceManager.getInstance().getView();
        view.clearSelection();
        StringTokenizer st = new StringTokenizer(buf.substring(7), ",-", true);
        boolean thru = false;
        int start = 0;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.charAt(0) == ',') continue;
            if (t.charAt(0) == '-') {
                thru = true;
                continue;
            }
            try {
                int ifIndex = ifIndexIf.nameToIfIndex(t);
                if (thru) {
                    for (int i = start; i <= ifIndex; ++i) {
                        PhysicalElement e = view.find(AbstractPort.class, i);
                        if (e == null) continue;
                        e.setSelected(true);
                    }
                    thru = false;
                } else {
                    PhysicalElement e = view.find(AbstractPort.class, ifIndex);
                    if (e != null) {
                        e.setSelected(true);
                    }
                }
                start = ifIndex;
            }
            catch (IllegalArgumentException ex) {}
        }
        view.repaint();
        Controls._ViewAttrButton.setEnabled(true);
    }
}

