/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.Controls;
import com.cisco.dcbu.dm.DM;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.SystemAttrIf;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.CheckUpgrade;
import com.cisco.dcbu.lib.jnm.SwitchAttrIf;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.TrapRegister;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTrapSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.proxy.ProxyTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.AbstractIpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.snmp.transport.UdpTransportOptions;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.NetUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.swing.JScrollPane;

public final class Discover {
    static boolean _Trace;
    static boolean _IsTrapRegisterNeeded;
    static boolean _ReDiscoverInProgress;
    static int[][] _Oid;
    public static SnmpOID _SysObjectIDOid;
    public static SnmpOID _SysDescrOid;
    public static SnmpOID _SysNameOid;
    public static SnmpOID _entPhysicalVendorTypeOid;
    static HashMap _Images;
    static String _Dms;
    static String _DeviceName;
    static String _DeviceNameWithSysName;
    static String _LoginDeviceName;
    static String _sysName;
    static String _Directory;
    static SwitchAttrIf _IfIndexIf;
    static SnmpOID _SysObjectID;
    static String _SysDescr;
    static String _SysVersion;
    static String _SysVersionFrmSup;
    static byte[] _switchWWN;
    static SwitchVersion _SysVersionObject;
    static int _MaxVarBindInPDU;
    static SnmpPeer _Peer;
    static SystemAttrIf _root;
    static PhysicalElement _rootElement;
    Class _deviceClass;
    static Discover _Instance;
    MediaTracker _tracker;
    private static int _SnmpLocalPort;
    static String _localVPNAddr;
    static SnmpSession _SnmpSession;
    public static boolean _UseProxy;
    public static InetSocketAddress _ProxyAddr;
    public static String _ProxyAddrString;
    public static int _summaryPollInterval_mds;
    public static int _summaryPollInterval_n5k;

    public static Discover getInstance() {
        if (_Instance == null) {
            _Instance = new Discover();
            try {
                Discover._Instance._tracker = new MediaTracker(DeviceManager.getInstance()._view);
                _SnmpSession = SnmpSession.getInstance();
                _Peer = new SnmpPeer(null);
                _Peer.setSession(_SnmpSession);
                SnmpPeer.addPeer(_Peer);
                String localPort = System.getProperty("snmp.localport");
                _SnmpLocalPort = 0;
                if (localPort != null && localPort.length() > 0) {
                    try {
                        _SnmpLocalPort = Integer.parseInt(localPort);
                    }
                    catch (NumberFormatException ex1) {
                        // empty catch block
                    }
                }
                SnmpTrapSession trapSession = new SnmpTrapSession();
                String exMsg = "";
                while (DM._Port <= DM._Port_Max) {
                    try {
                        trapSession.open(DM._Port);
                        break;
                    }
                    catch (Exception ex) {
                        exMsg = ex.getMessage();
                        ++DM._Port;
                    }
                }
                if (DM._Port > DM._Port_Max) {
                    if (_IsTrapRegisterNeeded) {
                        String msg = exMsg.indexOf("Cannot bind") != -1 || exMsg.indexOf("Cannot assign") != -1 ? "Another application has opened local trap port " + DM._Port + ".\n" + "DM will rely solely on regular device polling to detect changes." : exMsg;
                        DM._Port = -1;
                        throw new Exception(msg);
                    }
                } else {
                    SnmpTrapSession.setTrace(SnmpSession.isTrace());
                    TrapRegister._Port = trapSession.getLocalPort();
                    trapSession.getTrapChannel().addConsumer(DeviceManager.getInstance().getView());
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)DeviceManager.getInstance(), ex);
            }
        }
        return _Instance;
    }

    public void reopen() {
        try {
            this.discover(_Dms);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex);
        }
    }

    public void open(String deviceName, String userName, String authPassword, String privPassword, InetSocketAddress proxyAddr) throws SnmpException, UnknownHostException, Exception {
        boolean isCancel;
        AbstractIpTransportOptions opt = null;
        if (SnmpSession.isTrace()) {
            System.out.println("Discover::open  _UseProxy=" + _UseProxy + "  proxyAddr=" + proxyAddr);
        }
        if (SnmpSession._PreferTcp) {
            if (SnmpSession.isTrace()) {
                System.out.println("PreferTcp,  ignore Proxy");
            }
            _SnmpSession = SnmpSession.getInstance("tcp");
            _SnmpSession.open("tcp", new TcpTransportOptions(null, 161, _SnmpLocalPort));
        } else {
            String transName;
            if (_UseProxy && proxyAddr != null) {
                System.out.println("UserProxy...");
                transName = "proxy";
                if (!InetAddress.getLocalHost().equals(proxyAddr.getAddress())) {
                    System.out.println("UserProxy...  new ProxyTransportOptions");
                    opt = new ProxyTransportOptions(proxyAddr.getAddress(), proxyAddr.getPort());
                    if (_ProxyAddr != proxyAddr) {
                        _ProxyAddr = proxyAddr;
                    }
                } else {
                    transName = "udp";
                    System.out.println("UserProxy...   use udp  InetAddress equals");
                    opt = new UdpTransportOptions(null, _SnmpLocalPort);
                }
            } else {
                System.out.println("UserProxy...  use udp  !UseProxy");
                transName = "udp";
                opt = new UdpTransportOptions(null, _SnmpLocalPort);
            }
            _SnmpSession.open(transName, opt);
        }
        _Peer.setSession(_SnmpSession);
        PhysicalStatus.getInstance().setStatusTimer(false);
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(3));
        pdu.addNull(_SysObjectIDOid);
        pdu.addNull(_SysDescrOid);
        pdu.addNull(_SysNameOid);
        pdu.addNull(_entPhysicalVendorTypeOid);
        try {
            pdu.setAddress(InetAddress.getByName(deviceName));
        }
        catch (UnknownHostException ex) {
            StringBuffer sb = new StringBuffer(deviceName + " timed out.\nBusy network, no route, Unknown host, or snmpd is unresponsive.");
            if (DM._UseV3) {
                SnmpPeer.addPeer(_Peer);
                if (privPassword != null) {
                    sb.append("\nPlease check that your privacy password is correct.");
                }
            }
            throw new SnmpException(sb.toString());
        }
        catch (Exception ex) {
            throw ex;
        }
        pdu.setTimeout(SnmpPeer._Timeout);
        pdu.setPort(161);
        SnmpPeer tmpPeer = null;
        SnmpSession session = _Peer.getSession();
        SnmpPDU response = null;
        try {
            if (DM._UseV3) {
                SnmpPeer.removeAllPeers();
                tmpPeer = new SnmpPeer(pdu.getAddress(), session, userName, authPassword, DM._AuthProtocol, privPassword, DM._PrivProtocol);
                SnmpPeer.addPeer(tmpPeer);
                response = tmpPeer.send(pdu);
            } else {
                SnmpPeer.removeAllPeers();
                tmpPeer = new SnmpPeer(null);
                tmpPeer.setSession(_SnmpSession);
                SnmpPeer.addPeer(tmpPeer);
                tmpPeer.setAddress(pdu.getAddress());
                tmpPeer.setVersion(1);
                tmpPeer.setReadCommunity(userName);
                tmpPeer.setWriteCommunity(authPassword);
                response = tmpPeer.send(pdu);
            }
        }
        catch (SnmpException ex) {
            if (ex.getMessage().startsWith("timeout")) {
                StringBuffer sb = new StringBuffer(deviceName + " timed out.\nBusy network, no route, or snmpd is unresponsive.");
                if (DM._UseV3) {
                    SnmpPeer.addPeer(_Peer);
                    if (privPassword != null) {
                        sb.append("\nPlease check that your privacy password is correct.");
                    }
                }
                throw new SnmpException(sb.toString());
            }
            throw ex;
        }
        if (response.getVar(0) instanceof SnmpNull) {
            throw new SnmpException("Can't read SysObjectID");
        }
        if (_root != null && (isCancel = _root.closeDevice())) {
            return;
        }
        String dms = DmId.get((SnmpOID)response.getVar(0), response.getVar(1).toString(), response.getVar(3));
        try {
            String directory = this.convertClassToDir(dms);
            if (!dms.equals(_Dms)) {
                this.loadDMS(directory);
            }
            SystemAttrIf tmpRoot = (SystemAttrIf)Class.forName(dms).newInstance();
            tmpRoot.preDiscoveryCheck(response, tmpPeer);
        }
        catch (SnmpException ex) {
            throw new SnmpException(ex.getMessage());
        }
        _Peer = DM._UseV3 ? tmpPeer : tmpPeer;
        SnmpPeer.removeAllPeers();
        SnmpPeer.addPeer(_Peer);
        int[] sysObjectID = ((SnmpOID)response.getVar(0)).getValue();
        int type = sysObjectID[sysObjectID.length - 1];
        if (!DmId.isQuail(sysObjectID) && !DmId.isN7K(sysObjectID) && CheckUpgrade.isUpgradeNeeded(response.getVar(1).toString(), deviceName, DeviceManager.getInstance(), 1, type)) {
            System.exit(0);
        }
        _SysVersion = response.getVar(1).toString();
        if (_root != null) {
            DeviceManager.getInstance().showPhysicalView();
            _SysVersionObject = null;
            _SysVersionFrmSup = null;
            _switchWWN = null;
        }
        session.clearStats();
        DeviceManager.getInstance()._view.clear();
        DialogListener.getInstance().closeDeviceDialogs();
        _SysObjectID = (SnmpOID)response.getVar(0);
        _SysDescr = response.getVar(1).toString();
        _sysName = response.getVar(2).toString();
        _LoginDeviceName = deviceName;
        if (!_sysName.equals(deviceName) && !_sysName.equals("")) {
            _DeviceName = _sysName;
            _DeviceNameWithSysName = _sysName;
        } else {
            _DeviceNameWithSysName = deviceName;
            _DeviceName = deviceName;
        }
        this.discover(dms);
    }

    private String convertClassToDir(String classString) {
        String directory = classString.replace('.', '/');
        int lastSlash = directory.lastIndexOf(47);
        if (lastSlash != -1) {
            directory = "/" + directory.substring(0, lastSlash + 1);
        }
        return directory;
    }

    void discover(String dms) throws SnmpException, UnknownHostException {
        String directory = this.convertClassToDir(dms);
        boolean isNewDeviceFamily = !dms.equals(_Dms);
        _Dms = dms;
        if (isNewDeviceFamily) {
            _Images.clear();
            this.loadDMS(directory);
            _Directory = directory;
        }
        DeviceManager.getInstance().setStatus(" ");
        try {
            _root = (SystemAttrIf)Class.forName(dms).newInstance();
            _rootElement = (PhysicalElement)_root.getRoot().getConstructor(null).newInstance(null);
            if (isNewDeviceFamily) {
                DeviceManager dm = DeviceManager.getInstance();
                dm.removeDeviceUI();
                _root.addUI(dm._menubar, dm._toolbar, dm._listener);
                dm._menubar.add(Controls.getHelpMenu());
                dm._toolbar.add(Controls._HelpButton);
            }
            _IfIndexIf = (SwitchAttrIf)((Object)_root);
            _MaxVarBindInPDU = _root.getMaxVarBindInPDU();
            if (_MaxVarBindInPDU == 0) {
                _MaxVarBindInPDU = 40;
            }
            DialogListener.getInstance()._dialogClass = _root.getDialogClass();
            DMPanel.initMibVariableFormat(_root.getMibVariableFormatClass());
            DMPanel.initMibVariableSet(_root.getMibVariableSetClass());
            _root.discoverySetup(false);
            this.createPhysicalView(_rootElement, DeviceManager.getInstance()._view);
            StringBuffer title = new StringBuffer(64);
            DeviceManager.getInstance();
            title.append(DeviceManager._AppName);
            title.append(" - ");
            title.append(_DeviceNameWithSysName);
            if (DM._UseV3) {
                title.append(" [");
                title.append(_Peer.getUserName());
                if (_Peer.getPrivPassword() != null) {
                    title.append(", encrypted");
                }
                title.append(']');
            }
            DeviceManager.getInstance().setTitle(title.toString());
            _root.endDiscovery(false);
            String trapFailedMsg = "Trap Register failed-update at poll interval.";
            if (_IsTrapRegisterNeeded) {
                if (DM._Port != -1) {
                    try {
                        _root.trapRegister(_Peer);
                    }
                    catch (Exception ex) {
                        DeviceManager.getInstance().setStatus(trapFailedMsg);
                        DefaultLogger._DefLogger.debug((Object)(trapFailedMsg + " " + ex.getMessage()));
                    }
                } else {
                    DeviceManager.getInstance().setStatus(trapFailedMsg);
                    DefaultLogger._DefLogger.debug((Object)trapFailedMsg);
                }
            }
        }
        catch (Exception ex) {
            if (SnmpSession.isTrace()) {
                ex.printStackTrace();
            }
            throw new SnmpException(ex.getMessage());
        }
    }

    synchronized void rediscover() {
        if (_ReDiscoverInProgress) {
            return;
        }
        _ReDiscoverInProgress = true;
        PhysicalStatus.getInstance().setStatusTimer(false);
        PhysicalView view = DeviceManager.getInstance()._view;
        try {
            view.clear();
            DeviceManager.getInstance().setStatus(" ");
            _rootElement = (PhysicalElement)_root.getRoot().getConstructor(null).newInstance(null);
            _root.discoverySetup(true);
            this.createPhysicalView(_rootElement, view);
            _root.endDiscovery(true);
            _root.refresh();
        }
        catch (Exception ex) {
            DefaultLogger._DefLogger.debug((Object)ex);
        }
        view.repaint();
        _ReDiscoverInProgress = false;
    }

    void loadDMS(String directory) throws SnmpException {
        String fabricDirectory = "/com/cisco/dcbu/lib/mds/";
        try {
            DataInputStream is = new DataInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(fabricDirectory + "mib.dat")));
            MibNode.load(is);
            is.close();
        }
        catch (Exception ex) {
            throw new SnmpException("Can't open " + fabricDirectory + "mib.dat");
        }
        try {
            DMPanel.initProperties(fabricDirectory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void createPhysicalView(PhysicalElement e, PhysicalView view) throws Exception {
        view.addElement(e);
        e.setView(view);
        String bitmap = e.getBitmap();
        if (bitmap == null) {
            Dimension d = e.getSize();
            e._image = view.createImage(1, 1);
            e._rect = new Rectangle(0, 0, d.width, d.height);
        } else {
            e._image = this.getImage(e.getBitmap());
            e._rect = new Rectangle(0, 0, e._image.getWidth(view), e._image.getHeight(view));
        }
        e._index = new int[1];
        Graphics g = view.createOffScreenImage(e._rect.width, e._rect.height);
        g.drawImage(e._image, 0, 0, view);
        this.createChildren(e, view, g, 0, 0);
        JScrollPane sp = (JScrollPane)DeviceManager.getInstance()._tab.getComponentAt(0);
        Dimension d = new Dimension(view.getPreferredSize());
        sp.setPreferredSize(view.getPreferredSize());
        DeviceManager.getInstance().offsetViewSizeByTab(d);
        DeviceManager.getInstance()._tab.setPreferredSize(d);
        this.setSlotMembers(view);
        if (PhysicalStatus._StatusPollTimerEnable) {
            PhysicalStatus.getInstance().setStatusTimer(true);
            PhysicalStatus.getInstance().resetStatusTimerInterval();
        } else {
            PhysicalStatus.getInstance().getStatus();
        }
        DeviceManager.getInstance().getLegendMenuButton().setLegendVisble(true);
        view.invalidate();
        DeviceManager.getInstance().invalidate();
        DeviceManager.getInstance().pack();
    }

    void createChildren(PhysicalElement parent, PhysicalView view, Graphics g, int x, int y) throws Exception {
        Class[] children = parent.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            Class[] subClasses = parent.getChildSubclass(children[i]);
            int[][] pos = parent.getChildPos(children[i]);
            if (pos == null) continue;
            for (int j = 0; j < pos.length; ++j) {
                String bitmap;
                Class c = children[i];
                if (subClasses != null && (c = subClasses[j]) == null) continue;
                PhysicalElement e = (PhysicalElement)c.getConstructor(null).newInstance(null);
                e._index = parent.getChildIndex(children[i], j);
                e._parent = parent;
                if (e._index == null) {
                    if (parent._index[0] == 0) {
                        e._index = new int[1];
                        e._index[0] = j + 1;
                    } else {
                        int[] childIndex = new int[parent._index.length + 1];
                        System.arraycopy(parent._index, 0, childIndex, 0, parent._index.length);
                        childIndex[childIndex.length - 1] = j + 1;
                        e._index = e.getStatusIndex(childIndex);
                    }
                }
                if ((bitmap = e.getBitmap()) == null) continue;
                view.addElement(e);
                e.setView(view);
                e._image = this.getImage(bitmap);
                e._rect = new Rectangle(pos[j][0] + x, pos[j][1] + y, e._image.getWidth(view), e._image.getHeight(view));
                g.drawImage(e._image, e._rect.x, e._rect.y, view);
                this.createChildren(e, view, g, e._rect.x, e._rect.y);
            }
        }
    }

    public Image getImage(String fName) throws IOException {
        Image image = (Image)_Images.get(fName);
        if (image == null) {
            image = Toolkit.getDefaultToolkit().createImage(this.getImageURL(fName));
            this._tracker.addImage(image, 0);
            try {
                this._tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            _Images.put(fName, image);
        }
        return image;
    }

    Image getImage(InputStream in) throws IOException {
        byte[] buffer = new byte[in.available()];
        in.read(buffer);
        Image image = Toolkit.getDefaultToolkit().createImage(buffer);
        this._tracker.addImage(image, 0);
        try {
            this._tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return image;
    }

    private URL getImageURL(String fName) {
        URL url = this.getImageURL(_root.getClass(), fName);
        if (url == null) {
            DefaultLogger._DefLogger.debug((Object)("Image not found :" + fName));
        }
        return url;
    }

    private URL getImageURL(Class myClass, String fName) {
        URL url = null;
        if (DmSystem.class.isAssignableFrom(myClass)) {
            String pkgDir = this.convertClassToDir(myClass.getName());
            StringBuffer sb = new StringBuffer(64);
            sb.append(pkgDir).append("bitmaps/").append(fName);
            url = this.getClass().getResource(sb.toString());
            if (url == null && myClass.getSuperclass() != null) {
                url = this.getImageURL(myClass.getSuperclass(), fName);
            }
        }
        return url;
    }

    void setSlotMembers(PhysicalView view) {
        ((SystemAttrIf)((Object)_IfIndexIf)).setSlotMembers(new int[30], view._elements);
    }

    public static final void setSysObjectID(SnmpOID sysObjectID) {
        _SysObjectID = sysObjectID;
    }

    public static final int[] getSysObjectID() {
        return _SysObjectID.getValue();
    }

    public static final String getDeviceName() {
        return _DeviceName;
    }

    public static final String getLoginDeviceName() {
        return _LoginDeviceName;
    }

    public static final void setSystemName(String sysName) {
        if (!_sysName.equals(sysName) && !sysName.equals("")) {
            _DeviceName = sysName;
        }
        if (_DeviceNameWithSysName.indexOf(_sysName) != -1) {
            _DeviceNameWithSysName = _DeviceNameWithSysName.replaceFirst(_sysName, sysName);
            String title = DeviceManager.getInstance().getTitle();
            if (title.indexOf(_sysName) != -1) {
                title = title.replaceFirst(_sysName, sysName);
                DeviceManager.getInstance().setTitle(title);
            }
        }
        _sysName = sysName;
    }

    public static final String getSystemName() {
        return _sysName == null ? "" : _sysName;
    }

    public static final void setSysDescr(String sysDescr) {
        _SysDescr = sysDescr;
    }

    public static final String getSysDescr() {
        return _SysDescr;
    }

    public static final String getSysVersion() {
        return _SysVersion;
    }

    public static final SwitchVersion getSysVersionObject() {
        return new SwitchVersion(Discover.getSysVersionWithMinor());
    }

    public static final void setSysVersion(String sysVersion) {
        _SysVersion = sysVersion;
        _SysVersionFrmSup = null;
        _SysVersionObject = null;
    }

    public static final String getSysVersionSup() {
        return _SysVersionFrmSup;
    }

    public static final boolean setSysVersionFrmSup(String sysVersionFrmSup) {
        boolean isRediscovery = false;
        if (_SysVersionFrmSup != null && !_SysVersionFrmSup.equals(sysVersionFrmSup) && !Discover.isSysVersionEqual(sysVersionFrmSup)) {
            Discover.getInstance().rediscover();
            isRediscovery = true;
        }
        _SysVersionFrmSup = sysVersionFrmSup;
        return isRediscovery;
    }

    public static final String getSysVersionInterim() {
        if (_SysVersionFrmSup != null && !_SysVersionFrmSup.equals("")) {
            int endIdx = _SysVersionFrmSup.indexOf(40, 0);
            return _SysVersionFrmSup.substring(0, endIdx == -1 ? _SysVersionFrmSup.length() : endIdx);
        }
        int beginIdx = _SysVersion.indexOf("Interim version");
        beginIdx = beginIdx != -1 ? (beginIdx += 16) : _SysVersion.indexOf("Version") + 8;
        int endIdx = _SysVersion.indexOf(40, beginIdx);
        return _SysVersion.substring(beginIdx, endIdx == -1 ? _SysVersion.length() : endIdx);
    }

    public static final String getSysVersionWithMinor() {
        if (_SysVersionFrmSup != null && !_SysVersionFrmSup.equals("")) {
            int endIdx = _SysVersionFrmSup.indexOf(41, 0);
            return _SysVersionFrmSup.substring(0, endIdx == -1 ? _SysVersionFrmSup.length() : endIdx + 1);
        }
        int beginIdx = _SysVersion.indexOf("Interim version");
        beginIdx = beginIdx != -1 ? (beginIdx += 16) : _SysVersion.indexOf("Version") + 8;
        int endIdx = _SysVersion.indexOf(41, beginIdx);
        return _SysVersion.substring(beginIdx, endIdx == -1 ? _SysVersion.length() : endIdx + 1);
    }

    public static final boolean isSysVersionlessThan(String version) {
        if (_SysVersionObject == null) {
            _SysVersionObject = Discover.getSysVersionObject();
        }
        return _SysVersionObject.lessThan(new SwitchVersion(version));
    }

    public static final boolean isSysVersionEqual(String version) {
        if (_SysVersionObject == null) {
            _SysVersionObject = Discover.getSysVersionObject();
        }
        return _SysVersionObject.equals(new SwitchVersion(version));
    }

    public static final boolean isSysVersionlessThanEqual(String version) {
        if (_SysVersionObject == null) {
            _SysVersionObject = Discover.getSysVersionObject();
        }
        return _SysVersionObject.lessThanEqual(new SwitchVersion(version));
    }

    public static final boolean isSysVersionGreaterThanEqual(String version) {
        if (_SysVersionObject == null) {
            _SysVersionObject = Discover.getSysVersionObject();
        }
        return !_SysVersionObject.lessThan(new SwitchVersion(version));
    }

    public static final SnmpPeer getPeer() {
        return _Peer;
    }

    public static final SwitchAttrIf getRoot() {
        return _IfIndexIf;
    }

    public static final SystemAttrIf getSystemAttrIf() {
        return _root;
    }

    public static final byte[] getSwitchWWN() {
        if (_switchWWN == null) {
            _switchWWN = DmSystem.getSwitchWWN(_Peer);
        }
        return _switchWWN;
    }

    public static final boolean getIsTrapRegisterNeeded() {
        return _IsTrapRegisterNeeded;
    }

    public static final void setIsTrapRegisterNeeded(boolean isNeeded) {
        _IsTrapRegisterNeeded = isNeeded;
    }

    public static final PhysicalElement root() {
        return _rootElement;
    }

    public static final void setTrace(boolean trace) {
        _Trace = trace;
    }

    public static final String getDirectory() {
        return _Directory;
    }

    public static final boolean getIsV3() {
        return DM._UseV3;
    }

    public static final String getLocalVPNAddress() {
        return _localVPNAddr;
    }

    public static final boolean getIsReDiscoverInProgress() {
        return _ReDiscoverInProgress;
    }

    public static final boolean isTrapRegisterNeeded() {
        return _IsTrapRegisterNeeded;
    }

    public static final void testVPN() {
        _localVPNAddr = _Peer.getSession().getLocalVPNAddress();
        if (_Peer != null && _Peer.getSession().getLocalVPNAddress() == null && DmSystem.supportVPNDetect()) {
            String vpnAddr = NetUtil.getLocalHostFromSwitch(_Peer.getAddress());
            _Peer.getSession().setLocalHost(vpnAddr);
            if (vpnAddr != null) {
                if (NetUtil.isLocalHost(vpnAddr)) {
                    vpnAddr = "";
                } else {
                    DefaultLogger._DefLogger.debug((Object)("Detected VPN on " + vpnAddr));
                    _localVPNAddr = vpnAddr;
                }
            } else {
                String userSpecifiedVPN = System.getProperty("vpn.ipaddress");
                if (userSpecifiedVPN != null && userSpecifiedVPN.trim().length() > 0) {
                    try {
                        SnmpIpAddress.parse(userSpecifiedVPN.trim());
                    }
                    catch (Exception ex) {
                        DefaultLogger._DefLogger.debug((Object)("Invalid user specified VPN Address " + userSpecifiedVPN));
                    }
                    DefaultLogger._DefLogger.debug((Object)("Using user specified VPN Address " + userSpecifiedVPN));
                    _localVPNAddr = userSpecifiedVPN;
                }
            }
            _Peer.getSession().setLocalVPNAddress(vpnAddr);
        }
    }

    static {
        _IsTrapRegisterNeeded = true;
        _ReDiscoverInProgress = false;
        _Oid = new int[][]{{1, 3, 6, 1, 2, 1, 1, 1, 0}, {1, 3, 6, 1, 2, 1, 1, 2, 0}, {1, 3, 6, 1, 2, 1, 1, 5, 0}, {1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 3}};
        _SysObjectIDOid = new SnmpOID(_Oid[1]);
        _SysDescrOid = new SnmpOID(_Oid[0]);
        _SysNameOid = new SnmpOID(_Oid[2]);
        _entPhysicalVendorTypeOid = new SnmpOID(_Oid[3], 149);
        _Images = new HashMap();
        _SnmpLocalPort = 0;
        _summaryPollInterval_mds = 1;
        _summaryPollInterval_n5k = 1;
    }
}

