/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTable;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EnumRule;
import com.cisco.dcbu.dm.PhysicalStatus;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpIdList;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.MdsPortChooser;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxPanel;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Filter;
import com.cisco.dcbu.lib.ui.FindDialog;
import com.cisco.dcbu.lib.ui.GroupButtonPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class EditForm
extends DMPanel
implements ActionListener,
SnmpCallbackIf,
TableModelListener,
ListSelectionListener {
    public static final Color _FgColor = (Color)UIManager.getDefaults().get("Label.foreground");
    protected JComponent[] _values;
    public static final int AUTO_RESIZE_OFF_WIDTH = 1008;
    protected JLabel[] _labels;
    protected EnumRule[] _enumRule;
    protected DMPanel.ChangedFieldListener _changeListener;
    protected JScrollPane _scrollPane;
    protected DmTable _table;
    protected DmTableModel _tableModel;
    protected Array _data;
    int _multipleRow;
    int[] _enumGrid;
    protected boolean _isRefresh;
    protected Dimension _size;
    protected MenuButton _cfsButton;
    FindDialog _findDialog;

    public EditForm(String[] vars) {
        super(vars);
        this._container = new JPanel(new GridBagLayout());
    }

    @Override
    public void dispose() {
        this._changeListener = null;
        if (this._findDialog != null) {
            this._findDialog.dispose();
        }
    }

    @Override
    protected void setParentPanel(DMPanel panel) {
        this._parentPanel = panel;
    }

    @Override
    protected boolean isBuilt() {
        return this._mibNodes != null;
    }

    @Override
    protected void build() {
        AbstractButton b;
        if (this.isMultiple()) {
            this.buildModel();
            this.buildTable();
            this._container.setLayout(new BorderLayout());
            this._formPanel = new JPanel(new FlowLayout(0, 1, 2));
            this._container.add("North", this._formPanel);
            this._scrollPane = new JScrollPane();
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this._container.add("Center", this._scrollPane);
            this._scrollPane.setViewportView(this._table);
            this._scrollPane.setPreferredSize(this._table.calcPreferredSize());
        } else {
            this.buildForm();
        }
        this.removeMibVars();
        if (this._tableModel != null) {
            this._tableModel.setTable(this._table);
        }
        this.buildButtons();
        if (this._table != null) {
            this.enableButton('c', false);
            this.enableButton('P', false);
            Component[] tableChangeButtons = new Component[]{this.getButton('A'), this.getButton('u')};
            this._table.setChangeListener(tableChangeButtons);
        }
        if ((b = this.getButton("find")) != null) {
            b.setVisible(this.getFindMode() && this._table != null);
        }
    }

    @Override
    protected void removeMibVars() {
        if (this.isMultiple()) {
            this.removeColumnsUsingMibVars(this._table);
        } else {
            this.removeMibVarsFromForm();
        }
    }

    public void removeMibVarsFromForm() {
        this.addRemoveColumnUsingPerspective();
        Iterator i$ = this._removeMibVarIndicesSet.iterator();
        while (i$.hasNext()) {
            int mibVarIndex = (Integer)i$.next();
            this._removeMibVarsSet.add(this._vars[mibVarIndex]);
        }
        for (int i = 0; i < this._values.length && i < this._vars.length; ++i) {
            if (!this._removeMibVarsSet.contains(this._vars[i])) continue;
            if (this._labels[i] != null) {
                this._labels[i].setVisible(false);
            }
            if (this._values[i] == null) continue;
            this._values[i].setVisible(false);
        }
    }

    protected void buildForm() {
        this._labels = new JLabel[this._vars.length];
        this._values = new JComponent[this._vars.length];
        this._mibNodes = new MibNode[this._vars.length];
        for (int i = 0; i < this._values.length; ++i) {
            if (this._vars[i].charAt(0) == '-') {
                if (this._vars[i].length() <= 1) {
                    this._values[i] = new DialogSeparator();
                    continue;
                }
                this._values[i] = new DialogSeparator(this._vars[i].substring(1));
                continue;
            }
            this._mibNodes[i] = MibNode.get(this._vars[i]);
            if (this.isEditable(this._mibNodes[i])) {
                this._values[i] = this.buildComponent(this._vars[i], this._mibNodes[i], i);
                this.addChangeListener(i);
                this._isEditable = true;
            } else {
                this._values[i] = this.buildNonEditableComponent(this._vars[i], this._mibNodes[i], i);
                this._values[i].setFont(ChangedCellRenderer.getNormalFont());
                this._values[i].setForeground(Color.black);
            }
            if (this._values[i] instanceof JCheckBox) continue;
            this._labels[i] = this.createFormLabel(this._vars[i], i);
        }
        if (this._enumRule != null) {
            EnumRuleListener erl = new EnumRuleListener();
            for (int i = 0; i < this._enumRule.length; ++i) {
                JToggleButton rb = ((RadioButtonPanel)this._values[this._enumRule[i]._srcIndex]).getButton(this._enumRule[i]._enum);
                rb.addActionListener(erl);
            }
        }
        this.layoutForm();
        ((JPanel)this._container).setBorder(DialogUtil._Margin);
        this._size = this._container.getPreferredSize();
    }

    protected JLabel createFormLabel(String mibVar, int index) {
        return new JLabel(this.getFormLabel(mibVar, index) + ":", 4);
    }

    protected String getFormLabel(String mibVar, int index) {
        String v = this.trim(mibVar);
        v = v.replace("<html>", "");
        v = v.replace("<br>", " ");
        return v;
    }

    protected void layoutForm() {
        DialogUtil.buildPanel(this._container, this._labels, this._values);
    }

    protected void buildModel() {
        int i;
        int numMibVars = 0;
        for (i = 0; i < this._vars.length; ++i) {
            if (this._vars[i].charAt(0) == '-') continue;
            ++numMibVars;
        }
        if (numMibVars != this._vars.length) {
            String[] vars = new String[numMibVars];
            int j = 0;
            for (int i2 = 0; i2 < this._vars.length; ++i2) {
                if (this._vars[i2].charAt(0) == '-') continue;
                vars[j++] = this._vars[i2];
            }
            this._vars = vars;
        }
        if (this._tableModel == null) {
            this._tableModel = this.buildTableModel();
        }
        this._tableModel.build(this._indexTitle, this._vars, this._prefixes);
        if (this._indexTitles != null && this._indexTitles.length > 0) {
            this._tableModel.setIndexTitles(this._indexTitles);
            String[] headers = this._tableModel.getHeaders();
            String[] newHeaders = new String[headers.length + this._indexTitles.length - 1];
            System.arraycopy(this._indexTitles, 0, newHeaders, 0, this._indexTitles.length);
            System.arraycopy(headers, 1, newHeaders, this._indexTitles.length, newHeaders.length - this._indexTitles.length);
            this._tableModel.setHeaders(newHeaders);
            boolean[] editable = this._tableModel.getEditable();
            boolean[] newEditable = new boolean[editable.length + this._indexTitles.length - 1];
            System.arraycopy(editable, 1, newEditable, this._indexTitles.length, editable.length - 1);
            for (int i3 = 0; i3 < this._indexTitles.length; ++i3) {
                newEditable[i3] = false;
            }
            this._tableModel.setEditable(newEditable);
        }
        this._tableModel.setErrorComponent(this._parent);
        this._data = new Array(this._parent._multipleIndeces.length);
        this._mibNodes = this._tableModel._mibNodes;
        this._isEditable = this._tableModel.isEditable();
        for (i = 0; i < this._parent._multipleIndeces.length; ++i) {
            Object[] row = this.buildTableRow(this.getMultipleIndex(i));
            this._data.addElement(row);
        }
        this._tableModel.setData(this._data);
        this._tableModel.addTableModelListener(this);
        if (this._colHeaders != null) {
            for (i = 0; i < this._colHeaders.length; ++i) {
                if (this._colHeaders[i] == null) continue;
                this._tableModel.setHeader(i + this._colHeadersOffset, this._colHeaders[i]);
            }
        }
    }

    protected DmTableModel buildTableModel() {
        return new DmTableModel();
    }

    protected void buildTable() {
        this._table = new DmTable(this._tableModel);
        if (this._indexTitles != null && this._indexTitles.length > 0) {
            this._table.setIndexTitles(this._indexTitles);
        }
        this._table.setDMPanel(this);
        this._table.addEnumCellEditor(this._mibNodes);
        if (this._indexColumnRenderer != null) {
            this._table.getColumnModel().getColumn(0).setCellRenderer(this._indexColumnRenderer);
        } else if (!this._indexVisible) {
            this._table.removeColumn(this._table.getColumnModel().getColumn(0));
        }
        ListSelectionModel tableListener = this._table.getSelectionModel();
        tableListener.addListSelectionListener(this);
        tableListener.setSelectionMode(1);
        this._headerListener = new HeaderListener();
        this._table.getTableHeader().addMouseListener(this._headerListener);
        this._table.setSortable(true);
        this._tableModel.addTableModelListener(this);
        if (this._colGroup != null) {
            this._table.buildColGroups(this._colGroup, this._colGroupRanges);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean enable = e != null && e.getType() == 0 && this._tableModel.isChanged();
        this.enableButton('A', enable);
    }

    protected JComponent buildNonEditableComponent(String mibVar, MibNode mibNode, int index) {
        return new JLabel();
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        String tc = mibNode.getTCLabel();
        if (tc != null) {
            if (tc.equals("TruthValue") || tc.equals("Action")) {
                return new JCheckBox(this.trim(mibVar));
            }
            if (tc.equals("Password")) {
                return new JPasswordField();
            }
        }
        if (this.getApplicableEnums(mibNode) != null) {
            int grid;
            Object[] enums = this.getApplicableEnums(mibNode);
            if (enums.length < (grid = this.getEnumGrid(index)) * 2) {
                grid = enums.length;
            }
            if (mibNode.getType() == 4) {
                return new CheckBoxPanel(enums, grid);
            }
            return new RadioButtonPanel(enums, grid);
        }
        int width = this.getWidth(mibVar, mibNode, tc);
        if ((mibNode.getType() == 2 || mibNode.getType() == 66) && mibNode.getHi() != 0) {
            return new FieldPanel(width, mibNode.getLo(), mibNode.getHi(), (String)SnmpTableModel._Units.get(mibVar));
        }
        String units = (String)SnmpTableModel._Units.get(mibVar);
        if (units == null) {
            return new KTextField(width);
        }
        JLabel l = new JLabel(" " + units);
        l.setFont(ChangedCellRenderer.getNormalFont());
        return new FieldPanel(width, (JComponent)l);
    }

    protected int getWidth(String mibVar, MibNode mibNode, String tc) {
        int width = mibNode.getMaxWidth();
        if (mibNode.getType() == 4 || width > 31) {
            width = 0;
        }
        if (tc != null && tc.equals("FcNameId")) {
            width = 25;
        }
        if (tc != null && tc.equals("IscsiName")) {
            width = 40;
        }
        if (tc != null && tc.equals("DateAndTime")) {
            width = 25;
        }
        return width;
    }

    public void setEnumGrid(int index, int grid) {
        if (this._enumGrid == null) {
            this._enumGrid = new int[this._vars.length];
        }
        this._enumGrid[index] = grid;
    }

    protected int getEnumGrid(int index) {
        if (this._enumGrid != null && this._enumGrid[index] > 0) {
            return this._enumGrid[index];
        }
        return 3;
    }

    @Override
    protected Array getButtons() {
        Array<Object> b = new Array<Object>();
        if (this._isEditable) {
            b.addElement("Apply");
        }
        JButton findButton = new JButton("Find...");
        findButton.addActionListener(this);
        findButton.setActionCommand("find");
        b.addElement(findButton);
        b.addElement("Refresh");
        if (this.isMultiple()) {
            b.addElement(_ButtonAttr[3]);
            if (this._isEditable) {
                b.addElement(_ButtonAttr[4]);
                b.addElement(_ButtonAttr[5]);
            }
            b.addElement(_ButtonAttr[6]);
            b.addElement(_ButtonAttr[7]);
        }
        this._cfsButton = this.getCFSButton();
        this._cfsButton.setActionCommand("FabricWide");
        b.insertElementAt(this._cfsButton, 0);
        return b;
    }

    protected MenuButton getCFSButton() {
        return new CFSApplyButton(null, "CFS");
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (this._values[index] instanceof JTextField) {
            SnmpVar value = SnmpTableModel.getMibVariableSet(this._vars[index], ((JTextField)this._values[index]).getText(), _MibVariableSetMethods, _MibVariableSetClass);
            if (value != null && value instanceof SnmpVar) {
                return value;
            }
            return this.getVarFromString(((JTextField)this._values[index]).getText(), index);
        }
        if (this._values[index] instanceof JCheckBox) {
            SnmpVar value = SnmpTableModel.getMibVariableSet(this._vars[index], ((JCheckBox)this._values[index]).isSelected() ? Boolean.TRUE : Boolean.FALSE, _MibVariableSetMethods, _MibVariableSetClass);
            if (value != null && value instanceof SnmpVar) {
                return value;
            }
            return new SnmpInt(((JCheckBox)this._values[index]).isSelected() ? 1 : 2);
        }
        if (this._values[index] instanceof RadioButtonPanel) {
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            if (selected == -1) {
                throw new Exception(this._labels[index].getText() + " please make a selection");
            }
            MibEnum[] enums = this.getApplicableEnums(this._mibNodes[index]);
            return new SnmpInt(enums[selected].getValue());
        }
        if (this._values[index] instanceof CheckBoxPanel) {
            int byteSize = (((CheckBoxPanel)this._values[index]).getComponentCount() + 1) / 8 + 1;
            byte[] b = new byte[byteSize];
            Object[] selected = ((CheckBoxPanel)this._values[index]).getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                SnmpString.setBit(b, ((MibEnum)selected[i]).getValue() + 1);
            }
            return new SnmpString(b);
        }
        if (this._values[index] instanceof MdsPortChooser) {
            String ifName = ((MdsPortChooser)this._values[index]).getText();
            if (ifName.equals("")) {
                if (this._mibNodes[index].getHi() != 0) {
                    throw new Exception("Can not be blank.");
                }
                return null;
            }
            MdsPortChooser pc = (MdsPortChooser)this._values[index];
            if (pc.getExclusive()) {
                return new SnmpInt(Discover._IfIndexIf.nameToIfIndex(ifName));
            }
            return new SnmpIntList(ifName, Discover._IfIndexIf, DmSystem.getSlotMembers(), DmSystem.getIfNameTypes());
        }
        if (this._values[index] instanceof FieldPanel) {
            try {
                return this.getVarFromString(((FieldPanel)this._values[index]).getText(), index);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException(this.trim(this._vars[index]) + ' ' + ex.getMessage());
            }
            catch (SnmpException ex) {
                throw new NumberFormatException(this.trim(this._vars[index]) + ' ' + ex.getMessage());
            }
        }
        return null;
    }

    protected SnmpVar getVarFromString(String text, int index) throws Exception {
        try {
            String tcLabel = this._mibNodes[index].getTCLabel();
            if (this._mibNodes[index].getType() == 2) {
                if (this._mibNodes[index].getHi() != 0 && this._values[index] instanceof FieldPanel) {
                    ((FieldPanel)this._values[index]).getField().setText(((FieldPanel)this._values[index]).getText().trim());
                    return new SnmpInt(((FieldPanel)this._values[index]).getInt());
                }
                if (tcLabel != null && tcLabel.startsWith("InterfaceIndex")) {
                    return new SnmpInt(Discover.getRoot().nameToIfIndex(text));
                }
                return new SnmpInt(Integer.parseInt(text));
            }
            if (this._mibNodes[index].getType() == 66) {
                if (this._mibNodes[index].getHi() != 0 && this._values[index] instanceof FieldPanel) {
                    ((FieldPanel)this._values[index]).getField().setText(((FieldPanel)this._values[index]).getText().trim());
                    return new SnmpUnsignedInt(((FieldPanel)this._values[index]).getLong32());
                }
                return new SnmpUnsignedInt(FieldPanel.getLongNumber32(text));
            }
            if (this._mibNodes[index].getType() == 64) {
                return new SnmpIpAddress(text);
            }
            if (this._mibNodes[index].getType() == 6) {
                return new SnmpOID(text);
            }
            if (tcLabel != null) {
                if (tcLabel.equals("IdList")) {
                    return new SnmpIdList(text);
                }
                if (tcLabel.equals("FcAddressId")) {
                    return new SnmpFcAddressId(text);
                }
                if (tcLabel.equals("FcNameId")) {
                    return new SnmpWWN(text, false);
                }
                if (tcLabel.equals("FcNameIdOrZero")) {
                    return new SnmpWWN(text, true);
                }
                if (tcLabel.equals("BitmapBase0")) {
                    return new SnmpBitmap(text, true);
                }
                if (tcLabel.equals("Bitmap")) {
                    return new SnmpBitmap(text);
                }
                if (tcLabel.equals("InetAddress")) {
                    return new SnmpInetAddress(text);
                }
                if (tcLabel.equals("LongList")) {
                    return new SnmpLongList(text);
                }
                if (tcLabel.equals("DateAndTime")) {
                    return new SnmpDateAndTime(text);
                }
            }
            SnmpString s = new SnmpString(text);
            if (this._mibNodes[index].getMaxWidth() < s.getValue().length) {
                throw new NumberFormatException(" maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() > s.getValue().length) {
                throw new NumberFormatException(" minimum length is " + this._mibNodes[index].getMinWidth());
            }
            return s;
        }
        catch (NumberFormatException ex) {
            return this.postComponentErrMsg(index, ex);
        }
    }

    protected SnmpVar postComponentErrMsg(int index, Exception ex) throws Exception {
        String var = this.getErrMsgFieldName(this._vars[index], index) + ": ";
        if (ex.getMessage().startsWith(var)) {
            var = "";
        }
        if (ex.getMessage().startsWith("!")) {
            throw new Exception(ex.getMessage().substring(1));
        }
        if (ex.getMessage() != null && ex.getMessage().length() > 0) {
            if (ex.getMessage().startsWith("For input string: \"\"")) {
                throw new Exception("cannot be blank");
            }
            throw new Exception(var + ex.getMessage());
        }
        throw new Exception(var + "expected integer");
    }

    protected String getErrMsgFieldName(String mibVar, int index) {
        return this.getFormLabel(mibVar, index);
    }

    protected void setComponentValue(int i, SnmpVar v) {
        String tcLabel = this._mibNodes[i].getTCLabel();
        if (this._values[i] instanceof JLabel) {
            JLabel l = (JLabel)this._values[i];
            this.setComponentLabel(l, v, this._vars[i], this._mibNodes[i]);
        } else if (this._values[i] instanceof JTextField) {
            Object value = SnmpTableModel.getMibVariableFormat(this._vars[i], v, _MibVariableFormatMethods, _MibVariableFormatClass);
            if (value == null) {
                value = tcLabel != null && tcLabel.startsWith("InterfaceIndex") && v instanceof SnmpInt ? Discover.getRoot().ifIndexToName(((SnmpInt)v).getValue()) : v.toString();
            }
            ((JTextField)this._values[i]).setText(value.toString());
        } else if (this._values[i] instanceof JCheckBox) {
            ((JCheckBox)this._values[i]).setSelected(((SnmpInt)v).getValue() == 1);
        } else if (this._values[i] instanceof CheckBoxPanel) {
            this.setCheckBoxPanel((GroupButtonPanel)this._values[i], this.getApplicableEnums(this._mibNodes[i]), v);
        } else if (this._values[i] instanceof GroupButtonPanel) {
            this.setGroupButtonPanel((GroupButtonPanel)this._values[i], this.getApplicableEnums(this._mibNodes[i]), v);
        } else if (this._values[i] instanceof FieldPanel) {
            ((FieldPanel)this._values[i]).setText(v.toString());
        }
    }

    protected void setComponentLabel(JLabel l, SnmpVar v, String var, MibNode mibNode) {
        EditForm.setComponentValueLabel(l, v, var, mibNode);
    }

    public static void setComponentValueLabel(JLabel l, SnmpVar v, String var, MibNode mibNode) {
        MibEnum[] enums = mibNode.getEnums();
        if (enums != null) {
            if (v.getType() == 2) {
                l.setText(MibEnum.getLabel(enums, ((SnmpInt)v).getValue()));
            } else if (v.getType() == 4) {
                l.setText(SnmpString.bitsToString(((SnmpString)v).getValue(), enums));
            }
        } else {
            Object value = SnmpTableModel.getMibVariableFormat(var, v, _MibVariableFormatMethods, _MibVariableFormatClass);
            if (value != null) {
                String units = (String)SnmpTableModel._Units.get(var);
                if (units != null) {
                    l.setText(value.toString() + " " + units);
                } else {
                    l.setText(value.toString());
                }
            } else {
                String units = (String)SnmpTableModel._Units.get(var);
                if (units != null) {
                    l.setText(v + " " + units);
                } else if (v.getType() == 67 && mibNode.getTCLabel() != null && mibNode.getTCLabel().equals("TimeStamp")) {
                    SnmpTimeticks tt = (SnmpTimeticks)v;
                    if (tt.getValue() == 0L) {
                        l.setText("n/a");
                    } else {
                        long sysUptime = PhysicalStatus.getInstance().getSysUpTime();
                        if (sysUptime < tt.getValue()) {
                            l.setText("n/a");
                        } else {
                            l.setText(tt.toString(sysUptime - tt.getValue()));
                        }
                    }
                } else {
                    l.setText(v.toString());
                }
            }
        }
    }

    protected void set() throws Exception {
        if (this.isMultiple()) {
            if (this._table.isEditing()) {
                this._table.editingStopped(null);
            }
            if (!this.validateChanges(this._tableModel.getChanged(), this._tableModel, this._warningVars, this._warningMsg, -1)) {
                return;
            }
            SnmpPDU pdu = this.getSetPDUMulti();
            if (pdu != null) {
                this.sendPdu(pdu);
            }
            for (int i = 0; i < this._mibNodes.length; ++i) {
                String tcLabel;
                if (this._mibNodes[i] == null || (tcLabel = this._mibNodes[i].getTCLabel()) == null || !tcLabel.startsWith("Action")) continue;
                for (int j = 0; j < this._tableModel.getRowCount(); ++j) {
                    this._tableModel.setValueAt(Boolean.FALSE, j, i);
                }
            }
            this.enableButton('A', false);
            this.enableButton('u', false);
            this.fetchAllSetRows(this._tableModel.getChanged(), this._tableModel);
        } else {
            boolean ok = this.validateFormChanges(this._warningVars, this._warningMsg);
            if (!ok) {
                return;
            }
            SnmpPDU pdu = this.getSetPDU();
            if (pdu != null) {
                this.sendPdu(pdu);
                for (int i = 0; i < this._values.length; ++i) {
                    String tc;
                    if (this._mibNodes[i] == null || (tc = this._mibNodes[i].getTCLabel()) == null || !tc.equals("Action")) continue;
                    ((JCheckBox)this._values[i]).setSelected(false);
                }
                this._parent.evaluateUse();
            }
        }
        this.resetChanges();
        this.setStatus("ok");
    }

    protected boolean validateFormChanges(String[][] warnVars, String[] message) throws Exception {
        if (this._warningVars == null || this._warningVars.length == 0) {
            return true;
        }
        boolean needWarning = false;
        StringBuffer warnMsg = new StringBuffer();
        for (int i = 0; i < this._vars.length; ++i) {
            if (this._mibNodes[i] == null || !this.isEditable(this._mibNodes[i]) || !this.isChanged(i)) continue;
            for (int j = 0; j < warnVars.length; ++j) {
                if (!this.isWarnVar(this._vars[i], this.getComponentValue(i), warnVars[j], new Integer(i))) continue;
                needWarning = true;
                if (warnMsg.toString().length() > 0) {
                    int trimOffset = warnMsg.indexOf("Continue?");
                    if (trimOffset != -1) {
                        warnMsg = new StringBuffer(warnMsg.substring(0, trimOffset));
                    } else {
                        warnMsg.append('\n');
                    }
                }
                warnMsg.append(message[j]);
            }
        }
        if (needWarning) {
            return JOptionPane.showConfirmDialog(this.getParent(), warnMsg.toString(), this._parent.getTitle(), 0) == 0;
        }
        return true;
    }

    protected SnmpPDU getSetPDUMulti() throws Exception {
        return this._tableModel.setChangedCells();
    }

    protected SnmpPDU getSetPDU() throws Exception {
        SnmpPDU pdu = null;
        for (int i = 0; i < this._mibNodes.length; ++i) {
            if (this._mibNodes[i] == null || !this.isEditable(this._mibNodes[i]) || !this.isChanged(i)) continue;
            if (pdu == null) {
                pdu = new SnmpPDU(-93, new VarBindList());
            }
            try {
                pdu.addVar(new SnmpOID(this._mibNodes[i].getOid(), this.getIndex(i)), this.getComponentValue(i));
                continue;
            }
            catch (SnmpException ex) {
                this._values[i].requestFocus();
                throw ex;
            }
        }
        return pdu;
    }

    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        this.getPeer().set(pdu);
    }

    protected void preGet() throws SnmpException {
    }

    @Override
    protected void get() {
        this.setCFSButton(this.isCFSEnabled(true));
        this.enableButton('R', false);
        this.setStatus(" ");
        try {
            SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(this._mibNodes.length));
            if (this.isMultiple()) {
                this._multipleRow = 0;
                if (this._needRefreshTable && this._parent._multipleIndeces.length > 0) {
                    this._data = new Array(this._parent._multipleIndeces.length);
                    for (int i = 0; i < this._parent._multipleIndeces.length; ++i) {
                        Object[] row = this.buildTableRow(this.getMultipleIndex(i));
                        this._data.addElement(row);
                    }
                    this._tableModel.setData(this._data);
                    this._isRefresh = false;
                } else if (this._data.size() == 0) {
                    this._needsRefresh = false;
                    this._timeStamp = System.currentTimeMillis();
                    SwingUtilities.invokeLater(new UpdateTable());
                    this.enableButton('R', true);
                    this._isRefresh = false;
                    return;
                }
                this.preGet();
                for (int c = 1; c < this._mibNodes.length; ++c) {
                    pdu.addNull(new SnmpOID(this._mibNodes[c].getOid(), this._tableModel.getIndex(0, c)));
                }
            } else {
                this.preGet();
                for (int i = 0; i < this._mibNodes.length; ++i) {
                    if (this._vars[i].charAt(0) == '-') continue;
                    pdu.addNull(new SnmpOID(this._mibNodes[i].getOid(), this.getIndex(i)));
                }
            }
            this.sendGetPdu(pdu);
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
        this._needsRefresh = false;
        this._timeStamp = System.currentTimeMillis();
    }

    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        this.getPeer().send(pdu, this);
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (this._parent == null) {
            return;
        }
        if (this.isMultiple()) {
            this.callbackMulti(session, pdu, timedOut);
        } else if (timedOut || pdu.getError() != 0) {
            if (!timedOut) {
                Util.errorMessage((Component)this._parent, SnmpException.toError(pdu.getError()));
            }
            String errMsg = timedOut ? "timeout " : "error ";
            this.setErrorStatus(errMsg + SnmpTimeticks.getDateFormat().format(new Date()));
            this._parent.setCursor(Cursor.getDefaultCursor());
            this.enableButton('R', true);
        } else {
            this.updateForm(pdu);
            this.enableButton('R', true);
        }
    }

    protected void updateForm(SnmpPDU pdu) {
        block12: {
            int i = 0;
            int pduIndex = 0;
            while (pduIndex < pdu.getVariables().size()) {
                if (this._mibNodes[i] == null) {
                    --pduIndex;
                } else {
                    SnmpVar v = pdu.getVar(pduIndex);
                    if (v.getType() == 5) {
                        this.showError(i, true);
                    } else {
                        this.showError(i, false);
                        String tcLabel = this._mibNodes[i].getTCLabel();
                        if (tcLabel != null) {
                            if (tcLabel.equals("IdList")) {
                                v = new SnmpIdList((SnmpString)v);
                            } else if (v.getType() == 4) {
                                ((SnmpString)v).cacheString(tcLabel.equals("DisplayString") || tcLabel.equals("SnmpAdminString") || tcLabel.equals("Password") || tcLabel.equals("InetAddress"));
                            }
                        }
                        this.setComponentValue(i, v);
                    }
                }
                ++pduIndex;
                ++i;
            }
            if (!this.getStatus().startsWith("timeout")) {
                try {
                    this.postProcessing();
                }
                catch (Exception ex) {
                    if (!SnmpSession.isTrace()) break block12;
                    ex.printStackTrace();
                }
            }
        }
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.resetChanges();
        this.setCFSButton();
    }

    protected void callbackMulti(SnmpSession session, SnmpPDU pdu, boolean timedOut) {
        if (timedOut || pdu.getError() != 0) {
            if (!timedOut) {
                Util.errorMessage((Component)this._parent, SnmpException.toError(pdu.getError()));
            }
            String errMsg = timedOut ? "timeout " : "error ";
            this.setStatus(errMsg + " at " + this._multipleRow + " row(s) :" + SnmpTimeticks.getDateFormat().format(new Date()));
            this._parent.setCursor(Cursor.getDefaultCursor());
            this._table.colWidthToWidest();
            this._tableModel.fireTableDataChanged();
            this._isRefresh = false;
            this.enableButton('R', true);
            return;
        }
        SnmpVar v = pdu.getVar(0);
        if (this.isSkip(v, this._multipleRow)) {
            this._data.removeElementAt(this._multipleRow);
        } else {
            Object[] row = (Object[])this._data.elementAt(this._multipleRow);
            this.buildRow(row, pdu, this._multipleRow);
            ++this._multipleRow;
        }
        if (this._multipleRow == this._data.size()) {
            this._parent.setCursor(Cursor.getDefaultCursor());
            SwingUtilities.invokeLater(new UpdateTable());
        } else {
            pdu.reset();
            pdu.setCommand((byte)-96);
            for (int c = 1; c < this._mibNodes.length; ++c) {
                pdu.addNull(new SnmpOID(this._mibNodes[c].getOid(), this._tableModel.getIndex(this._multipleRow, c)));
            }
            try {
                this.sendGetMultiPdu(pdu, this._multipleRow);
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                this.enableButton('R', true);
            }
        }
    }

    protected boolean isSkip(SnmpVar v, int rowNo) {
        return v.getType() == 5;
    }

    protected Object[] buildTableRow(int[] index) {
        Object[] row = new Object[this._vars.length + 2];
        row[0] = new SnmpOID(index);
        return row;
    }

    protected void buildRow(Object[] row, SnmpPDU pdu, int rowNo) {
        for (int i = 1; i < this._mibNodes.length && i <= pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = pdu.getVariables().get(i - 1);
            row[i] = this._tableModel.toCellEditTable(this._mibNodes[i], pdu, vb, this._vars[i - 1], null, rowNo, i);
        }
        if (this._indexTitles != null && this._indexTitles.length > 0) {
            Object[] newRow = new Object[row.length + this._indexTitles.length - 1];
            newRow[0] = row[0];
            int[] oid = ((SnmpOID)row[0]).getValue();
            this.separateIndexCol(newRow, oid);
            if (this._indexColsRenderers != null) {
                for (int j = 1; j < this._indexColsRenderers.length; ++j) {
                    if (this._indexColsRenderers[j] == null) continue;
                    this._table.getColumnModel().getColumn(j).setCellRenderer(this._indexColsRenderers[j]);
                }
            }
            System.arraycopy(row, 1, newRow, this._indexTitles.length, row.length - 2);
            row = newRow;
        }
    }

    protected void sendGetMultiPdu(SnmpPDU pdu, int rowNo) throws SnmpException {
        this.getPeer().send(pdu, this);
    }

    protected void postProcessing() throws SnmpException {
    }

    protected void updateTableLater() {
        SwingUtilities.invokeLater(new UpdateTable());
    }

    protected void updateTable() {
        block7: {
            if (!this.getStatus().startsWith("timeout") && this._data.size() > 0) {
                try {
                    this.postProcessing();
                }
                catch (Exception ex) {
                    if (!SnmpSession.isTrace()) break block7;
                    ex.printStackTrace();
                }
            }
        }
        this.setStatus(this._data.size() + " row(s)");
        Dimension d = this._table.calcPreferredSize();
        try {
            int insets = Filter._IsMetal ? 3 : 5;
            Dimension bd = this._buttonPanel == null ? new Dimension(insets, insets) : this._buttonPanel.getPreferredSize();
            ((JPanel)this._container).setPreferredSize(new Dimension(d.width + 2 * insets, d.height + 2 * insets + bd.height));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d.width > 1008) {
            this._table.setAutoResizeMode(0);
        }
        this._table.getTableHeader().resizeAndRepaint();
        this.resetChanges();
        this.enableButton('c', false);
        this.enableButton('E', this._data.size() > 0);
        this.enableButton('p', this._data.size() > 0);
        this.setCFSButton();
        if (!this._isRefresh) {
            this._parent.repack(this);
        }
        this._isRefresh = false;
        this.enableButton('R', true);
    }

    protected void showError(int index, boolean isError) {
        if (this._labels[index] != null) {
            this._labels[index].setForeground(isError ? Color.red : _FgColor);
        }
        if (isError) {
            if (this._values[index] instanceof JTextField || this._values[index] instanceof FieldPanel) {
                this.setComponentText(index, "");
            } else if (this._values[index] instanceof JLabel) {
                ((JLabel)this._values[index]).setText("");
            } else if (this._values[index] instanceof GroupButtonPanel) {
                ((GroupButtonPanel)this._values[index]).clearSelection();
            } else if (this._values[index] instanceof JCheckBox) {
                ((JCheckBox)this._values[index]).setSelected(false);
            }
        }
    }

    protected void setCheckBoxPanel(GroupButtonPanel rbp, MibEnum[] enums, SnmpVar val) {
        block3: {
            block2: {
                if (val.getType() != 2) break block2;
                int bits = ((SnmpInt)val).getValue();
                int numComponents = rbp.getComponentCount();
                for (int i = 0; i < enums.length; ++i) {
                    if (i >= numComponents) continue;
                    rbp.getButton(i).setSelected((bits & 1 << i) > 0);
                }
                break block3;
            }
            if (val.getType() != 4) break block3;
            byte[] bits = ((SnmpString)val).getValue();
            int max = bits.length * 8;
            for (int i = 0; i <= max && i < enums.length; ++i) {
                rbp.getButton(i).setSelected(SnmpString.getBit(bits, i + 1));
            }
        }
    }

    protected void setGroupButtonPanel(GroupButtonPanel rbp, MibEnum[] enums, SnmpVar val) {
        if (val.getType() == 4) {
            DefaultLogger._DefLogger.debug((Object)"BITS tbd");
        } else if (val.getType() == 2) {
            int v = ((SnmpInt)val).getValue();
            rbp.clearSelection();
            for (int j = 0; j < enums.length; ++j) {
                if (v != enums[j].getValue()) continue;
                if (j >= rbp.getComponentCount()) break;
                JToggleButton rb = rbp.getButton(j);
                rb.setSelected(true);
                this.invokeEnumRule(rb);
                break;
            }
        }
    }

    public void setEnumRules(EnumRule[] rule) {
        this._enumRule = rule;
    }

    protected void invokeEnumRule(JToggleButton rb) {
        if (this._enumRule != null) {
            Container parent = rb.getParent();
            for (int i = 0; i < this._enumRule.length; ++i) {
                if (parent != this._values[this._enumRule[i]._srcIndex] || !rb.getText().equals(this._enumRule[i]._enum)) continue;
                this.setEnabled(this._enumRule[i]._dstIndex, this._enumRule[i]._enabled);
            }
        }
    }

    protected void addChangeListener(int index) {
        if (this._changeListener == null) {
            this._changeListener = new DMPanel.ChangedFieldListener();
        }
        if (this._values[index] instanceof JTextField) {
            ((JTextField)this._values[index]).addKeyListener(this._changeListener);
            if (this._mibNodes != null && this._mibNodes[index].getTCLabel() != null && this._mibNodes[index].getTCLabel().equals("NetMask")) {
                this._values[index].addFocusListener(new NetMaskListener(index - 1));
            }
        } else if (this._values[index] instanceof FieldPanel) {
            ((FieldPanel)this._values[index]).getField().addKeyListener(this._changeListener);
        } else if (this._values[index] instanceof JToggleButton) {
            ((JToggleButton)this._values[index]).addItemListener(this._changeListener);
        } else if (this._values[index] instanceof GroupButtonPanel) {
            ((GroupButtonPanel)this._values[index]).addChangeListener(this._changeListener);
        }
    }

    protected void resetChanges() {
        if (this.isMultiple()) {
            this._tableModel.resetChanges(false);
        } else {
            for (int i = 0; i < this._values.length; ++i) {
                if (this._mibNodes[i] == null || !this.isEditable(this._mibNodes[i])) continue;
                this.clearChanged(this._values[i]);
            }
        }
        if (this._isEditable) {
            this.enableButton('A', false);
            this.enableButton('u', false);
            this.enableButton('P', false);
        }
    }

    protected boolean isChanged(int index) {
        if (this._values[index] instanceof GroupButtonPanel) {
            return ((GroupButtonPanel)this._values[index]).isChanged();
        }
        if (this._values[index] instanceof FieldPanel) {
            return ((FieldPanel)this._values[index]).getField().getFont() == ChangedCellRenderer.getChangeFont();
        }
        return this._values[index].getFont() == ChangedCellRenderer.getChangeFont();
    }

    protected final JLabel getLabel(int index) {
        return this._labels[index];
    }

    protected final JComponent getComponentAt(int index) {
        return this._values[index];
    }

    protected String getComponentText(int index) {
        if (this._values[index] instanceof FieldPanel) {
            return ((FieldPanel)this._values[index]).getText();
        }
        if (this._values[index] instanceof JTextField) {
            return ((JTextField)this._values[index]).getText();
        }
        return null;
    }

    protected void setComponentText(int index, String text) {
        if (this._values[index] instanceof FieldPanel) {
            ((FieldPanel)this._values[index]).setText(text);
        } else {
            ((JTextField)this._values[index]).setText(text);
        }
    }

    protected void setComponentAt(int index, JComponent value) {
        this._values[index] = value;
        DialogUtil.constrain(this._container, value, new GridBagConstraints(), 1, index, 0, 17);
    }

    protected void removeComponentAt(int index) {
        if (this._labels[index] != null) {
            this._container.remove(this._labels[index]);
        }
        this._container.remove(this._values[index]);
    }

    protected void setComponentVisibleAt(int index, boolean visible) {
        if (this._labels[index] != null) {
            this._labels[index].setVisible(visible);
        }
        this._values[index].setVisible(visible);
    }

    protected void setEnabled(int index, boolean enabled) {
        if (this.isMultiple()) {
            return;
        }
        if (this._labels[index] != null) {
            this._labels[index].setEnabled(enabled);
        }
        this._values[index].setEnabled(enabled);
        if (this._values[index] instanceof JPasswordField) {
            if (!enabled) {
                this._values[index].setBackground(UIManager.getColor("Label.background"));
            } else {
                this._values[index].setBackground(UIManager.getColor("TextField.background"));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableButton('c', this._table.getSelectedRowCount() > 0);
        this.enableButton('P', this._table.getSelectedRowCount() > 0);
    }

    public JComponent[] getComponents() {
        return this._values;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this._table != null) {
                this._table.editingStopped(null);
            }
            if (e.getSource() instanceof AbstractButton) {
                this.doIt(((AbstractButton)e.getSource()).getActionCommand().charAt(0), e);
            } else {
                this.doIt(' ', e);
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
        catch (Exception ex) {
            if (SnmpSession.isTrace()) {
                ex.printStackTrace();
            }
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
        catch (Error ex) {
            Util.errorMessage((Component)this._parent, ex.getMessage());
        }
    }

    protected void fetchSetForm() {
        this.get();
    }

    protected void doIt(char ch, ActionEvent e) throws Exception {
        switch (ch) {
            case 'A': {
                this.set();
                if (this.isMultiple()) break;
                this.fetchSetForm();
                break;
            }
            case 'R': {
                if (this._table != null && this._table.isEditing()) {
                    this._table.editingStopped(null);
                }
                this.setStatus(" ");
                this._isRefresh = true;
                this.get();
                break;
            }
            case 'H': {
                this.helpAction();
                break;
            }
            case 'C': {
                this.closeAction();
                break;
            }
            case 'c': {
                this._table.copy();
                break;
            }
            case 'P': {
                this._table.paste();
                break;
            }
            case 'p': {
                try {
                    this._table.print(DeviceManager._AppName);
                }
                catch (Exception ex) {
                    if (SnmpSession.isTrace()) {
                        ex.printStackTrace();
                    }
                    Util.errorMessage((Component)DeviceManager.getInstance(), ex);
                }
                break;
            }
            case 'E': {
                String fName = Util.getFileName((JFrame)this._parent.getParent(), "*.txt", 1);
                if (fName == null) break;
                this._table.export(fName);
                break;
            }
            case 'u': {
                if (this._table.isEditing()) {
                    this._table.editingStopped(null);
                }
                this._tableModel.undo();
                this.enableButton('A', false);
                this.enableButton('u', false);
                break;
            }
            case 'f': {
                if (this._findDialog == null) {
                    this._findDialog = new FindDialog(this._parent, null, (KTable)this._table);
                    int dash = this._parent.getTitle().lastIndexOf("-");
                    this._findDialog.setTitle(this._parent.getTitle().substring(dash + 1) + " Find");
                }
                this._findDialog.setVisible(true);
            }
        }
    }

    class CFSApplyButton
    extends MenuButton {
        String[] _cfsActionMenu;

        public CFSApplyButton(JMenu menu, String name) {
            super(menu, name);
            this._cfsActionMenu = new String[]{"Commit", "Abort"};
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block9: {
                if (this._menu == null) {
                    this._menu = new JMenu();
                    this.buildMenu(this._cfsActionMenu);
                }
                if (e.getSource() instanceof JMenuItem) {
                    try {
                        if (((JMenuItem)e.getSource()).getText().startsWith("Apply")) {
                            EditForm.this.set();
                            break block9;
                        }
                        int action = ((JMenuItem)e.getSource()).getText().startsWith("Commit") ? 4 : 5;
                        EditForm.this.cfsAction(action);
                    }
                    catch (SnmpException ex) {
                        Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                    }
                    catch (Exception ex) {
                        if (SnmpSession.isTrace()) {
                            ex.printStackTrace();
                        }
                        Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
                    }
                    catch (Error ex) {
                        Util.errorMessage((Component)EditForm.this._parent, ex.getMessage());
                    }
                } else {
                    super.actionPerformed(e);
                }
            }
        }
    }

    class NetMaskListener
    extends FocusAdapter {
        int _netIndex;

        public NetMaskListener(int netIndex) {
            this._netIndex = netIndex;
        }

        @Override
        public void focusGained(FocusEvent e) {
            ((JTextField)e.getSource()).setText(IpUtil.getMask(((JTextField)EditForm.this._values[this._netIndex]).getText()));
        }
    }

    class EnumRuleListener
    implements ActionListener {
        EnumRuleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditForm.this.invokeEnumRule((JRadioButton)e.getSource());
        }
    }

    class UpdateTable
    implements Runnable {
        UpdateTable() {
        }

        @Override
        public void run() {
            EditForm.this.updateTable();
        }
    }
}

