/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.util.ClientCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.ws.common.Constants;
import org.jboss.ws.core.jaxrpc.client.CallImpl;
import org.jboss.ws.core.jaxrpc.client.ServiceFactoryImpl;
import org.jboss.ws.core.jaxrpc.client.ServiceImpl;

public class EventManagerJAXC {
    private static final boolean DEBUG_LOG = true;
    private String TARGET_NAMESPACE = "http://ep.san.jaxws.dcbu.cisco.com/";
    private String TARGET_ENDPOINT_ADDRESS = "http://localhost/EventManagerWSService/EventManagerWS?wsdl";
    private static final String KEYSTORE = File.separator + "jboss-4.2.2.GA" + File.separator + "server" + File.separator + "fm" + File.separator + "conf" + File.separator + "fmserver.jks";
    private static final String KEYPASS = "fmserver_1_2_3";
    private final QName SERVICE_NAME = new QName("EventManagerWS");
    private String username;
    private String password;
    private int protocol;
    private ServiceImpl service;
    private CallImpl caller;
    private boolean snmpv3;
    private boolean _isHttps;
    private boolean useJBoss = true;

    public EventManagerJAXC(String username, String password, int protocol) throws Exception {
        this();
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.snmpv3 = true;
    }

    private EventManagerJAXC() throws Exception {
        this.loadConfig();
        ServiceFactoryImpl factory = (ServiceFactoryImpl)ServiceFactoryImpl.newInstance();
        this.service = (ServiceImpl)factory.createService(this.SERVICE_NAME);
        this.caller = (CallImpl)this.service.createCall();
        this.caller.setTargetEndpointAddress(this.TARGET_ENDPOINT_ADDRESS);
    }

    public EventManagerJAXC(String community) throws Exception {
        this();
        this.snmpv3 = false;
        if (community == null) {
            community = "";
        }
        this.username = community.trim();
    }

    public EventManagerJAXC(String username, String password) throws Exception {
        this(username, password, 0);
    }

    private void log(String msg) {
        DefaultLogger._DefLogger.debug((Object)msg);
    }

    private void loadConfig() throws Exception {
        String conf = ClientCache.getInstallLocation() + "install.conf";
        this.log("\nreading config from " + conf);
        File confFile = new File(conf);
        if (confFile.exists()) {
            this.log("\nfile exists...");
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(confFile));
            }
            catch (Exception ioex) {
                this.log("can not find method or port from " + conf + " - " + ioex);
            }
            String method = Boolean.valueOf(props.getProperty("mds.web.https")) != false ? "https" : "http";
            this._isHttps = Boolean.valueOf(props.getProperty("mds.web.https"));
            String port = props.getProperty("mds.web.startPort");
            if (port == null) {
                port = "80";
            }
            this.log("\nmethod=" + method + " port=" + port);
            String endpoint = method + "://localhost:" + port + "/EventManagerWSService/EventManagerWS";
            this.useJBoss = true;
            if (endpoint == null) {
                throw new Exception("Unable to find server endpoint.");
            }
            this.TARGET_ENDPOINT_ADDRESS = endpoint;
            if (this._isHttps) {
                System.setProperty("javax.net.ssl.trustStore", props.getProperty("mds.dcmRoot") + KEYSTORE);
                System.setProperty("javax.net.ssl.trustStorePassword", KEYPASS);
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", port);
            }
            System.setProperty("https.proxySet", this._isHttps ? "true" : "false");
            System.setProperty("org.jboss.security.ignoreHttpsHost", "true");
        } else {
            this.log(conf + " does not exist");
        }
        this.log("\nend of loadConfig ENDPOINT=" + this.TARGET_ENDPOINT_ADDRESS);
    }

    private String findService(String server) {
        String AXIS_URL = server + "/axis/services/EventManager";
        String JBOSSWS_URL = server + "/EventManagerWSService/EventManagerWS";
        try {
            return this.tryConnection(JBOSSWS_URL);
        }
        catch (Exception ex) {
            this.useJBoss = false;
            this.log("No service found on " + JBOSSWS_URL + ": " + ex.getMessage());
            try {
                return this.tryConnection(AXIS_URL);
            }
            catch (Exception ex2) {
                this.log("No service found on " + AXIS_URL + ": " + ex2.getMessage());
                return null;
            }
        }
    }

    private String tryConnection(String urlAddr) throws MalformedURLException, IOException {
        URL url = new URL(urlAddr + "?wsdl");
        URLConnection conn = url.openConnection();
        conn.connect();
        conn.setReadTimeout(10000);
        InputStream is = conn.getInputStream();
        if (is == null) {
            throw new IOException("No stream");
        }
        is.close();
        return urlAddr;
    }

    private String getProtocol(int auth, int priv) {
        String aStr = "";
        String pStr = "";
        switch (auth) {
            case 0: {
                aStr = "MD5";
                break;
            }
            case 1: {
                aStr = "SHA";
                break;
            }
            default: {
                aStr = "MD5";
            }
        }
        if (priv > -1) {
            switch (priv) {
                case 0: {
                    pStr = "DES";
                    break;
                }
                case 1: {
                    pStr = "AES";
                    break;
                }
                default: {
                    pStr = "DES";
                }
            }
            return aStr + "_" + pStr;
        }
        return aStr;
    }

    public String getSyslogAddress(String targetAddr) throws RemoteException {
        String addr = null;
        if (this.snmpv3) {
            addr = this.getSyslogAddress(targetAddr, -1, null);
        } else {
            this.caller.setOperationName(new QName(this.TARGET_NAMESPACE, "getSyslogAddressAuthV2"));
            this.caller.removeAllParameters();
            this.caller.addParameter("community", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
            this.caller.addParameter("targetAddr", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
            this.caller.setReturnType(Constants.TYPE_LITERAL_STRING);
            addr = (String)this.caller.invoke(new Object[]{this.username, targetAddr});
        }
        return addr;
    }

    public String getSyslogAddress(String targetAddr, int privacyProtocol, String privacyPassword) throws RemoteException {
        this.caller.setOperationName(new QName(this.TARGET_NAMESPACE, "getSyslogAddressAuthV3"));
        this.caller.removeAllParameters();
        this.caller.addParameter("username", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("protocol", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("authPassword", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("privPassword", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("targetAddr", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.setReturnType(Constants.TYPE_LITERAL_STRING);
        String res = (String)this.caller.invoke(new Object[]{this.username, this.getProtocol(this.protocol, privacyProtocol), this.password, privacyPassword, targetAddr});
        return res;
    }

    public boolean addSource(String targetAddr) throws RemoteException {
        boolean ret = false;
        if (this.snmpv3) {
            ret = this.addSource(targetAddr, -1, null);
        } else {
            this.caller.setOperationName(new QName(this.TARGET_NAMESPACE, "addSourceAuthV2"));
            this.caller.removeAllParameters();
            this.caller.addParameter("community", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
            this.caller.addParameter("targetAddr", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
            this.caller.setReturnType(Constants.TYPE_LITERAL_BOOLEAN);
            ret = (Boolean)this.caller.invoke(new Object[]{this.username, targetAddr});
        }
        return ret;
    }

    public boolean addSource(String targetAddr, int privacyProtocol, String privacyPassword) throws RemoteException {
        this.caller.setOperationName(new QName(this.TARGET_NAMESPACE, "addSourceAuthV3"));
        this.caller.removeAllParameters();
        this.caller.addParameter("username", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("protocol", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("authPassword", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("privPassword", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.addParameter("targetAddr", Constants.TYPE_LITERAL_STRING, ParameterMode.IN);
        this.caller.setReturnType(Constants.TYPE_LITERAL_BOOLEAN);
        this.caller.setOperationName(new QName(this.TARGET_NAMESPACE, "addSourceAuthV3"));
        boolean res = (Boolean)this.caller.invoke(new Object[]{this.username, this.getProtocol(this.protocol, privacyProtocol), this.password, privacyPassword, targetAddr});
        return res;
    }

    public String getEndPoint() {
        return this.TARGET_ENDPOINT_ADDRESS;
    }

    public boolean isHttps() {
        return this._isHttps;
    }

    public static void main(String[] args) throws Exception {
        EventManagerJAXC c = new EventManagerJAXC("admin", "nbv_12345");
        System.out.println(c.getSyslogAddress("172.23.150.30"));
    }
}

