/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dm;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.Util;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JFrame;

public class HelpBuilder {
    static final String DTD_TOC = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<!DOCTYPE toc  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Toc Version 1.0//EN\" \"http://java.sun.com/products/javahelp/toc_1_0.dtd\">";
    static final String DTD_MAP = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<!DOCTYPE map  PUBLIC \"-//Sun Microsystems Inc.//DTD JavaHelp Map Version 1.0//EN\" \"http://java.sun.com/products/javahelp/map_1_0.dtd\">";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Object br;
        if (argv.length != 1) {
            System.err.println("Usage: <deviceDirectory>");
            System.exit(1);
        }
        String dir = argv[0] + File.separator;
        Class<?> dialogsClass = null;
        int[] zero = new int[]{0, 0};
        Discover._SysObjectID = new SnmpOID(zero);
        PrintStream osToc = null;
        PrintStream osMap = null;
        Properties descriptions = new Properties();
        try {
            dialogsClass = Class.forName(dir.replace(File.separatorChar, '.') + "dialogs.Dialogs");
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(dir + "mibs" + File.separator + "help.properties"));
            descriptions.load(is);
            is.close();
            MibNode.load(dir + "mib.dat");
            SnmpTableModel._Aliases = new HashMap();
            br = new BufferedReader(new FileReader(dir + "alias.properties"));
            Util.load(SnmpTableModel._Aliases, (BufferedReader)br);
            ((BufferedReader)br).close();
            osToc = new PrintStream(new FileOutputStream(dir + "help" + File.separator + "TOC.xml"));
            osMap = new PrintStream(new FileOutputStream(dir + "help" + File.separator + "map.jhm"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            br = argv[0];
            synchronized (br) {
                try {
                    argv[0].wait(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            System.exit(1);
        }
        osMap.println(DTD_MAP);
        osMap.println("<map version=\"1.0\">");
        osMap.println("<mapID target=\"welcome\" url=\"topics/index.html\" />");
        osToc.println(DTD_TOC);
        osToc.println("<toc version=\"1.0\">");
        try {
            Object[] m = dialogsClass.getMethods();
            Arrays.sort(m);
            for (int i = 0; i < m.length; ++i) {
                if (((Method)m[i]).getReturnType() != DMDialog.class) continue;
                System.out.println(((Method)m[i]).getName() + " " + ((Method)m[i]).getReturnType());
                DMDialog d = HelpBuilder.build(dialogsClass, ((Method)m[i]).getName());
                for (int j = 0; j < d._tabPanels.size(); ++j) {
                    StringBuffer sb;
                    String desc;
                    String v;
                    int k;
                    int mnemonic;
                    String title;
                    DMPanel p = (DMPanel)d._tabPanels.elementAt(j);
                    PrintStream os = new PrintStream(new FileOutputStream(dir + "help/topics" + File.separator + p._help + ".html"));
                    os.print("<HTML><TITLE>");
                    String catName = ((Method)m[i]).getName();
                    int sp = catName.indexOf(95);
                    if (sp != -1) {
                        catName = catName.replace('_', ' ');
                    }
                    if ((title = p._title) != null && (mnemonic = title.lastIndexOf(38)) != -1) {
                        title = Util.removeMnemonic(title, mnemonic);
                    }
                    os.print(catName);
                    if (title != null) {
                        os.print(" " + title);
                    }
                    os.println("</TITLE>");
                    if (j == 0 && d._tabPanels.size() > 1) {
                        osToc.println("<tocitem text=\"" + catName + "\">");
                    }
                    osToc.println("  <tocitem text=\"" + (title == null ? catName : title) + "\" target=\"" + p._help + "\"/>");
                    if (d._tabPanels.size() > 1 && j == d._tabPanels.size() - 1) {
                        osToc.println("</tocitem>");
                    }
                    osMap.println("<mapID target=\"" + p._help + "\" url=\"topics/" + p._help + ".html\" />");
                    os.println("<BODY><TABLE WIDTH=\"100%\">");
                    os.print("<CAPTION><FONT FACE=\"Arial\" COLOR=\"#000080\" SIZE=\"4\"><P ALIGN=\"LEFT\"><B>");
                    os.print(catName);
                    if (title != null) {
                        os.print(" " + title);
                    }
                    os.print("</B></FONT></CAPTION>");
                    os.print("<TR><TD></FONT><FONT FACE=\"Arial\" COLOR=\"#000080\" SIZE=\"2\"><B>Item</B></TD>");
                    os.print("<TD><FONT FACE=\"Arial\" COLOR=\"#000080\" SIZE=\"2\"><B>Description</B></TD><TR>");
                    if (p._helpIndeces != null) {
                        for (k = 0; k < p._helpIndeces.length; ++k) {
                            v = p._helpIndeces[k];
                            if (v.charAt(0) == '-') continue;
                            desc = descriptions.getProperty(v);
                            if (desc == null) {
                                desc = "?";
                            }
                            sb = new StringBuffer(512);
                            sb.append("<TR><TD VALIGN=TOP><FONT FACE=\"Arial\" SIZE=\"2\">");
                            sb.append(p.trim(p._helpIndeces[k]));
                            sb.append("</TD><TD><FONT FACE=\"Arial\" SIZE=\"2\">");
                            sb.append(desc);
                            sb.append("</TD></TR>");
                            os.println(sb.toString());
                        }
                    }
                    for (k = 0; k < p._vars.length; ++k) {
                        v = p._vars[k];
                        if (v.charAt(0) == '-') continue;
                        desc = descriptions.getProperty(v);
                        if (desc == null) {
                            desc = "?";
                        }
                        sb = new StringBuffer(512);
                        sb.append("<TR><TD VALIGN=TOP><FONT FACE=\"Arial\" SIZE=\"2\">");
                        sb.append(p.trim(p._vars[k]));
                        sb.append("</TD><TD><FONT FACE=\"Arial\" SIZE=\"2\">");
                        sb.append(desc);
                        sb.append("</TD></TR>");
                        os.println(sb.toString());
                    }
                    os.println("</TABLE>");
                    os.println("</BODY></HTML>");
                    os.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String string = argv[0];
            synchronized (string) {
                try {
                    argv[0].wait(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        osMap.println("</map>");
        osMap.close();
        osToc.println("</toc>");
        osToc.close();
        System.exit(0);
    }

    static DMDialog build(Class dclass, String method) {
        try {
            Class[] types = new Class[]{JFrame.class, SnmpPeer.class};
            Object[] args = new Object[2];
            Method m = dclass.getMethod(method, types);
            return (DMDialog)m.invoke((Object)dclass, args);
        }
        catch (InvocationTargetException ex) {
            Exception realEx = (Exception)ex.getTargetException();
            if (realEx == null) {
                realEx = ex;
            }
            System.err.println(realEx);
            realEx.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            System.err.println("No such method: " + method);
        }
        catch (IllegalAccessException ex) {
            System.err.println("Can't access method: " + method);
        }
        return null;
    }
}

