/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpInetAddress;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.Util;

public class EditInetAddrInTable
extends EditTable {
    String[] _addrVar;
    String[] _addrTypeVar;
    int[][] _addrTypeOid;
    int[][] _addrOid;
    protected int[] _addrType;
    int[] _addrTypePos;
    int[] _addrPos;

    public EditInetAddrInTable(String[] vars, String[] addrVar, String[] addrTypeVar) {
        super(vars);
        this._addrVar = addrVar;
        this._addrTypeVar = addrTypeVar;
        this._addrType = new int[addrTypeVar.length];
        this._addrOid = new int[addrVar.length][];
        this._addrTypeOid = new int[addrTypeVar.length][];
        this._addrTypePos = new int[addrTypeVar.length];
        this._addrPos = new int[addrVar.length];
        for (int i = 0; i < addrVar.length; ++i) {
            this._addrOid[i] = MibNode.get(addrVar[i]).getOid();
            this._addrTypeOid[i] = MibNode.get(addrTypeVar[i]).getOid();
            this._addrTypePos[i] = this.getVarIndex(addrTypeVar[i]);
            this._addrPos[i] = this.getVarIndex(addrVar[i]);
        }
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        this.buildAddrType(pdu);
        return super.buildRow(pdu, responseOid, rowNo);
    }

    protected void buildAddrType(SnmpPDU pdu) {
        for (int i = 0; i < this._addrTypeVar.length; ++i) {
            this._addrType[i] = pdu.getVariables().intValue(this._addrTypePos[i]);
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpInetAddrTableModel();
    }

    public class SnmpInetAddrTableModel
    extends DmTableModel {
        @Override
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            for (int i = 0; i < EditInetAddrInTable.this._addrVar.length; ++i) {
                if (!var.equals(EditInetAddrInTable.this._addrVar[i])) continue;
                if (EditInetAddrInTable.this._addrType[i] == 1 || EditInetAddrInTable.this._addrType[i] == 2) {
                    return new SnmpIpAddress(pdu.getVariables().byteValue(col - 1));
                }
                return vb.getVar();
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }

        @Override
        public Object getSetValueAt(Object aValue, int row, int col) {
            Object[] data;
            Object target;
            if (col != -1 && this.getAddrTypePos(col) != -1 && (target = (data = (Object[])this.getData().elementAt(row))[col]) instanceof SnmpInetAddress) {
                try {
                    aValue = new SnmpInetAddress(aValue.toString(), true);
                }
                catch (SnmpException ex) {
                    Util.errorMessage(this.getErrorComponent(), ex);
                }
                return aValue;
            }
            return super.getSetValueAt(aValue, row, col);
        }

        @Override
        protected SnmpVar getChangedCell(int row, int col) throws Exception {
            if (EditInetAddrInTable.this._addrPos[0] != -1 && this.getAddrTypePos(col) != -1) {
                Object o = this.getValueAt(row, col);
                int type = ((JnmMibEnum)this.getValueAt(row, this.getAddrTypePos(col))).getValue();
                if (type == 1 || type == 2) {
                    return new SnmpInetAddress(o.toString(), true);
                }
                return new SnmpString(o.toString());
            }
            return super.getChangedCell(row, col);
        }

        private int getAddrTypePos(int pos) {
            for (int i = 0; i < EditInetAddrInTable.this._addrPos.length; ++i) {
                if (pos != EditInetAddrInTable.this._addrPos[i] + 1) continue;
                return EditInetAddrInTable.this._addrTypePos[i] + 1;
            }
            return -1;
        }
    }
}

