/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel.EditEChannelTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;

public class EditVLANBaseForm
extends EditForm {
    boolean _removeHelpBtn;
    SnmpString _vlanVar;
    protected int _first;
    protected int _2k;
    protected int _3k;
    protected int _4k;
    protected int _first2kActive;
    protected int _second2kActive;
    protected int[] _utilTypes;
    static final int UTIL_TYPE_4_2k4k_POS = 0;

    public EditVLANBaseForm(String[] vars, int first, int[] types) {
        this(vars, false, first, types);
    }

    public EditVLANBaseForm(String[] vars, boolean removeHelpBtn, int first, int type) {
        this(vars, removeHelpBtn, first, new int[]{type});
    }

    public EditVLANBaseForm(String[] vars, boolean removeHelpBtn, int first, int[] utilTypes) {
        super(vars);
        this._removeHelpBtn = removeHelpBtn;
        this._utilTypes = utilTypes;
        this._first = first;
        this._2k = this._first + 1;
        this._3k = this._first + 2;
        this._4k = this._first + 3;
        this._first2kActive = utilTypes.length > 1 ? first + 4 : -1;
        this._second2kActive = utilTypes.length > 1 ? first + 5 : -1;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        if (this._removeHelpBtn) {
            AbstractButton refreshBtn = this.getButton('R');
            AbstractButton helpBtn = this.getButton('H');
            this._buttonPanel.remove(refreshBtn);
            this._buttonPanel.remove(helpBtn);
        }
    }

    @Override
    protected void build() {
        super.build();
        if (this.isMultiple()) {
            if (this._second2kActive > 0) {
                this._table.removeColumn(this._table.getColumnModel().getColumn(this._second2kActive + 1));
            }
            for (int i = this._4k + 1; i > this._2k; --i) {
                this._table.removeColumn(this._table.getColumnModel().getColumn(i));
            }
        } else {
            int i;
            for (i = this._first + 1; i < this._4k + 1; ++i) {
                this._labels[i].setVisible(false);
                this._values[i].setVisible(false);
            }
            this._labels[this._first].setText("VLAN List:");
            if (this._first2kActive > 0) {
                for (i = this._first2kActive + 1; i < this._second2kActive + 1; ++i) {
                    this._labels[i].setVisible(false);
                    this._values[i].setVisible(false);
                }
                this._labels[this._first2kActive].setText("Active VLAN List:");
            }
        }
    }

    @Override
    protected boolean isEditable(MibNode mibNode) {
        if (DmId.isN5K(Discover.getSysObjectID())) {
            return false;
        }
        return super.isEditable(mibNode);
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (!timedOut) {
            pdu = this.getVlans(pdu);
        }
        super.callback(session, reqid, pdu, timedOut);
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        pdu = this.splitVar2k4k(pdu);
        this.getPeer().setFrag(pdu);
    }

    protected SnmpPDU getVlans(SnmpPDU pdu) {
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < this._utilTypes.length; ++i) {
            this.appendVlan4kTo2kVar(vbl, this._utilTypes[i]);
        }
        return pdu;
    }

    void appendVlan4kTo2kVar(VarBindList vbl, int utilType) {
        int[] vlanOid = PortInterfaceUtil.getInstance(utilType).getFirstOid();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVar vlansVar;
            if (!vbl.getVb(i).getOid().startsWith(vlanOid) || (vlansVar = vbl.get(i).getVar()).getType() == 5 || vlansVar.getType() == 5) continue;
            try {
                SnmpString vlans;
                if (utilType == 14) {
                    vlans = (SnmpString)vlansVar;
                    SnmpString vlanSecond = (SnmpString)vbl.get(i + 1).getVar();
                    vlans = PortInterfaceUtil.getInstance(utilType).getVlans4Two(vlans, vlanSecond);
                    continue;
                }
                vlans = (SnmpString)vlansVar;
                SnmpString vlan2k = (SnmpString)vbl.get(i + 1).getVar();
                SnmpString vlan3k = (SnmpString)vbl.get(i + 2).getVar();
                SnmpString vlan4k = (SnmpString)vbl.get(i + 3).getVar();
                vlans = PortInterfaceUtil.getInstance(utilType).getVlans(vlans, vlan2k, vlan3k, vlan4k);
                continue;
            }
            catch (ClassCastException ex) {
                DefaultLogger._DefLogger.debug((Object)("Agent does not return the proper number of VarBinds: vlans=" + vbl.get(this._first).getVar() + "vlan2k=" + vbl.get(this._2k).getVar()));
                DefaultLogger._DefLogger.debug((Object)("Agent does not return the proper number of VarBinds: vlan3k=" + vbl.get(this._3k).getVar() + "vlan4k=" + vbl.get(this._4k).getVar()));
            }
        }
    }

    protected SnmpPDU splitVar2k4k(SnmpPDU pdu) {
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            if (!vb.getOid().startsWith(PortInterfaceUtil.getInstance(this._utilTypes[0]).getFirstOid())) continue;
            PortInterfaceUtil.getInstance(this._utilTypes[0]).addVlan4k2Pdu(pdu, vb.getOid(), vb.getVar(), oid[oid.length - 1]);
        }
        return pdu;
    }

    @Override
    protected SnmpPDU sendFetchAllSetRowsPDU(VarBindList vbl) throws SnmpException {
        SnmpPDU respPDU = super.sendFetchAllSetRowsPDU(vbl);
        vbl = respPDU.getVariables();
        this.appendVlan4kTo2kVar(vbl, this._utilTypes[0]);
        return respPDU;
    }

    @Override
    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        this._vlanVar = (SnmpString)pdu.getVar(this._first);
    }

    @Override
    protected void setComponentLabel(JLabel l, SnmpVar v, String var, MibNode mibNode) {
        if (DmId.isN5K(Discover.getSysObjectID()) && var.equals("vmVlans")) {
            EditVLANBaseForm.setComponentValueLabel(l, v, "vmVlansNonIPS", mibNode);
        } else {
            super.setComponentLabel(l, v, var, mibNode);
        }
    }

    @Override
    protected boolean isChanged(int index) {
        try {
            SnmpVar newVlanVar = this.getComponentValue(this._first);
            if (((SnmpString)newVlanVar).equals(this._vlanVar)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.isChanged(index);
    }

    @Override
    protected Object[] buildTableRow(int[] index) {
        Object[] row = new Object[this._vars.length + 3];
        row[0] = new SnmpOID(index);
        return row;
    }

    @Override
    protected void buildRow(Object[] row, SnmpPDU pdu, int rowNo) {
        super.buildRow(row, pdu, rowNo);
        row[row.length - 1] = row[this._first + 1];
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        super.doIt(ch, e);
        if (ch == 'A' && this._parentTable != null) {
            ((EditEChannelTable)this._parentTable).get();
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpVlanTableModel();
    }

    class SnmpVlanTableModel
    extends DmTableModel {
        SnmpVlanTableModel() {
        }

        @Override
        public void markUndo(int row, int col, Object aValue) {
            Object[] values = (Object[])EditVLANBaseForm.this._data.elementAt(row);
            Object[] changed = (Object[])values[this.getHeaders().length];
            if (col == EditVLANBaseForm.this._first + 1 && ((String)aValue).equals((String)values[values.length - 1])) {
                if (changed != null && changed[col] != null) {
                    changed[col] = null;
                }
                return;
            }
            super.markUndo(row, col, aValue);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (DmId.isN5K(Discover.getSysObjectID())) {
                return false;
            }
            return super.isCellEditable(row, col);
        }

        @Override
        public Object toCell(MibNode mibNode, SnmpVar v, String var, int row) {
            if (DmId.isN5K(Discover.getSysObjectID()) && var.equals("vmVlans")) {
                var = "vmVlansNonIPS";
            }
            return super.toCell(mibNode, v, var, row);
        }
    }
}

