/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dmdb.andiamo.dialogs.DeviceAlias;
import com.cisco.dcbu.dmdb.andiamo.dialogs.EndPort;
import com.cisco.dcbu.dmdb.andiamo.dialogs.IslLink;
import com.cisco.dcbu.dmdb.andiamo.dialogs.Switch;
import com.cisco.dcbu.dmdb.andiamo.dialogs.VsanDomainId;
import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SwitchMapUtil {
    public static final int ISL_FILTER_ALL = 0;
    public static final int ISL_FILTER_PSM = 1;

    public static HashMap getSwitchMapHash(SnmpPeer peer, int vsanId, ArrayList switchArray) {
        HashMap<VsanDomainId, Switch> switchHash = new HashMap<VsanDomainId, Switch>();
        HashMap<Integer, VsanDomainId> addrIndex2DomainIdHasp = new HashMap<Integer, VsanDomainId>();
        String[] ie = new String[]{"fcsIeDomainId", "fcsIeMgmtAddrListIndex"};
        int[][] ieVars = new int[ie.length][];
        for (int i = 0; i < ie.length; ++i) {
            ieVars[i] = MibNode.get(ie[i]).getOid();
        }
        VarBindList vbl = new VarBindList(ieVars.length);
        for (int i = 0; i < ieVars.length; ++i) {
            if (vsanId == 0) {
                vbl.add(new SnmpVarBind(new SnmpOID(ieVars[i])));
                continue;
            }
            vbl.add(new SnmpVarBind(new SnmpOID(ieVars[i], vsanId)));
        }
        try {
            int k;
            SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
            VarBindList vblResp = resp.getVariables();
            VarBindList vblIp = new VarBindList();
            int[] fcsMgmtAddr = MibNode.get("fcsMgmtAddr").getOid();
            int[] mgmtIndex = new int[2];
            for (int i = 0; i < vblResp.size(); i += ieVars.length) {
                boolean isMDS;
                int listIndex;
                int domainId = vblResp.intValue(i);
                if (domainId == 0 || (listIndex = vblResp.intValue(i + 1)) == 0) continue;
                SnmpVarBind vb = vblResp.getVb(i);
                int[] oid = vb.getOid().getValue();
                int vsan = oid[oid.length - 9];
                if (vsanId != 0 && vsan != vsanId) break;
                byte[] wwn = new byte[8];
                k = oid.length - 8;
                int j = 0;
                while (k < oid.length) {
                    wwn[j] = (byte)(oid[k] & 0xFF);
                    ++k;
                    ++j;
                }
                boolean bl = isMDS = WwnDictionary.isCiscoWwn(wwn) && wwn[0] >> 4 == 2;
                if (isMDS) {
                    wwn = WwnDictionary.vsanWwnToSwwn(wwn);
                }
                Wwn wwnV = new Wwn(wwn);
                String a = wwnV.toString();
                VsanDomainId vsanDomainId = new VsanDomainId(vsan, domainId, wwnV);
                Switch dmSwitch = new Switch(vsan, domainId, wwnV, isMDS, false);
                switchHash.put(vsanDomainId, dmSwitch);
                addrIndex2DomainIdHasp.put(new Integer(listIndex), vsanDomainId);
            }
            VarBindList vblIp2 = new VarBindList();
            vblIp2.add(new SnmpVarBind(new SnmpOID(fcsMgmtAddr)));
            if (vblIp2.size() != 0) {
                SnmpPDU respIp = SnmpFetch.getBulk(peer, vblIp2);
                VarBindList vblRespIp = respIp.getVariables();
                int prevListIndex = -1;
                boolean found = false;
                InetAddress defaultAddr = null;
                Switch sw = null;
                for (k = 0; k < respIp.getVariables().size(); ++k) {
                    boolean isAddrMgmtAddr;
                    int[] oid = respIp.getVariables().get(k).getOid().getValue();
                    int listIndex = oid[oid.length - 2];
                    int mgmtIndexR = oid[oid.length - 1];
                    if (listIndex != prevListIndex) {
                        if (sw != null && sw.getInetAddr() == null) {
                            sw.setInetAddr(defaultAddr);
                        }
                        found = false;
                        defaultAddr = null;
                        VsanDomainId vsanDomainId = (VsanDomainId)addrIndex2DomainIdHasp.get(new Integer(listIndex));
                        if (vsanDomainId == null) {
                            found = true;
                            continue;
                        }
                        sw = (Switch)switchHash.get(vsanDomainId);
                        if (sw == null) {
                            found = true;
                            continue;
                        }
                        prevListIndex = listIndex;
                    }
                    if (found || mgmtIndexR % 2 == 0) continue;
                    String addr = vblRespIp.stringValue(k);
                    InetAddress inetAddr = NetUtil.parseIpAddress(addr);
                    boolean bl = isAddrMgmtAddr = addr.endsWith("eth-ip") && !inetAddr.isLinkLocalAddress() && !inetAddr.isMulticastAddress() && !addr.startsWith("n/a");
                    if (defaultAddr == null) {
                        defaultAddr = inetAddr;
                    }
                    if (!isAddrMgmtAddr || !(inetAddr instanceof Inet4Address)) continue;
                    found = true;
                    sw.setInetAddr(inetAddr);
                }
            }
            for (VsanDomainId vsanDomainId : switchHash.keySet()) {
                Switch dmSwitch = (Switch)switchHash.get(vsanDomainId);
                switchArray.add(dmSwitch);
            }
            return switchHash;
        }
        catch (SnmpException ex) {
            if (SnmpSession.isTrace()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static HashMap getEndPortHash(HashMap switchHash, SnmpPeer peer, int vsanId, InetAddress myIpAddr, ArrayList endPortList, ArrayList switchArray, ArrayList npvISLArray) {
        HashMap<Wwn, EndPort> endPointHash;
        block20: {
            endPointHash = new HashMap<Wwn, EndPort>();
            if (switchHash == null) {
                switchArray = new ArrayList<Switch>();
                switchHash = SwitchMapUtil.getSwitchMapHash(peer, vsanId, switchArray);
            }
            if (switchHash == null) {
                return endPointHash;
            }
            try {
                String[] ns = new String[]{"fcNameServerPortName", "fcNameServerFabricPortName", "fcNameServerFC4Type", "fcNameServerNodeName", "fcNameServerNodeIpAddress", "fcNameServerSymbolicPortName", "fcNameServerProcAssoc"};
                int[][] nsVars = new int[ns.length][];
                for (int i = 0; i < ns.length; ++i) {
                    nsVars[i] = MibNode.get(ns[i]).getOid();
                }
                VarBindList vbl = new VarBindList(nsVars.length);
                for (int i = 0; i < nsVars.length; ++i) {
                    if (vsanId == 0) {
                        vbl.add(new SnmpVarBind(new SnmpOID(nsVars[i])));
                        continue;
                    }
                    vbl.add(new SnmpVarBind(new SnmpOID(nsVars[i], vsanId)));
                }
                SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
                VarBindList vblResp = resp.getVariables();
                for (int i = 0; i < vblResp.size(); i += nsVars.length) {
                    boolean isCisco;
                    SnmpVarBind vb = vblResp.getVb(i);
                    int[] oid = vb.getOid().getValue();
                    int vsan = oid[oid.length - 4];
                    int fcIdNum = (oid[oid.length - 3] << 16) + (oid[oid.length - 2] << 8) + oid[oid.length - 1];
                    Wwn pWwn = new Wwn(vblResp.byteValue(i));
                    byte[] fWwnb = vblResp.byteValue(i + 1);
                    Wwn cc = new Wwn(fWwnb);
                    String ccc = cc.toString();
                    String ddd = pWwn.toString();
                    int domainId = fcIdNum >> 16;
                    if (vsanId != 0 && vsan != vsanId) break;
                    int[] fc4Types = vblResp.byteValue(i + 2) == null ? null : SnmpIntList.valueOf(vblResp.byteValue(i + 2));
                    boolean isNPVLink = Fc4Decoder.isFc4TypeSet(fc4Types, 229);
                    if (myIpAddr != null && !isNPVLink) {
                        ArrayList swList = SwitchMapUtil.SwitchIPByVsanDomainId(switchHash, vsan, domainId);
                        boolean found = false;
                        for (int j = 0; j < swList.size(); ++j) {
                            if (((Switch)swList.get(j)).isNPVLink()) continue;
                            InetAddress ipAddr = ((Switch)swList.get(j)).getInetAddr();
                            String c = ipAddr == null ? "" : ipAddr.toString();
                            String d = myIpAddr.toString();
                            if (ipAddr == null || !ipAddr.equals(myIpAddr)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                    if (fWwnb.length == 0 || fWwnb[0] == 0 || (isCisco = WwnDictionary.isCiscoWwn(pWwn.getValue())) && pWwn.getValue()[0] >> 4 == 1 || WwnDictionary.isVRRP(pWwn.getValue()) || Fc4Decoder.isFc4TypeSet(fc4Types, 224) || Fc4Decoder.isFc4TypeSet(fc4Types, 225) || Fc4Decoder.isFc4TypeSet(fc4Types, 24)) continue;
                    if (isNPVLink) {
                        boolean isMDS;
                        System.out.println("..............  npv link");
                        Wwn nWWN = new Wwn(vblResp.byteValue(i + 3));
                        byte[] wwnB = nWWN.getValue();
                        boolean bl = isMDS = WwnDictionary.isCiscoWwn(wwnB) && wwnB[0] >> 4 == 2;
                        if (isMDS) {
                            wwnB = WwnDictionary.vsanWwnToSwwn(wwnB);
                        }
                        Wwn wwnV = new Wwn(wwnB);
                        String a = wwnV.toString();
                        Switch coreSwitch = null;
                        InetAddress nodeIp = null;
                        byte[] b = vblResp.byteValue(i + 4);
                        if (!GenUtil.isValueFilled(b, (byte)0)) {
                            try {
                                nodeIp = GenUtil.startsWith(b, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}) ? Inet4Address.getByAddress(new byte[]{b[12], b[13], b[14], b[15]}) : Inet6Address.getByAddress(b);
                            }
                            catch (UnknownHostException uhe) {
                                System.out.println(pWwn + " -- returns invalid node IP address: " + SnmpString.toHexString(b));
                            }
                        }
                        String e = nodeIp != null ? nodeIp.toString() : "null";
                        for (Object VsanDomainId2 : switchHash.keySet()) {
                            String aaa;
                            Switch sw = (Switch)switchHash.get(VsanDomainId2);
                            String string = aaa = sw.getInetAddr() == null ? "" : sw.getInetAddr().toString();
                            if (vsan != sw.getVsan() || domainId != sw.getDomainId() || sw.isNPVLink() || sw.getInetAddr() == null) continue;
                            String v = sw.getInetAddr().toString();
                            coreSwitch = sw;
                            break;
                        }
                        if (coreSwitch != null && coreSwitch.getInetAddr() != null && coreSwitch.getInetAddr().equals(myIpAddr)) {
                            String symNodeName = vblResp.stringValue(i + 5);
                            if (symNodeName == null || symNodeName.trim().length() == 0) {
                                symNodeName = "";
                            }
                            int fpIfIndex = Discover.getRoot().ifWwn2IfIndex(fWwnb, IfIndexIf.FwwnInfo.NPV);
                            int npIfIndex = Discover.getRoot().ifWwn2IfIndex(pWwn.getValue(), IfIndexIf.FwwnInfo.NPV);
                            IslLink dmIsl = new IslLink(vsanId, myIpAddr, domainId, fpIfIndex, nodeIp, domainId, npIfIndex, symNodeName);
                            dmIsl.setfWwn(fWwnb);
                            npvISLArray.add(dmIsl);
                        }
                        if (SwitchMapUtil.switchExist(switchHash, vsanId, domainId, nodeIp)) continue;
                        VsanDomainId vsanDomainId = new VsanDomainId(vsan, domainId, wwnV);
                        Switch dmSwitch = new Switch(vsan, domainId, wwnV, isMDS, true);
                        dmSwitch.setfWwn(fWwnb);
                        dmSwitch.setPWWN(pWwn);
                        dmSwitch.setInetAddr(nodeIp);
                        dmSwitch.setCoreSwitch(coreSwitch);
                        switchHash.put(vsanDomainId, dmSwitch);
                        switchArray.add(dmSwitch);
                        continue;
                    }
                    byte[] ipa = vblResp.byteValue(i + 6);
                    int ipaIfIndex = SwitchMapUtil.ipaToIfIndex(ipa);
                    int ifindex = ipaIfIndex == -1 ? Discover.getRoot().ifWwn2IfIndex(fWwnb, IfIndexIf.FwwnInfo.EP) : ipaIfIndex;
                    EndPort dmEndPort = new EndPort(vsan, domainId, pWwn, fcIdNum, fWwnb, ifindex);
                    endPointHash.put(pWwn, dmEndPort);
                    endPortList.add(dmEndPort);
                }
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block20;
                ex.printStackTrace();
            }
        }
        for (int i = endPortList.size() - 1; i >= 0; --i) {
            EndPort endPort = (EndPort)endPortList.get(i);
            byte[] fWwnb = endPort.getfWwn();
            for (int j = 0; j < npvISLArray.size(); ++j) {
                IslLink npvLink = (IslLink)npvISLArray.get(j);
                if (!Arrays.equals(fWwnb, npvLink.getfWwn())) continue;
                endPortList.remove(i);
                endPointHash.remove(endPort.getWWN());
            }
        }
        return endPointHash;
    }

    public static HashMap getDeviceAliasHash(HashMap switchHash, HashMap endPortHash, SnmpPeer peer, int vsanId, InetAddress myIpAddr, ArrayList endPortList, ArrayList switchArray, ArrayList deviceAliasList) {
        HashMap<String, DeviceAlias> deviceAliasHash;
        block8: {
            deviceAliasHash = new HashMap<String, DeviceAlias>();
            if (switchHash == null) {
                switchHash = SwitchMapUtil.getSwitchMapHash(peer, vsanId, new ArrayList());
            }
            if (switchHash == null) {
                return deviceAliasHash;
            }
            if (endPortHash == null) {
                endPortHash = SwitchMapUtil.getEndPortHash(switchHash, peer, vsanId, myIpAddr, endPortList, switchArray, new ArrayList());
            }
            try {
                String[] da = new String[]{"cfdaConfigDeviceId"};
                int[][] daVars = new int[da.length][];
                for (int i = 0; i < da.length; ++i) {
                    daVars[i] = MibNode.get(da[i]).getOid();
                }
                VarBindList vbl = new VarBindList(daVars.length);
                for (int i = 0; i < daVars.length; ++i) {
                    vbl.add(new SnmpVarBind(new SnmpOID(daVars[i])));
                }
                SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
                VarBindList vblResp = resp.getVariables();
                int offset = MibNode.get(da[0]).getOid().length;
                for (int i = 0; i < vblResp.size(); i += daVars.length) {
                    int[] oid = vblResp.get(i).getOid().getValue();
                    String alias = SnmpString.toString(oid, offset + 1, oid.length);
                    Wwn pWwn = new Wwn(vblResp.byteValue(i));
                    EndPort ep = SwitchMapUtil.endPortByPWWN(endPortHash, pWwn);
                    if (vsanId != 0 && (ep == null || vsanId != ep.getVsanId())) continue;
                    DeviceAlias das = new DeviceAlias(alias, ep, pWwn);
                    deviceAliasHash.put(alias, das);
                    deviceAliasList.add(das);
                }
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block8;
                ex.printStackTrace();
            }
        }
        return deviceAliasHash;
    }

    public static ArrayList getIslArray(HashMap switchHash, ArrayList npvISLList, SnmpPeer peer, int vsanId, InetAddress myIpAddr, InetAddress nbrIpAddr, int filterType) {
        return SwitchMapUtil.getIslArray(switchHash, npvISLList, peer, vsanId, myIpAddr, nbrIpAddr, filterType, false);
    }

    public static ArrayList getIslArray(HashMap switchHash, ArrayList npvISLList, SnmpPeer peer, int vsanId, InetAddress myIpAddr, InetAddress nbrIpAddr, int filterType, boolean needPortChannelMembers) {
        ArrayList<IslLink> islList;
        block16: {
            islList = new ArrayList<IslLink>();
            if (switchHash == null) {
                switchHash = SwitchMapUtil.getSwitchMapHash(peer, vsanId, new ArrayList());
            }
            if (switchHash == null) {
                return islList;
            }
            try {
                int j;
                int i;
                String[] fspf = new String[]{"fspfLinkNbrDomainId", "fspfLinkPortIndex", "fspfLinkNbrPortIndex"};
                int[] fcIfWwn = MibNode.get("fcIfWwn").getOid();
                int[][] fspfVars = new int[fspf.length][];
                for (int i2 = 0; i2 < fspf.length; ++i2) {
                    fspfVars[i2] = MibNode.get(fspf[i2]).getOid();
                }
                VarBindList vbl = new VarBindList(fspfVars.length);
                VarBindList wwnVbl = new VarBindList();
                for (int i3 = 0; i3 < fspfVars.length; ++i3) {
                    if (vsanId == 0) {
                        vbl.add(new SnmpVarBind(new SnmpOID(fspfVars[i3])));
                        continue;
                    }
                    vbl.add(new SnmpVarBind(new SnmpOID(fspfVars[i3], vsanId)));
                }
                VarBindList pcList = new VarBindList();
                ArrayList<Integer> pcListPos = new ArrayList<Integer>();
                SnmpPDU resp = SnmpFetch.getBulk(peer, vbl);
                VarBindList vblResp = resp.getVariables();
                for (i = 0; i < vblResp.size(); i += fspfVars.length) {
                    SnmpVarBind vb = vblResp.getVb(i);
                    int[] oid = vb.getOid().getValue();
                    int vsan = oid[oid.length - 4];
                    int domainId = oid[oid.length - 3];
                    int nbrDomainId = vblResp.intValue(i);
                    if (vsanId != 0 && vsan != vsanId) break;
                    if (myIpAddr == null) continue;
                    ArrayList swList = SwitchMapUtil.SwitchIPByVsanDomainId(switchHash, vsan, domainId);
                    for (j = 0; j < swList.size(); ++j) {
                        InetAddress ipAddr;
                        Switch dmSwitch = (Switch)swList.get(j);
                        if (dmSwitch == null || (ipAddr = dmSwitch.getInetAddr()) == null) continue;
                        String c = ipAddr.toString();
                        String d = myIpAddr.toString();
                        if (ipAddr == null || !ipAddr.equals(myIpAddr)) continue;
                        ArrayList nbrSwList = SwitchMapUtil.SwitchIPByVsanDomainId(switchHash, vsan, nbrDomainId);
                        for (int k = 0; k < nbrSwList.size(); ++k) {
                            Switch nbrSwitch = (Switch)nbrSwList.get(k);
                            if (dmSwitch == null || nbrSwitch == null) continue;
                            String a = nbrIpAddr == null ? "---" : nbrIpAddr.toString();
                            String b = nbrSwitch._inetAddr.toString();
                            if (nbrSwitch.isNPVLink() && !nbrSwitch.getCoreSwitch().getInetAddr().equals(myIpAddr) || !nbrSwitch.isNPVLink() && nbrIpAddr != null && nbrSwitch._inetAddr != null && !nbrIpAddr.equals(nbrSwitch._inetAddr)) continue;
                            int ifIndex = vblResp.intValue(i + 1);
                            int nbrIfIndex = vblResp.intValue(i + 2);
                            ifIndex = dmSwitch._isMDS ? IfIndexUtil.fspfPortIndexToIfIndex(ifIndex) : ifIndex;
                            int n = nbrIfIndex = dmSwitch._isMDS ? IfIndexUtil.fspfPortIndexToIfIndex(nbrIfIndex) : nbrIfIndex;
                            if (filterType == 1 && IfIndexUtil.getType(ifIndex) != 1 && IfIndexUtil.getType(ifIndex) != 4 && IfIndexUtil.getType(ifIndex) != 10 && IfIndexUtil.getType(ifIndex) != 30) continue;
                            IslLink dmIsl = new IslLink(vsan, dmSwitch._inetAddr, domainId, ifIndex, nbrSwitch._inetAddr, nbrDomainId, nbrIfIndex, null);
                            islList.add(dmIsl);
                            wwnVbl.add(new SnmpVarBind(new SnmpOID(fcIfWwn, new int[]{ifIndex})));
                            if (!needPortChannelMembers || IfIndexUtil.getType(ifIndex) != 4) continue;
                            pcList.add(MibNode.get("portChannelMemberList").getOid(), (ifIndex & 0xFF) + 1);
                            pcListPos.add(new Integer(islList.size() - 1));
                        }
                    }
                }
                if (wwnVbl.size() != 0) {
                    SnmpPDU respWwn = SnmpFetch.get(peer, wwnVbl);
                    VarBindList vblRespWwn = respWwn.getVariables();
                    for (int i4 = 0; i4 < islList.size() && i4 < vblRespWwn.size(); ++i4) {
                        byte[] fWWN = vblRespWwn.byteValue(i4);
                        IslLink dmIsl = (IslLink)islList.get(i4);
                        dmIsl.setfWwn(fWWN);
                    }
                }
                for (i = 0; i < npvISLList.size(); ++i) {
                    IslLink link = (IslLink)npvISLList.get(i);
                    if (!link.getIpAddr().equals(myIpAddr) || link.getNbrIpAddr() == null || nbrIpAddr != null && !link.getNbrIpAddr().equals(nbrIpAddr)) continue;
                    islList.add(link);
                }
                if (needPortChannelMembers && pcListPos.size() > 0 && pcList.size() > 0) {
                    SnmpPDU respMembers = SnmpFetch.get(peer, pcList);
                    pcList = respMembers.getVariables();
                    for (int i5 = pcList.size() - 1; i5 >= 0; --i5) {
                        SnmpVar pcMemberList = pcList.get(i5).getVar();
                        if (pcMemberList.getType() != 4) continue;
                        int[] memberList = SnmpIntList.valueOf(((SnmpString)pcList.get(i5).getVar()).getValue());
                        int pcPos = (Integer)pcListPos.get(i5);
                        IslLink pcIsl = (IslLink)islList.get(pcPos);
                        int pcIfIndex = pcIsl.getIslIfIndex();
                        for (j = 0; j < memberList.length; ++j) {
                            IslLink pcMember = new IslLink(pcIsl._vsanId, pcIsl.getIpAddr(), pcIsl.getDomainId(), memberList[j], pcIsl.getNbrIpAddr(), pcIsl.getNbrDomainId(), pcIsl._nbrIslIfIndex, pcIfIndex, pcIsl.getNbrIfIndexSymbolicName());
                            islList.add(pcMember);
                        }
                    }
                }
            }
            catch (SnmpException ex) {
                if (!SnmpSession.isTrace()) break block16;
                ex.printStackTrace();
            }
        }
        return islList;
    }

    public static ArrayList SwitchIPByVsanDomainId(HashMap switchHash, int vsanId, int domainId) {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        for (VsanDomainId swKey : switchHash.keySet()) {
            if (swKey.getVsanId() != vsanId || swKey.getDomainId() != domainId) continue;
            Switch dmSwitch = (Switch)switchHash.get(swKey);
            swList.add(dmSwitch);
        }
        return swList;
    }

    public static Switch SwitchIPByVsanDomainIdCore(HashMap switchHash, int vsanId, int domainId) {
        for (VsanDomainId swKey : switchHash.keySet()) {
            Switch dmSwitch = (Switch)switchHash.get(swKey);
            if (swKey.getVsanId() != vsanId || swKey.getDomainId() != domainId || dmSwitch.isNPVLink()) continue;
            return dmSwitch;
        }
        return null;
    }

    public static InetAddress SwitchIPByVsanDomainIdWwn(HashMap switchHash, int vsanId, int domainId, Wwn wwn) {
        Switch dmSwitch = (Switch)switchHash.get(new VsanDomainId(vsanId, domainId, wwn));
        return dmSwitch == null ? null : dmSwitch.getInetAddr();
    }

    public static InetAddress SwitchIPBySwitchWWN(HashMap switchHash, Wwn switchWWN) {
        if (switchHash == null || switchHash.size() == 0 || switchWWN.getValue().length == 0) {
            return null;
        }
        for (Object VsanDomainId2 : switchHash.keySet()) {
            Switch dmSwitch = (Switch)switchHash.get(VsanDomainId2);
            if (!switchWWN.equals(dmSwitch.getWWN())) continue;
            return dmSwitch.getInetAddr();
        }
        return null;
    }

    public static EndPort endPortByPWWN(HashMap endPortHash, Wwn pWWN) {
        if (endPortHash == null || pWWN.getValue().length == 0) {
            return null;
        }
        return (EndPort)endPortHash.get(pWWN);
    }

    public static int getDomainId(HashMap switchHash, int vsanId, InetAddress ipAddr) {
        for (Object VsanDomainId2 : switchHash.keySet()) {
            Switch dmSwitch = (Switch)switchHash.get(VsanDomainId2);
            if (dmSwitch.getVsan() != vsanId || !dmSwitch.getInetAddr().equals(ipAddr)) continue;
            return dmSwitch.getDomainId();
        }
        return -1;
    }

    public static boolean switchExist(HashMap switchHash, int vsanId, int domainId, InetAddress ip) {
        for (Object VsanDomainId2 : switchHash.keySet()) {
            Switch dmSwitch = (Switch)switchHash.get(VsanDomainId2);
            if (dmSwitch.getVsan() != vsanId || ip == null || dmSwitch.getInetAddr() == null || !ip.equals(dmSwitch.getInetAddr())) continue;
            return true;
        }
        return false;
    }

    public static int ipaToIfIndex(byte[] ipa) {
        if (ipa.length < 8 || Arrays.equals(ipa, new byte[]{0, 0, 0, 0, 0, 0, 0, 0}) || Arrays.equals(ipa, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1})) {
            return -1;
        }
        return ((ipa[4] & 0xFF) << 24) + ((ipa[5] & 0xFF) << 16) + ((ipa[6] & 0xFF) << 8) + (ipa[7] & 0xFF);
    }
}

