/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.mds.PortChooser;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckboxMenuButton;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class VsanIdCheckboxMenuButton
extends CheckboxMenuButton {
    public static final int VSAN_TYPE = 1;
    public static final int VSAN_IP_TYPE = 2;
    SnmpPeer _peer;
    EditForm _parent;
    int _type;

    public VsanIdCheckboxMenuButton(JMenu menu, SnmpPeer peer) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._type = 1;
    }

    public VsanIdCheckboxMenuButton(JMenu menu, SnmpPeer peer, int type) {
        super(menu);
        this._peer = peer;
        this._parent = null;
        this._type = type;
    }

    public void setParent(EditForm parent) {
        this._parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._menu == null) {
            this._menu = new JMenu();
            try {
                Object[] names;
                Object[] objectArray = names = this._type == 1 ? this.getVsanId(this._peer) : this.getVsanIPId(this._peer);
                if (names == null || names.length == 0) {
                    this.setEnabled(false);
                    return;
                }
                this.buildMenu(names);
            }
            catch (SnmpException snmpException) {
                // empty catch block
            }
        }
        super.actionPerformed(e);
        if (e.getSource() instanceof JMenuItem && this._parent != null) {
            this._parent.setChanged((FieldPanel)this.getParent());
        }
    }

    protected String[] getVsanId(SnmpPeer peer) throws SnmpException {
        VarBindList vbl = new VarBindList();
        int[] vsanName = MibNode.get("vsanName").getOid();
        int oidLen = vsanName.length;
        vbl.add(new SnmpVarBind(new SnmpOID(vsanName)));
        vbl = SnmpFetch.getBulk(peer, vbl, 0).getVariables();
        if (vbl.size() == 0) {
            return null;
        }
        Array<String> vsanId = new Array<String>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.get(i).getOid().getValue();
            if (oid[oidLen] == 4094) continue;
            vsanId.addElement(SnmpOID.toString(oid, oidLen, oid.length));
        }
        if (vsanId.size() == 0) {
            return null;
        }
        String[] names = new String[vsanId.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)vsanId.elementAt(i);
        }
        return names;
    }

    protected String[] getVsanIPId(SnmpPeer peer) throws SnmpException {
        int[] interfaceList = new int[]{};
        try {
            interfaceList = PortChooser.fetchInterfaces(peer, 4, Discover.getRoot());
        }
        catch (SnmpException ex) {
            return new String[0];
        }
        if (interfaceList == null || interfaceList.length == 0) {
            return null;
        }
        String[] names = new String[interfaceList.length];
        for (int j = 0; j < interfaceList.length; ++j) {
            names[j] = Discover.getRoot().ifIndexToName(interfaceList[j]);
        }
        return names;
    }
}

