/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CopyConfigUtil;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.NetUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.Timer;

public class EditConfigForm
extends EditForm
implements ItemListener {
    static final int IPV4 = 1;
    static final int COPY_FROM = 0;
    static final int COPY_TO = 1;
    static final int IPADDRESS = 3;
    static final int FILENAME = 4;
    static final int PROTOCOL = 5;
    static final int USER = 6;
    static final int PASSWORD = 7;
    SnmpPDU _ccStatusPDU;
    int[] _index;
    protected Timer _statusTimer;
    int _elapsedPollTime;
    MibEnum[] srcEnums;
    MibEnum[] dstEnums;
    MibEnum[] protocolEnums;
    FieldPanel _fileName;

    public EditConfigForm(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        ((RadioButtonPanel)this.getComponentAt(0)).setSelected(1);
        ((RadioButtonPanel)this.getComponentAt(1)).setSelected(0);
        if (Discover.isSysVersionlessThan("2.1(0)")) {
            ((RadioButtonPanel)this.getComponentAt(1)).getButton(((RadioButtonPanel)this.getComponentAt(1)).getComponentCount() - 1).setVisible(false);
        }
        ((RadioButtonPanel)this.getComponentAt(1)).getComponent(1).setVisible(false);
        ((RadioButtonPanel)this.getComponentAt(0)).addChangeListener(this);
        ((RadioButtonPanel)this.getComponentAt(1)).addChangeListener(this);
        try {
            Discover.getInstance();
            String localAddr = NetUtil.detectSourceAddress(Discover.getPeer().getAddress()).getHostAddress();
            this.setComponentText(3, localAddr);
        }
        catch (Exception ex) {
            try {
                this.setComponentText(3, InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this._fileName.setText(Discover.getDeviceName() + "_cfg.txt");
        ((RadioButtonPanel)this.getComponentAt(5)).addChangeListener(this);
        ((RadioButtonPanel)this.getComponentAt(5)).getButton(1).doClick();
        ((RadioButtonPanel)this.getComponentAt(5)).getButton(0).doClick();
        this.setComponentText(6, this.getPeer().getUserName());
        this.setComponentText(7, this.getPeer().getAuthPassword());
        this.getComponentAt(0).setFont(ChangedCellRenderer.getNormalFont());
        this.getComponentAt(1).setFont(ChangedCellRenderer.getNormalFont());
        this.getComponentAt(5).setFont(ChangedCellRenderer.getNormalFont());
        this.getButton('R').setVisible(false);
        this.getButton('A').setEnabled(true);
        this.srcEnums = this._mibNodes[0].getEnums();
        this.dstEnums = this._mibNodes[1].getEnums();
        this.protocolEnums = this._mibNodes[5].getEnums();
        this.setCFSButton();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        String btn = ((JRadioButton)e.getSource()).getText();
        if (btn.equals("tftp") || btn.equals("ftp") || btn.equals("sftp")) {
            boolean enable = ((JToggleButton)e.getSource()).getText().charAt(0) != 't';
            this.setEnabled(6, enable);
            this.setEnabled(7, enable);
        } else {
            int selectedFrom;
            String from;
            int selectedTo = ((RadioButtonPanel)this._values[1]).getSelected();
            String to = ((JRadioButton)((RadioButtonPanel)this._values[1]).getButton(selectedTo)).getText();
            ((RadioButtonPanel)this._values[0]).getButton(0).setEnabled(!to.startsWith("fabric"));
            ((RadioButtonPanel)this._values[0]).getButton(1).setEnabled(!to.startsWith("fabric"));
            if (to.startsWith("fabric")) {
                ((RadioButtonPanel)this._values[0]).getButton(2).doClick();
            }
            boolean enable = (from = ((JRadioButton)((RadioButtonPanel)this._values[0]).getButton(selectedFrom = ((RadioButtonPanel)this._values[0]).getSelected())).getText()).startsWith("server") || to.startsWith("server");
            boolean istftp = ((RadioButtonPanel)this._values[5]).getSelected() == 0;
            this.setEnabled(3, enable);
            this._fileName.setEnabled(enable);
            this.setEnabled(5, enable);
            this.setEnabled(6, enable && !istftp);
            this.setEnabled(7, enable && !istftp);
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 4) {
            JButton browse = new JButton("...");
            browse.addActionListener(this);
            browse.setMargin(DialogUtil.getInsets());
            this._fileName = new FieldPanel(20, (JComponent)browse);
            JPanel fileNamePanel = new JPanel(new BorderLayout());
            fileNamePanel.add((Component)new JLabel("(Path may need to be relative to TFTP root)"), "East");
            fileNamePanel.add((Component)this._fileName, "West");
            return fileNamePanel;
        }
        if (index == 7) {
            return new JPasswordField();
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void get() {
    }

    @Override
    protected void addChangeListener(int index) {
    }

    @Override
    protected void set() throws Exception {
        if (((JTextField)this._values[3]).getText().equals("")) {
            throw new Exception("Please provide Server Address.");
        }
        SnmpPeer snmpPeer = this.getPeer();
        int n = this.srcEnums[((RadioButtonPanel)this.getComponentAt(0)).getSelected()].getValue();
        int n2 = this.dstEnums[((RadioButtonPanel)this.getComponentAt(1)).getSelected()].getValue();
        String string = ((JTextField)this._values[3]).getText();
        String string2 = this._fileName.getText();
        int n3 = this.protocolEnums[((RadioButtonPanel)this.getComponentAt(5)).getSelected()].getValue();
        String string3 = ((JTextField)this._values[6]).getText();
        String string4 = ((JTextField)this._values[7]).getText();
        Discover.getInstance();
        this._index = CopyConfigUtil.CopyConfig(snmpPeer, n, n2, string, string2, n3, string3, string4, Discover.getSysVersionWithMinor());
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        this.enableButton('A', false);
        this._ccStatusPDU = CopyConfigUtil.getCopyConfigStatusPDU(this._index);
        this._elapsedPollTime = 0;
        this._statusTimer = new Timer(3000, this);
        this._statusTimer.start();
    }

    void pollSwitch() throws Exception {
        if (this._parent == null) {
            this._statusTimer.stop();
            return;
        }
        SnmpPDU resp = this.getPeer().send(this._ccStatusPDU);
        if (resp.getVar(0).getType() == 5) {
            throw new Exception("Copy Config failed: unknown");
        }
        int state = ((SnmpInt)resp.getVar(0)).getValue();
        if (state == 1 || state == 2) {
            this.setStatus(this._elapsedPollTime + " secs");
            return;
        }
        this._statusTimer.stop();
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.enableButton('A', true);
        if (state == 3) {
            this.setStatus("File transfer successful [" + this._elapsedPollTime + " secs]");
            if (this.srcEnums[((RadioButtonPanel)this.getComponentAt(0)).getSelected()].getValue() == 4 && this.dstEnums[((RadioButtonPanel)this.getComponentAt(1)).getSelected()].getValue() == 3) {
                this.getPeer().resetNumSets();
            }
            CopyConfigUtil.deleteCopyConfigEntry(this.getPeer(), this._index);
        } else if (state == 4) {
            this.setStatus(" ");
            int failCause = ((SnmpInt)resp.getVar(1)).getValue();
            if (failCause == 7) {
                if (JOptionPane.showConfirmDialog(this.getParent(), "The config file had errors.\nOpen error log in browser?", this.getParent().getTitle(), 0, 2) == 0) {
                    if (SnmpSession.isTrace()) {
                        DefaultLogger._DefLogger.debug((Object)("cc error: someConfigApplyFailed, opening http://" + Discover.getLoginDeviceName() + "/configcopy.txt"));
                    }
                    ExternalTools.openURL("http://" + Discover.getLoginDeviceName() + "/configcopy.txt");
                }
                CopyConfigUtil.deleteCopyConfigEntry(this.getPeer(), this._index);
                return;
            }
            if (failCause == 9) {
                String log = this.getErrorLog(this._index);
                if (log.equals("")) {
                    log = "RequestAborted, no detailed error.";
                }
                Util.errorMessage((Component)this._parent, log);
                CopyConfigUtil.deleteCopyConfigEntry(this.getPeer(), this._index);
                return;
            }
            CopyConfigUtil.deleteCopyConfigEntry(this.getPeer(), this._index);
            throw new Exception("Copy Config failed: " + MibEnum.getLabel(MibNode.get("ccCopyFailCause").getEnums(), failCause));
        }
    }

    private String getErrorLog(int[] index) {
        try {
            VarBindList vbl = new VarBindList();
            vbl = new VarBindList();
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ccCopyErrorDeviceIpAddressType").getOid(), index)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ccCopyErrorDeviceIpAddress").getOid(), index)));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("ccCopyErrorDescription").getOid(), index)));
            vbl = SnmpFetch.getBulk(this.getPeer(), vbl).getVariables();
            if (vbl.size() == 0) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            int indexLen = MibNode.get("ccCopyErrorDeviceIpAddressType").getOid().length;
            for (int i = 0; i < vbl.size(); i += 3) {
                int type = vbl.intValue(i);
                if (type == 1) {
                    sb.append(SnmpIpAddress.toString(((SnmpString)vbl.get(i + 1).getVar()).getValue()));
                } else {
                    sb.append(vbl.stringValue(i + 1));
                }
                sb.append(" ");
                sb.append(vbl.stringValue(i + 2));
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (SnmpException ex) {
            StringBuffer sb = new StringBuffer();
            sb.append("failed to retreive errorTable: ");
            sb.append(ex.getMessage());
            return sb.toString();
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (e.getSource() == this._statusTimer) {
            try {
                this._elapsedPollTime += 3;
                this.pollSwitch();
            }
            catch (Exception ex) {
                this._statusTimer.stop();
                throw ex;
            }
        } else if (ch == '.') {
            String fName = Util.getFileName(DeviceManager.getInstance(), "*_cfg.txt", 0, false);
            if (fName != null) {
                this._fileName.setText(fName);
            }
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        try {
            return super.getComponentValue(index);
        }
        catch (Exception ex) {
            if (index == 3) {
                String server = ((JTextField)this._values[index]).getText();
                try {
                    InetAddress addr = InetAddress.getByName(server);
                    return new SnmpIpAddress(addr.getHostAddress());
                }
                catch (Exception ex2) {
                    throw ex;
                }
            }
            throw ex;
        }
    }
}

