/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.admin;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.ActionRenderer;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.renderers.BackgroundRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class EditFeatureControlTable
extends EditTable {
    Timer _statusTimer;
    static final int[] _cfcFeatureCtrlActionOid = MibNode.get("cfcFeatureCtrlAction").getOid();
    static final int[] _cfcFeatureCtrlLastActionOid = MibNode.get("cfcFeatureCtrlLastAction").getOid();
    static final int[] _cfcFeatureCtrlLastActionResultOid = MibNode.get("cfcFeatureCtrlLastActionResult").getOid();
    static final int[] _cfcFeatureCtrlLastFailureReasonOid = MibNode.get("cfcFeatureCtrlLastFailureReason").getOid();
    static final int[] _cfcFeatureCtrlOpStatusOid = MibNode.get("cfcFeatureCtrlOpStatus").getOid();
    static final int[] _clmLicenseFlagOid = MibNode.get("clmLicenseFlag").getOid();
    static final int[] _clmLicenseGracePeriodLeftOid = MibNode.get("clmLicenseGracePeriodLeft").getOid();
    static final int[] MAINFRAME_LICENSE_INDEX = new int[]{13, 77, 65, 73, 78, 70, 82, 65, 77, 69, 95, 80, 75, 71};
    Array _actionChangedCells = new Array();
    boolean _isPolling = false;
    static final int INDEX_COL = 0;
    static final int FEATURE_COL = 1;
    static final int OP_STATUS_COL = 2;
    static final int ACTION_COL = 3;
    static final int LAST_ACTION_COL = 4;
    static final int ACTION_STATUS_COL = 5;
    static final int FAILURE_REASON_COL = 6;
    static final int ACTION_RESULT_INPROGRESS = 4;
    static final int FCIP_INDEX = 2;
    static final int FICON_INDEX = 4;
    static final int ISCSI_INDEX = 5;
    static final int ISCSI_VSAN_MEMBERSHIP_INDEX = 10;
    static final int ISNS_INDEX = 12;
    static final int ISNS_CLOUD_DISCOVERY_INDEX = 20;
    static final int CLUSTER_INDEX = 32;
    static final int SME_INDEX = 33;
    static final int LACP_INDEX = 34;
    static final int NPV_INDEX = 37;
    static final int INTFACE_VLAN_INDEX = 42;
    static final int PRIVATE_VLAN_INDEX = 44;
    static final int ETH_PORT_SEC_INDEX = 46;
    static final int UDLD_INDEX = 50;
    static final int ENM_INDEX = 56;
    static final int OTV_INDEX = 59;
    static final int FCOE_INDEX = 66;
    static final int FPORT_CHANNEL_TRUNK = 68;
    static final int IOA_INDEX = 72;
    static final int WCCP_INDEX = 76;
    static final String npvEnableWarningMsg = "<html>Changing to npv mode erases the current configuration and reboots the switch in npv mode.<p>Do you want to continue?</html>";
    static final String npvDisableWarningMsg = "<html>Disabling npv mode erases the current configuration and reboots the switch in non-npv mode.<p>Do you want to continue?</html>";
    static final String fcoeWarningMsg = "<html>For the fcoe feature changes to be effective, you would need to save the current configuration<p> and then reboot the switch.<p>Do you want to continue?</html>";
    static final String ficonWarningMsg = "<html>MAINFRAME_PKG license not installed. ficon feature will be shut down after grace period of approximately ";
    static final String fTrunkingWarningMsg = "<html>Admin trunk mode will be set to off for<p>1- Interfaces with admin switchport mode F,FL,FX,SD,ST in admin down state<p>2- Interfaces with operational switchport mode F,FL,SD,ST..<p>Continue?</html>";
    boolean _hasIPS = DmSystem.hasIPS();
    boolean _mainFrame_Licence_InGracePeriod;
    String _mainFrame_Licence_GraceLeft;

    public EditFeatureControlTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        this._table.getColumnModel().getColumn(1).setCellRenderer(new BackgroundRenderer());
        this._table.removeColumn(this._table.getColumnModel().getColumn(5));
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this._tableModel.sort(1, false);
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        this._table.getColumnModel().getColumn(4).setCellRenderer(new ActionRenderer());
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        String result = (String)row[5];
        if (result.equals("failed")) {
            row[5] = result + " - " + ((SnmpString)row[6]).toString();
        }
        return row;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        this._mainFrame_Licence_InGracePeriod = false;
        this._mainFrame_Licence_GraceLeft = "";
        VarBindList vbl = new VarBindList();
        vbl.add(_clmLicenseFlagOid, MAINFRAME_LICENSE_INDEX);
        vbl.add(_clmLicenseGracePeriodLeftOid, MAINFRAME_LICENSE_INDEX);
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        SnmpPDU resp = this.getPeer().send(pdu);
        SnmpVar var = resp.getVariables().getVb(0).getVar();
        if (var.getType() != 4) {
            return;
        }
        byte[] bits = ((SnmpString)var).getValue();
        if (SnmpString.getBitBase0(bits, 4) && !SnmpString.getBitBase0(bits, 1)) {
            this._mainFrame_Licence_InGracePeriod = true;
            int gracePeriod = resp.getVariables().intValue(1);
            this._mainFrame_Licence_GraceLeft = MibVariableFormat.clmLicenseGracePeriodLeft(gracePeriod, var).toString();
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'A') {
            if (this._actionChangedCells != null) {
                this._actionChangedCells.clear();
            }
            this._actionChangedCells = this._tableModel.getChanged();
            if (this._actionChangedCells == null || this._actionChangedCells.size() == 0) {
                return;
            }
            Array<Cell> prunedCells = new Array<Cell>();
            for (int i = 0; i < this._actionChangedCells.size(); ++i) {
                Cell changedCell = (Cell)this._actionChangedCells.elementAt(i);
                if (changedCell._col != 3) continue;
                prunedCells.addElement(changedCell);
            }
            this._actionChangedCells = prunedCells;
            if (prunedCells.size() > 0) {
                if (this._statusTimer == null) {
                    this._statusTimer = new Timer(1000, this);
                }
                if (this._statusTimer.isRunning()) {
                    this._statusTimer.restart();
                } else {
                    this._statusTimer.start();
                }
                super.doIt(ch, e);
                this.doPoll();
                this._isPolling = true;
            } else {
                super.doIt(ch, e);
            }
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    public void dispose() {
        this.stopPoll();
        super.dispose();
    }

    private void stopPoll() {
        if (this._isPolling) {
            this._statusTimer.stop();
            this._isPolling = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._isPolling) {
                this.doPoll();
                return;
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private void doPoll() {
        SnmpPDU respPDU;
        block13: {
            if (this._parent == null) {
                this.stopPoll();
                return;
            }
            if (this._actionChangedCells == null || this._actionChangedCells.size() == 0) {
                this.stopPoll();
                return;
            }
            SnmpPDU getPDU = new SnmpPDU(-96, new VarBindList());
            for (int i = this._actionChangedCells.size() - 1; i >= 0; --i) {
                Cell thisCell = (Cell)this._actionChangedCells.elementAt(i);
                if (thisCell == null || thisCell._row == -1 || thisCell._row >= this._data.size()) {
                    this._actionChangedCells.removeElementAt(i);
                    continue;
                }
                int[] index = this._tableModel.getIndex(thisCell._row, thisCell._col);
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastActionResultOid, index)));
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastFailureReasonOid, index)));
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlOpStatusOid, index)));
                getPDU.addVar(new SnmpVarBind(new SnmpOID(_cfcFeatureCtrlLastActionOid, index)));
            }
            if (getPDU.getVariables().size() == 0) {
                this.stopPoll();
                return;
            }
            respPDU = null;
            try {
                respPDU = this.getPeer().send(getPDU);
            }
            catch (SnmpException se) {
                if (!SnmpSession.isTrace()) break block13;
                se.printStackTrace();
            }
        }
        if (respPDU == null) {
            return;
        }
        VarBindList respList = respPDU.getVariables();
        for (int i = 0; i < respList.size(); i += 4) {
            int[] cellIndex;
            SnmpVarBind resp = respList.getVb(i);
            int actionResult = respList.intValue(i);
            int[] oid = resp.getOid().getValue();
            int[] index = new int[oid.length - _cfcFeatureCtrlLastActionResultOid.length];
            System.arraycopy(oid, _cfcFeatureCtrlLastActionResultOid.length, index, 0, index.length);
            Cell actionChangedCell = null;
            int j = 0;
            for (j = 0; !(j >= this._actionChangedCells.size() || (actionChangedCell = (Cell)this._actionChangedCells.elementAt(j)) != null && actionChangedCell._row != -1 && actionChangedCell._row < this._data.size() && SnmpOID.equals(index, cellIndex = this._tableModel.getIndex(actionChangedCell._row))); ++j) {
            }
            if (actionChangedCell == null) {
                return;
            }
            String strLastActionResult = MibEnum.getLabel(MibNode.get("cfsFeatureOpLastActionResult").getEnums(), actionResult);
            String failureReason = respList.stringValue(i + 1);
            if (strLastActionResult.equals("failed")) {
                strLastActionResult = strLastActionResult + " - " + failureReason;
            }
            this._tableModel.setValueAt(strLastActionResult, actionChangedCell._row, 5);
            this._tableModel.setValueAt(MibEnum.getLabel(MibNode.get("cfcFeatureCtrlOpStatus").getEnums(), respList.intValue(i + 2)), actionChangedCell._row, 2);
            this._tableModel.setValueAt(MibEnum.getLabel(MibNode.get("cfsFeatureOpLastAction").getEnums(), respList.intValue(i + 3)), actionChangedCell._row, 4);
            this._table.calcPreferredSize();
            if (actionResult == 4) continue;
            this._actionChangedCells.removeElementAt(j);
            if (this._actionChangedCells.size() == 0) {
                this.stopPoll();
            }
            if (oid[oid.length - 1] != 4 || respList.intValue(i + 2) != 2 && respList.intValue(i + 2) != 3) continue;
            System.out.println(" enable AutoSave " + respList.intValue(i + 2));
            DmSystem._AutoSave.enable(respList.intValue(i + 2) == 2);
        }
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        int[] oid = pdu.getOid(0).getValue();
        if (!(this._hasIPS || oid[oid.length - 1] != 2 && oid[oid.length - 1] != 5 && oid[oid.length - 1] != 10 && oid[oid.length - 1] != 12 && oid[oid.length - 1] != 20)) {
            return true;
        }
        if (oid[oid.length - 1] == 4 && Discover.isSysVersionlessThan("3.0(0)")) {
            return true;
        }
        if (!DmSystem.isFeatureSupported4NPV(oid[oid.length - 1])) {
            return true;
        }
        return super.isSkip(pdu);
    }

    @Override
    protected boolean validateChanges(Array cells, SnmpTableModel model, String[][] mibVars, String[] message, int offset) {
        StringBuffer sb = new StringBuffer();
        int clusterSmeFlag = 0;
        StringBuffer errSb = new StringBuffer();
        for (int i = 0; i < cells.size(); ++i) {
            Object featureIndex;
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col != 3 || !SnmpOID.equals(((SnmpOID)(featureIndex = this._tableModel.getValueAt(cell._row, 0))).getValue(), new int[]{32}) && !SnmpOID.equals(((SnmpOID)featureIndex).getValue(), new int[]{33})) continue;
            if (clusterSmeFlag == 0) {
                ++clusterSmeFlag;
                continue;
            }
            if (clusterSmeFlag != 1) break;
            errSb.append("Please enable cluster before sme, or disable sme before cluster.");
            break;
        }
        if (errSb.toString().length() > 0) {
            Util.errorMessage((Component)this._parent, errSb.toString());
            return false;
        }
        ArrayList<String> warningStrings = new ArrayList<String>();
        ArrayList<String> resetWarningStrings = new ArrayList<String>();
        Object[] options = new String[]{"Yes", "No"};
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.elementAt(i);
            if (cell._col != 3) continue;
            Object action = this._tableModel.getValueAt(cell._row, 3);
            Object featureIndex = this._tableModel.getValueAt(cell._row, 0);
            if (SnmpOID.equals(((SnmpOID)featureIndex).getValue(), new int[]{66}) && Discover.isSysVersionlessThan("4.1(3)")) {
                resetWarningStrings.add(fcoeWarningMsg);
            } else if (SnmpOID.equals(((SnmpOID)featureIndex).getValue(), new int[]{37})) {
                if (((JnmMibEnum)action).getValue() == 2) {
                    resetWarningStrings.add(npvEnableWarningMsg);
                }
                if (((JnmMibEnum)action).getValue() == 3) {
                    resetWarningStrings.add(npvDisableWarningMsg);
                }
            } else if (SnmpOID.equals(((SnmpOID)featureIndex).getValue(), new int[]{68}) && ((JnmMibEnum)action).getValue() == 2) {
                warningStrings.add(fTrunkingWarningMsg);
            } else if (SnmpOID.equals(((SnmpOID)featureIndex).getValue(), new int[]{4}) && ((JnmMibEnum)action).getValue() == 2 && this._mainFrame_Licence_InGracePeriod) {
                StringBuffer msg = new StringBuffer();
                msg.append(ficonWarningMsg);
                msg.append(this._mainFrame_Licence_GraceLeft);
                msg.append("<p>Do you want to continue?</html>");
                warningStrings.add(msg.toString());
            }
            if (((JnmMibEnum)action).getValue() != 3 || SnmpOID.equals(((SnmpOID)featureIndex).getValue(), new int[]{37})) continue;
            Object featureName = this._tableModel.getValueAt(cell._row, 1);
            if (sb.toString().length() == 0) {
                sb.append(featureName);
                continue;
            }
            sb.append(", ");
            sb.append(featureName);
        }
        if (sb.toString().length() > 0 && JOptionPane.showOptionDialog(this.getParent(), "Are you sure?  Disabling " + sb.toString() + " will remove the feature's configuration.", this._parent.getTitle(), 0, 3, null, options, "No") == 1) {
            return false;
        }
        for (String warningString : warningStrings) {
            if (JOptionPane.showOptionDialog(this.getParent(), warningString, this._parent.getTitle(), 0, 3, null, options, "No") != 1) continue;
            return false;
        }
        for (String resetWarningString : resetWarningStrings) {
            if (JOptionPane.showOptionDialog(this.getParent(), resetWarningString, this._parent.getTitle(), 0, 3, null, options, "No") != 1) continue;
            return false;
        }
        return super.validateChanges(cells, model, mibVars, message, offset);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new FeatureControlTableModel();
    }

    class FeatureControlTableModel
    extends DmTableModel {
        FeatureControlTableModel() {
        }

        @Override
        public boolean isCellActive(int pRow, int pCol) {
            Object o;
            if (DmId.isN5K(Discover.getSysObjectID()) && (o = this.getValueAt(pRow, 0)) instanceof SnmpOID) {
                int featureIndex = ((SnmpOID)o).getValue()[0];
                return featureIndex != 44 && featureIndex != 42 && featureIndex != 50 && featureIndex != 34 && featureIndex != 46 && featureIndex != 56 && featureIndex != 59 && featureIndex != 72 && featureIndex != 76;
            }
            return super.isCellActive(pRow, pCol);
        }

        @Override
        public SnmpPDU setChangedCells() throws Exception {
            if (EditFeatureControlTable.this._actionChangedCells == null || EditFeatureControlTable.this._actionChangedCells.size() == 0) {
                return null;
            }
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(EditFeatureControlTable.this._actionChangedCells.size()));
            for (int i = 0; i < EditFeatureControlTable.this._actionChangedCells.size(); ++i) {
                Cell cell = (Cell)EditFeatureControlTable.this._actionChangedCells.elementAt(i);
                if (!this._mibNodes[cell._col].isEditable()) continue;
                int[] index = this.getIndex(cell._row, cell._col);
                SnmpOID oid = new SnmpOID(this._mibNodes[cell._col].getOid(), index);
                pdu.addVar(oid, this.getChangedCell(cell._row, cell._col));
            }
            return pdu;
        }
    }
}

