/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.Filter;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class EditCallHomeAlertForm
extends EditForm {
    int _failureCause = this.getVarIndex("callHomeAlertActionFailureCause");
    JTextArea _failureCauseTextArea;
    private boolean _isBuilt = false;

    public EditCallHomeAlertForm(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        this._isBuilt = false;
        RadioButtonPanel rbp = (RadioButtonPanel)this.getComponentAt(1);
        rbp.getButton(0).setVisible(false);
    }

    @Override
    protected JComponent buildNonEditableComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this._failureCause) {
            this._failureCauseTextArea = new JTextArea();
            this._failureCauseTextArea.setEditable(false);
            this._failureCauseTextArea.setWrapStyleWord(true);
            this._failureCauseTextArea.setLineWrap(true);
            this._failureCauseTextArea.setFont(ChangedCellRenderer.getNormalFont());
            this._failureCauseTextArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
            JScrollPane sp = new JScrollPane(this._failureCauseTextArea);
            sp.setPreferredSize(new Dimension(320, 70));
            return sp;
        }
        return super.buildNonEditableComponent(mibVar, mibNode, index);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i == this._failureCause) {
            this._failureCauseTextArea.setText(v.toString());
        } else {
            super.setComponentValue(i, v);
        }
    }

    @Override
    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        if (!this._isBuilt) {
            Dimension d = this._parent.getPreferredSize();
            int insets = Filter._IsMetal ? 1 : 3;
            this._parent.setPreferredSize(new Dimension(d.width + insets, d.height + insets));
            this._parent.validate();
            this._parent.invalidate();
            this._parent.pack();
            this._isBuilt = true;
        }
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        int[] _ccmMsgThrottlingEnableOid = MibNode.get("ccmMsgThrottlingEnable").getOid();
        int[] _ccmPeriodicSwInventoryMsgEnableOid = MibNode.get("ccmPeriodicSwInventoryMsgEnable").getOid();
        super.sendPdu(pdu);
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            int[] oid = pdu.getVariables().get(i).getOid().getValue();
            if (!SnmpOID.startsWith(oid, _ccmMsgThrottlingEnableOid) && !SnmpOID.startsWith(oid, _ccmPeriodicSwInventoryMsgEnableOid)) continue;
            this.setCFSPending(this.getPeer());
            break;
        }
    }
}

