/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.event;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dmdb.andiamo.dialogs.event.EditRmonTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.table.Cell;

public class EditHCAlarmTable
extends EditRmonTable {
    static final int ALARM_VALUE_SIGN = 12;
    static final int RISING_SIGN = 13;
    static final int RISING_HI = 14;
    static final int FALLING_SIGN = 15;
    static final int FALLING_HI = 16;
    static final int POSITIVE = 2;
    static final int NAGATIVE = 3;
    boolean _isSupportEntryModify = Discover.isSysVersionGreaterThanEqual("4.1(3)");

    public EditHCAlarmTable(String[] vars, boolean isHCAlarm) {
        super(vars, isHCAlarm);
    }

    @Override
    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(16));
        this._table.removeColumn(this._table.getColumnModel().getColumn(15));
        this._table.removeColumn(this._table.getColumnModel().getColumn(14));
        this._table.removeColumn(this._table.getColumnModel().getColumn(13));
        this._table.removeColumn(this._table.getColumnModel().getColumn(12));
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpHCAlarmlTableModel();
    }

    class SnmpHCAlarmlTableModel
    extends DmTableModel {
        SnmpHCAlarmlTableModel() {
        }

        @Override
        public Object toCellEditTable(MibNode mibNode, SnmpPDU pdu, SnmpVarBind vb, String var, SnmpOID index, int row, int col) {
            SnmpVar v = vb.getVar();
            if (var.equals("cHcAlarmRisingThreshAbsValueLo") || var.equals("cHcAlarmFallingThreshAbsValueLo")) {
                int signVarPos;
                int hiVarPos;
                if (var.equals("cHcAlarmRisingThreshAbsValueLo")) {
                    hiVarPos = 13;
                    signVarPos = 12;
                } else {
                    hiVarPos = 15;
                    signVarPos = 14;
                }
                SnmpVar[] values = new SnmpVar[]{pdu.getVar(signVarPos), pdu.getVar(hiVarPos), v};
                EditHCAlarmTable.this._tableModel;
                EditHCAlarmTable.this._tableModel;
                EditHCAlarmTable.this._tableModel;
                return DmTableModel.getMibVariableFormat(var, values, DmTableModel._MibVariableFormatMethods, DmTableModel._MibVariableFormatClass);
            }
            if (var.equals("cHcAlarmAbsValue")) {
                SnmpVar[] values = new SnmpVar[]{pdu.getVar(11), v};
                EditHCAlarmTable.this._tableModel;
                EditHCAlarmTable.this._tableModel;
                EditHCAlarmTable.this._tableModel;
                return DmTableModel.getMibVariableFormat(var, values, DmTableModel._MibVariableFormatMethods, DmTableModel._MibVariableFormatClass);
            }
            return super.toCellEditTable(mibNode, pdu, vb, var, index, row, col);
        }

        @Override
        protected void addChangedCell(SnmpPDU pdu, SnmpOID oid, Cell cell) throws Exception {
            if (cell._col == 6 || cell._col == 8) {
                Object o = this.getValueAt(cell._row, cell._col);
                if (o instanceof String) {
                    int sign;
                    int[] lowOid;
                    String text = (String)o;
                    int[] index = this.getIndex(cell._row, cell._col);
                    boolean isRising = cell._col == 6;
                    int[] signOid = isRising ? MibNode.get("cHcAlarmRisingThresholdValStatus").getOid() : MibNode.get("cHcAlarmFallingThrsholdValStatus").getOid();
                    int[] hiOid = isRising ? MibNode.get("cHcAlarmRisingThreshAbsValueHi").getOid() : MibNode.get("cHcAlarmFallingThreshAbsValueHi").getOid();
                    int[] nArray = lowOid = isRising ? MibNode.get("cHcAlarmRisingThreshAbsValueLo").getOid() : MibNode.get("cHcAlarmFallingThreshAbsValueLo").getOid();
                    if (text.startsWith("-")) {
                        sign = 3;
                        text = text.substring(1);
                    } else {
                        sign = 2;
                    }
                    pdu.addVar(new SnmpOID(signOid, index), new SnmpInt(sign));
                    long threshold = FieldPanel.getLongNumber(text);
                    if (threshold > -1L) {
                        long lo = threshold & 0xFFFFFFFFFFFFFFFFL;
                        long hi = threshold >> 32 & 0xFFFFFFFFFFFFFFFFL;
                        pdu.addVar(new SnmpOID(hiOid, index), new SnmpGauge(hi));
                        pdu.addVar(new SnmpOID(lowOid, index), new SnmpGauge(lo));
                    } else {
                        pdu.addVar(new SnmpOID(lowOid, index), new SnmpGauge(threshold));
                    }
                } else {
                    super.addChangedCell(pdu, oid, cell);
                }
            } else {
                super.addChangedCell(pdu, oid, cell);
            }
        }
    }
}

