/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.fc;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditDmDomainTable
extends EditTable {
    public EditDmDomainTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void postProcessing() throws SnmpException {
        VarBindList vbl = new VarBindList(2);
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("dmPrincipalSwitchWwn").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("dmLocalSwitchWwn").getOid())));
        SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl, 0);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        int[] vsans = new int[vbl.size() / 2];
        SnmpString[] principals = new SnmpString[vsans.length];
        SnmpString[] locals = new SnmpString[vsans.length];
        int i = 0;
        int k = 0;
        while (i < vbl.size()) {
            SnmpVarBind vb = vbl.get(i++);
            int[] oid = vb.getOid().getValue();
            vsans[k] = oid[oid.length - 1];
            principals[k] = (SnmpString)vb.getVar();
            locals[k] = (SnmpString)vbl.get(i++).getVar();
            ++k;
        }
        for (i = 0; i < this._data.size(); ++i) {
            int vsanNo;
            Object[] row = (Object[])this._data.elementAt(i);
            int comma = row[0].toString().indexOf(44);
            int vsan = Integer.parseInt(row[0].toString().substring(0, comma));
            SnmpString wwn = (SnmpString)row[1];
            for (vsanNo = 0; vsanNo < vsans.length && vsan != vsans[vsanNo]; ++vsanNo) {
            }
            if (vsanNo == vsans.length) continue;
            boolean isPrincipal = wwn.equals(principals[vsanNo]);
            boolean isLocal = wwn.equals(locals[vsanNo]);
            if (isPrincipal || isLocal) {
                StringBuffer sb = new StringBuffer(32);
                sb.append(WwnDictionary.get(wwn.getValue()));
                if (isLocal) {
                    sb.append(" [Local]");
                }
                if (isPrincipal) {
                    sb.append(" [Principal]");
                }
                row[1] = sb.toString();
                continue;
            }
            row[1] = WwnDictionary.get(wwn.getValue());
        }
    }
}

